/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScript;

public final class KtNamedDeclarationUtil {
    @Nullable
    public static FqNameUnsafe getUnsafeFQName(@NotNull KtNamedDeclaration namedDeclaration) {
        FqName fqName2;
        if (namedDeclaration == null) {
            KtNamedDeclarationUtil.$$$reportNull$$$1(0);
        }
        if (namedDeclaration == null) {
            KtNamedDeclarationUtil.$$$reportNull$$$0(0);
        }
        return (fqName2 = namedDeclaration.getFqName()) != null ? fqName2.toUnsafe() : null;
    }

    @Nullable
    static FqName getFQName(@NotNull KtNamedDeclaration namedDeclaration) {
        Name name;
        if (namedDeclaration == null) {
            KtNamedDeclarationUtil.$$$reportNull$$$1(1);
        }
        if (namedDeclaration == null) {
            KtNamedDeclarationUtil.$$$reportNull$$$0(1);
        }
        if ((name = namedDeclaration.getNameAsName()) == null) {
            return null;
        }
        FqName parentFqName = KtNamedDeclarationUtil.getParentFqName(namedDeclaration);
        if (parentFqName == null) {
            return null;
        }
        return parentFqName.child(name);
    }

    @Nullable
    public static FqName getParentFqName(@NotNull KtNamedDeclaration namedDeclaration) {
        PsiElement parent2;
        if (namedDeclaration == null) {
            KtNamedDeclarationUtil.$$$reportNull$$$1(2);
        }
        if (namedDeclaration == null) {
            KtNamedDeclarationUtil.$$$reportNull$$$0(2);
        }
        if ((parent2 = namedDeclaration.getParent()) instanceof KtClassBody) {
            parent2 = parent2.getParent();
        }
        if (parent2 instanceof KtFile) {
            return ((KtFile)parent2).getPackageFqName();
        }
        if (parent2 instanceof KtNamedFunction || parent2 instanceof KtClass) {
            return KtNamedDeclarationUtil.getFQName((KtNamedDeclaration)parent2);
        }
        if (namedDeclaration instanceof KtParameter) {
            KtClassOrObject constructorClass = KtPsiUtil.getClassIfParameterIsProperty((KtParameter)namedDeclaration);
            if (constructorClass != null) {
                return KtNamedDeclarationUtil.getFQName(constructorClass);
            }
        } else {
            PsiElement parentOfParent;
            if (parent2 instanceof KtObjectDeclaration) {
                return KtNamedDeclarationUtil.getFQName((KtNamedDeclaration)parent2);
            }
            if (parent2 instanceof KtBlockExpression && (parentOfParent = parent2.getParent()) instanceof KtScript) {
                return ((KtScript)parentOfParent).getFqName();
            }
        }
        return null;
    }

    private KtNamedDeclarationUtil() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "namedDeclaration";
        objectArray2[1] = "org/jetbrains/kotlin/psi/KtNamedDeclarationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getUnsafeFQName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFQName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentFqName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "namedDeclaration";
        objectArray2[1] = "org/jetbrains/kotlin/psi/KtNamedDeclarationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getUnsafeFQName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFQName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentFqName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

