/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.util;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatchStatus;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentUnmapped;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCall;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCallsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u00b6\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\n\u001a\u00020\u0001\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0005\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0012\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0013\u001a\f\u0010\u0014\u001a\u0004\u0018\u00010\u000f*\u00020\u0012\u001a\f\u0010\u0014\u001a\u0004\u0018\u00010\u000f*\u00020\u0015\u001a\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017H\u0002\u001a\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u0012*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u0012\u0010\u001c\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u0013*\u0004\u0018\u00010\u0002\u001a\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0013*\u0006\u0012\u0002\b\u00030\r\u001a\u001a\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\r*\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b\u001a&\u0010!\u001a\u0004\u0018\u00010\"\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r2\b\u0010#\u001a\u0004\u0018\u00010\u0018\u001a\u001e\u0010$\u001a\u0004\u0018\u00010\u0012*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010%\u001a\u00020\u0001\u001a(\u0010&\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\r*\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010%\u001a\u00020\u0001\u001a\u001a\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0\r*\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u0010\u0010)\u001a\u0004\u0018\u00010\u0013*\u0006\u0012\u0002\b\u00030\r\u001a\u001e\u0010*\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\r*\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u001e\u0010*\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\r*\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u001a\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\r*\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u001a\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\r*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u0014\u0010,\u001a\u0004\u0018\u00010-*\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u0014\u0010.\u001a\u0004\u0018\u00010\u0018*\u00020\u00122\u0006\u0010/\u001a\u00020\u0013\u001a\n\u00100\u001a\u00020\u0002*\u00020\u0012\u001a\u0010\u00101\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*\u00020\u0012\u001a\u0010\u00101\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*\u000202\u001a\u001a\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u0002040\r*\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b\u001a\"\u00105\u001a\u00020\u0001\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r2\u0006\u00106\u001a\u00020\"\u001a\u001a\u00107\u001a\u00020\u0001\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r\u001a\u001a\u00108\u001a\u00020\u0001\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r\u001a\u001a\u00109\u001a\u00020\u0001*\u00020\u00122\u0006\u0010:\u001a\u00020\u001b2\u0006\u0010;\u001a\u00020<\u001a(\u00109\u001a\u00020\u0001\"\u000e\b\u0000\u0010=*\b\u0012\u0004\u0012\u0002H=0>*\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H=0>\u001a\n\u0010?\u001a\u00020\u0001*\u00020\u0005\u001a\n\u0010?\u001a\u00020\u0001*\u00020\u0012\u001a\n\u0010@\u001a\u00020\u0001*\u00020\u0012\u001a\u001a\u0010A\u001a\u00020\u0001\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r\u001a.\u0010B\u001a\u00020C*\u00020D2\b\u0010/\u001a\u0004\u0018\u00010\u00132\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020G0FH\u0086\b\u00f8\u0001\u0000\u001a\u001a\u0010H\u001a\u00020\u0001\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0I\u001a\n\u0010J\u001a\u00020K*\u00020L\u001a\u001a\u0010M\u001a\u00020\u0001\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006N"}, d2={"isFakeElement", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElement;)Z", "isFakePsiElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Z", "isTrailingLambdaOnNewLIne", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;)Z", "allArgumentsMapped", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "asCallableReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "createLookupLocation", "Lorg/jetbrains/kotlin/incremental/KotlinLookupLocation;", "Lorg/jetbrains/kotlin/psi/Call;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "extractCallableReferenceExpression", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCall;", "filterArgsInParentheses", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "getCall", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getCallWithAssert", "getCalleeExpressionIfAny", "getFirstArgumentExpression", "getFunctionResolvedCallWithAssert", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getParameterForArgument", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "valueArgument", "getParentCall", "strict", "getParentResolvedCall", "getPropertyResolvedCallWithAssert", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getReceiverExpression", "getResolvedCall", "getResolvedCallWithAssert", "getType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getValueArgumentForExpression", "expression", "getValueArgumentListOrElement", "getValueArgumentsInParentheses", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "getVariableResolvedCallWithAssert", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "hasTypeMismatchErrorOnParameter", "parameter", "hasUnmappedArguments", "hasUnmappedParameters", "hasUnresolvedArguments", "bindingContext", "statementFilter", "Lorg/jetbrains/kotlin/resolve/StatementFilter;", "C", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "isCallableReference", "isSafeCall", "noErrorsInValueArguments", "reportTrailingLambdaErrorOr", "", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "originalDiagnostic", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "shouldBeSubstituteWithStubTypes", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl;", "toOldSubstitution", "Lorg/jetbrains/kotlin/types/TypeSubstitution;", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/NewTypeSubstitutor;", "usesDefaultArguments", "frontend"})
public final class CallUtilKt {
    public static final <D extends CallableDescriptor> boolean noErrorsInValueArguments(@NotNull ResolvedCall<D> $this$noErrorsInValueArguments) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$noErrorsInValueArguments, "<this>");
            List<? extends ValueArgument> list2 = $this$noErrorsInValueArguments.getCall().getValueArguments();
            Intrinsics.checkNotNullExpressionValue(list2, "call.valueArguments");
            Iterable $this$all$iv = list2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ValueArgument argument2 = (ValueArgument)element$iv;
                    boolean bl2 = false;
                    ValueArgument valueArgument = argument2;
                    Intrinsics.checkNotNull(valueArgument);
                    if (!$this$noErrorsInValueArguments.getArgumentMapping(valueArgument).isError()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final <D extends CallableDescriptor> boolean hasUnmappedArguments(@NotNull ResolvedCall<D> $this$hasUnmappedArguments) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$hasUnmappedArguments, "<this>");
            List<? extends ValueArgument> list2 = $this$hasUnmappedArguments.getCall().getValueArguments();
            Intrinsics.checkNotNullExpressionValue(list2, "call.valueArguments");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ValueArgument argument2 = (ValueArgument)element$iv;
                    boolean bl2 = false;
                    ValueArgument valueArgument = argument2;
                    Intrinsics.checkNotNull(valueArgument);
                    if (!Intrinsics.areEqual($this$hasUnmappedArguments.getArgumentMapping(valueArgument), ArgumentUnmapped.INSTANCE)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final <D extends CallableDescriptor> boolean hasUnmappedParameters(@NotNull ResolvedCall<D> $this$hasUnmappedParameters) {
        Intrinsics.checkNotNullParameter($this$hasUnmappedParameters, "<this>");
        Map<ValueParameterDescriptor, ResolvedValueArgument> map = $this$hasUnmappedParameters.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map, "valueArguments");
        Map<ValueParameterDescriptor, ResolvedValueArgument> parameterToArgumentMap = map;
        Set<ValueParameterDescriptor> set = parameterToArgumentMap.keySet();
        List<ValueParameterDescriptor> list2 = $this$hasUnmappedParameters.getResultingDescriptor().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "resultingDescriptor.valueParameters");
        return !set.containsAll((Collection)list2);
    }

    public static final <D extends CallableDescriptor> boolean allArgumentsMapped(@NotNull ResolvedCall<D> $this$allArgumentsMapped) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$allArgumentsMapped, "<this>");
            List<? extends ValueArgument> list2 = $this$allArgumentsMapped.getCall().getValueArguments();
            Intrinsics.checkNotNullExpressionValue(list2, "call.valueArguments");
            Iterable $this$all$iv = list2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ValueArgument argument2 = (ValueArgument)element$iv;
                    boolean bl2 = false;
                    if ($this$allArgumentsMapped.getArgumentMapping(argument2) instanceof ArgumentMatch) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final <D extends CallableDescriptor> boolean hasTypeMismatchErrorOnParameter(@NotNull ResolvedCall<D> $this$hasTypeMismatchErrorOnParameter, @NotNull ValueParameterDescriptor parameter) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter($this$hasTypeMismatchErrorOnParameter, "<this>");
            Intrinsics.checkNotNullParameter(parameter, "parameter");
            ResolvedValueArgument resolvedValueArgument = $this$hasTypeMismatchErrorOnParameter.getValueArguments().get(parameter);
            if (resolvedValueArgument == null) {
                return true;
            }
            List<ValueArgument> list2 = resolvedValueArgument.getArguments();
            Intrinsics.checkNotNullExpressionValue(list2, "resolvedValueArgument.arguments");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ArgumentMapping argumentMapping;
                    ValueArgument argument2 = (ValueArgument)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue($this$hasTypeMismatchErrorOnParameter.getArgumentMapping(argument2), "getArgumentMapping(argument)");
                    if (!(argumentMapping instanceof ArgumentMatch && ((ArgumentMatch)argumentMapping).getStatus() == ArgumentMatchStatus.TYPE_MISMATCH)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public static final <D extends CallableDescriptor> ValueParameterDescriptor getParameterForArgument(@NotNull ResolvedCall<D> $this$getParameterForArgument, @Nullable ValueArgument valueArgument) {
        ArgumentMapping argumentMapping;
        Intrinsics.checkNotNullParameter($this$getParameterForArgument, "<this>");
        ValueArgument valueArgument2 = valueArgument;
        if (valueArgument2 != null) {
            ValueArgument it = valueArgument2;
            boolean bl = false;
            argumentMapping = $this$getParameterForArgument.getArgumentMapping(it);
        } else {
            argumentMapping = null;
        }
        ArgumentMapping argumentMapping2 = argumentMapping;
        ArgumentMatch argumentMatch = argumentMapping2 instanceof ArgumentMatch ? (ArgumentMatch)argumentMapping2 : null;
        return argumentMatch != null ? argumentMatch.getValueParameter() : null;
    }

    public static final <D extends CallableDescriptor> boolean usesDefaultArguments(@NotNull ResolvedCall<D> $this$usesDefaultArguments) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter($this$usesDefaultArguments, "<this>");
            List<ResolvedValueArgument> list2 = $this$usesDefaultArguments.getValueArgumentsByIndex();
            if (list2 != null) {
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ResolvedValueArgument it = (ResolvedValueArgument)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof DefaultValueArgument)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public static final <C extends ResolutionContext<C>> boolean hasUnresolvedArguments(@NotNull Call $this$hasUnresolvedArguments, @NotNull ResolutionContext<C> context2) {
        Intrinsics.checkNotNullParameter($this$hasUnresolvedArguments, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        BindingContext bindingContext = context2.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "context.trace.bindingContext");
        StatementFilter statementFilter = context2.statementFilter;
        Intrinsics.checkNotNullExpressionValue(statementFilter, "context.statementFilter");
        return CallUtilKt.hasUnresolvedArguments($this$hasUnresolvedArguments, bindingContext, statementFilter);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasUnresolvedArguments(@NotNull Call $this$hasUnresolvedArguments, @NotNull BindingContext bindingContext, @NotNull StatementFilter statementFilter) {
        boolean bl;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$hasUnresolvedArguments, "<this>");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Intrinsics.checkNotNullParameter(statementFilter, "statementFilter");
        List<? extends ValueArgument> list2 = $this$hasUnresolvedArguments.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list2, "valueArguments");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Object object2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (ValueArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getArgumentExpression());
        }
        List arguments2 = (List)destination$iv$iv;
        Iterable $this$any$iv = arguments2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        object2 = $this$any$iv.iterator();
        do {
            KotlinType expressionType;
            if (!object2.hasNext()) return false;
            Object element$iv = object2.next();
            KtExpression argument2 = (KtExpression)element$iv;
            boolean bl3 = false;
            if (argument2 == null || ArgumentTypeResolver.isFunctionLiteralOrCallableReference(argument2, statementFilter)) {
                bl = false;
                continue;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(argument2, bindingContext);
            if (resolvedCall2 instanceof MutableResolvedCall) {
                if (!((MutableResolvedCall)resolvedCall2).hasInferredReturnType()) {
                    bl = false;
                    continue;
                }
            } else if (resolvedCall2 instanceof NewResolvedCallImpl) {
                boolean bl4;
                Object object3 = object = ((NewResolvedCallImpl)resolvedCall2).getResultingDescriptor().getReturnType();
                if (object3 != null) {
                    Intrinsics.checkNotNullExpressionValue(object3, "returnType");
                    bl4 = KotlinTypeKt.isError((KotlinType)object);
                } else {
                    bl4 = false;
                }
                if (bl4) {
                    bl = false;
                    continue;
                }
            }
            if ((expressionType = bindingContext.getType(argument2)) == null) return true;
            if (KotlinTypeKt.isError(expressionType)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public static final List<ValueArgument> getValueArgumentsInParentheses(@NotNull Call $this$getValueArgumentsInParentheses) {
        Intrinsics.checkNotNullParameter($this$getValueArgumentsInParentheses, "<this>");
        List<? extends ValueArgument> list2 = $this$getValueArgumentsInParentheses.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list2, "valueArguments");
        return CallUtilKt.filterArgsInParentheses(list2);
    }

    @NotNull
    public static final List<ValueArgument> getValueArgumentsInParentheses(@NotNull KtCallElement $this$getValueArgumentsInParentheses) {
        Intrinsics.checkNotNullParameter($this$getValueArgumentsInParentheses, "<this>");
        List<? extends ValueArgument> list2 = $this$getValueArgumentsInParentheses.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list2, "valueArguments");
        return CallUtilKt.filterArgsInParentheses(list2);
    }

    @NotNull
    public static final KtElement getValueArgumentListOrElement(@NotNull Call $this$getValueArgumentListOrElement) {
        KtElement ktElement;
        Intrinsics.checkNotNullParameter($this$getValueArgumentListOrElement, "<this>");
        if ($this$getValueArgumentListOrElement instanceof CallTransformer.CallForImplicitInvoke) {
            Call call2 = ((CallTransformer.CallForImplicitInvoke)$this$getValueArgumentListOrElement).getOuterCall();
            Intrinsics.checkNotNullExpressionValue(call2, "outerCall");
            ktElement = CallUtilKt.getValueArgumentListOrElement(call2);
        } else {
            KtValueArgumentList ktValueArgumentList = $this$getValueArgumentListOrElement.getValueArgumentList();
            if (ktValueArgumentList != null) {
                ktElement = ktValueArgumentList;
            } else {
                KtExpression ktExpression = $this$getValueArgumentListOrElement.getCalleeExpression();
                if (ktExpression != null) {
                    ktElement = ktExpression;
                } else {
                    KtElement ktElement2 = $this$getValueArgumentListOrElement.getCallElement();
                    ktElement = ktElement2;
                    Intrinsics.checkNotNullExpressionValue(ktElement2, "callElement");
                }
            }
        }
        return ktElement;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ValueArgument> filterArgsInParentheses(List<? extends ValueArgument> $this$filterArgsInParentheses) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$filterArgsInParentheses;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ValueArgument it = (ValueArgument)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof KtLambdaArgument))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final ValueArgument getValueArgumentForExpression(@NotNull Call $this$getValueArgumentForExpression, @NotNull KtExpression expression2) {
        Object v2;
        block1: {
            Intrinsics.checkNotNullParameter($this$getValueArgumentForExpression, "<this>");
            Intrinsics.checkNotNullParameter(expression2, "expression");
            List<? extends ValueArgument> list2 = $this$getValueArgumentForExpression.getValueArguments();
            Intrinsics.checkNotNullExpressionValue(list2, "valueArguments");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ValueArgument it = (ValueArgument)element$iv;
                boolean bl = false;
                Object object = it;
                if (!(object != null && (object = object.getArgumentExpression()) != null ? CallUtilKt.getValueArgumentForExpression$isParenthesizedExpression((KtElement)object, expression2) : false)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    @Nullable
    public static final KtExpression getCalleeExpressionIfAny(@Nullable KtElement $this$getCalleeExpressionIfAny) {
        KtElement element = $this$getCalleeExpressionIfAny instanceof KtExpression ? (KtElement)KtPsiUtil.deparenthesize((KtExpression)$this$getCalleeExpressionIfAny) : $this$getCalleeExpressionIfAny;
        KtElement ktElement = element;
        return ktElement instanceof KtSimpleNameExpression ? (KtExpression)element : (ktElement instanceof KtCallElement ? ((KtCallElement)element).getCalleeExpression() : (ktElement instanceof KtQualifiedExpression ? CallUtilKt.getCalleeExpressionIfAny(((KtQualifiedExpression)element).getSelectorExpression()) : (ktElement instanceof KtOperationExpression ? (KtExpression)((KtOperationExpression)element).getOperationReference() : null)));
    }

    @Nullable
    public static final Call getCall(@NotNull KtElement $this$getCall, @NotNull BindingContext context2) {
        KtExpression reference;
        PsiElement psiElement;
        KtProperty subjectVariable;
        KtElement element;
        Intrinsics.checkNotNullParameter($this$getCall, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        KtElement ktElement = element = $this$getCall instanceof KtExpression ? (KtElement)KtPsiUtil.deparenthesize((KtExpression)$this$getCall) : $this$getCall;
        if (element == null) {
            return null;
        }
        if (element instanceof KtCallElement && ((KtCallElement)element).getCalleeExpression() == null) {
            return null;
        }
        if (element instanceof KtWhenExpression && (subjectVariable = ((KtWhenExpression)element).getSubjectVariable()) != null) {
            return CallUtilKt.getCall(subjectVariable, context2);
        }
        PsiElement parent2 = element.getParent();
        PsiElement psiElement2 = parent2;
        KtExpression ktExpression = psiElement2 instanceof KtInstanceExpressionWithLabel ? (KtExpression)parent2 : (psiElement2 instanceof KtUserType ? (KtExpression)((psiElement = ((KtUserType)parent2).getParent().getParent()) instanceof KtConstructorCalleeExpression ? (KtConstructorCalleeExpression)psiElement : null) : (reference = CallUtilKt.getCalleeExpressionIfAny(element)));
        if (reference != null) {
            return (Call)context2.get(BindingContext.CALL, reference);
        }
        return (Call)context2.get(BindingContext.CALL, element);
    }

    @Nullable
    public static final Call getParentCall(@NotNull KtElement $this$getParentCall, @NotNull BindingContext context2, boolean strict) {
        KtElement parent2;
        Intrinsics.checkNotNullParameter($this$getParentCall, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        Class[] classArray = new Class[]{KtSimpleNameExpression.class, KtCallElement.class, KtBinaryExpression.class, KtUnaryExpression.class, KtArrayAccessExpression.class};
        Class[] callExpressionTypes = classArray;
        KtElement ktElement = parent2 = strict ? (KtElement)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentCall, Arrays.copyOf(callExpressionTypes, callExpressionTypes.length)) : (KtElement)PsiTreeUtil.getNonStrictParentOfType($this$getParentCall, Arrays.copyOf(callExpressionTypes, callExpressionTypes.length));
        return ktElement != null ? CallUtilKt.getCall(ktElement, context2) : null;
    }

    public static /* synthetic */ Call getParentCall$default(KtElement ktElement, BindingContext bindingContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return CallUtilKt.getParentCall(ktElement, bindingContext, bl);
    }

    @Nullable
    public static final ResolvedCall<? extends CallableDescriptor> getResolvedCall(@Nullable Call $this$getResolvedCall, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        return (ResolvedCall)context2.get(BindingContext.RESOLVED_CALL, $this$getResolvedCall);
    }

    @Nullable
    public static final ResolvedCall<? extends CallableDescriptor> getResolvedCall(@Nullable KtElement $this$getResolvedCall, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Object object = $this$getResolvedCall;
        return object != null && (object = CallUtilKt.getCall((KtElement)object, context2)) != null ? CallUtilKt.getResolvedCall((Call)object, context2) : null;
    }

    @Nullable
    public static final ResolvedCall<? extends CallableDescriptor> getParentResolvedCall(@Nullable KtElement $this$getParentResolvedCall, @NotNull BindingContext context2, boolean strict) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Object object = $this$getParentResolvedCall;
        return object != null && (object = CallUtilKt.getParentCall((KtElement)object, context2, strict)) != null ? CallUtilKt.getResolvedCall((Call)object, context2) : null;
    }

    public static /* synthetic */ ResolvedCall getParentResolvedCall$default(KtElement ktElement, BindingContext bindingContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return CallUtilKt.getParentResolvedCall(ktElement, bindingContext, bl);
    }

    @NotNull
    public static final Call getCallWithAssert(@NotNull KtElement $this$getCallWithAssert, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter($this$getCallWithAssert, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        Call $this$sure$iv = CallUtilKt.getCall($this$getCallWithAssert, context2);
        boolean $i$f$sure = false;
        Call call2 = $this$sure$iv;
        if (call2 == null) {
            boolean bl = false;
            String string2 = "No call for " + PsiUtilsKt.getTextWithLocation($this$getCallWithAssert);
            throw new AssertionError((Object)string2);
        }
        return call2;
    }

    @NotNull
    public static final ResolvedCall<? extends CallableDescriptor> getResolvedCallWithAssert(@NotNull KtElement $this$getResolvedCallWithAssert, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter($this$getResolvedCallWithAssert, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        ResolvedCall<? extends CallableDescriptor> $this$sure$iv = CallUtilKt.getResolvedCall($this$getResolvedCallWithAssert, context2);
        boolean $i$f$sure = false;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = $this$sure$iv;
        if (resolvedCall2 == null) {
            boolean bl = false;
            String string2 = "No resolved call for " + PsiUtilsKt.getTextWithLocation($this$getResolvedCallWithAssert);
            throw new AssertionError((Object)string2);
        }
        return resolvedCall2;
    }

    @NotNull
    public static final ResolvedCall<? extends CallableDescriptor> getResolvedCallWithAssert(@NotNull Call $this$getResolvedCallWithAssert, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter($this$getResolvedCallWithAssert, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        ResolvedCall<? extends CallableDescriptor> $this$sure$iv = CallUtilKt.getResolvedCall($this$getResolvedCallWithAssert, context2);
        boolean $i$f$sure = false;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = $this$sure$iv;
        if (resolvedCall2 == null) {
            boolean bl = false;
            StringBuilder stringBuilder2 = new StringBuilder().append("No resolved call for ");
            KtElement ktElement = $this$getResolvedCallWithAssert.getCallElement();
            Intrinsics.checkNotNullExpressionValue(ktElement, "this.callElement");
            String string2 = stringBuilder2.append(PsiUtilsKt.getTextWithLocation(ktElement)).toString();
            throw new AssertionError((Object)string2);
        }
        return resolvedCall2;
    }

    @NotNull
    public static final ResolvedCall<? extends FunctionDescriptor> getFunctionResolvedCallWithAssert(@NotNull KtExpression $this$getFunctionResolvedCallWithAssert, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter($this$getFunctionResolvedCallWithAssert, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert($this$getFunctionResolvedCallWithAssert, context2);
        boolean bl = resolvedCall2.getResultingDescriptor() instanceof FunctionDescriptor;
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "ResolvedCall for this expression must be ResolvedCall<? extends FunctionDescriptor>: " + PsiUtilsKt.getTextWithLocation($this$getFunctionResolvedCallWithAssert);
            throw new AssertionError((Object)string2);
        }
        return resolvedCall2;
    }

    @NotNull
    public static final ResolvedCall<? extends PropertyDescriptor> getPropertyResolvedCallWithAssert(@NotNull KtExpression $this$getPropertyResolvedCallWithAssert, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter($this$getPropertyResolvedCallWithAssert, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert($this$getPropertyResolvedCallWithAssert, context2);
        boolean bl = resolvedCall2.getResultingDescriptor() instanceof PropertyDescriptor;
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "ResolvedCall for this expression must be ResolvedCall<? extends PropertyDescriptor>: " + PsiUtilsKt.getTextWithLocation($this$getPropertyResolvedCallWithAssert);
            throw new AssertionError((Object)string2);
        }
        return resolvedCall2;
    }

    @NotNull
    public static final ResolvedCall<? extends VariableDescriptor> getVariableResolvedCallWithAssert(@NotNull KtExpression $this$getVariableResolvedCallWithAssert, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter($this$getVariableResolvedCallWithAssert, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert($this$getVariableResolvedCallWithAssert, context2);
        boolean bl = resolvedCall2.getResultingDescriptor() instanceof VariableDescriptor;
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "ResolvedCall for this expression must be ResolvedCall<? extends PropertyDescriptor>: " + PsiUtilsKt.getTextWithLocation($this$getVariableResolvedCallWithAssert);
            throw new AssertionError((Object)string2);
        }
        return resolvedCall2;
    }

    @Nullable
    public static final KotlinType getType(@NotNull KtExpression $this$getType, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter($this$getType, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        KotlinType type2 = context2.getType($this$getType);
        if (type2 != null) {
            return type2;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($this$getType, context2);
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            return ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getResultingDescriptor().getType();
        }
        return null;
    }

    public static final boolean isFakeElement(@NotNull KtElement $this$isFakeElement) {
        Intrinsics.checkNotNullParameter($this$isFakeElement, "<this>");
        PsiFile file2 = $this$isFakeElement.getContainingFile();
        return file2 instanceof KtFile && KtPsiFactoryKt.getDoNotAnalyze((KtFile)file2) != null;
    }

    public static final boolean isFakePsiElement(@NotNull PsiElement $this$isFakePsiElement) {
        Intrinsics.checkNotNullParameter($this$isFakePsiElement, "<this>");
        return $this$isFakePsiElement instanceof KtElement && CallUtilKt.isFakeElement((KtElement)$this$isFakePsiElement);
    }

    public static final boolean isSafeCall(@NotNull Call $this$isSafeCall) {
        Intrinsics.checkNotNullParameter($this$isSafeCall, "<this>");
        if ($this$isSafeCall instanceof CallTransformer.CallForImplicitInvoke && ((CallTransformer.CallForImplicitInvoke)$this$isSafeCall).getOuterCall().isSemanticallyEquivalentToSafeCall()) {
            return true;
        }
        return $this$isSafeCall.isSemanticallyEquivalentToSafeCall();
    }

    public static final boolean isCallableReference(@NotNull Call $this$isCallableReference) {
        Intrinsics.checkNotNullParameter($this$isCallableReference, "<this>");
        KtElement ktElement = $this$isCallableReference.getCallElement();
        Intrinsics.checkNotNullExpressionValue(ktElement, "callElement");
        KtElement callElement = ktElement;
        return CallUtilKt.isCallableReference(callElement);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isCallableReference(@NotNull PsiElement $this$isCallableReference) {
        Intrinsics.checkNotNullParameter($this$isCallableReference, "<this>");
        if (!($this$isCallableReference instanceof KtNameReferenceExpression)) return false;
        PsiElement psiElement = ((KtNameReferenceExpression)$this$isCallableReference).getParent();
        KtCallableReferenceExpression ktCallableReferenceExpression = psiElement instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)psiElement : null;
        if (!Intrinsics.areEqual(ktCallableReferenceExpression != null ? ktCallableReferenceExpression.getCallableReference() : null, $this$isCallableReference)) return false;
        return true;
    }

    @Nullable
    public static final KtCallableReferenceExpression asCallableReferenceExpression(@NotNull PsiElement $this$asCallableReferenceExpression) {
        KtCallableReferenceExpression ktCallableReferenceExpression;
        Intrinsics.checkNotNullParameter($this$asCallableReferenceExpression, "<this>");
        if (CallUtilKt.isCallableReference($this$asCallableReferenceExpression)) {
            PsiElement psiElement = $this$asCallableReferenceExpression.getParent();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableReferenceExpression");
            }
            ktCallableReferenceExpression = (KtCallableReferenceExpression)psiElement;
        } else {
            ktCallableReferenceExpression = $this$asCallableReferenceExpression instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)$this$asCallableReferenceExpression : null;
        }
        return ktCallableReferenceExpression;
    }

    @NotNull
    public static final KotlinLookupLocation createLookupLocation(@NotNull Call $this$createLookupLocation) {
        Intrinsics.checkNotNullParameter($this$createLookupLocation, "<this>");
        KtExpression calleeExpression = $this$createLookupLocation.getCalleeExpression();
        KtElement ktElement = calleeExpression != null && !CallUtilKt.isFakeElement(calleeExpression) ? (KtElement)calleeExpression : $this$createLookupLocation.getCallElement();
        Intrinsics.checkNotNullExpressionValue(ktElement, "if (calleeExpression != \u2026\n        else callElement");
        KtElement element = ktElement;
        return new KotlinLookupLocation(element);
    }

    @Nullable
    public static final KotlinLookupLocation createLookupLocation(@NotNull KtExpression $this$createLookupLocation) {
        Intrinsics.checkNotNullParameter($this$createLookupLocation, "<this>");
        return !CallUtilKt.isFakeElement($this$createLookupLocation) ? new KotlinLookupLocation($this$createLookupLocation) : null;
    }

    @Nullable
    public static final KtExpression getFirstArgumentExpression(@NotNull ResolvedCall<?> $this$getFirstArgumentExpression) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter($this$getFirstArgumentExpression, "<this>");
        List<ResolvedValueArgument> list2 = $this$getFirstArgumentExpression.getValueArgumentsByIndex();
        if (list2 != null) {
            List<ResolvedValueArgument> $this$getFirstArgumentExpression_u24lambda_u2d17 = list2;
            boolean bl = false;
            ktExpression = $this$getFirstArgumentExpression_u24lambda_u2d17.get(0).getArguments().get(0).getArgumentExpression();
        } else {
            ktExpression = null;
        }
        return ktExpression;
    }

    @Nullable
    public static final KtExpression getReceiverExpression(@NotNull ResolvedCall<?> $this$getReceiverExpression) {
        Object object;
        Intrinsics.checkNotNullParameter($this$getReceiverExpression, "<this>");
        ReceiverValue $this$safeAs$iv = $this$getReceiverExpression.getExtensionReceiver();
        boolean $i$f$safeAs = false;
        ReceiverValue receiverValue = $this$safeAs$iv;
        if (!(receiverValue instanceof ExpressionReceiver)) {
            receiverValue = null;
        }
        if ((object = (ExpressionReceiver)receiverValue) == null || (object = object.getExpression()) == null) {
            ReceiverValue $this$safeAs$iv2 = $this$getReceiverExpression.getDispatchReceiver();
            boolean $i$f$safeAs2 = false;
            ReceiverValue receiverValue2 = $this$safeAs$iv2;
            if (!(receiverValue2 instanceof ExpressionReceiver)) {
                receiverValue2 = null;
            }
            ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue2;
            object = expressionReceiver != null ? expressionReceiver.getExpression() : null;
        }
        return object;
    }

    public static final boolean isTrailingLambdaOnNewLIne(@NotNull KtLambdaExpression $this$isTrailingLambdaOnNewLIne) {
        block3: {
            Intrinsics.checkNotNullParameter($this$isTrailingLambdaOnNewLIne, "<this>");
            PsiElement psiElement = $this$isTrailingLambdaOnNewLIne.getParent();
            if (psiElement == null) break block3;
            PsiElement $this$safeAs$iv = psiElement;
            boolean $i$f$safeAs = false;
            PsiElement psiElement2 = $this$safeAs$iv;
            if (!(psiElement2 instanceof KtLambdaArgument)) {
                psiElement2 = null;
            }
            if ((psiElement = (KtLambdaArgument)psiElement2) != null) {
                PsiElement lambdaArgument = psiElement;
                boolean bl = false;
                for (PsiElement prevSibling = ((ASTDelegatePsiElement)lambdaArgument).getPrevSibling(); prevSibling != null && !(prevSibling instanceof KtElement); prevSibling = prevSibling.getPrevSibling()) {
                    if (!(prevSibling instanceof PsiWhiteSpace) || !prevSibling.textContains('\n')) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final void reportTrailingLambdaErrorOr(@NotNull BindingTrace $this$reportTrailingLambdaErrorOr, @Nullable KtExpression expression2, @NotNull Function1<? super KtExpression, ? extends Diagnostic> originalDiagnostic) {
        block2: {
            Intrinsics.checkNotNullParameter($this$reportTrailingLambdaErrorOr, "<this>");
            Intrinsics.checkNotNullParameter(originalDiagnostic, "originalDiagnostic");
            boolean $i$f$reportTrailingLambdaErrorOr = false;
            KtExpression ktExpression = expression2;
            if (ktExpression == null) break block2;
            KtExpression expr = ktExpression;
            boolean bl = false;
            if (expr instanceof KtLambdaExpression && CallUtilKt.isTrailingLambdaOnNewLIne((KtLambdaExpression)expr)) {
                $this$reportTrailingLambdaErrorOr.report(Errors.UNEXPECTED_TRAILING_LAMBDA_ON_A_NEW_LINE.on((KtLambdaExpression)expr));
            } else {
                $this$reportTrailingLambdaErrorOr.report(originalDiagnostic.invoke(expr));
            }
        }
    }

    @NotNull
    public static final TypeSubstitution toOldSubstitution(@NotNull NewTypeSubstitutor $this$toOldSubstitution) {
        Intrinsics.checkNotNullParameter($this$toOldSubstitution, "<this>");
        return new TypeSubstitution($this$toOldSubstitution){
            final /* synthetic */ NewTypeSubstitutor $this_toOldSubstitution;
            {
                this.$this_toOldSubstitution = $receiver;
            }

            @Nullable
            public TypeProjection get(@NotNull KotlinType key) {
                UnwrappedType unwrappedType;
                Intrinsics.checkNotNullParameter(key, "key");
                UnwrappedType it = unwrappedType = this.$this_toOldSubstitution.safeSubstitute(key.unwrap());
                boolean bl = false;
                UnwrappedType unwrappedType2 = it != key ? unwrappedType : null;
                return unwrappedType2 != null ? TypeUtilsKt.asTypeProjection(unwrappedType2) : null;
            }

            public boolean isEmpty() {
                return this.$this_toOldSubstitution.isEmpty();
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final <D extends CallableDescriptor> boolean shouldBeSubstituteWithStubTypes(@NotNull ResolvedCallImpl<D> $this$shouldBeSubstituteWithStubTypes) {
        KotlinType kotlinType;
        boolean bl;
        boolean bl2;
        Map.Entry<DeclarationDescriptorNonRoot, Object> argument2;
        boolean bl3;
        Intrinsics.checkNotNullParameter($this$shouldBeSubstituteWithStubTypes, "<this>");
        Map<TypeParameterDescriptor, KotlinType> map = $this$shouldBeSubstituteWithStubTypes.getTypeArguments();
        Intrinsics.checkNotNullExpressionValue(map, "typeArguments");
        Map<DeclarationDescriptorNonRoot, Object> $this$any$iv = map;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            bl3 = false;
        } else {
            for (Map.Entry<TypeParameterDescriptor, KotlinType> entry : $this$any$iv.entrySet()) {
                argument2 = entry;
                boolean bl4 = false;
                KotlinType kotlinType2 = argument2.getValue();
                Intrinsics.checkNotNullExpressionValue(kotlinType2, "argument.value");
                if (!TypeUtilsKt.contains(kotlinType2, shouldBeSubstituteWithStubTypes.1.1.INSTANCE)) continue;
                return true;
            }
            bl3 = false;
        }
        if (bl3) return true;
        Object object = $this$shouldBeSubstituteWithStubTypes.getDispatchReceiver();
        if (object != null && (object = object.getType()) != null) {
            if (TypeUtilsKt.contains((KotlinType)object, shouldBeSubstituteWithStubTypes.2.INSTANCE)) {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        Object object2 = $this$shouldBeSubstituteWithStubTypes.getExtensionReceiver();
        if (object2 != null && (object2 = object2.getType()) != null) {
            if (TypeUtilsKt.contains((KotlinType)object2, shouldBeSubstituteWithStubTypes.3.INSTANCE)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = $this$shouldBeSubstituteWithStubTypes.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map2, "valueArguments");
        $this$any$iv = map2;
        $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            return false;
        }
        Iterator<Map.Entry<DeclarationDescriptorNonRoot, Object>> iterator2 = $this$any$iv.entrySet().iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Map.Entry<DeclarationDescriptorNonRoot, Object> entry = iterator2.next();
            argument2 = entry;
            boolean bl5 = false;
            kotlinType = ((ValueParameterDescriptor)argument2.getKey()).getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "argument.key.type");
        } while (!TypeUtilsKt.contains(kotlinType, shouldBeSubstituteWithStubTypes.4.1.INSTANCE));
        return true;
    }

    @Nullable
    public static final KtCallableReferenceExpression extractCallableReferenceExpression(@NotNull KotlinCall $this$extractCallableReferenceExpression) {
        Intrinsics.checkNotNullParameter($this$extractCallableReferenceExpression, "<this>");
        return CallUtilKt.extractCallableReferenceExpression(PSIKotlinCallsKt.getPsiKotlinCall($this$extractCallableReferenceExpression).getPsiCall());
    }

    @Nullable
    public static final KtCallableReferenceExpression extractCallableReferenceExpression(@NotNull Call $this$extractCallableReferenceExpression) {
        Intrinsics.checkNotNullParameter($this$extractCallableReferenceExpression, "<this>");
        KtElement ktElement = $this$extractCallableReferenceExpression.getCallElement();
        Intrinsics.checkNotNullExpressionValue(ktElement, "callElement");
        return CallUtilKt.asCallableReferenceExpression(ktElement);
    }

    private static final KtElement getValueArgumentForExpression$deparenthesizeStructurally(KtElement $this$getValueArgumentForExpression_u24deparenthesizeStructurally) {
        KtElement deparenthesized = $this$getValueArgumentForExpression_u24deparenthesizeStructurally instanceof KtExpression ? (KtElement)KtPsiUtil.deparenthesizeOnce((KtExpression)$this$getValueArgumentForExpression_u24deparenthesizeStructurally) : $this$getValueArgumentForExpression_u24deparenthesizeStructurally;
        return !Intrinsics.areEqual(deparenthesized, $this$getValueArgumentForExpression_u24deparenthesizeStructurally) ? deparenthesized : ($this$getValueArgumentForExpression_u24deparenthesizeStructurally instanceof KtLambdaExpression ? (KtElement)((KtLambdaExpression)$this$getValueArgumentForExpression_u24deparenthesizeStructurally).getFunctionLiteral() : ($this$getValueArgumentForExpression_u24deparenthesizeStructurally instanceof KtFunctionLiteral ? (KtElement)((KtFunctionLiteral)$this$getValueArgumentForExpression_u24deparenthesizeStructurally).getBodyExpression() : null));
    }

    private static final boolean getValueArgumentForExpression$isParenthesizedExpression(KtElement $this$getValueArgumentForExpression_u24isParenthesizedExpression, KtExpression $expression) {
        boolean bl;
        block1: {
            Sequence<KtElement> $this$any$iv = SequencesKt.generateSequence($this$getValueArgumentForExpression_u24isParenthesizedExpression, (Function1)getValueArgumentForExpression.isParenthesizedExpression.1.INSTANCE);
            boolean $i$f$any = false;
            Iterator<KtElement> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                KtElement element$iv;
                KtElement it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it, $expression)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ KtElement access$getValueArgumentForExpression$deparenthesizeStructurally(KtElement $receiver) {
        return CallUtilKt.getValueArgumentForExpression$deparenthesizeStructurally($receiver);
    }
}

