// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/devtools/cloudbuild/v2/repositories.proto

package cloudbuildpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	RepositoryManager_CreateConnection_FullMethodName          = "/google.devtools.cloudbuild.v2.RepositoryManager/CreateConnection"
	RepositoryManager_GetConnection_FullMethodName             = "/google.devtools.cloudbuild.v2.RepositoryManager/GetConnection"
	RepositoryManager_ListConnections_FullMethodName           = "/google.devtools.cloudbuild.v2.RepositoryManager/ListConnections"
	RepositoryManager_UpdateConnection_FullMethodName          = "/google.devtools.cloudbuild.v2.RepositoryManager/UpdateConnection"
	RepositoryManager_DeleteConnection_FullMethodName          = "/google.devtools.cloudbuild.v2.RepositoryManager/DeleteConnection"
	RepositoryManager_CreateRepository_FullMethodName          = "/google.devtools.cloudbuild.v2.RepositoryManager/CreateRepository"
	RepositoryManager_BatchCreateRepositories_FullMethodName   = "/google.devtools.cloudbuild.v2.RepositoryManager/BatchCreateRepositories"
	RepositoryManager_GetRepository_FullMethodName             = "/google.devtools.cloudbuild.v2.RepositoryManager/GetRepository"
	RepositoryManager_ListRepositories_FullMethodName          = "/google.devtools.cloudbuild.v2.RepositoryManager/ListRepositories"
	RepositoryManager_DeleteRepository_FullMethodName          = "/google.devtools.cloudbuild.v2.RepositoryManager/DeleteRepository"
	RepositoryManager_FetchReadWriteToken_FullMethodName       = "/google.devtools.cloudbuild.v2.RepositoryManager/FetchReadWriteToken"
	RepositoryManager_FetchReadToken_FullMethodName            = "/google.devtools.cloudbuild.v2.RepositoryManager/FetchReadToken"
	RepositoryManager_FetchLinkableRepositories_FullMethodName = "/google.devtools.cloudbuild.v2.RepositoryManager/FetchLinkableRepositories"
	RepositoryManager_FetchGitRefs_FullMethodName              = "/google.devtools.cloudbuild.v2.RepositoryManager/FetchGitRefs"
)

// RepositoryManagerClient is the client API for RepositoryManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type RepositoryManagerClient interface {
	// Creates a Connection.
	CreateConnection(ctx context.Context, in *CreateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single connection.
	GetConnection(ctx context.Context, in *GetConnectionRequest, opts ...grpc.CallOption) (*Connection, error)
	// Lists Connections in a given project and location.
	ListConnections(ctx context.Context, in *ListConnectionsRequest, opts ...grpc.CallOption) (*ListConnectionsResponse, error)
	// Updates a single connection.
	UpdateConnection(ctx context.Context, in *UpdateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single connection.
	DeleteConnection(ctx context.Context, in *DeleteConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a Repository.
	CreateRepository(ctx context.Context, in *CreateRepositoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates multiple repositories inside a connection.
	BatchCreateRepositories(ctx context.Context, in *BatchCreateRepositoriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single repository.
	GetRepository(ctx context.Context, in *GetRepositoryRequest, opts ...grpc.CallOption) (*Repository, error)
	// Lists Repositories in a given connection.
	ListRepositories(ctx context.Context, in *ListRepositoriesRequest, opts ...grpc.CallOption) (*ListRepositoriesResponse, error)
	// Deletes a single repository.
	DeleteRepository(ctx context.Context, in *DeleteRepositoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Fetches read/write token of a given repository.
	FetchReadWriteToken(ctx context.Context, in *FetchReadWriteTokenRequest, opts ...grpc.CallOption) (*FetchReadWriteTokenResponse, error)
	// Fetches read token of a given repository.
	FetchReadToken(ctx context.Context, in *FetchReadTokenRequest, opts ...grpc.CallOption) (*FetchReadTokenResponse, error)
	// FetchLinkableRepositories get repositories from SCM that are
	// accessible and could be added to the connection.
	FetchLinkableRepositories(ctx context.Context, in *FetchLinkableRepositoriesRequest, opts ...grpc.CallOption) (*FetchLinkableRepositoriesResponse, error)
	// Fetch the list of branches or tags for a given repository.
	FetchGitRefs(ctx context.Context, in *FetchGitRefsRequest, opts ...grpc.CallOption) (*FetchGitRefsResponse, error)
}

type repositoryManagerClient struct {
	cc grpc.ClientConnInterface
}

func NewRepositoryManagerClient(cc grpc.ClientConnInterface) RepositoryManagerClient {
	return &repositoryManagerClient{cc}
}

func (c *repositoryManagerClient) CreateConnection(ctx context.Context, in *CreateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, RepositoryManager_CreateConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) GetConnection(ctx context.Context, in *GetConnectionRequest, opts ...grpc.CallOption) (*Connection, error) {
	out := new(Connection)
	err := c.cc.Invoke(ctx, RepositoryManager_GetConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) ListConnections(ctx context.Context, in *ListConnectionsRequest, opts ...grpc.CallOption) (*ListConnectionsResponse, error) {
	out := new(ListConnectionsResponse)
	err := c.cc.Invoke(ctx, RepositoryManager_ListConnections_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) UpdateConnection(ctx context.Context, in *UpdateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, RepositoryManager_UpdateConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) DeleteConnection(ctx context.Context, in *DeleteConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, RepositoryManager_DeleteConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) CreateRepository(ctx context.Context, in *CreateRepositoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, RepositoryManager_CreateRepository_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) BatchCreateRepositories(ctx context.Context, in *BatchCreateRepositoriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, RepositoryManager_BatchCreateRepositories_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) GetRepository(ctx context.Context, in *GetRepositoryRequest, opts ...grpc.CallOption) (*Repository, error) {
	out := new(Repository)
	err := c.cc.Invoke(ctx, RepositoryManager_GetRepository_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) ListRepositories(ctx context.Context, in *ListRepositoriesRequest, opts ...grpc.CallOption) (*ListRepositoriesResponse, error) {
	out := new(ListRepositoriesResponse)
	err := c.cc.Invoke(ctx, RepositoryManager_ListRepositories_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) DeleteRepository(ctx context.Context, in *DeleteRepositoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, RepositoryManager_DeleteRepository_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) FetchReadWriteToken(ctx context.Context, in *FetchReadWriteTokenRequest, opts ...grpc.CallOption) (*FetchReadWriteTokenResponse, error) {
	out := new(FetchReadWriteTokenResponse)
	err := c.cc.Invoke(ctx, RepositoryManager_FetchReadWriteToken_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) FetchReadToken(ctx context.Context, in *FetchReadTokenRequest, opts ...grpc.CallOption) (*FetchReadTokenResponse, error) {
	out := new(FetchReadTokenResponse)
	err := c.cc.Invoke(ctx, RepositoryManager_FetchReadToken_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) FetchLinkableRepositories(ctx context.Context, in *FetchLinkableRepositoriesRequest, opts ...grpc.CallOption) (*FetchLinkableRepositoriesResponse, error) {
	out := new(FetchLinkableRepositoriesResponse)
	err := c.cc.Invoke(ctx, RepositoryManager_FetchLinkableRepositories_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) FetchGitRefs(ctx context.Context, in *FetchGitRefsRequest, opts ...grpc.CallOption) (*FetchGitRefsResponse, error) {
	out := new(FetchGitRefsResponse)
	err := c.cc.Invoke(ctx, RepositoryManager_FetchGitRefs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RepositoryManagerServer is the server API for RepositoryManager service.
// All implementations should embed UnimplementedRepositoryManagerServer
// for forward compatibility
type RepositoryManagerServer interface {
	// Creates a Connection.
	CreateConnection(context.Context, *CreateConnectionRequest) (*longrunningpb.Operation, error)
	// Gets details of a single connection.
	GetConnection(context.Context, *GetConnectionRequest) (*Connection, error)
	// Lists Connections in a given project and location.
	ListConnections(context.Context, *ListConnectionsRequest) (*ListConnectionsResponse, error)
	// Updates a single connection.
	UpdateConnection(context.Context, *UpdateConnectionRequest) (*longrunningpb.Operation, error)
	// Deletes a single connection.
	DeleteConnection(context.Context, *DeleteConnectionRequest) (*longrunningpb.Operation, error)
	// Creates a Repository.
	CreateRepository(context.Context, *CreateRepositoryRequest) (*longrunningpb.Operation, error)
	// Creates multiple repositories inside a connection.
	BatchCreateRepositories(context.Context, *BatchCreateRepositoriesRequest) (*longrunningpb.Operation, error)
	// Gets details of a single repository.
	GetRepository(context.Context, *GetRepositoryRequest) (*Repository, error)
	// Lists Repositories in a given connection.
	ListRepositories(context.Context, *ListRepositoriesRequest) (*ListRepositoriesResponse, error)
	// Deletes a single repository.
	DeleteRepository(context.Context, *DeleteRepositoryRequest) (*longrunningpb.Operation, error)
	// Fetches read/write token of a given repository.
	FetchReadWriteToken(context.Context, *FetchReadWriteTokenRequest) (*FetchReadWriteTokenResponse, error)
	// Fetches read token of a given repository.
	FetchReadToken(context.Context, *FetchReadTokenRequest) (*FetchReadTokenResponse, error)
	// FetchLinkableRepositories get repositories from SCM that are
	// accessible and could be added to the connection.
	FetchLinkableRepositories(context.Context, *FetchLinkableRepositoriesRequest) (*FetchLinkableRepositoriesResponse, error)
	// Fetch the list of branches or tags for a given repository.
	FetchGitRefs(context.Context, *FetchGitRefsRequest) (*FetchGitRefsResponse, error)
}

// UnimplementedRepositoryManagerServer should be embedded to have forward compatible implementations.
type UnimplementedRepositoryManagerServer struct {
}

func (UnimplementedRepositoryManagerServer) CreateConnection(context.Context, *CreateConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConnection not implemented")
}
func (UnimplementedRepositoryManagerServer) GetConnection(context.Context, *GetConnectionRequest) (*Connection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConnection not implemented")
}
func (UnimplementedRepositoryManagerServer) ListConnections(context.Context, *ListConnectionsRequest) (*ListConnectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConnections not implemented")
}
func (UnimplementedRepositoryManagerServer) UpdateConnection(context.Context, *UpdateConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConnection not implemented")
}
func (UnimplementedRepositoryManagerServer) DeleteConnection(context.Context, *DeleteConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConnection not implemented")
}
func (UnimplementedRepositoryManagerServer) CreateRepository(context.Context, *CreateRepositoryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRepository not implemented")
}
func (UnimplementedRepositoryManagerServer) BatchCreateRepositories(context.Context, *BatchCreateRepositoriesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateRepositories not implemented")
}
func (UnimplementedRepositoryManagerServer) GetRepository(context.Context, *GetRepositoryRequest) (*Repository, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRepository not implemented")
}
func (UnimplementedRepositoryManagerServer) ListRepositories(context.Context, *ListRepositoriesRequest) (*ListRepositoriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRepositories not implemented")
}
func (UnimplementedRepositoryManagerServer) DeleteRepository(context.Context, *DeleteRepositoryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRepository not implemented")
}
func (UnimplementedRepositoryManagerServer) FetchReadWriteToken(context.Context, *FetchReadWriteTokenRequest) (*FetchReadWriteTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchReadWriteToken not implemented")
}
func (UnimplementedRepositoryManagerServer) FetchReadToken(context.Context, *FetchReadTokenRequest) (*FetchReadTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchReadToken not implemented")
}
func (UnimplementedRepositoryManagerServer) FetchLinkableRepositories(context.Context, *FetchLinkableRepositoriesRequest) (*FetchLinkableRepositoriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchLinkableRepositories not implemented")
}
func (UnimplementedRepositoryManagerServer) FetchGitRefs(context.Context, *FetchGitRefsRequest) (*FetchGitRefsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchGitRefs not implemented")
}

// UnsafeRepositoryManagerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RepositoryManagerServer will
// result in compilation errors.
type UnsafeRepositoryManagerServer interface {
	mustEmbedUnimplementedRepositoryManagerServer()
}

func RegisterRepositoryManagerServer(s grpc.ServiceRegistrar, srv RepositoryManagerServer) {
	s.RegisterService(&RepositoryManager_ServiceDesc, srv)
}

func _RepositoryManager_CreateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).CreateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryManager_CreateConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).CreateConnection(ctx, req.(*CreateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_GetConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).GetConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryManager_GetConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).GetConnection(ctx, req.(*GetConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_ListConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConnectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).ListConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryManager_ListConnections_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).ListConnections(ctx, req.(*ListConnectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_UpdateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).UpdateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryManager_UpdateConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).UpdateConnection(ctx, req.(*UpdateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_DeleteConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).DeleteConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryManager_DeleteConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).DeleteConnection(ctx, req.(*DeleteConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_CreateRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).CreateRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryManager_CreateRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).CreateRepository(ctx, req.(*CreateRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_BatchCreateRepositories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateRepositoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).BatchCreateRepositories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryManager_BatchCreateRepositories_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).BatchCreateRepositories(ctx, req.(*BatchCreateRepositoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_GetRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).GetRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryManager_GetRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).GetRepository(ctx, req.(*GetRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_ListRepositories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRepositoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).ListRepositories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryManager_ListRepositories_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).ListRepositories(ctx, req.(*ListRepositoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_DeleteRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).DeleteRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryManager_DeleteRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).DeleteRepository(ctx, req.(*DeleteRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_FetchReadWriteToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchReadWriteTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).FetchReadWriteToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryManager_FetchReadWriteToken_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).FetchReadWriteToken(ctx, req.(*FetchReadWriteTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_FetchReadToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchReadTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).FetchReadToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryManager_FetchReadToken_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).FetchReadToken(ctx, req.(*FetchReadTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_FetchLinkableRepositories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchLinkableRepositoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).FetchLinkableRepositories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryManager_FetchLinkableRepositories_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).FetchLinkableRepositories(ctx, req.(*FetchLinkableRepositoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_FetchGitRefs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchGitRefsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).FetchGitRefs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryManager_FetchGitRefs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).FetchGitRefs(ctx, req.(*FetchGitRefsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// RepositoryManager_ServiceDesc is the grpc.ServiceDesc for RepositoryManager service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var RepositoryManager_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.cloudbuild.v2.RepositoryManager",
	HandlerType: (*RepositoryManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateConnection",
			Handler:    _RepositoryManager_CreateConnection_Handler,
		},
		{
			MethodName: "GetConnection",
			Handler:    _RepositoryManager_GetConnection_Handler,
		},
		{
			MethodName: "ListConnections",
			Handler:    _RepositoryManager_ListConnections_Handler,
		},
		{
			MethodName: "UpdateConnection",
			Handler:    _RepositoryManager_UpdateConnection_Handler,
		},
		{
			MethodName: "DeleteConnection",
			Handler:    _RepositoryManager_DeleteConnection_Handler,
		},
		{
			MethodName: "CreateRepository",
			Handler:    _RepositoryManager_CreateRepository_Handler,
		},
		{
			MethodName: "BatchCreateRepositories",
			Handler:    _RepositoryManager_BatchCreateRepositories_Handler,
		},
		{
			MethodName: "GetRepository",
			Handler:    _RepositoryManager_GetRepository_Handler,
		},
		{
			MethodName: "ListRepositories",
			Handler:    _RepositoryManager_ListRepositories_Handler,
		},
		{
			MethodName: "DeleteRepository",
			Handler:    _RepositoryManager_DeleteRepository_Handler,
		},
		{
			MethodName: "FetchReadWriteToken",
			Handler:    _RepositoryManager_FetchReadWriteToken_Handler,
		},
		{
			MethodName: "FetchReadToken",
			Handler:    _RepositoryManager_FetchReadToken_Handler,
		},
		{
			MethodName: "FetchLinkableRepositories",
			Handler:    _RepositoryManager_FetchLinkableRepositories_Handler,
		},
		{
			MethodName: "FetchGitRefs",
			Handler:    _RepositoryManager_FetchGitRefs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/cloudbuild/v2/repositories.proto",
}
