// This file was AUTOMATICALLY GENERATED by kilt-import (smuggol) from github.com/robertkrimen/kilt

package kilt

import (
	"os"
)

// Symlink
func (self Kilt) Symlink(oldname, newname string, overwrite bool) error {
	return Symlink(oldname, newname, overwrite)
}

func Symlink(oldname, newname string, overwrite bool) error {
	err := os.Symlink(oldname, newname)
	if err == nil {
		return nil // Success
	}
	if !os.IsExist(err) {
		return err // Failure
	}
	// Failure, file exists
	symbolic := false
	{
		stat, err := os.Lstat(newname)
		if err != nil {
			return err
		}
		symbolic = stat.Mode()&os.ModeSymlink != 0
	}
	if !symbolic {
		return err
	}
	if !overwrite {
		return nil
	}
	err = os.Remove(newname)
	if err != nil {
		return err
	}
	return os.Symlink(oldname, newname)
}
