package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"errors"
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/converter"

	"strings"
)

// VulnerabilityDataObjectExtendPropertiesOperations 扩展操作属性
type VulnerabilityDataObjectExtendPropertiesOperations struct {

	// 是否内置属性，取值说明：false 表示手工导入漏洞；true 表示内置漏洞
	IsBuildIn *VulnerabilityDataObjectExtendPropertiesOperationsIsBuildIn `json:"is_build_in,omitempty"`
}

func (o VulnerabilityDataObjectExtendPropertiesOperations) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "VulnerabilityDataObjectExtendPropertiesOperations struct{}"
	}

	return strings.Join([]string{"VulnerabilityDataObjectExtendPropertiesOperations", string(data)}, " ")
}

type VulnerabilityDataObjectExtendPropertiesOperationsIsBuildIn struct {
	value string
}

type VulnerabilityDataObjectExtendPropertiesOperationsIsBuildInEnum struct {
	TRUE  VulnerabilityDataObjectExtendPropertiesOperationsIsBuildIn
	FALSE VulnerabilityDataObjectExtendPropertiesOperationsIsBuildIn
}

func GetVulnerabilityDataObjectExtendPropertiesOperationsIsBuildInEnum() VulnerabilityDataObjectExtendPropertiesOperationsIsBuildInEnum {
	return VulnerabilityDataObjectExtendPropertiesOperationsIsBuildInEnum{
		TRUE: VulnerabilityDataObjectExtendPropertiesOperationsIsBuildIn{
			value: "true",
		},
		FALSE: VulnerabilityDataObjectExtendPropertiesOperationsIsBuildIn{
			value: "false",
		},
	}
}

func (c VulnerabilityDataObjectExtendPropertiesOperationsIsBuildIn) Value() string {
	return c.value
}

func (c VulnerabilityDataObjectExtendPropertiesOperationsIsBuildIn) MarshalJSON() ([]byte, error) {
	return utils.Marshal(c.value)
}

func (c *VulnerabilityDataObjectExtendPropertiesOperationsIsBuildIn) UnmarshalJSON(b []byte) error {
	myConverter := converter.StringConverterFactory("string")
	if myConverter == nil {
		return errors.New("unsupported StringConverter type: string")
	}

	interf, err := myConverter.CovertStringToInterface(strings.Trim(string(b[:]), "\""))
	if err != nil {
		return err
	}

	if val, ok := interf.(string); ok {
		c.value = val
		return nil
	} else {
		return errors.New("convert enum data to string error")
	}
}
