// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/notebooks/v1beta1/service.proto

package notebookspb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	NotebookService_ListInstances_FullMethodName           = "/google.cloud.notebooks.v1beta1.NotebookService/ListInstances"
	NotebookService_GetInstance_FullMethodName             = "/google.cloud.notebooks.v1beta1.NotebookService/GetInstance"
	NotebookService_CreateInstance_FullMethodName          = "/google.cloud.notebooks.v1beta1.NotebookService/CreateInstance"
	NotebookService_RegisterInstance_FullMethodName        = "/google.cloud.notebooks.v1beta1.NotebookService/RegisterInstance"
	NotebookService_SetInstanceAccelerator_FullMethodName  = "/google.cloud.notebooks.v1beta1.NotebookService/SetInstanceAccelerator"
	NotebookService_SetInstanceMachineType_FullMethodName  = "/google.cloud.notebooks.v1beta1.NotebookService/SetInstanceMachineType"
	NotebookService_SetInstanceLabels_FullMethodName       = "/google.cloud.notebooks.v1beta1.NotebookService/SetInstanceLabels"
	NotebookService_DeleteInstance_FullMethodName          = "/google.cloud.notebooks.v1beta1.NotebookService/DeleteInstance"
	NotebookService_StartInstance_FullMethodName           = "/google.cloud.notebooks.v1beta1.NotebookService/StartInstance"
	NotebookService_StopInstance_FullMethodName            = "/google.cloud.notebooks.v1beta1.NotebookService/StopInstance"
	NotebookService_ResetInstance_FullMethodName           = "/google.cloud.notebooks.v1beta1.NotebookService/ResetInstance"
	NotebookService_ReportInstanceInfo_FullMethodName      = "/google.cloud.notebooks.v1beta1.NotebookService/ReportInstanceInfo"
	NotebookService_IsInstanceUpgradeable_FullMethodName   = "/google.cloud.notebooks.v1beta1.NotebookService/IsInstanceUpgradeable"
	NotebookService_UpgradeInstance_FullMethodName         = "/google.cloud.notebooks.v1beta1.NotebookService/UpgradeInstance"
	NotebookService_UpgradeInstanceInternal_FullMethodName = "/google.cloud.notebooks.v1beta1.NotebookService/UpgradeInstanceInternal"
	NotebookService_ListEnvironments_FullMethodName        = "/google.cloud.notebooks.v1beta1.NotebookService/ListEnvironments"
	NotebookService_GetEnvironment_FullMethodName          = "/google.cloud.notebooks.v1beta1.NotebookService/GetEnvironment"
	NotebookService_CreateEnvironment_FullMethodName       = "/google.cloud.notebooks.v1beta1.NotebookService/CreateEnvironment"
	NotebookService_DeleteEnvironment_FullMethodName       = "/google.cloud.notebooks.v1beta1.NotebookService/DeleteEnvironment"
)

// NotebookServiceClient is the client API for NotebookService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type NotebookServiceClient interface {
	// Lists instances in a given project and location.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Gets details of a single Instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Creates a new Instance in a given project and location.
	CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Registers an existing legacy notebook instance to the Notebooks API server.
	// Legacy instances are instances created with the legacy Compute Engine
	// calls. They are not manageable by the Notebooks API out of the box. This
	// call makes these instances manageable by the Notebooks API.
	RegisterInstance(ctx context.Context, in *RegisterInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the guest accelerators of a single Instance.
	SetInstanceAccelerator(ctx context.Context, in *SetInstanceAcceleratorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the machine type of a single Instance.
	SetInstanceMachineType(ctx context.Context, in *SetInstanceMachineTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the labels of an Instance.
	SetInstanceLabels(ctx context.Context, in *SetInstanceLabelsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Instance.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Starts a notebook instance.
	StartInstance(ctx context.Context, in *StartInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Stops a notebook instance.
	StopInstance(ctx context.Context, in *StopInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Resets a notebook instance.
	ResetInstance(ctx context.Context, in *ResetInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Allows notebook instances to
	// report their latest instance information to the Notebooks
	// API server. The server will merge the reported information to
	// the instance metadata store. Do not use this method directly.
	ReportInstanceInfo(ctx context.Context, in *ReportInstanceInfoRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Check if a notebook instance is upgradable.
	// Deprecated. Please consider using v1.
	IsInstanceUpgradeable(ctx context.Context, in *IsInstanceUpgradeableRequest, opts ...grpc.CallOption) (*IsInstanceUpgradeableResponse, error)
	// Deprecated: Do not use.
	// Upgrades a notebook instance to the latest version.
	// Deprecated. Please consider using v1.
	UpgradeInstance(ctx context.Context, in *UpgradeInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Allows notebook instances to
	// call this endpoint to upgrade themselves. Do not use this method directly.
	// Deprecated. Please consider using v1.
	UpgradeInstanceInternal(ctx context.Context, in *UpgradeInstanceInternalRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists environments in a project.
	ListEnvironments(ctx context.Context, in *ListEnvironmentsRequest, opts ...grpc.CallOption) (*ListEnvironmentsResponse, error)
	// Gets details of a single Environment.
	GetEnvironment(ctx context.Context, in *GetEnvironmentRequest, opts ...grpc.CallOption) (*Environment, error)
	// Creates a new Environment.
	CreateEnvironment(ctx context.Context, in *CreateEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Environment.
	DeleteEnvironment(ctx context.Context, in *DeleteEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type notebookServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewNotebookServiceClient(cc grpc.ClientConnInterface) NotebookServiceClient {
	return &notebookServiceClient{cc}
}

func (c *notebookServiceClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, NotebookService_ListInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, NotebookService_GetInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_CreateInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) RegisterInstance(ctx context.Context, in *RegisterInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_RegisterInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) SetInstanceAccelerator(ctx context.Context, in *SetInstanceAcceleratorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_SetInstanceAccelerator_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) SetInstanceMachineType(ctx context.Context, in *SetInstanceMachineTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_SetInstanceMachineType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) SetInstanceLabels(ctx context.Context, in *SetInstanceLabelsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_SetInstanceLabels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_DeleteInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) StartInstance(ctx context.Context, in *StartInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_StartInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) StopInstance(ctx context.Context, in *StopInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_StopInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) ResetInstance(ctx context.Context, in *ResetInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_ResetInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) ReportInstanceInfo(ctx context.Context, in *ReportInstanceInfoRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_ReportInstanceInfo_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *notebookServiceClient) IsInstanceUpgradeable(ctx context.Context, in *IsInstanceUpgradeableRequest, opts ...grpc.CallOption) (*IsInstanceUpgradeableResponse, error) {
	out := new(IsInstanceUpgradeableResponse)
	err := c.cc.Invoke(ctx, NotebookService_IsInstanceUpgradeable_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *notebookServiceClient) UpgradeInstance(ctx context.Context, in *UpgradeInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_UpgradeInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *notebookServiceClient) UpgradeInstanceInternal(ctx context.Context, in *UpgradeInstanceInternalRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_UpgradeInstanceInternal_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) ListEnvironments(ctx context.Context, in *ListEnvironmentsRequest, opts ...grpc.CallOption) (*ListEnvironmentsResponse, error) {
	out := new(ListEnvironmentsResponse)
	err := c.cc.Invoke(ctx, NotebookService_ListEnvironments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) GetEnvironment(ctx context.Context, in *GetEnvironmentRequest, opts ...grpc.CallOption) (*Environment, error) {
	out := new(Environment)
	err := c.cc.Invoke(ctx, NotebookService_GetEnvironment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) CreateEnvironment(ctx context.Context, in *CreateEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_CreateEnvironment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) DeleteEnvironment(ctx context.Context, in *DeleteEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_DeleteEnvironment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NotebookServiceServer is the server API for NotebookService service.
// All implementations should embed UnimplementedNotebookServiceServer
// for forward compatibility
type NotebookServiceServer interface {
	// Lists instances in a given project and location.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Gets details of a single Instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Creates a new Instance in a given project and location.
	CreateInstance(context.Context, *CreateInstanceRequest) (*longrunningpb.Operation, error)
	// Registers an existing legacy notebook instance to the Notebooks API server.
	// Legacy instances are instances created with the legacy Compute Engine
	// calls. They are not manageable by the Notebooks API out of the box. This
	// call makes these instances manageable by the Notebooks API.
	RegisterInstance(context.Context, *RegisterInstanceRequest) (*longrunningpb.Operation, error)
	// Updates the guest accelerators of a single Instance.
	SetInstanceAccelerator(context.Context, *SetInstanceAcceleratorRequest) (*longrunningpb.Operation, error)
	// Updates the machine type of a single Instance.
	SetInstanceMachineType(context.Context, *SetInstanceMachineTypeRequest) (*longrunningpb.Operation, error)
	// Updates the labels of an Instance.
	SetInstanceLabels(context.Context, *SetInstanceLabelsRequest) (*longrunningpb.Operation, error)
	// Deletes a single Instance.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*longrunningpb.Operation, error)
	// Starts a notebook instance.
	StartInstance(context.Context, *StartInstanceRequest) (*longrunningpb.Operation, error)
	// Stops a notebook instance.
	StopInstance(context.Context, *StopInstanceRequest) (*longrunningpb.Operation, error)
	// Resets a notebook instance.
	ResetInstance(context.Context, *ResetInstanceRequest) (*longrunningpb.Operation, error)
	// Allows notebook instances to
	// report their latest instance information to the Notebooks
	// API server. The server will merge the reported information to
	// the instance metadata store. Do not use this method directly.
	ReportInstanceInfo(context.Context, *ReportInstanceInfoRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Check if a notebook instance is upgradable.
	// Deprecated. Please consider using v1.
	IsInstanceUpgradeable(context.Context, *IsInstanceUpgradeableRequest) (*IsInstanceUpgradeableResponse, error)
	// Deprecated: Do not use.
	// Upgrades a notebook instance to the latest version.
	// Deprecated. Please consider using v1.
	UpgradeInstance(context.Context, *UpgradeInstanceRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Allows notebook instances to
	// call this endpoint to upgrade themselves. Do not use this method directly.
	// Deprecated. Please consider using v1.
	UpgradeInstanceInternal(context.Context, *UpgradeInstanceInternalRequest) (*longrunningpb.Operation, error)
	// Lists environments in a project.
	ListEnvironments(context.Context, *ListEnvironmentsRequest) (*ListEnvironmentsResponse, error)
	// Gets details of a single Environment.
	GetEnvironment(context.Context, *GetEnvironmentRequest) (*Environment, error)
	// Creates a new Environment.
	CreateEnvironment(context.Context, *CreateEnvironmentRequest) (*longrunningpb.Operation, error)
	// Deletes a single Environment.
	DeleteEnvironment(context.Context, *DeleteEnvironmentRequest) (*longrunningpb.Operation, error)
}

// UnimplementedNotebookServiceServer should be embedded to have forward compatible implementations.
type UnimplementedNotebookServiceServer struct {
}

func (UnimplementedNotebookServiceServer) ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstances not implemented")
}
func (UnimplementedNotebookServiceServer) GetInstance(context.Context, *GetInstanceRequest) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstance not implemented")
}
func (UnimplementedNotebookServiceServer) CreateInstance(context.Context, *CreateInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInstance not implemented")
}
func (UnimplementedNotebookServiceServer) RegisterInstance(context.Context, *RegisterInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RegisterInstance not implemented")
}
func (UnimplementedNotebookServiceServer) SetInstanceAccelerator(context.Context, *SetInstanceAcceleratorRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetInstanceAccelerator not implemented")
}
func (UnimplementedNotebookServiceServer) SetInstanceMachineType(context.Context, *SetInstanceMachineTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetInstanceMachineType not implemented")
}
func (UnimplementedNotebookServiceServer) SetInstanceLabels(context.Context, *SetInstanceLabelsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetInstanceLabels not implemented")
}
func (UnimplementedNotebookServiceServer) DeleteInstance(context.Context, *DeleteInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInstance not implemented")
}
func (UnimplementedNotebookServiceServer) StartInstance(context.Context, *StartInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartInstance not implemented")
}
func (UnimplementedNotebookServiceServer) StopInstance(context.Context, *StopInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopInstance not implemented")
}
func (UnimplementedNotebookServiceServer) ResetInstance(context.Context, *ResetInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetInstance not implemented")
}
func (UnimplementedNotebookServiceServer) ReportInstanceInfo(context.Context, *ReportInstanceInfoRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportInstanceInfo not implemented")
}
func (UnimplementedNotebookServiceServer) IsInstanceUpgradeable(context.Context, *IsInstanceUpgradeableRequest) (*IsInstanceUpgradeableResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsInstanceUpgradeable not implemented")
}
func (UnimplementedNotebookServiceServer) UpgradeInstance(context.Context, *UpgradeInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpgradeInstance not implemented")
}
func (UnimplementedNotebookServiceServer) UpgradeInstanceInternal(context.Context, *UpgradeInstanceInternalRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpgradeInstanceInternal not implemented")
}
func (UnimplementedNotebookServiceServer) ListEnvironments(context.Context, *ListEnvironmentsRequest) (*ListEnvironmentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEnvironments not implemented")
}
func (UnimplementedNotebookServiceServer) GetEnvironment(context.Context, *GetEnvironmentRequest) (*Environment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEnvironment not implemented")
}
func (UnimplementedNotebookServiceServer) CreateEnvironment(context.Context, *CreateEnvironmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEnvironment not implemented")
}
func (UnimplementedNotebookServiceServer) DeleteEnvironment(context.Context, *DeleteEnvironmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEnvironment not implemented")
}

// UnsafeNotebookServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to NotebookServiceServer will
// result in compilation errors.
type UnsafeNotebookServiceServer interface {
	mustEmbedUnimplementedNotebookServiceServer()
}

func RegisterNotebookServiceServer(s grpc.ServiceRegistrar, srv NotebookServiceServer) {
	s.RegisterService(&NotebookService_ServiceDesc, srv)
}

func _NotebookService_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_ListInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_GetInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_CreateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).CreateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_CreateInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).CreateInstance(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_RegisterInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegisterInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).RegisterInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_RegisterInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).RegisterInstance(ctx, req.(*RegisterInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_SetInstanceAccelerator_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetInstanceAcceleratorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).SetInstanceAccelerator(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_SetInstanceAccelerator_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).SetInstanceAccelerator(ctx, req.(*SetInstanceAcceleratorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_SetInstanceMachineType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetInstanceMachineTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).SetInstanceMachineType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_SetInstanceMachineType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).SetInstanceMachineType(ctx, req.(*SetInstanceMachineTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_SetInstanceLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetInstanceLabelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).SetInstanceLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_SetInstanceLabels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).SetInstanceLabels(ctx, req.(*SetInstanceLabelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_DeleteInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_StartInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).StartInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_StartInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).StartInstance(ctx, req.(*StartInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_StopInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).StopInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_StopInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).StopInstance(ctx, req.(*StopInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_ResetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).ResetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_ResetInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).ResetInstance(ctx, req.(*ResetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_ReportInstanceInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportInstanceInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).ReportInstanceInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_ReportInstanceInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).ReportInstanceInfo(ctx, req.(*ReportInstanceInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_IsInstanceUpgradeable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IsInstanceUpgradeableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).IsInstanceUpgradeable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_IsInstanceUpgradeable_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).IsInstanceUpgradeable(ctx, req.(*IsInstanceUpgradeableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_UpgradeInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpgradeInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).UpgradeInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_UpgradeInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).UpgradeInstance(ctx, req.(*UpgradeInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_UpgradeInstanceInternal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpgradeInstanceInternalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).UpgradeInstanceInternal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_UpgradeInstanceInternal_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).UpgradeInstanceInternal(ctx, req.(*UpgradeInstanceInternalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_ListEnvironments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEnvironmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).ListEnvironments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_ListEnvironments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).ListEnvironments(ctx, req.(*ListEnvironmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_GetEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).GetEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_GetEnvironment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).GetEnvironment(ctx, req.(*GetEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_CreateEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).CreateEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_CreateEnvironment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).CreateEnvironment(ctx, req.(*CreateEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_DeleteEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).DeleteEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_DeleteEnvironment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).DeleteEnvironment(ctx, req.(*DeleteEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// NotebookService_ServiceDesc is the grpc.ServiceDesc for NotebookService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var NotebookService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.notebooks.v1beta1.NotebookService",
	HandlerType: (*NotebookServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInstances",
			Handler:    _NotebookService_ListInstances_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _NotebookService_GetInstance_Handler,
		},
		{
			MethodName: "CreateInstance",
			Handler:    _NotebookService_CreateInstance_Handler,
		},
		{
			MethodName: "RegisterInstance",
			Handler:    _NotebookService_RegisterInstance_Handler,
		},
		{
			MethodName: "SetInstanceAccelerator",
			Handler:    _NotebookService_SetInstanceAccelerator_Handler,
		},
		{
			MethodName: "SetInstanceMachineType",
			Handler:    _NotebookService_SetInstanceMachineType_Handler,
		},
		{
			MethodName: "SetInstanceLabels",
			Handler:    _NotebookService_SetInstanceLabels_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _NotebookService_DeleteInstance_Handler,
		},
		{
			MethodName: "StartInstance",
			Handler:    _NotebookService_StartInstance_Handler,
		},
		{
			MethodName: "StopInstance",
			Handler:    _NotebookService_StopInstance_Handler,
		},
		{
			MethodName: "ResetInstance",
			Handler:    _NotebookService_ResetInstance_Handler,
		},
		{
			MethodName: "ReportInstanceInfo",
			Handler:    _NotebookService_ReportInstanceInfo_Handler,
		},
		{
			MethodName: "IsInstanceUpgradeable",
			Handler:    _NotebookService_IsInstanceUpgradeable_Handler,
		},
		{
			MethodName: "UpgradeInstance",
			Handler:    _NotebookService_UpgradeInstance_Handler,
		},
		{
			MethodName: "UpgradeInstanceInternal",
			Handler:    _NotebookService_UpgradeInstanceInternal_Handler,
		},
		{
			MethodName: "ListEnvironments",
			Handler:    _NotebookService_ListEnvironments_Handler,
		},
		{
			MethodName: "GetEnvironment",
			Handler:    _NotebookService_GetEnvironment_Handler,
		},
		{
			MethodName: "CreateEnvironment",
			Handler:    _NotebookService_CreateEnvironment_Handler,
		},
		{
			MethodName: "DeleteEnvironment",
			Handler:    _NotebookService_DeleteEnvironment_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/notebooks/v1beta1/service.proto",
}
