/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.apply;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.CharSource;
import com.google.errorprone.fixes.Replacement;
import com.google.errorprone.fixes.Replacements;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.tools.JavaFileObject;

public class SourceFile {
    private final String path;
    private final StringBuilder sourceBuilder;

    public static SourceFile create(JavaFileObject fileObject) throws IOException {
        return new SourceFile(fileObject.toUri().getPath(), fileObject.getCharContent(false));
    }

    public SourceFile(String path, CharSequence source) {
        this.path = path;
        this.sourceBuilder = new StringBuilder(source);
    }

    public String getPath() {
        return this.path;
    }

    public List<String> getLines() {
        try {
            return CharSource.wrap((CharSequence)this.sourceBuilder).readLines();
        }
        catch (IOException e) {
            throw new AssertionError("IOException not possible, as the string is in-memory", e);
        }
    }

    public String getSourceText() {
        return this.sourceBuilder.toString();
    }

    public CharSequence getAsSequence() {
        return CharBuffer.wrap(this.sourceBuilder).asReadOnlyBuffer();
    }

    public void setSourceText(CharSequence source) {
        this.sourceBuilder.setLength(0);
        this.sourceBuilder.append(source);
    }

    public String getFragmentByChars(int startPosition, int endPosition) {
        return this.sourceBuilder.substring(startPosition, endPosition);
    }

    public String getFragmentByLines(int startLine, int endLine) {
        Preconditions.checkArgument((startLine <= endLine ? 1 : 0) != 0);
        return Joiner.on((String)"\n").join(this.getLines(startLine, endLine)) + "\n";
    }

    private List<String> getLines(int startLine, int endLine) {
        LineNumberReader reader = new LineNumberReader(new StringReader(this.sourceBuilder.toString()));
        ArrayList<String> lines = new ArrayList<String>(endLine - startLine + 1);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (reader.getLineNumber() >= startLine) {
                    lines.add(line);
                }
                if (reader.getLineNumber() < endLine) continue;
            }
            return lines;
        }
        catch (IOException e) {
            throw new AssertionError("Wrapped StringReader should not produce I/O exceptions", e);
        }
    }

    public void replaceLines(List<String> lines) {
        this.sourceBuilder.replace(0, this.sourceBuilder.length(), Joiner.on((String)"\n").join(lines) + "\n");
    }

    public void replaceLines(int startLine, int endLine, List<String> replacementLines) {
        Preconditions.checkArgument((startLine <= endLine ? 1 : 0) != 0);
        List<String> originalLines = this.getLines();
        ArrayList<String> newLines = new ArrayList<String>();
        for (int i = 0; i < originalLines.size(); ++i) {
            int lineNum = i + 1;
            if (lineNum == startLine) {
                newLines.addAll(replacementLines);
                continue;
            }
            if (lineNum > startLine && lineNum <= endLine) continue;
            newLines.add(originalLines.get(i));
        }
        this.replaceLines(newLines);
    }

    public void replaceChars(int startPosition, int endPosition, String replacement) {
        try {
            this.sourceBuilder.replace(startPosition, endPosition, replacement);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(String.format("Replacement cannot be made. Source file %s has length %d, requested start position %d, requested end position %d, replacement %s", this.path, this.sourceBuilder.length(), startPosition, endPosition, replacement));
        }
    }

    void makeReplacements(Replacements changes) {
        ImmutableSet<Replacement> replacements = changes.ascending();
        switch (replacements.size()) {
            case 0: {
                return;
            }
            case 1: {
                Replacement onlyReplacement = (Replacement)Iterables.getOnlyElement(replacements);
                this.replaceChars(onlyReplacement.startPosition(), onlyReplacement.endPosition(), onlyReplacement.replaceWith());
                return;
            }
        }
        StringBuilder newContent = new StringBuilder();
        int positionInOriginal = 0;
        for (Replacement repl : replacements) {
            Preconditions.checkArgument((repl.endPosition() <= this.sourceBuilder.length() ? 1 : 0) != 0, (String)"End [%s] should not exceed source length [%s]", (int)repl.endPosition(), (int)this.sourceBuilder.length());
            newContent.append(this.sourceBuilder, positionInOriginal, repl.startPosition());
            newContent.append(repl.replaceWith());
            positionInOriginal = repl.endPosition();
        }
        newContent.append(this.sourceBuilder, positionInOriginal, this.sourceBuilder.length());
        this.setSourceText(newContent);
    }
}

