/*
 * Subset of Influx API covered by Influx CLI
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * API version: 2.0.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package api

import (
	"encoding/json"
	"time"
)

// LogEvent struct for LogEvent
type LogEvent struct {
	// The time ([RFC3339Nano date/time format]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#rfc3339nano-timestamp)) that the event occurred.
	Time *time.Time `json:"time,omitempty" yaml:"time,omitempty"`
	// A description of the event that occurred.
	Message *string `json:"message,omitempty" yaml:"message,omitempty"`
	// The ID of the task run that generated the event.
	RunID *string `json:"runID,omitempty" yaml:"runID,omitempty"`
}

// NewLogEvent instantiates a new LogEvent object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewLogEvent() *LogEvent {
	this := LogEvent{}
	return &this
}

// NewLogEventWithDefaults instantiates a new LogEvent object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewLogEventWithDefaults() *LogEvent {
	this := LogEvent{}
	return &this
}

// GetTime returns the Time field value if set, zero value otherwise.
func (o *LogEvent) GetTime() time.Time {
	if o == nil || o.Time == nil {
		var ret time.Time
		return ret
	}
	return *o.Time
}

// GetTimeOk returns a tuple with the Time field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *LogEvent) GetTimeOk() (*time.Time, bool) {
	if o == nil || o.Time == nil {
		return nil, false
	}
	return o.Time, true
}

// HasTime returns a boolean if a field has been set.
func (o *LogEvent) HasTime() bool {
	if o != nil && o.Time != nil {
		return true
	}

	return false
}

// SetTime gets a reference to the given time.Time and assigns it to the Time field.
func (o *LogEvent) SetTime(v time.Time) {
	o.Time = &v
}

// GetMessage returns the Message field value if set, zero value otherwise.
func (o *LogEvent) GetMessage() string {
	if o == nil || o.Message == nil {
		var ret string
		return ret
	}
	return *o.Message
}

// GetMessageOk returns a tuple with the Message field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *LogEvent) GetMessageOk() (*string, bool) {
	if o == nil || o.Message == nil {
		return nil, false
	}
	return o.Message, true
}

// HasMessage returns a boolean if a field has been set.
func (o *LogEvent) HasMessage() bool {
	if o != nil && o.Message != nil {
		return true
	}

	return false
}

// SetMessage gets a reference to the given string and assigns it to the Message field.
func (o *LogEvent) SetMessage(v string) {
	o.Message = &v
}

// GetRunID returns the RunID field value if set, zero value otherwise.
func (o *LogEvent) GetRunID() string {
	if o == nil || o.RunID == nil {
		var ret string
		return ret
	}
	return *o.RunID
}

// GetRunIDOk returns a tuple with the RunID field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *LogEvent) GetRunIDOk() (*string, bool) {
	if o == nil || o.RunID == nil {
		return nil, false
	}
	return o.RunID, true
}

// HasRunID returns a boolean if a field has been set.
func (o *LogEvent) HasRunID() bool {
	if o != nil && o.RunID != nil {
		return true
	}

	return false
}

// SetRunID gets a reference to the given string and assigns it to the RunID field.
func (o *LogEvent) SetRunID(v string) {
	o.RunID = &v
}

func (o LogEvent) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Time != nil {
		toSerialize["time"] = o.Time
	}
	if o.Message != nil {
		toSerialize["message"] = o.Message
	}
	if o.RunID != nil {
		toSerialize["runID"] = o.RunID
	}
	return json.Marshal(toSerialize)
}

type NullableLogEvent struct {
	value *LogEvent
	isSet bool
}

func (v NullableLogEvent) Get() *LogEvent {
	return v.value
}

func (v *NullableLogEvent) Set(val *LogEvent) {
	v.value = val
	v.isSet = true
}

func (v NullableLogEvent) IsSet() bool {
	return v.isSet
}

func (v *NullableLogEvent) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableLogEvent(val *LogEvent) *NullableLogEvent {
	return &NullableLogEvent{value: val, isSet: true}
}

func (v NullableLogEvent) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableLogEvent) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
