package lttb

import (
	"testing"
)

var data = []Point[float64]{
	{0, 29.357995947822218}, {1, 29.40932479606209}, {2, 29.28168582006162}, {3, 30.409965579108867}, {4, 30.7726859735917}, {5, 30.839942247539028}, {6, 30.760611642264667}, {7, 31.203663004229718}, {8, 31.38899603525572}, {9, 30.890299916955737},
	{10, 30.467811944911556}, {11, 30.596837868069542}, {12, 30.59789593509767}, {13, 30.19693062465079}, {14, 29.89081330734553}, {15, 29.54668002901058}, {16, 29.54890739422219}, {17, 30.53743760171474}, {18, 30.74066032317061}, {19, 30.3774450601516},
	{20, 30.095148889986568}, {21, 30.057979182917986}, {22, 30.364655421168525}, {23, 30.293450053773604}, {24, 30.14578230340987}, {25, 30.277772879951996}, {26, 30.3711931235659}, {27, 30.355932660992572}, {28, 29.994740831603046}, {29, 29.938012885023657},
	{30, 29.557268760451187}, {31, 29.16161297604625}, {32, 29.6921163421055}, {33, 30.246270628292226}, {34, 30.210955154680928}, {35, 29.382964668934058}, {36, 29.52892023906641}, {37, 29.719742065732202}, {38, 30.013856636945924}, {39, 29.818636169776926},
	{40, 27.931224826933345}, {41, 28.103057873678374}, {42, 28.276025902356782}, {43, 28.193497487789774}, {44, 28.22099171488288}, {45, 28.06872431241809}, {46, 27.239835885250365}, {47, 26.606504358317906}, {48, 27.220308136213916}, {49, 25.80790898978574},
	{50, 26.060334838062595}, {51, 25.89611036822564}, {52, 25.824433242208308}, {53, 25.89212193260212}, {54, 27.28963669872412}, {55, 27.208259984780806}, {56, 27.298211480886604}, {57, 27.056163307023077}, {58, 26.434701869643924}, {59, 26.21938188318228},
	{60, 26.402877759468772}, {61, 26.326019357967294}, {62, 27.592635104460253}, {63, 27.597468405434316}, {64, 27.533410081050647}, {65, 27.30713964830731}, {66, 27.170789712751404}, {67, 27.610166301145746}, {68, 27.619847332319885}, {69, 27.55974343996647},
	{70, 28.168803492093716}, {71, 28.284229862452584}, {72, 28.292638086760352}, {73, 28.523718178262335}, {74, 28.52268591410558}, {75, 28.576637206595993}, {76, 27.763715461946813}, {77, 27.48488075310065}, {78, 27.304006460281794}, {79, 26.902025619666333},
	{80, 26.690162079132378}, {81, 26.52277286738866}, {82, 26.09406789919051}, {83, 26.029039984983562}, {84, 26.145181108429618}, {85, 24.75335912549342}, {86, 24.787772395126176}, {87, 24.966652093726385}, {88, 25.33621421606084}, {89, 25.29283081429076},
	{90, 25.427452306231707}, {91, 25.34334450564347}, {92, 25.971939771661045}, {93, 25.907910638400836}, {94, 25.971895864171003}, {95, 26.448419417928317}, {96, 26.461057396494514}, {97, 26.332417666691025}, {98, 26.17395667752311}, {99, 25.318121919340044},
	{100, 26.092918888834987}, {101, 26.080903284583307}, {102, 26.65713935644778}, {103, 26.90227335392346}, {104, 27.14904791481757}, {105, 27.45775156727039}, {106, 28.476933177720472}, {107, 27.899526884805073}, {108, 27.274094274806096}, {109, 27.007320452528134},
	{110, 27.767594298696466}, {111, 28.669197835798027}, {112, 28.78287095361503}, {113, 28.744062941208348}, {114, 29.266136201836588}, {115, 29.29631346563548}, {116, 29.30576721224685}, {117, 28.92417256867908}, {118, 29.172020952087326}, {119, 29.36572118529946},
	{120, 29.407882394097168}, {121, 29.24581675687127}, {122, 30.374496989862006}, {123, 29.75867484229172}, {124, 29.724977349500893}, {125, 29.766232845230032}, {126, 29.755425025733203}, {127, 29.891515813029994}, {128, 29.224842590902917}, {129, 29.19894861750696},
	{130, 28.877260649054524}, {131, 29.100160763856657}, {132, 29.11303194254891}, {133, 29.471499370130353}, {134, 29.725430707066725}, {135, 29.875645922022283}, {136, 29.32336837740634}, {137, 29.659223458914788}, {138, 29.916122460150415}, {139, 29.947591268372232},
	{140, 29.912720660976237}, {141, 30.030001305562784}, {142, 30.01603062688162}, {143, 30.206305874273855}, {144, 29.654798308068155}, {145, 29.51005186796388}, {146, 29.479249298103124}, {147, 29.50465455692649}, {148, 28.668390496723326}, {149, 29.70235193454973},
	{150, 29.651621644229916}, {151, 29.514646394709878}, {152, 29.506006233800203}, {153, 29.85094476486748}, {154, 29.815453456016304}, {155, 29.942433471924208}, {156, 29.690047803042003}, {157, 29.081114874079432}, {158, 29.064499954878283}, {159, 29.17427761652929},
	{160, 28.48135454514647}, {161, 28.43614347392514}, {162, 28.615830690136196}, {163, 27.244815449582045}, {164, 28.030839937141593}, {165, 28.09433740820739}, {166, 28.134090510807432}, {167, 28.333335545414524}, {168, 28.187860385951467}, {169, 28.275647207865163},
	{170, 28.110663780904385}, {171, 27.941108395946074}, {172, 27.155839334130572}, {173, 27.486338387798014}, {174, 27.822551655905976}, {175, 27.863745721980674}, {176, 27.51492123912736}, {177, 27.83845450366903}, {178, 27.143346163904276}, {179, 26.470510229480666},
	{180, 27.030260699355054}, {181, 26.530046883178517}, {182, 26.061343714664623}, {183, 26.451944204073293}, {184, 26.430516873002972}, {185, 27.54560649645601}, {186, 27.607455732128237}, {187, 27.3151823435893}, {188, 27.015508353290546}, {189, 27.564104270774138},
	{190, 27.401004407024764}, {191, 27.158236015306873}, {192, 27.15560082391509}, {193, 27.052060260660955}, {194, 27.170854273897024}, {195, 27.764649442110628}, {196, 28.37485762180034}, {197, 28.693644963914128}, {198, 28.639988945921225}, {199, 28.55415913033328},
	{200, 28.227269873938933}, {201, 28.17193587609251}, {202, 28.326544342536973}, {203, 27.64207374329132}, {204, 28.28132114918632}, {205, 28.87895845286964}, {206, 28.188530355189847}, {207, 27.543826104728634}, {208, 27.518668557969406}, {209, 27.501005443892083},
	{210, 27.4034023213343}, {211, 27.81919230719886}, {212, 28.51752545491846}, {213, 28.45642871817993}, {214, 28.281434136230057}, {215, 28.955222450571647}, {216, 28.817758413114476}, {217, 28.512855374048605}, {218, 28.53649013938214}, {219, 28.037741647416063},
	{220, 28.758762367232816}, {221, 28.411225526795217}, {222, 28.081382658095393}, {223, 28.018197966678386}, {224, 27.669840575416934}, {225, 27.729482622798493}, {226, 27.44804950151258}, {227, 27.057357503159633}, {228, 27.02667664651584}, {229, 26.99034079421472},
	{230, 27.624460374012415}, {231, 26.6107079586933}, {232, 26.586632740266342}, {233, 26.50503068257422}, {234, 26.528094947562206}, {235, 27.42586110225183}, {236, 27.58607997646959}, {237, 27.119751888180552}, {238, 27.08687612699868}, {239, 26.50890594997075},
	{240, 27.31126847238326}, {241, 27.241646652930587}, {242, 27.206837899664286}, {243, 27.806910729195003}, {244, 27.943871889687294}, {245, 27.682133734768627}, {246, 27.717567280916626}, {247, 28.50754775235408}, {248, 28.522618646129153}, {249, 28.119450170073687},
	{250, 28.142446798473102}, {251, 27.493875384325104}, {252, 27.232866008532874}, {253, 26.815819408391537}, {254, 26.66806605894335}, {255, 26.832795316319906}, {256, 26.6709072973403}, {257, 26.805339614467922}, {258, 25.87709141573906}, {259, 25.78663848060838},
	{260, 26.292688529709856}, {261, 26.13540568260593}, {262, 26.950679537489023}, {263, 26.74360016328177}, {264, 25.880978465490344}, {265, 26.625349316487267}, {266, 27.726596358113618}, {267, 27.678660195691705}, {268, 27.712915567796777}, {269, 27.721698306913026},
	{270, 27.905267233295028}, {271, 27.957187159455156}, {272, 27.858194094400584}, {273, 28.081932932040928}, {274, 27.735044748607958}, {275, 27.032793497721116}, {276, 27.507939311361685}, {277, 27.574645954142067}, {278, 27.574051095225684}, {279, 27.759761781417595},
	{280, 27.365795276665352}, {281, 26.617667215269847}, {282, 26.798097033417232}, {283, 26.195989054524656}, {284, 26.976938134909243}, {285, 26.89198848346594}, {286, 27.147250351373707}, {287, 27.43948527543756}, {288, 28.0008367927751}, {289, 28.231697069321097},
	{290, 28.7967810312443}, {291, 29.512759843423506}, {292, 29.41555351035952}, {293, 30.70537467842703}, {294, 30.332009655179892}, {295, 30.368538690398843}, {296, 30.73440265654596}, {297, 30.967799052657455}, {298, 31.22392323854322}, {299, 31.122470949743033},
	{300, 31.140432351354303}, {301, 31.13729855237942}, {302, 30.716789453632746}, {303, 31.055606178854195}, {304, 31.025310612429436}, {305, 30.746317663776093}, {306, 31.16989662941391}, {307, 29.623226075091324}, {308, 29.11707721446215}, {309, 29.671462419401518},
	{310, 29.32656872224774}, {311, 29.360034344664133}, {312, 30.193073601940906}, {313, 30.051282853224887}, {314, 30.094809176026143}, {315, 30.62616938793058}, {316, 31.24738345775188}, {317, 31.288951935975373}, {318, 30.793680071961138}, {319, 30.855230722079575},
	{320, 30.172789122099953}, {321, 30.16588226960243}, {322, 30.02896795596743}, {323, 28.710256908027688}, {324, 28.788445957400086}, {325, 29.14084131034792}, {326, 29.154793392113767}, {327, 29.509956518244064}, {328, 29.919766479376083}, {329, 30.809790278228583},
	{330, 31.51994434827819}, {331, 31.14360887134284}, {332, 30.960009728867895}, {333, 31.007757592227232}, {334, 29.912529162927882}, {335, 30.430549132609936}, {336, 30.286270410087386}, {337, 30.29853067098949}, {338, 30.28484502358319}, {339, 30.2649148646112},
	{340, 30.269814084876984}, {341, 29.48743777656781}, {342, 29.25324229055582}, {343, 29.3224085984498}, {344, 28.845749148292715}, {345, 28.25734414947841}, {346, 28.22244460496951}, {347, 28.212727797755832}, {348, 28.099709252761244}, {349, 28.157686542165766},
	{350, 28.15110192590233}, {351, 28.242118337655835}, {352, 29.53367482995351}, {353, 29.532585019641683}, {354, 29.943653842668887}, {355, 28.64740678713178}, {356, 28.627878421859094}, {357, 28.85948017439502}, {358, 29.421837208187565}, {359, 29.213674689162733},
	{360, 29.588524659441383}, {361, 29.871736651370572}, {362, 29.97536581410366}, {363, 29.090848126781193}, {364, 29.07367624649577}, {365, 28.936182688349078}, {366, 28.478980562612755}, {367, 27.701450632319055}, {368, 27.70314463302395}, {369, 27.690633468393905},
	{370, 27.712418470005847}, {371, 28.04360951096915}, {372, 27.899319369636174}, {373, 27.67953057101954}, {374, 27.33713099741098}, {375, 27.715275282261704}, {376, 27.09457980740444}, {377, 26.564904718909652}, {378, 26.851805720484524}, {379, 27.17971899490677},
	{380, 27.203035420946204}, {381, 26.98833921789535}, {382, 27.3376969508508}, {383, 27.36673199620505}, {384, 27.22367712016426}, {385, 27.295774446517406}, {386, 27.24426813335004}, {387, 27.804345559349205}, {388, 27.81107241888124}, {389, 28.007141902081127},
	{390, 28.196204812447014}, {391, 27.570724094739713}, {392, 28.353947742891283}, {393, 28.264285808134655}, {394, 28.001544074943496}, {395, 28.073693599174273}, {396, 28.13948170648531}, {397, 27.7246917685699}, {398, 27.372056917732422}, {399, 26.76664288679182},
	{400, 26.726530330089947}, {401, 26.73659456496834}, {402, 26.35282363879538}, {403, 26.953655414803745}, {404, 27.037728660238816}, {405, 26.391122852260175}, {406, 26.45637305967239}, {407, 25.78486318168484}, {408, 25.92078676697798}, {409, 26.4970571420541},
	{410, 25.86809752383717}, {411, 26.534413662015773}, {412, 27.226357547185447}, {413, 26.71252553894152}, {414, 26.435002451423312}, {415, 26.921455461481504}, {416, 27.06045686220195}, {417, 27.09418382303274}, {418, 28.011098852919908}, {419, 27.896959438752912},
	{420, 27.914042725695705}, {421, 27.547368437091734}, {422, 26.710013475304418}, {423, 26.67332778875601}, {424, 26.624659424882857}, {425, 26.57172379809563}, {426, 26.846697174621756}, {427, 25.8834697613218}, {428, 26.0400273638686}, {429, 25.922770964698366},
	{430, 26.550977646141284}, {431, 26.7196171595444}, {432, 26.57693368973477}, {433, 26.754937488902705}, {434, 26.68923906981248}, {435, 27.578054073124644}, {436, 28.491944955522996}, {437, 29.462067517762534}, {438, 29.049663449716007}, {439, 29.29125398211083},
	{440, 29.716399938469106}, {441, 29.697795912329543}, {442, 28.842426341018918}, {443, 27.995794268014496}, {444, 27.568707173494055}, {445, 27.572194900322412}, {446, 28.94876289646488}, {447, 28.827587778805206}, {448, 28.20122725800809}, {449, 28.982543824618322},
	{450, 28.98764510982713}, {451, 28.476638374330257}, {452, 27.8971845311884}, {453, 28.357599004387694}, {454, 29.550067169716076}, {455, 29.059986913307316}, {456, 29.44698201092504}, {457, 29.444893222605785}, {458, 30.2987283695555}, {459, 30.490753195685443},
	{460, 30.3712818585665}, {461, 31.03092246398632}, {462, 31.1306416649066}, {463, 31.204020755490298}, {464, 31.302761670091414}, {465, 31.287884426895985}, {466, 30.49414678626753}, {467, 30.9842218570926}, {468, 30.88247586217915}, {469, 31.65627890749247},
	{470, 31.300373482363312}, {471, 31.009412915052188}, {472, 31.135319385771062}, {473, 31.142947189076295}, {474, 31.095825728106682}, {475, 31.402733294236572}, {476, 31.348161546083656}, {477, 31.600766880442425}, {478, 31.51732023898528}, {479, 31.218212979786024},
	{480, 31.431310499487758}, {481, 31.536799819023997}, {482, 31.590576295671646}, {483, 31.49429616322668}, {484, 32.1816892011556}, {485, 32.61239327037908}, {486, 32.69902576477615}, {487, 32.89146487332367}, {488, 33.87564290993047}, {489, 33.89045560640269},
	{490, 33.8295470579556}, {491, 33.83070162926511}, {492, 33.57726370546161}, {493, 33.80516778960143}, {494, 34.26212065396207}, {495, 34.4134739195819}, {496, 34.72554255082181}, {497, 34.7082104992009}, {498, 34.60279005425693}, {499, 34.231204914439},
	{500, 34.099389551023904}, {501, 34.22803109888905}, {502, 34.610384365507166}, {503, 34.902573683307146}, {504, 35.0720672663373}, {505, 35.02095234082352}, {506, 35.21029830385259}, {507, 36.39939489896903}, {508, 36.49626843650683}, {509, 36.91759867136517},
	{510, 36.62252163480901}, {511, 36.637052547917165}, {512, 37.07289132044249}, {513, 37.943749079996564}, {514, 37.31678988480502}, {515, 37.10207023840552}, {516, 37.50103188910752}, {517, 36.711556296699854}, {518, 36.69985201593515}, {519, 35.88305508619134},
	{520, 35.819177348929244}, {521, 35.238662967688704}, {522, 35.204473848884604}, {523, 35.73171925218891}, {524, 37.10654099191614}, {525, 36.97832117698606}, {526, 37.88944422270623}, {527, 37.566765945668905}, {528, 36.952108419930035}, {529, 37.16172877345256},
	{530, 36.79432449958657}, {531, 36.83537718548058}, {532, 37.241795032269486}, {533, 36.98172720447497}, {534, 37.12848852369968}, {535, 37.144201171899056}, {536, 37.291084012425635}, {537, 37.20361280452033}, {538, 37.14673041600966}, {539, 36.56539045560211},
	{540, 36.46052858989325}, {541, 36.577035838031236}, {542, 36.413434939980604}, {543, 36.830541819855966}, {544, 36.708601164617306}, {545, 36.754028252130254}, {546, 36.86880281045058}, {547, 36.20522653559122}, {548, 36.19016853939169}, {549, 35.60660078018533},
	{550, 35.58380480655832}, {551, 36.15574897354542}, {552, 35.96603587272573}, {553, 36.01846266557714}, {554, 36.1246059100681}, {555, 35.776226062342324}, {556, 35.53756438274776}, {557, 36.09285691162272}, {558, 36.024821241563764}, {559, 36.07242575850486},
	{560, 36.902047436744915}, {561, 36.783371618493575}, {562, 36.97312505169229}, {563, 38.33987731208528}, {564, 38.12211125979531}, {565, 37.867344065570286}, {566, 37.91294220403035}, {567, 37.90421561454514}, {568, 37.52932323225818}, {569, 38.09065950561944},
	{570, 38.3481668904528}, {571, 38.38853417076884}, {572, 38.82875488776441}, {573, 39.30100206552399}, {574, 39.22872668781665}, {575, 39.26377992972712}, {576, 39.11286987148877}, {577, 38.55996270262097}, {578, 39.53759984840164}, {579, 39.434972831723044},
	{580, 39.58456959406775}, {581, 40.02469156333131}, {582, 39.83799518416734}, {583, 41.066310308184526}, {584, 41.249674158569356}, {585, 41.84405324758257}, {586, 42.44197850928179}, {587, 42.44435586698777}, {588, 42.51450858652831}, {589, 42.497079884180856},
	{590, 41.86201338457368}, {591, 41.97430910917171}, {592, 42.38604395890263}, {593, 42.77701512105045}, {594, 42.917712727399795}, {595, 41.92733574585986}, {596, 41.98001270512809}, {597, 42.21709441156598}, {598, 41.73101118068132}, {599, 41.511566903501254},
	{600, 41.151843749654674}, {601, 40.936735208747976}, {602, 41.07670022261416}, {603, 41.00310883262705}, {604, 41.175657930592564}, {605, 39.65057441921113}, {606, 40.59197307871199}, {607, 40.19328008308628}, {608, 39.96642122821799}, {609, 39.980554983282815},
	{610, 39.198802516126015}, {611, 40.28881956306739}, {612, 40.835001630650424}, {613, 40.96840019049191}, {614, 41.47803284199829}, {615, 42.31117692587696}, {616, 42.56501744522036}, {617, 40.75017426985965}, {618, 40.54474737773533}, {619, 40.32299207284596},
	{620, 40.59233541049153}, {621, 39.799369403233875}, {622, 39.90740256156506}, {623, 39.84656589770128}, {624, 40.51863738080248}, {625, 40.36927897222197}, {626, 39.577466020927666}, {627, 40.24059624379228}, {628, 39.888654784809695}, {629, 39.06459566315487},
	{630, 39.21824625899819}, {631, 39.707949621228416}, {632, 39.6862655989382}, {633, 39.232670266668386}, {634, 38.72226788949448}, {635, 38.90143970392931}, {636, 38.58114412526509}, {637, 37.47764070721714}, {638, 38.14287868141234}, {639, 37.95489640397961},
	{640, 37.978479310316544}, {641, 38.08870157682401}, {642, 37.86650279398312}, {643, 37.83158400391423}, {644, 37.661339861002425}, {645, 37.77028468310174}, {646, 38.19873503550377}, {647, 37.84181306063926}, {648, 36.15953352691078}, {649, 36.15954745676219},
	{650, 36.70039654101666}, {651, 36.747404928048674}, {652, 36.45440618086992}, {653, 36.50375344553345}, {654, 36.12499971175383}, {655, 36.25540639161984}, {656, 36.14128341022631}, {657, 36.13550126300937}, {658, 36.47636290489859}, {659, 36.52934581511136},
	{660, 36.180684191314654}, {661, 36.1345774586021}, {662, 35.88734753480093}, {663, 35.910114094303935}, {664, 37.494624894014834}, {665, 37.388322481490356}, {666, 37.51949607161456}, {667, 37.42672416426224}, {668, 37.607431895150505}, {669, 38.1169043451165},
	{670, 38.198701944392226}, {671, 37.672228180889036}, {672, 37.573597996143555}, {673, 37.61475549631909}, {674, 37.704351969731974}, {675, 36.526503465131775}, {676, 37.14283711760895}, {677, 37.042216595367044}, {678, 37.19943347657908}, {679, 37.030753837557455},
	{680, 37.29832109446188}, {681, 37.34909191845969}, {682, 37.396667764315495}, {683, 37.71513970238973}, {684, 37.035963822400284}, {685, 37.09132966834279}, {686, 36.671363246669195}, {687, 36.725271547538746}, {688, 36.732765304609515}, {689, 37.049756926857675},
	{690, 37.100425916489115}, {691, 37.80849557841213}, {692, 38.00370168917147}, {693, 38.65064301128746}, {694, 38.16137008804746}, {695, 38.16628690738749}, {696, 38.509868983636345}, {697, 38.51329094834429}, {698, 38.63409846835321}, {699, 38.33551139578646},
	{700, 37.86178126970245}, {701, 37.20625176875522}, {702, 37.13864013016608}, {703, 36.598956314019325}, {704, 36.73225170870823}, {705, 36.645909925459954}, {706, 36.931378033672665}, {707, 37.15159698187774}, {708, 37.20499450218726}, {709, 37.312534314076736},
	{710, 38.234122213566266}, {711, 38.23482019038691}, {712, 39.50821685803287}, {713, 39.3687472311753}, {714, 40.43514365409954}, {715, 40.44682389295688}, {716, 39.81067959969004}, {717, 39.4239320658717}, {718, 39.54620136509768}, {719, 39.70807547297041},
	{720, 39.66237013592385}, {721, 39.72023820319751}, {722, 40.02829005394066}, {723, 39.9923106822397}, {724, 39.88229973919716}, {725, 39.577778632304906}, {726, 39.42713453659046}, {727, 39.43664948339558}, {728, 39.90314312163109}, {729, 40.00741574107013},
	{730, 40.7177664595581}, {731, 40.72045099279074}, {732, 38.3054003174184}, {733, 37.63394119070095}, {734, 37.190128597342806}, {735, 37.63802392396217}, {736, 37.09659077679385}, {737, 37.08430082665866}, {738, 37.031926029911546}, {739, 36.92762266554352},
	{740, 36.768283960686276}, {741, 36.80986118421022}, {742, 37.00023584840072}, {743, 37.37757227329164}, {744, 37.65237108287256}, {745, 37.65431119266612}, {746, 37.78202911987313}, {747, 37.26755576516154}, {748, 37.253878362362926}, {749, 37.25181149353707},
	{750, 38.046853987139436}, {751, 38.52088550994239}, {752, 38.50060736503108}, {753, 39.721168829902766}, {754, 39.714977806533284}, {755, 41.2027128451164}, {756, 41.271353835056736}, {757, 41.42756394972893}, {758, 41.20791889996719}, {759, 41.51542890247571},
	{760, 41.533271125006856}, {761, 41.57431095381387}, {762, 42.43297879649776}, {763, 42.697486616671064}, {764, 42.943817792210965}, {765, 43.00326844639773}, {766, 43.04122373477804}, {767, 42.72385932125831}, {768, 42.91563938083615}, {769, 43.09789890970447},
	{770, 43.21939147903337}, {771, 42.593500985806116}, {772, 42.552074422506266}, {773, 41.96625047640962}, {774, 42.43760021996765}, {775, 42.15036608724706}, {776, 42.01801170238841}, {777, 42.108251206065354}, {778, 42.13720797898185}, {779, 41.734510693754125},
	{780, 41.98861197273539}, {781, 41.855890804590906}, {782, 41.83653956517087}, {783, 41.84729249879647}, {784, 41.34451591903922}, {785, 41.198937855641844}, {786, 40.9934126996872}, {787, 40.33193886547389}, {788, 40.42177093298795}, {789, 40.56423832118387},
	{790, 40.56930078212437}, {791, 40.44001792153413}, {792, 39.36239492015202}, {793, 39.2299512438198}, {794, 39.98930528782557}, {795, 39.78753261124546}, {796, 39.7771218730521}, {797, 40.08078557739916}, {798, 39.9026881045777}, {799, 39.846598822934695},
	{800, 39.819165988548605}, {801, 39.779536346223246}, {802, 39.417184051357914}, {803, 39.04248228046798}, {804, 39.04467471746209}, {805, 39.19976668706493}, {806, 38.62608414650186}, {807, 38.56950606795273}, {808, 38.11427821927686}, {809, 38.003564811967195},
	{810, 38.9186775339263}, {811, 39.32280711240079}, {812, 39.37066040646152}, {813, 39.35771550162152}, {814, 39.82593927687213}, {815, 39.41511912781052}, {816, 39.632089125382805}, {817, 39.7013716770543}, {818, 39.71871324205181}, {819, 39.3691037472924},
	{820, 39.4630528375144}, {821, 39.463557590573124}, {822, 39.84149848240294}, {823, 39.731112944493475}, {824, 39.46553273230596}, {825, 38.983001317774516}, {826, 39.111806633972954}, {827, 39.11241986582127}, {828, 39.060815486719235}, {829, 38.62106612409818},
	{830, 38.45726527644363}, {831, 38.46243114268653}, {832, 37.81089603641852}, {833, 37.06489698994548}, {834, 35.65801215219413}, {835, 35.598044467413054}, {836, 35.51269552874315}, {837, 35.26479970268285}, {838, 36.55531335895278}, {839, 36.707855369730034},
	{840, 36.5489032234404}, {841, 36.3485272462068}, {842, 36.365162732119266}, {843, 36.175883792606705}, {844, 36.16643352096541}, {845, 36.721302046157795}, {846, 36.738751647960406}, {847, 36.499637035175965}, {848, 36.461882187600125}, {849, 36.474313661197286},
	{850, 36.138203284641186}, {851, 36.47458889999187}, {852, 36.9122685068765}, {853, 36.84193719836966}, {854, 36.016869149964144}, {855, 35.908626743361204}, {856, 35.853057192524155}, {857, 35.49400703601318}, {858, 35.23328368215224}, {859, 35.43381027728788},
	{860, 35.441912396566295}, {861, 36.11980562386126}, {862, 35.987081872648865}, {863, 35.354742046128464}, {864, 35.11437170180045}, {865, 35.10075744627144}, {866, 35.33061979174065}, {867, 35.26826901332004}, {868, 34.76420766370852}, {869, 34.36825504722903},
	{870, 33.95310090031108}, {871, 34.76854906618263}, {872, 34.96941220214851}, {873, 34.89082477498721}, {874, 34.930226673548425}, {875, 34.818344629526955}, {876, 33.46752591731415}, {877, 32.4461932776035}, {878, 32.63093881621515}, {879, 32.571549274273316},
	{880, 31.70273743751098}, {881, 31.560570134656707}, {882, 30.11896242237412}, {883, 29.976753491813355}, {884, 30.151470049420453}, {885, 29.968667652811302}, {886, 29.914108861900175}, {887, 29.315297425726456}, {888, 29.465096537128055}, {889, 30.38412313034993},
	{890, 30.529005936656326}, {891, 30.377111661676715}, {892, 30.690112657456975}, {893, 31.19665096563887}, {894, 30.23180166165202}, {895, 30.214575260830543}, {896, 30.61887791868095}, {897, 31.69516453152183}, {898, 31.724657127738052}, {899, 31.3260343161325},
	{900, 31.448576476567858}, {901, 31.384197051367188}, {902, 31.42382604514501}, {903, 31.77933470325809}, {904, 31.54527210384609}, {905, 31.662859065404803}, {906, 31.952233276070345}, {907, 31.710429406503827}, {908, 31.69910928793987}, {909, 31.26054806750292},
	{910, 31.252913740901814}, {911, 31.069356216279907}, {912, 31.450376052945543}, {913, 31.446602308578885}, {914, 32.88848724097737}, {915, 32.97405474992589}, {916, 32.95989543002121}, {917, 33.50228160406862}, {918, 33.57376811625785}, {919, 33.49455873288756},
	{920, 32.739675795181945}, {921, 32.69683391724602}, {922, 33.81401934792278}, {923, 33.68504119872676}, {924, 33.08473835369315}, {925, 32.71783936639953}, {926, 33.576629314879405}, {927, 33.496669377208725}, {928, 32.32323980202774}, {929, 32.19540083945545},
	{930, 31.681562294745188}, {931, 31.21936553988134}, {932, 32.02350301138198}, {933, 31.99391696064781}, {934, 31.222294641434715}, {935, 31.49393327555392}, {936, 31.60562877897029}, {937, 31.719747501964054}, {938, 31.631337228109494}, {939, 31.876599195053196},
	{940, 31.839975677295737}, {941, 31.57998061624259}, {942, 32.247156373569744}, {943, 33.13453225404717}, {944, 33.57148226581986}, {945, 33.67881606804257}, {946, 34.27627744671606}, {947, 34.2667236377486}, {948, 35.0394972266412}, {949, 35.06221556029825},
	{950, 35.317831610972426}, {951, 35.47650956265658}, {952, 35.92884652798027}, {953, 36.40171114341679}, {954, 35.651733034914436}, {955, 36.021038886103796}, {956, 36.194620959224366}, {957, 36.14405991221338}, {958, 36.02271118328351}, {959, 36.01617792703485},
	{960, 36.718644368420634}, {961, 36.658954226071046}, {962, 36.58675202460727}, {963, 35.89078679017791}, {964, 35.94749384377098}, {965, 35.92838317262612}, {966, 34.32490064912566}, {967, 33.68329350874763}, {968, 33.72780060374807}, {969, 33.521931400031036},
	{970, 33.48546378484414}, {971, 33.729671379093105}, {972, 32.483138764110244}, {973, 32.70061143845538}, {974, 31.882058598338592}, {975, 31.85978103716163}, {976, 31.360355110091252}, {977, 31.338506662447838}, {978, 31.4975196000238}, {979, 31.636516566035457},
	{980, 31.76928554942759}, {981, 31.596565826225252}, {982, 31.24504603522091}, {983, 30.97685607999551}, {984, 30.776149614114455}, {985, 30.369022511891757}, {986, 30.65823464304316}, {987, 30.536961423755283}, {988, 30.543171096017304}, {989, 29.709033348016842},
	{990, 29.787775153315135}, {991, 30.020098011459627}, {992, 30.161570003700696}, {993, 30.110594653721783}, {994, 30.269521765071406}, {995, 30.887702552351005}, {996, 31.092501292990715}, {997, 30.96235060201595}, {998, 31.371052725132344}, {999, 31.652461552974707},
	{1000, 31.925382030352395}, {1001, 32.09718279718192}, {1002, 32.404705995647134}, {1003, 32.40399854679425}, {1004, 32.105619052543034}, {1005, 32.123902211392696}, {1006, 32.26894930916644}, {1007, 32.06571185804976}, {1008, 32.27138533885846}, {1009, 32.459468377391936},
	{1010, 32.45637104295923}, {1011, 33.97355416481095}, {1012, 34.073372443262755}, {1013, 34.555509854599876}, {1014, 34.001992433795586}, {1015, 34.028775375039515}, {1016, 33.15444517016032}, {1017, 33.25999551152861}, {1018, 33.56889630842039}, {1019, 33.836008073592865},
	{1020, 34.6557254577998}, {1021, 34.16915786529838}, {1022, 33.91355886515464}, {1023, 33.53814944935212}, {1024, 33.73093246034526}, {1025, 33.779257221704746}, {1026, 33.55901656076105}, {1027, 33.522411543634334}, {1028, 33.308377022855574}, {1029, 33.46872487000558},
	{1030, 33.398428332372106}, {1031, 32.78130678002823}, {1032, 32.569113758452666}, {1033, 31.58571790720343}, {1034, 32.16172427938117}, {1035, 31.661979621179476}, {1036, 31.632175065844496}, {1037, 31.789546741031184}, {1038, 32.26513372369237}, {1039, 32.18304328830448},
	{1040, 32.71362639662142}, {1041, 31.299268596529224}, {1042, 27.792537058477052}, {1043, 31.385259077931753}, {1044, 30.591065858607116}, {1045, 31.272338876555935}, {1046, 31.673417165689862}, {1047, 31.185485416617453}, {1048, 31.29116101415942}, {1049, 31.420045699024275},
	{1050, 32.72027856671056}, {1051, 32.70728464282712}, {1052, 32.84488754596194}, {1053, 33.19971370723099}, {1054, 33.00087402494973}, {1055, 32.99077340899255}, {1056, 32.83232129107784}, {1057, 32.30498262311541}, {1058, 32.30946094376116}, {1059, 32.940891339151776},
	{1060, 32.68854192681414}, {1061, 32.73363409330329}, {1062, 32.79589758581314}, {1063, 32.289791532294295}, {1064, 32.68604720099993}, {1065, 33.33078243465505}, {1066, 33.54826648297002}, {1067, 33.40865566016796}, {1068, 33.41296471315078}, {1069, 32.77182145012062},
	{1070, 32.33224727266914}, {1071, 32.27203157051601}, {1072, 32.26109905266389}, {1073, 32.921499096795074}, {1074, 33.38395175893338}, {1075, 33.78768855190261}, {1076, 33.442367223026764}, {1077, 33.237913854994794}, {1078, 31.147232293821737}, {1079, 31.146482126046756},
	{1080, 31.71150780117646}, {1081, 31.814296312484636}, {1082, 30.955859429080363}, {1083, 30.987259649137073}, {1084, 30.89065910781576}, {1085, 31.16579586461409}, {1086, 31.118733218136573}, {1087, 30.533273297600925}, {1088, 29.252834071159857}, {1089, 29.685743434805644},
	{1090, 29.705920523322913}, {1091, 29.85069842502032}, {1092, 30.388305038615574}, {1093, 30.161758590806624}, {1094, 30.779652282941164}, {1095, 30.91190072880913}, {1096, 31.56528710281942}, {1097, 31.768065818580393}, {1098, 31.8230334699979}, {1099, 32.1658225590106},
	{1100, 32.18402247418236}, {1101, 33.487267406897004}, {1102, 33.51902089155666}, {1103, 33.39833431034105}, {1104, 32.50713483623776}, {1105, 32.66530621931014}, {1106, 32.78927126650209}, {1107, 32.650964726546256}, {1108, 32.70706148431291}, {1109, 32.916943844199004},
	{1110, 32.49004088753038}, {1111, 32.945619481604744}, {1112, 33.03101393088018}, {1113, 33.01159487630862}, {1114, 33.17414749212253}, {1115, 34.21219988578758}, {1116, 34.00043238845383}, {1117, 33.61923485510282}, {1118, 34.275948039809364}, {1119, 33.87944072377637},
	{1120, 33.57361872056542}, {1121, 33.60777850243776}, {1122, 33.95519829789812}, {1123, 34.101866130091636}, {1124, 35.08344176854378}, {1125, 35.290045657998256}, {1126, 34.99789523160777}, {1127, 35.11162512342385}, {1128, 35.150203027075506}, {1129, 34.9547553234651},
	{1130, 35.68267560816188}, {1131, 35.94530333733083}, {1132, 36.40684420002165}, {1133, 36.90897436886569}, {1134, 36.68925056413046}, {1135, 36.77241779692453}, {1136, 36.7768373962142}, {1137, 36.615559524302526}, {1138, 36.15108571210806}, {1139, 36.31887166999472},
	{1140, 36.25359696272827}, {1141, 36.04048635034041}, {1142, 36.00631287066912}, {1143, 36.459483786091326}, {1144, 36.523711914237204}, {1145, 35.76502964124057}, {1146, 36.18603634547918}, {1147, 36.143227345894964}, {1148, 35.42846972819206}, {1149, 34.22551552384586},
	{1150, 35.085356710729094}, {1151, 34.978408345953554}, {1152, 35.02162912627897}, {1153, 34.6749544956021}, {1154, 34.5294083257531}, {1155, 33.989361791250865}, {1156, 33.90560409554212}, {1157, 34.22819180059112}, {1158, 35.09979866464593}, {1159, 35.459597394271825},
	{1160, 35.028413870661275}, {1161, 35.07365163864229}, {1162, 35.008455674695846}, {1163, 34.87027987153975}, {1164, 32.73740982908738}, {1165, 35.86288920810587}, {1166, 36.38448730256452}, {1167, 35.69198792205293}, {1168, 35.7287802068078}, {1169, 35.67047911791235},
	{1170, 35.65931562676154}, {1171, 35.63860255804954}, {1172, 36.28377914027185}, {1173, 36.31724433582806}, {1174, 36.42873315721097}, {1175, 36.55293797881833}, {1176, 36.68858364718202}, {1177, 36.68542383419321}, {1178, 36.59630640724288}, {1179, 36.46919978323624},
	{1180, 35.97612499492244}, {1181, 35.97470028204401}, {1182, 36.88186754506275}, {1183, 36.89180762556425}, {1184, 37.398624973193115}, {1185, 37.6485574658129}, {1186, 37.59944793075436}, {1187, 37.52123044476694}, {1188, 37.545545238118}, {1189, 37.63568398432097},
	{1190, 37.60117292673316}, {1191, 37.76737303107856}, {1192, 37.796708933792935}, {1193, 38.44788884052119}, {1194, 38.433526334130406}, {1195, 38.53261361058563}, {1196, 38.20625193191746}, {1197, 38.216892858955696}, {1198, 38.10624817074387}, {1199, 38.31498368822061},
	{1200, 38.28171670233931}, {1201, 38.03504598890333}, {1202, 37.469381149070585}, {1203, 37.645843865994834}, {1204, 37.996863546861626}, {1205, 37.39010863231819}, {1206, 37.916484620097826}, {1207, 37.9792008265341}, {1208, 37.56402382212345}, {1209, 37.64236828858301},
	{1210, 38.20048604682538}, {1211, 38.1135776386156}, {1212, 38.06926736333271}, {1213, 37.85109980183144}, {1214, 37.8667193253515}, {1215, 37.79731989239691}, {1216, 37.79569290509785}, {1217, 37.507680665850124}, {1218, 37.86538998455543}, {1219, 37.97413406343451},
	{1220, 38.153189871670634}, {1221, 37.705945919911386}, {1222, 38.003018638410715}, {1223, 37.97804975659373}, {1224, 37.86005819640923}, {1225, 37.74622347438676}, {1226, 37.24273013769576}, {1227, 37.471847978186396}, {1228, 36.574577925568015}, {1229, 36.898112403986175},
	{1230, 37.93262825928585}, {1231, 37.98350758652906}, {1232, 37.3327630080204}, {1233, 37.87253628352105}, {1234, 37.03465628886385}, {1235, 37.3628779234913}, {1236, 37.257920892232235}, {1237, 37.355020597223806}, {1238, 36.42612381389829}, {1239, 35.71849960760021},
	{1240, 35.569737001180215}, {1241, 35.639328778372764}, {1242, 36.67505414760637}, {1243, 36.529877025906195}, {1244, 36.17805747298349}, {1245, 36.20730061152778}, {1246, 36.7654190000416}, {1247, 36.066963570873966}, {1248, 34.80315462413555}, {1249, 34.79204497446974},
	{1250, 34.96282416930701}, {1251, 35.29525328571966}, {1252, 35.39276674967225}, {1253, 35.17789113339765}, {1254, 35.1734239698592}, {1255, 36.27186268761327}, {1256, 36.12969032844646}, {1257, 35.56797468172719}, {1258, 35.413952983479305}, {1259, 35.473554398381665},
	{1260, 34.959780400150386}, {1261, 34.705612847987084}, {1262, 35.122081505219015}, {1263, 35.54647234411569}, {1264, 35.56585165590874}, {1265, 34.07163330273662}, {1266, 34.061764136955}, {1267, 34.98718482740182}, {1268, 35.194478377248124}, {1269, 34.814779163097306},
	{1270, 35.63339066284622}, {1271, 36.248018614293784}, {1272, 35.89931722172987}, {1273, 36.02707673294714}, {1274, 35.47928825105021}, {1275, 35.339226659095814}, {1276, 36.04365822060287}, {1277, 36.12975065194946}, {1278, 35.657328019340454}, {1279, 35.92456974548614},
	{1280, 36.330656914157935}, {1281, 36.192088120039486}, {1282, 35.48734879533039}, {1283, 35.20967589696835}, {1284, 35.16528283177774}, {1285, 35.05450151673027}, {1286, 34.083660774124404}, {1287, 33.772468853879964}, {1288, 33.29191351706884}, {1289, 33.40417208662001},
	{1290, 32.607679572698984}, {1291, 32.60800666862871}, {1292, 32.6060770265256}, {1293, 32.50260313437235}, {1294, 32.66708354095242}, {1295, 32.66682027747426}, {1296, 33.0078376785496}, {1297, 32.79448909601}, {1298, 33.33055451566498}, {1299, 33.80720872380922},
	{1300, 34.03662018610426}, {1301, 33.471561770605334}, {1302, 33.464542278200675}, {1303, 33.5135192502925}, {1304, 33.522105679079196}, {1305, 33.486732091763336}, {1306, 34.102696294452976}, {1307, 34.28410402104561}, {1308, 34.50821094970082}, {1309, 34.2800121277366},
	{1310, 34.07699583444763}, {1311, 33.29032898991077}, {1312, 33.447416548419994}, {1313, 33.07070289905697}, {1314, 32.76441433179846}, {1315, 32.35364095869243}, {1316, 32.19453136744108}, {1317, 32.001227569765504}, {1318, 32.1893553685659}, {1319, 32.17192961357054},
	{1320, 32.05156175088731}, {1321, 32.01319521995405}, {1322, 31.361540797597904}, {1323, 31.358737048716332}, {1324, 31.4094163556713}, {1325, 31.385674150907523}, {1326, 30.397821572277874}, {1327, 30.430993318308072}, {1328, 30.559151734617863}, {1329, 30.709052945784077},
	{1330, 30.762480629193092}, {1331, 30.428823245671445}, {1332, 30.549369360601233}, {1333, 30.401524153538364}, {1334, 30.862514784963658}, {1335, 30.543179751483258}, {1336, 30.546876105280212}, {1337, 30.8118556608746}, {1338, 30.73308277586123}, {1339, 31.09586849152352},
	{1340, 30.443543543528172}, {1341, 30.574438626388865}, {1342, 30.433112514559557}, {1343, 29.60468065056554}, {1344, 29.518027759834045}, {1345, 29.530716732475156}, {1346, 29.258574444161773}, {1347, 28.96213974116116}, {1348, 30.094589411608464}, {1349, 30.027880530088794},
	{1350, 30.00173657659883}, {1351, 30.7570211333231}, {1352, 30.905455874138642}, {1353, 30.95776014140416}, {1354, 31.25924961163502}, {1355, 31.28781614068638}, {1356, 31.259224092967646}, {1357, 31.471490532081248}, {1358, 30.66993696457886}, {1359, 29.51601931381402},
	{1360, 29.658359527955362}, {1361, 29.498776144228817}, {1362, 29.0952884352307}, {1363, 27.583844233928247}, {1364, 27.104268459905846}, {1365, 25.95144210780829}, {1366, 25.823464503416666}, {1367, 25.72514162857761}, {1368, 25.654123815674225}, {1369, 26.051979147188657},
	{1370, 25.841597348616787}, {1371, 25.03088000259754}, {1372, 24.40430526113091}, {1373, 24.39450861715055}, {1374, 24.868258110961357}, {1375, 24.87891945990089}, {1376, 24.826829203959203}, {1377, 24.723127466527284}, {1378, 25.189101108151846}, {1379, 24.999892026613335},
	{1380, 25.403952465657824}, {1381, 25.395818912419763}, {1382, 25.361488701260853}, {1383, 25.168837708367573}, {1384, 25.822974064286573}, {1385, 25.184633998151693}, {1386, 25.673392593447062}, {1387, 25.493115319468433}, {1388, 25.616885562952366}, {1389, 26.26185502334556},
	{1390, 26.63671721716633}, {1391, 27.41659614028529}, {1392, 27.180001027499763}, {1393, 27.31191586358311}, {1394, 27.41516507193562}, {1395, 27.621542573182392}, {1396, 28.333329103903207}, {1397, 28.490364050694232}, {1398, 28.282737229661876}, {1399, 28.487368411327616},
	{1400, 27.619991904229085}, {1401, 27.775228746290942}, {1402, 27.75784788858771}, {1403, 26.388008503362745}, {1404, 26.390446759456594}, {1405, 26.804841863728445}, {1406, 26.645161583486924}, {1407, 25.978560150820044}, {1408, 25.928009125329705}, {1409, 25.928237301882948},
	{1410, 25.750677096758384}, {1411, 25.3386270250864}, {1412, 25.140774560316675}, {1413, 24.34074260607449}, {1414, 24.754961425981048}, {1415, 24.730194413283783}, {1416, 24.920450795877183}, {1417, 25.024801997124456}, {1418, 24.6651943693905}, {1419, 25.194960339720506},
	{1420, 25.34229435510204}, {1421, 25.305380825552025}, {1422, 25.412841036914795}, {1423, 25.505668659821385}, {1424, 25.930434241278466}, {1425, 25.958267633145237}, {1426, 26.031451433938873}, {1427, 26.586990196306772}, {1428, 27.292096678546}, {1429, 28.12071488383503},
	{1430, 28.02832144500101}, {1431, 28.58386148422691}, {1432, 28.79404266374261}, {1433, 29.738295917981866}, {1434, 29.720007389392677}, {1435, 29.63633778940114}, {1436, 29.68841036823205}, {1437, 29.575033122960512}, {1438, 29.539149897548384}, {1439, 29.80686249903287},
	{1440, 30.862182502538953}, {1441, 30.42493141449586}, {1442, 30.427703473898646}, {1443, 30.502760352966796}, {1444, 30.537509584235174}, {1445, 30.206448675310977}, {1446, 30.230172108384416}, {1447, 30.164364772985248}, {1448, 29.417259389108583}, {1449, 29.280495127154293},
	{1450, 29.331776246449813}, {1451, 28.98662862990845}, {1452, 29.752510306571484}, {1453, 29.70066010243845}, {1454, 29.357272975382973}, {1455, 29.25016590767666}, {1456, 29.355245117563307}, {1457, 29.533981898101043}, {1458, 29.569017902727573}, {1459, 29.611976373457114},
	{1460, 29.731805290138638}, {1461, 29.757994213197602}, {1462, 30.0901622202274}, {1463, 31.279393484956277}, {1464, 31.228915684424805}, {1465, 31.39987446802975}, {1466, 30.81523244839042}, {1467, 31.19319811379786}, {1468, 31.21869066135987}, {1469, 31.378064726660238},
	{1470, 31.36503448737635}, {1471, 30.890723656435668}, {1472, 31.278271018448063}, {1473, 31.27351266944355}, {1474, 30.906433524045895}, {1475, 31.094199381637562}, {1476, 32.22446329349785}, {1477, 31.755676495678124}, {1478, 31.863329580086756}, {1479, 34.1769485077606},
	{1480, 33.67109006952487}, {1481, 34.032560599893785}, {1482, 35.17463593455005}, {1483, 34.68680491085987}, {1484, 35.34323186904023}, {1485, 36.06846197316916}, {1486, 35.75474567916718}, {1487, 34.95879681397107}, {1488, 34.91513272089497}, {1489, 34.27429545432343},
	{1490, 34.47677587538645}, {1491, 34.8837191993053}, {1492, 34.888682229883216}, {1493, 34.6615444728743}, {1494, 34.691697874937915}, {1495, 34.673137205747096}, {1496, 34.619588001105676}, {1497, 34.67924802646811}, {1498, 34.711467226688804}, {1499, 34.378496298766606},
	{1500, 34.01906505065623}, {1501, 34.1921149855785}, {1502, 34.645939695035565}, {1503, 34.55325778595661}, {1504, 34.837013970080854}, {1505, 34.3201819146262}, {1506, 34.21433963893517}, {1507, 34.209807913410046}, {1508, 34.29503290261106}, {1509, 34.372533557964495},
	{1510, 34.29249674028179}, {1511, 34.1793952178106}, {1512, 34.23027204162766}, {1513, 34.30024655177506}, {1514, 34.29076290991813}, {1515, 34.872527881393644}, {1516, 34.88183138613434}, {1517, 34.99793065640857}, {1518, 35.116718830483286}, {1519, 35.11046533465197},
	{1520, 36.014438556584366}, {1521, 36.02360905142489}, {1522, 35.91482043384545}, {1523, 35.809274512011065}, {1524, 35.59619773000511}, {1525, 35.44019543122139}, {1526, 35.64144780604629}, {1527, 35.58080982359661}, {1528, 35.452624932745614}, {1529, 35.467238834711935},
	{1530, 35.041073967062886}, {1531, 34.27022167037798}, {1532, 33.77867219668047}, {1533, 33.675446148880425}, {1534, 34.29649579312852}, {1535, 33.80063094230085}, {1536, 33.83706673096555}, {1537, 34.19813699318839}, {1538, 34.67898341154741}, {1539, 34.61565170828406},
	{1540, 34.88435222539337}, {1541, 34.74803849982474}, {1542, 34.88836986733776}, {1543, 34.316664346866176}, {1544, 35.1429379016867}, {1545, 35.236518386423754}, {1546, 35.480022507695814}, {1547, 35.51129848892317}, {1548, 35.55074228557621}, {1549, 35.47965462275921},
	{1550, 35.1614123321548}, {1551, 34.649935916461956}, {1552, 33.831408529297455}, {1553, 33.68659149830347}, {1554, 34.76348070802675}, {1555, 34.75436175642519}, {1556, 34.670519236256325}, {1557, 34.40743801250581}, {1558, 35.03821600965653}, {1559, 35.074059881857586},
	{1560, 34.66313179952048}, {1561, 34.05122520128333}, {1562, 34.369261269504776}, {1563, 34.306862410511414}, {1564, 34.35513437341248}, {1565, 34.42016699549108}, {1566, 34.32411882750936}, {1567, 35.10444315366103}, {1568, 35.21667415434252}, {1569, 34.56235394065422},
	{1570, 34.99569538327316}, {1571, 35.051462529787685}, {1572, 35.65901988130965}, {1573, 35.30919470315533}, {1574, 35.43427648307305}, {1575, 35.26105873637407}, {1576, 34.984210066219426}, {1577, 34.974915529232504}, {1578, 34.64250053081252}, {1579, 34.855051142104344},
	{1580, 34.61935447447808}, {1581, 33.30095950674964}, {1582, 33.52159175029287}, {1583, 33.30245847520868}, {1584, 33.22017010546928}, {1585, 33.302509858225584}, {1586, 33.37904181575153}, {1587, 33.25298440074963}, {1588, 33.25372890621039}, {1589, 33.55633290212615},
	{1590, 33.564240306946566}, {1591, 33.77554531353173}, {1592, 33.77747427631988}, {1593, 33.758375775192526}, {1594, 34.36417258641864}, {1595, 34.31644882079321}, {1596, 33.55182639869085}, {1597, 33.56219047110169}, {1598, 33.44110230199712}, {1599, 33.37853776463871},
	{1600, 32.03520633056414}, {1601, 32.091659309762015}, {1602, 32.3728274207352}, {1603, 32.32296532348558}, {1604, 32.248876392188286}, {1605, 32.2486900311155}, {1606, 32.30827587355294}, {1607, 31.55600150552031}, {1608, 32.275031428073206}, {1609, 32.27879842764017},
	{1610, 32.12685506952653}, {1611, 32.04232751622579}, {1612, 32.3717511617595}, {1613, 32.90499426727991}, {1614, 31.34160341506861}, {1615, 32.79935984939758}, {1616, 33.3133749284244}, {1617, 33.330066949919654}, {1618, 33.6696207424472}, {1619, 33.44727416894953},
	{1620, 32.937035354917406}, {1621, 32.42098193976603}, {1622, 32.40919020921572}, {1623, 32.40926615430823}, {1624, 31.91939496950345}, {1625, 31.745665996112034}, {1626, 31.762245569926346}, {1627, 31.76510278674478}, {1628, 32.18895805255132}, {1629, 32.17884231058142},
	{1630, 31.634810462741328}, {1631, 31.569967535436145}, {1632, 32.29578832893024}, {1633, 32.930732352651475}, {1634, 33.03934988366926}, {1635, 33.21635409643862}, {1636, 33.261326384884754}, {1637, 33.39655980314689}, {1638, 35.11945078307172}, {1639, 35.076572468626274},
	{1640, 34.95856618844892}, {1641, 34.85019550097897}, {1642, 34.70787112679453}, {1643, 34.64396731467868}, {1644, 34.03523254807719}, {1645, 34.599545249438016}, {1646, 34.911136115744284}, {1647, 35.12923123083873}, {1648, 34.19771898956377}, {1649, 34.081163717338875},
	{1650, 33.952021163589286}, {1651, 34.03909563960654}, {1652, 33.826004075423334}, {1653, 33.69501183562262}, {1654, 33.54101912632574}, {1655, 33.534398838396605}, {1656, 33.551479085175345}, {1657, 34.17014679283176}, {1658, 33.68298225679782}, {1659, 33.914956135823154},
	{1660, 33.85350696847641}, {1661, 33.5930418617416}, {1662, 33.698585740003914}, {1663, 33.53164709646962}, {1664, 32.942749249597995}, {1665, 32.78927293361512}, {1666, 32.805622975726415}, {1667, 32.678834731539396}, {1668, 32.49005865138826}, {1669, 32.45598674269622},
	{1670, 32.38305018611963}, {1671, 32.39849660167694}, {1672, 33.26082532734355}, {1673, 33.32014170105489}, {1674, 33.73004210039798}, {1675, 33.724298776862106}, {1676, 33.68423539254731}, {1677, 33.563159682253556}, {1678, 33.46610598060115}, {1679, 33.46576401188156},
	{1680, 33.6082093792797}, {1681, 34.06829829976045}, {1682, 33.78773476628623}, {1683, 33.847057378024175}, {1684, 35.250271418221374}, {1685, 35.09767253763393}, {1686, 35.074861457363895}, {1687, 35.40140497372611}, {1688, 36.31807881704327}, {1689, 37.93153971576717},
	{1690, 37.96917757654617}, {1691, 38.22198787034048}, {1692, 38.23678368537367}, {1693, 38.20599590804662}, {1694, 38.68369317469104}, {1695, 38.79215511609461}, {1696, 38.802109502845106}, {1697, 38.753495704229714}, {1698, 38.96421874631208}, {1699, 38.90821233250077},
	{1700, 39.16182425119748}, {1701, 38.853831057337715}, {1702, 38.63611099293661}, {1703, 38.24474852988975}, {1704, 38.38469009174058}, {1705, 38.32872094403988}, {1706, 38.153737338484326}, {1707, 38.264923332806745}, {1708, 38.280563758044565}, {1709, 38.18750466726223},
	{1710, 38.56983066481024}, {1711, 39.505085657555355}, {1712, 39.69872974322229}, {1713, 40.39204144577866}, {1714, 40.48553785053598}, {1715, 41.3269897150344}, {1716, 41.609581527655735}, {1717, 41.65892696057186}, {1718, 41.837313217148804}, {1719, 41.8289668854985},
	{1720, 42.15881862704277}, {1721, 42.73710053588433}, {1722, 42.348456207492845}, {1723, 42.096157824123665}, {1724, 41.92253556951924}, {1725, 41.917137854036646}, {1726, 41.97608613143687}, {1727, 41.72574431293022}, {1728, 41.24861627279633}, {1729, 41.87472943187815},
	{1730, 41.87568170648001}, {1731, 42.17909911414902}, {1732, 42.049177661936255}, {1733, 41.97474828244962}, {1734, 41.356541003497355}, {1735, 41.22195929777421}, {1736, 41.194030410051106}, {1737, 41.392479793475935}, {1738, 41.34843546848941}, {1739, 41.34402528705148},
	{1740, 42.07661962525981}, {1741, 41.52647896910617}, {1742, 41.44561097861686}, {1743, 40.958470191837534}, {1744, 41.037829903821645}, {1745, 41.07205195864329}, {1746, 41.46906637533652}, {1747, 41.49343224957735}, {1748, 40.610182804195105}, {1749, 41.017801824810185},
	{1750, 40.79059366319508}, {1751, 40.70441966049171}, {1752, 40.70503981535662}, {1753, 39.93683574905368}, {1754, 39.752239396736506}, {1755, 39.7645522699645}, {1756, 39.55588740392734}, {1757, 39.74727156272358}, {1758, 39.9737782466988}, {1759, 40.39693575020464},
	{1760, 40.216674372755165}, {1761, 40.25136763580497}, {1762, 39.38556407545778}, {1763, 39.26119592497736}, {1764, 39.16195286452751}, {1765, 38.86948923485995}, {1766, 39.61600974311452}, {1767, 39.39522112770508}, {1768, 39.514089866690526}, {1769, 39.45799756858736},
	{1770, 38.90570527579156}, {1771, 38.80478381534035}, {1772, 38.83322167157176}, {1773, 39.64297039815119}, {1774, 40.33223301684341}, {1775, 40.41694728495109}, {1776, 40.06020383799442}, {1777, 40.07361881200165}, {1778, 39.77916448556436}, {1779, 39.96893684870016},
	{1780, 40.57894081959218}, {1781, 39.89797496618613}, {1782, 39.35261558123242}, {1783, 39.36008989987693}, {1784, 38.0512977550727}, {1785, 38.264000581925124}, {1786, 38.26169623365976}, {1787, 39.10252385765842}, {1788, 39.27088966509622}, {1789, 39.15216453676914},
	{1790, 39.41049327702329}, {1791, 39.39907719439436}, {1792, 38.82328669157878}, {1793, 39.35804609496024}, {1794, 39.52870877903105}, {1795, 40.562208982859616}, {1796, 41.015089776340226}, {1797, 40.87083252184389}, {1798, 40.53994999420047}, {1799, 41.02575733506004},
	{1800, 41.17619373256442}, {1801, 41.19685023564847}, {1802, 40.98189573065346}, {1803, 41.159763360041595}, {1804, 41.59421552557119}, {1805, 41.20806640088285}, {1806, 40.414699831836835}, {1807, 39.92415966374783}, {1808, 39.62606546104271}, {1809, 39.857180263975444},
	{1810, 39.59080107893363}, {1811, 39.6974862276464}, {1812, 39.442229052918876}, {1813, 39.30199180817845}, {1814, 39.48025720867229}, {1815, 39.5287187420122}, {1816, 38.853563440015805}, {1817, 38.77749075357144}, {1818, 39.12960232658636}, {1819, 39.07838534119988},
	{1820, 39.149292277699324}, {1821, 39.00774814154133}, {1822, 38.63589451271645}, {1823, 38.95501568270912}, {1824, 38.4982817921926}, {1825, 39.10088500152322}, {1826, 39.59621160868451}, {1827, 39.45833354062081}, {1828, 39.59936421761144}, {1829, 39.57053924615646},
	{1830, 39.55660528183884}, {1831, 39.71569674116191}, {1832, 39.71328630121623}, {1833, 39.5500745849456}, {1834, 39.52081122302288}, {1835, 38.74032920127892}, {1836, 39.19864530117539}, {1837, 39.06947571924525}, {1838, 39.34422885689023}, {1839, 39.6353362225693},
	{1840, 40.71459696346432}, {1841, 40.66496952468566}, {1842, 41.006778236777826}, {1843, 40.98904213311685}, {1844, 40.108733704463795}, {1845, 39.422159369592656}, {1846, 39.23842350070322}, {1847, 37.531170184849564}, {1848, 38.05353522108415}, {1849, 38.31111320664359},
	{1850, 38.64900610422957}, {1851, 38.686484249347565}, {1852, 38.68434197825875}, {1853, 38.72332458907287}, {1854, 38.81119764084882}, {1855, 38.46493433585336}, {1856, 38.51556317974943}, {1857, 38.764010535750494}, {1858, 38.55294929767745}, {1859, 38.078366113942565},
	{1860, 38.42988961361437}, {1861, 39.047014068329304}, {1862, 39.532635843081685}, {1863, 39.10571993423328}, {1864, 39.60131420080908}, {1865, 38.81680138357229}, {1866, 39.25082176080607}, {1867, 38.15677220409511}, {1868, 38.62555210254061}, {1869, 38.47132788365266},
	{1870, 38.487714681626166}, {1871, 38.39888830728324}, {1872, 37.54975105530615}, {1873, 36.620496899833185}, {1874, 36.76592939311881}, {1875, 36.77417927197788}, {1876, 36.78457313190018}, {1877, 36.726556157401774}, {1878, 37.19484339680942}, {1879, 37.12075085414386},
	{1880, 36.977258419880144}, {1881, 36.91078025788851}, {1882, 37.02130072401423}, {1883, 36.55535121811925}, {1884, 35.989467257305485}, {1885, 35.963032268137205}, {1886, 36.010752822606925}, {1887, 36.02787704722448}, {1888, 36.49326570398064}, {1889, 36.23934542841747},
	{1890, 35.87776015328743}, {1891, 35.09797528518658}, {1892, 35.077065290325194}, {1893, 35.311414001953885}, {1894, 34.57305509209034}, {1895, 34.6842074805997}, {1896, 34.80183031401632}, {1897, 35.47101264307737}, {1898, 35.17048394585489}, {1899, 35.089175368832215},
	{1900, 35.22509160122155}, {1901, 35.01261679236839}, {1902, 35.20621635881338}, {1903, 35.37294264170206}, {1904, 34.459027714667855}, {1905, 35.092154761591416}, {1906, 34.8517351148361}, {1907, 34.86550272062247}, {1908, 35.125600870401854}, {1909, 34.83446288221645},
	{1910, 34.78242112077965}, {1911, 34.31203602602105}, {1912, 34.279540168694986}, {1913, 35.1096803630126}, {1914, 34.514233849300744}, {1915, 34.53539867779291}, {1916, 34.279414052434674}, {1917, 34.36455267465703}, {1918, 34.10174900420402}, {1919, 34.41175163800032},
	{1920, 34.291999205288036}, {1921, 34.19594013042914}, {1922, 34.18838364564101}, {1923, 36.07392483120914}, {1924, 36.05098431555323}, {1925, 36.76095964181586}, {1926, 37.82863560027054}, {1927, 37.52980493319014}, {1928, 37.53527503569141}, {1929, 37.512668716830554},
	{1930, 37.11106227609642}, {1931, 37.349978643969806}, {1932, 37.20979207398837}, {1933, 37.29059943130983}, {1934, 37.12675552575493}, {1935, 37.34021255585861}, {1936, 37.33863802694112}, {1937, 36.93793225844994}, {1938, 36.96147855185145}, {1939, 37.079544775050316},
	{1940, 36.96800493367608}, {1941, 36.62130515314802}, {1942, 36.64654224799271}, {1943, 36.564393168165026}, {1944, 36.76798510268848}, {1945, 36.34484500467934}, {1946, 35.77622429269998}, {1947, 36.28861461359311}, {1948, 35.62308019530623}, {1949, 35.44131748549641},
	{1950, 34.85392909768805}, {1951, 34.55133668610086}, {1952, 35.092025906373635}, {1953, 34.768122961192404}, {1954, 35.02372314142307}, {1955, 35.11384033534372}, {1956, 35.09859916781124}, {1957, 35.63073140705392}, {1958, 35.47556248383545}, {1959, 34.87826460124942},
	{1960, 34.87959003890974}, {1961, 34.025365090862095}, {1962, 33.804380004654575}, {1963, 32.78020946544929}, {1964, 32.75918431846117}, {1965, 32.75851314921747}, {1966, 32.93198375479733}, {1967, 35.25828074460553}, {1968, 34.28240693566641}, {1969, 34.339864432373425},
	{1970, 34.12397376413126}, {1971, 34.79011341612875}, {1972, 34.64686103755323}, {1973, 34.599313028973235}, {1974, 34.53242934134927}, {1975, 34.606548457455425}, {1976, 34.83272344102554}, {1977, 34.49913157098365}, {1978, 34.70437557256804}, {1979, 35.19565588926615},
	{1980, 35.185492244262484}, {1981, 33.550787666460536}, {1982, 34.02484580154227}, {1983, 34.15044793215261}, {1984, 34.543313702949256}, {1985, 34.49383893491851}, {1986, 34.69468439935647}, {1987, 34.36140916945972}, {1988, 33.199535764838636}, {1989, 33.54089185371181},
	{1990, 33.25543526295492}, {1991, 33.126250139798344}, {1992, 32.1006804695537}, {1993, 32.11793625750763}, {1994, 31.547141310894098}, {1995, 31.358848538734513}, {1996, 30.96324192071878}, {1997, 31.081433577858583}, {1998, 31.004611604459708}, {1999, 30.86284767543519},
	{2000, 30.105433307161203}, {2001, 29.32024170286219}, {2002, 29.319658236582814}, {2003, 29.758958255855212}, {2004, 30.117663632341145}, {2005, 29.548890824528907}, {2006, 29.35044585015188}, {2007, 29.38762759040267}, {2008, 29.391950686507506}, {2009, 30.353380249710128},
	{2010, 29.46899984490753}, {2011, 29.33586115695675}, {2012, 29.36114381531963}, {2013, 29.256022938524392}, {2014, 29.207874497314503}, {2015, 29.266115045795534}, {2016, 29.11037246533442}, {2017, 29.98833975350206}, {2018, 29.827356428113166}, {2019, 29.196369679790173},
	{2020, 29.09133736287457}, {2021, 29.35398305475309}, {2022, 29.54604416792868}, {2023, 28.36216318117799}, {2024, 28.172545798424313}, {2025, 29.167896346989487}, {2026, 29.134747648857985}, {2027, 28.0133642954549}, {2028, 27.97694686027503}, {2029, 28.374194072568063},
	{2030, 28.37095153088029}, {2031, 28.388216858848796}, {2032, 27.992329533869835}, {2033, 27.367870148995426}, {2034, 27.251995482961384}, {2035, 27.746729670664767}, {2036, 27.679330290354688}, {2037, 28.028729073068334}, {2038, 28.028705243794963}, {2039, 28.350786367009555},
	{2040, 28.352026432670012}, {2041, 28.225867429505602}, {2042, 28.211139910084785}, {2043, 28.126532263542863}, {2044, 28.0111605756859}, {2045, 28.037986830307158}, {2046, 27.771048205304385}, {2047, 28.101282898505325}, {2048, 27.956754355558264}, {2049, 28.898451768426284},
	{2050, 28.33803560429799}, {2051, 28.51219696371789}, {2052, 28.687032331939648}, {2053, 28.519256261795114}, {2054, 28.534411822889545}, {2055, 28.475878463300383}, {2056, 28.425823720753847}, {2057, 28.531458363352172}, {2058, 28.371986321151727}, {2059, 27.281010674258564},
	{2060, 27.285423846392753}, {2061, 26.982970399775176}, {2062, 26.779917891194174}, {2063, 27.334018434853117}, {2064, 27.261844645356348}, {2065, 27.08643958372844}, {2066, 27.399456700893154}, {2067, 27.35064731231653}, {2068, 27.27964623953228}, {2069, 27.594268915970815},
	{2070, 27.529530803142432}, {2071, 27.57032488737316}, {2072, 27.4481123592095}, {2073, 26.840190037017013}, {2074, 25.848284039508844}, {2075, 27.842568040851305}, {2076, 28.053732543316965}, {2077, 28.626766043264496}, {2078, 28.147220846160913}, {2079, 28.116929624170805},
	{2080, 28.006707726319842}, {2081, 28.30104291864807}, {2082, 28.33894272086177}, {2083, 28.44881078446907}, {2084, 28.407665090419357}, {2085, 29.120266868128827}, {2086, 29.3317588176526}, {2087, 29.665040474972592}, {2088, 29.513552545038365}, {2089, 29.692597123031344},
	{2090, 28.981378296214995}, {2091, 29.09551924330645}, {2092, 29.103036068928503}, {2093, 29.546315663547908}, {2094, 29.957633494290146}, {2095, 29.904489752089027}, {2096, 29.905243264397946}, {2097, 29.046115152161175}, {2098, 29.044952829872138}, {2099, 29.266240445467794},
	{2100, 29.59245009354912}, {2101, 29.711595098413557}, {2102, 30.01909364831503}, {2103, 30.02844709237877}, {2104, 29.95602684268363}, {2105, 29.966649831798698}, {2106, 29.870132199150568}, {2107, 30.054469107153587}, {2108, 30.00047327238945}, {2109, 29.56478041606059},
	{2110, 29.90146475387948}, {2111, 29.622907648647697}, {2112, 30.309630232664347}, {2113, 29.964474309001496}, {2114, 29.49100419801057}, {2115, 29.961421989896223}, {2116, 30.346134915473066}, {2117, 30.604426349400814}, {2118, 31.112159919665434}, {2119, 31.422724201504558},
	{2120, 31.585365400843976}, {2121, 31.996984724582912}, {2122, 32.01819220164321}, {2123, 29.835521461379106}, {2124, 30.096046165850005}, {2125, 30.103782504040677}, {2126, 30.053631787942646}, {2127, 29.906750519100672}, {2128, 29.906138940448397}, {2129, 29.852649788445774},
	{2130, 30.207615016068207}, {2131, 30.820165055355577}, {2132, 30.66806843164003}, {2133, 29.933937853455785}, {2134, 29.836930249713454}, {2135, 29.643987595361455}, {2136, 30.19074784312923}, {2137, 30.22542736675569}, {2138, 29.853735660522815}, {2139, 29.84557151500528},
	{2140, 29.839193019325773}, {2141, 31.156302724258683}, {2142, 31.25546101123808}, {2143, 31.108453918938817}, {2144, 30.666860514055692}, {2145, 30.645333186456657}, {2146, 30.170151295689198}, {2147, 30.295207809019463}, {2148, 30.8518824742632}, {2149, 31.113576998851187},
	{2150, 31.31604954619179}, {2151, 31.312585749752536}, {2152, 30.864704949670024}, {2153, 30.89452281143898}, {2154, 31.23342385585233}, {2155, 31.404784721717572}, {2156, 31.18805814717659}, {2157, 31.837154644201334}, {2158, 31.806849694846097}, {2159, 31.730917911346975},
	{2160, 31.640559706015285}, {2161, 31.04070924433706}, {2162, 29.808188744723488}, {2163, 30.56052952306829}, {2164, 30.606670887563382}, {2165, 30.40372997396476}, {2166, 30.720199473446222}, {2167, 30.76154769857017}, {2168, 30.970925562360136}, {2169, 31.019650519858754},
	{2170, 31.229380140618062}, {2171, 31.388864514313752}, {2172, 31.354301610850698}, {2173, 30.99276274081928}, {2174, 31.915179561018494}, {2175, 31.918576205835393}, {2176, 33.159103841393794}, {2177, 33.29787809852651}, {2178, 33.01252169346593}, {2179, 33.02073471727393},
	{2180, 32.99606635802466}, {2181, 33.00728410289347}, {2182, 34.05607738376311}, {2183, 33.15858774223605}, {2184, 33.43289159046996}, {2185, 33.4955768254167}, {2186, 33.49850941243009}, {2187, 33.6849166584474}, {2188, 33.94841513146962}, {2189, 33.30304766805812},
	{2190, 33.22108394356688}, {2191, 32.69882923499378}, {2192, 32.427937313925405}, {2193, 32.18858592278298}, {2194, 32.32103253993895}, {2195, 32.71485240989556}, {2196, 33.33520209595963}, {2197, 33.263196044170755}, {2198, 32.710035724800086}, {2199, 33.15410338967067},
	{2200, 33.49162431986145}, {2201, 33.710578425275074}, {2202, 33.32543853826808}, {2203, 33.25527764293191}, {2204, 33.46839755330703}, {2205, 33.683203814839125}, {2206, 33.73810431818219}, {2207, 33.26839137241745}, {2208, 32.870015366666216}, {2209, 33.00655626613422},
	{2210, 33.461231149892406}, {2211, 33.89423423998636}, {2212, 33.50309147431082}, {2213, 33.579287468108}, {2214, 33.66791505848393}, {2215, 34.38967435369897}, {2216, 36.28181224897229}, {2217, 36.88357351027984}, {2218, 36.84878280662571}, {2219, 37.47217008391058},
	{2220, 37.84817431115949}, {2221, 37.90417263033801}, {2222, 37.83987872444627}, {2223, 37.32997096688406}, {2224, 37.4853701637283}, {2225, 38.101980955554055}, {2226, 37.634879540380766}, {2227, 37.458475294951995}, {2228, 37.24084436632412}, {2229, 38.45249609002218},
	{2230, 37.85699416217567}, {2231, 37.35638525020401}, {2232, 37.34244352498811}, {2233, 37.61816197522845}, {2234, 37.16649173849021}, {2235, 37.47322953068236}, {2236, 37.2333430674181}, {2237, 37.14977263499141}, {2238, 36.93966508491671}, {2239, 37.069212698488194},
	{2240, 37.13031285412952}, {2241, 37.12637993171949}, {2242, 36.91777324959473}, {2243, 36.89130918063377}, {2244, 36.83287503871216}, {2245, 37.20202075141188}, {2246, 36.83524257279788}, {2247, 36.830944738890715}, {2248, 36.98000618572528}, {2249, 37.42482479721468},
	{2250, 37.63036405693426}, {2251, 36.667366298537495}, {2252, 36.752893008045845}, {2253, 36.353792852732994}, {2254, 36.68479700023098}, {2255, 36.69141503905663}, {2256, 36.87350479821814}, {2257, 36.165233755112176}, {2258, 35.733553198879285}, {2259, 35.48805636280678},
	{2260, 35.620206059835176}, {2261, 35.633174461262}, {2262, 35.8437425347841}, {2263, 35.9725442605288}, {2264, 35.30481451302577}, {2265, 34.799856216789664}, {2266, 35.20793503084299}, {2267, 35.15095956450417}, {2268, 35.52063000497536}, {2269, 35.7847373835048},
	{2270, 35.4149729701676}, {2271, 35.20790810237125}, {2272, 35.015963290895314}, {2273, 35.152141159882405}, {2274, 34.7677733076443}, {2275, 34.48805775061282}, {2276, 34.48754941675096}, {2277, 34.31241590281594}, {2278, 34.39912341428924}, {2279, 34.214813920779555},
	{2280, 34.28073309875244}, {2281, 33.48991097769715}, {2282, 33.48007351832354}, {2283, 34.358913453235225}, {2284, 34.81847331063591}, {2285, 35.01545093767003}, {2286, 35.522962489940845}, {2287, 35.4137445712856}, {2288, 36.11012685056512}, {2289, 36.22211408792958},
	{2290, 36.18967456479244}, {2291, 36.19988717533946}, {2292, 36.82497371024283}, {2293, 36.828687017747605}, {2294, 36.81449738807559}, {2295, 36.83820772921837}, {2296, 37.24345441577025}, {2297, 36.92597317758977}, {2298, 35.8576345692627}, {2299, 35.88555065526424},
	{2300, 36.06990172210221}, {2301, 35.94117611192266}, {2302, 35.917302525035176}, {2303, 35.67840840680457}, {2304, 36.24622015952215}, {2305, 36.3620909907333}, {2306, 36.530845130699554}, {2307, 37.10057430482785}, {2308, 36.99538603909066}, {2309, 37.317285421916054},
	{2310, 37.023853418725835}, {2311, 37.331141223084856}, {2312, 36.8562932336869}, {2313, 36.872868345401656}, {2314, 37.29544282161283}, {2315, 37.162364534385944}, {2316, 37.12578408822864}, {2317, 37.27181141630765}, {2318, 37.4312789350087}, {2319, 37.13237760566537},
	{2320, 37.11211557589226}, {2321, 36.8242524461256}, {2322, 36.99871196220295}, {2323, 36.53900862036208}, {2324, 37.02861438655951}, {2325, 36.87864302249147}, {2326, 37.35471016767267}, {2327, 37.48320749003392}, {2328, 37.90669667178226}, {2329, 38.226516715835075},
	{2330, 38.22517385982157}, {2331, 38.517597628277066}, {2332, 39.13171392966848}, {2333, 38.43519575012611}, {2334, 39.019538645173135}, {2335, 38.96816384019192}, {2336, 39.18980442092051}, {2337, 39.20626086856055}, {2338, 38.91508217017819}, {2339, 39.768877736103605},
	{2340, 39.77576200648055}, {2341, 39.70340066789778}, {2342, 39.28514875368393}, {2343, 39.45020952653042}, {2344, 39.39155936608262}, {2345, 38.98575368659195}, {2346, 39.07457749590117}, {2347, 39.315569014125366}, {2348, 39.534223631257824}, {2349, 39.46496086158911},
	{2350, 39.68920036760856}, {2351, 39.76991133023266}, {2352, 39.535528882389414}, {2353, 38.78464337191674}, {2354, 38.84802165134902}, {2355, 39.13969405342098}, {2356, 39.57233319093269}, {2357, 39.4775906546037}, {2358, 39.22345113789871}, {2359, 38.57809299449735},
	{2360, 38.57645107268238}, {2361, 38.972137312472306}, {2362, 38.48045973837729}, {2363, 38.13356592124918}, {2364, 37.58820508109955}, {2365, 37.201698739301705}, {2366, 36.94671668201051}, {2367, 37.2977080973896}, {2368, 37.56900473168416}, {2369, 38.107005730339885},
	{2370, 37.66230861685099}, {2371, 37.91179580848597}, {2372, 38.021982005474676}, {2373, 37.980026494228056}, {2374, 37.936145999397155}, {2375, 38.02211453233284}, {2376, 38.184818957491586}, {2377, 38.001562339346805}, {2378, 38.17115924132589}, {2379, 38.02933185572005},
	{2380, 39.26672886459662}, {2381, 39.438886818730374}, {2382, 39.632666785719366}, {2383, 39.69431724624071}, {2384, 38.45229246819694}, {2385, 38.92044292382193}, {2386, 38.71930950151329}, {2387, 38.743236180041634}, {2388, 38.983429309450706}, {2389, 38.97420423718335},
	{2390, 38.7215640748561}, {2391, 37.29737183692541}, {2392, 37.45124430298096}, {2393, 37.528370436924256}, {2394, 37.95222937643749}, {2395, 37.83598429862198}, {2396, 37.497742223483016}, {2397, 37.445480102504746}, {2398, 37.30971600962666}, {2399, 37.35293634455916},
	{2400, 37.53645804280457}, {2401, 37.39990233842864}, {2402, 37.35307876697158}, {2403, 37.20884959153676}, {2404, 37.37721955667315}, {2405, 38.163601842424356}, {2406, 38.1744583572895}, {2407, 38.22526886325096}, {2408, 37.74537108958047}, {2409, 37.695977476731315},
	{2410, 37.132399280518335}, {2411, 37.58951197469921}, {2412, 37.595014414031965}, {2413, 37.8352174960965}, {2414, 38.19482676835253}, {2415, 38.81615407880503}, {2416, 38.96954505622985}, {2417, 38.51014481284331}, {2418, 38.70949789629867}, {2419, 38.8330673644232},
	{2420, 38.79852936780312}, {2421, 38.36989947803435}, {2422, 38.38299952696908}, {2423, 38.37911293511124}, {2424, 38.30523674843859}, {2425, 38.2780523618985}, {2426, 38.11238736059342}, {2427, 38.146761901654045}, {2428, 38.16577426042987}, {2429, 37.21503059523459},
	{2430, 37.20194861904684}, {2431, 37.93629061523524}, {2432, 37.73740404804743}, {2433, 38.19428643465362}, {2434, 38.665082590845316}, {2435, 38.73654599191024}, {2436, 38.91621864442491}, {2437, 38.91583279385087}, {2438, 39.070111723777586}, {2439, 39.020903222278925},
	{2440, 39.11691716267563}, {2441, 38.48057387525625}, {2442, 38.53568696118676}, {2443, 38.643673021215534}, {2444, 38.260311740941205}, {2445, 38.22563157129045}, {2446, 38.02954799036356}, {2447, 38.37221447795219}, {2448, 38.39689602415647}, {2449, 38.39841000702669},
	{2450, 38.42466352375716}, {2451, 38.54182197292112}, {2452, 37.97168851025008}, {2453, 37.98072923120449}, {2454, 38.500048729444565}, {2455, 38.51204601961472}, {2456, 38.57119577782335}, {2457, 38.66797170791196}, {2458, 38.42048390776265}, {2459, 38.37374323690084},
	{2460, 37.32968095967905}, {2461, 37.08263012999697}, {2462, 37.50308137969606}, {2463, 37.74228959632586}, {2464, 37.74069036775092}, {2465, 37.17849832026422}, {2466, 36.96662265441138}, {2467, 36.94747312813148}, {2468, 37.478003899130535}, {2469, 36.78538811979787},
	{2470, 36.72166338143237}, {2471, 36.05942648742004}, {2472, 35.87090337493837}, {2473, 35.86422187859753}, {2474, 36.19415669239082}, {2475, 36.4304121266589}, {2476, 37.3789805517048}, {2477, 37.50777745489909}, {2478, 37.1957829652079}, {2479, 37.17977294040911},
	{2480, 38.216074640194954}, {2481, 39.76987261793349}, {2482, 39.710123436790155}, {2483, 39.46441746053927}, {2484, 39.887390948196604}, {2485, 40.47940528392495}, {2486, 40.96173004505429}, {2487, 40.80366573878367}, {2488, 41.54175623171586}, {2489, 41.9020390419709},
	{2490, 42.33439627394617}, {2491, 43.42510969518392}, {2492, 43.3467495490359}, {2493, 43.55870952188062}, {2494, 43.687712555042445}, {2495, 43.5164043044117}, {2496, 43.50241651823093}, {2497, 44.29101702903774}, {2498, 43.557445214897555}, {2499, 43.93564846197703},
	{2500, 43.443137649447785}, {2501, 42.20225850019654}, {2502, 41.79435089000459}, {2503, 41.76196350512668}, {2504, 42.303354344610476}, {2505, 43.10084057387829}, {2506, 43.178994474468176}, {2507, 42.428481094831376}, {2508, 42.547354773308356}, {2509, 42.76222854703309},
	{2510, 41.82251108158902}, {2511, 39.95979151189301}, {2512, 39.95821075474937}, {2513, 40.79681508224348}, {2514, 40.81708050706749}, {2515, 40.86098377024993}, {2516, 41.37066167344864}, {2517, 40.811835396416136}, {2518, 41.75210935179267}, {2519, 42.081642066666376},
	{2520, 42.08290785008212}, {2521, 42.24300735871055}, {2522, 43.469996426408535}, {2523, 43.07953421381988}, {2524, 42.75861204389449}, {2525, 42.68285436365714}, {2526, 42.70557759253858}, {2527, 42.48853467614813}, {2528, 42.57942769581852}, {2529, 41.641644251781955},
	{2530, 41.995153297318495}, {2531, 41.948491392461136}, {2532, 42.10736843531852}, {2533, 42.09104450737047}, {2534, 41.844893380773094}, {2535, 41.604667841842605}, {2536, 41.664479889713284}, {2537, 41.721596977396956}, {2538, 41.03970005650016}, {2539, 41.02554512620144},
	{2540, 40.87794875769463}, {2541, 39.90420781213615}, {2542, 39.917556293894414}, {2543, 39.854472672630656}, {2544, 40.07480007115982}, {2545, 39.67254038329676}, {2546, 39.75546306998178}, {2547, 39.738281539976}, {2548, 40.68871115360799}, {2549, 40.634406366307545},
	{2550, 40.825610497929816}, {2551, 40.56134401134031}, {2552, 40.49316949904079}, {2553, 41.411980447849764}, {2554, 41.45708514923727}, {2555, 41.62699785722495}, {2556, 40.73847974293596}, {2557, 40.9036273444639}, {2558, 40.835583475220645}, {2559, 40.692726642278075},
	{2560, 40.02156508795992}, {2561, 39.59727702576626}, {2562, 39.85915504290939}, {2563, 40.25776254670131}, {2564, 38.98058165621274}, {2565, 39.19626524671679}, {2566, 40.27851337856}, {2567, 40.42198078582052}, {2568, 40.84324235005817}, {2569, 41.43936550130537},
	{2570, 41.01778584521347}, {2571, 41.71741296575474}, {2572, 41.80764781109384}, {2573, 41.86906945022645}, {2574, 41.261486612033735}, {2575, 41.05330428242297}, {2576, 40.858767555527805}, {2577, 41.20327089795783}, {2578, 41.72211067822387}, {2579, 42.24939510039889},
	{2580, 43.02032269889916}, {2581, 43.169601435406285}, {2582, 43.03240557408647}, {2583, 44.058494616358495}, {2584, 42.69632168879649}, {2585, 42.70233698941648}, {2586, 42.694697227758425}, {2587, 42.88764129390405}, {2588, 43.08913827262613}, {2589, 42.89734340644753},
	{2590, 42.541548108008676}, {2591, 42.810258239438845}, {2592, 41.86604756233666}, {2593, 41.62721508609488}, {2594, 41.42397058232155}, {2595, 41.226915898008365}, {2596, 41.362278318282556}, {2597, 40.55335045136749}, {2598, 40.53227628820762}, {2599, 40.55804572554107},
	{2600, 40.59654847444725}, {2601, 40.600759547237764}, {2602, 39.886740241510296}, {2603, 39.74441936291896}, {2604, 39.4574717226145}, {2605, 40.060274508040756}, {2606, 40.13087881643223}, {2607, 40.034347420207766}, {2608, 39.99959402815168}, {2609, 39.96436408170099},
	{2610, 40.05829543634176}, {2611, 39.36433405019379}, {2612, 39.18728728622009}, {2613, 39.24495519885113}, {2614, 39.07757095227659}, {2615, 39.274474362783934}, {2616, 39.10484953636473}, {2617, 38.82145181383544}, {2618, 39.14891944323103}, {2619, 38.38965006924832},
	{2620, 38.39353088180409}, {2621, 37.5842486836372}, {2622, 37.50572067949534}, {2623, 37.47652007277792}, {2624, 37.460762948164124}, {2625, 37.70360102326645}, {2626, 37.9284949964923}, {2627, 37.94965323046383}, {2628, 38.7335220955414}, {2629, 38.261029750354496},
	{2630, 38.32794292196558}, {2631, 38.15225856809112}, {2632, 37.90928164592873}, {2633, 38.23964767428957}, {2634, 38.52123444438283}, {2635, 38.42104882766221}, {2636, 38.96022542956203}, {2637, 39.24100815688652}, {2638, 39.08793479950826}, {2639, 39.08884782494273},
	{2640, 39.55798120001941}, {2641, 39.105610334728816}, {2642, 39.007630691250704}, {2643, 38.20582502075655}, {2644, 37.543315900244956}, {2645, 37.57555493691154}, {2646, 37.28692975360062}, {2647, 36.23295703793576}, {2648, 36.18918955965909}, {2649, 36.08967399169209},
	{2650, 35.959764744648616}, {2651, 36.19197227091526}, {2652, 36.660749297052476}, {2653, 36.64494239211856}, {2654, 36.42558293570474}, {2655, 35.6375906092785}, {2656, 35.70674524011707}, {2657, 35.57068617114742}, {2658, 35.373679501491125}, {2659, 34.672906766786355},
	{2660, 34.63171730160524}, {2661, 34.67893812694516}, {2662, 34.654847702252816}, {2663, 34.65402092594314}, {2664, 34.771606902340174}, {2665, 34.88770410184326}, {2666, 35.02613347813431}, {2667, 34.46478240438498}, {2668, 34.68568272903622}, {2669, 34.44312396898851},
	{2670, 34.21234874898513}, {2671, 34.22641653591384}, {2672, 34.128223876429104}, {2673, 34.11242598726876}, {2674, 33.96946719921404}, {2675, 33.96323823944133}, {2676, 34.10711370082857}, {2677, 33.61921918842873}, {2678, 33.86921234418534}, {2679, 34.38300717848694},
	{2680, 34.47612413434144}, {2681, 33.878358516222164}, {2682, 33.95450317313319}, {2683, 34.15914443090066}, {2684, 33.8706108159827}, {2685, 34.38200284883451}, {2686, 34.38499453227831}, {2687, 34.540332423206024}, {2688, 34.180253970681264}, {2689, 34.23917159483758},
	{2690, 33.3409032838207}, {2691, 33.31758465582364}, {2692, 33.77426222148222}, {2693, 33.98469402333139}, {2694, 35.18897714992098}, {2695, 35.27834052976643}, {2696, 35.30947212883306}, {2697, 34.697407680416966}, {2698, 35.480822427408455}, {2699, 35.56467660433882},
	{2700, 35.53420547926852}, {2701, 35.541541884085056}, {2702, 35.587731051837416}, {2703, 35.20649466374446}, {2704, 34.23840909461753}, {2705, 34.03444342209502}, {2706, 33.765366528347904}, {2707, 33.83889062651724}, {2708, 33.58019639477255}, {2709, 33.404308515206424},
	{2710, 32.5794052072048}, {2711, 32.585104546723436}, {2712, 32.266279628194816}, {2713, 31.763850208735782}, {2714, 31.82468466746643}, {2715, 31.693375409028246}, {2716, 31.713589796403312}, {2717, 31.89442805523013}, {2718, 30.539601797884956}, {2719, 30.419562355741576},
	{2720, 30.570511736331543}, {2721, 30.436298375688793}, {2722, 30.4150717914012}, {2723, 30.65434061186432}, {2724, 30.55584352842997}, {2725, 30.666073288068162}, {2726, 30.631386637749323}, {2727, 30.253653739813487}, {2728, 29.709659914781653}, {2729, 28.896044518517407},
	{2730, 28.61563883266229}, {2731, 28.70191534200063}, {2732, 29.201426696903418}, {2733, 29.55609328115069}, {2734, 28.656892877727273}, {2735, 29.07942162200021}, {2736, 29.26501321868672}, {2737, 29.646954975157882}, {2738, 29.334935013945213}, {2739, 29.050159467980038},
	{2740, 29.0197508395469}, {2741, 28.774518059870104}, {2742, 29.406230838159324}, {2743, 29.384319812035454}, {2744, 28.16252911704915}, {2745, 28.370968057426175}, {2746, 28.47565669331631}, {2747, 28.557859294540695}, {2748, 28.61247793755877}, {2749, 28.290652073805152},
	{2750, 27.951340656361044}, {2751, 28.423165549960824}, {2752, 28.44548879989753}, {2753, 28.43557149451693}, {2754, 28.041081598237184}, {2755, 27.037025918511283}, {2756, 27.037046717739166}, {2757, 26.76662330440143}, {2758, 26.699917649004856}, {2759, 26.889805976598808},
	{2760, 26.801047959108622}, {2761, 26.760134602011636}, {2762, 27.18343703683992}, {2763, 27.16859736505303}, {2764, 27.04599114188329}, {2765, 27.07137489048196}, {2766, 27.998508184180817}, {2767, 27.90008295282876}, {2768, 27.64403546500875}, {2769, 27.526129921325765},
	{2770, 27.17477572419831}, {2771, 27.341255122694978}, {2772, 27.281292839268044}, {2773, 27.457194113628123}, {2774, 27.125831819180696}, {2775, 27.153488900596923}, {2776, 26.40548276755705}, {2777, 26.20664419363637}, {2778, 25.447443897366075}, {2779, 25.436213063192547},
	{2780, 25.80691677092328}, {2781, 25.911262332850754}, {2782, 25.827467186922345}, {2783, 25.93386934563249}, {2784, 25.87141867343481}, {2785, 26.127903579867812}, {2786, 26.11594064081708}, {2787, 25.968383286170432}, {2788, 26.12819163023331}, {2789, 26.528383252253256},
	{2790, 26.63041226276307}, {2791, 26.12308929789773}, {2792, 25.824556557378628}, {2793, 25.705278327514673}, {2794, 25.533179388113364}, {2795, 25.111955575936644}, {2796, 25.19306942608654}, {2797, 25.315610017978926}, {2798, 25.54647388963821}, {2799, 25.487771689167698},
	{2800, 25.81216153045184}, {2801, 25.763987775825093}, {2802, 25.902526292298354}, {2803, 25.968428482836103}, {2804, 26.41323130119539}, {2805, 26.49882702247749}, {2806, 26.49213018635884}, {2807, 27.54190493767045}, {2808, 26.535580599916567}, {2809, 26.57432320629819},
	{2810, 26.90159184032591}, {2811, 26.587265607613453}, {2812, 26.59291668712681}, {2813, 26.423373614090597}, {2814, 27.866860910585345}, {2815, 28.207557672760228}, {2816, 28.496172416512515}, {2817, 28.42429902292854}, {2818, 28.524648108317813}, {2819, 28.611122350682358},
	{2820, 27.732969193443907}, {2821, 27.399970276602343}, {2822, 27.905344738574847}, {2823, 27.942078810801064}, {2824, 27.804282414772008}, {2825, 27.8069558632371}, {2826, 27.832235140508022}, {2827, 27.37610449016281}, {2828, 27.448768550966395}, {2829, 27.772837570338186},
	{2830, 28.168201851600365}, {2831, 28.149299964281663}, {2832, 28.131056291061356}, {2833, 27.900258674853603}, {2834, 27.900129431796973}, {2835, 27.703804331410204}, {2836, 27.233402978544067}, {2837, 28.62270120196561}, {2838, 28.753984952852}, {2839, 27.849450371851088},
	{2840, 28.607099713321475}, {2841, 28.581922133054277}, {2842, 28.44598231620244}, {2843, 28.502126322789735}, {2844, 28.33255356108348}, {2845, 28.285305697352577}, {2846, 28.09977585227804}, {2847, 27.757945405078186}, {2848, 26.392688537225578}, {2849, 26.425165673292835},
	{2850, 26.545835303452666}, {2851, 26.439538464328816}, {2852, 26.269936477378405}, {2853, 26.512109899359487}, {2854, 27.512278345593856}, {2855, 28.082715243376764}, {2856, 28.41596094710675}, {2857, 27.45862971920284}, {2858, 27.39257771938314}, {2859, 27.36345333435615},
	{2860, 27.47151777939197}, {2861, 27.950894827790314}, {2862, 27.60764930763731}, {2863, 27.60813226132976}, {2864, 27.372749995542335}, {2865, 27.521145751594496}, {2866, 27.940176424747328}, {2867, 28.35191115083003}, {2868, 27.83432934764762}, {2869, 29.15786344470242},
	{2870, 29.79498828662717}, {2871, 29.568955183772818}, {2872, 29.517280037492394}, {2873, 29.63961776908481}, {2874, 30.662190826973372}, {2875, 31.71938876522025}, {2876, 31.826598098832324}, {2877, 31.826543856914203}, {2878, 31.789643116898706}, {2879, 31.92180528432921},
	{2880, 31.80959471460479}, {2881, 31.681403018636786}, {2882, 31.191957159319717}, {2883, 30.912044142938722}, {2884, 30.34671826324825}, {2885, 29.98006193864975}, {2886, 29.472355419791427}, {2887, 29.479494293595344}, {2888, 29.752640347399335}, {2889, 30.09718091452955},
	{2890, 30.431387560542564}, {2891, 29.496695832798583}, {2892, 29.246495986640035}, {2893, 29.222427974948758}, {2894, 29.124858728303685}, {2895, 28.965028596965585}, {2896, 29.08714179149652}, {2897, 30.4283543168946}, {2898, 31.215229365152215}, {2899, 31.150712888260642},
	{2900, 30.857590831985288}, {2901, 31.460128657051456}, {2902, 31.159427314891474}, {2903, 31.165617956156684}, {2904, 31.299914014945326}, {2905, 31.11690963033505}, {2906, 30.967174302858048}, {2907, 30.995885840876113}, {2908, 31.29636960058828}, {2909, 31.434858618252605},
	{2910, 31.416675748910425}, {2911, 30.205448705736853}, {2912, 29.93565034197684}, {2913, 30.343706590216623}, {2914, 30.21957109990217}, {2915, 30.85282680317679}, {2916, 30.968361747768547}, {2917, 30.009066802972328}, {2918, 29.932154181020326}, {2919, 30.093782671075324},
	{2920, 30.404844874889584}, {2921, 30.331546653465736}, {2922, 30.147767848823545}, {2923, 29.709117723930547}, {2924, 29.3659833798085}, {2925, 28.862774209616173}, {2926, 28.51448224611682}, {2927, 28.76793928928293}, {2928, 28.673496746750068}, {2929, 28.472443770823936},
	{2930, 29.022303006465368}, {2931, 28.00637473939249}, {2932, 28.031008433611056}, {2933, 27.729183209158307}, {2934, 27.9366018038988}, {2935, 27.640659462246116}, {2936, 27.171697419833}, {2937, 26.408787788436918}, {2938, 26.28204138551267}, {2939, 25.932006217741982},
	{2940, 26.169627229499696}, {2941, 25.822279798439705}, {2942, 26.35586961220703}, {2943, 26.18132397957769}, {2944, 26.044539631613738}, {2945, 25.974095714129387}, {2946, 27.05091837318809}, {2947, 26.974693513444837}, {2948, 27.072069424664924}, {2949, 26.25090442405271},
	{2950, 26.73596169363717}, {2951, 25.905671210399422}, {2952, 25.691113922860477}, {2953, 26.299532712205195}, {2954, 24.96955683778935}, {2955, 24.888869198579197}, {2956, 24.601211234973405}, {2957, 24.034114487943505}, {2958, 24.024743202429732}, {2959, 25.019008794538035},
	{2960, 24.432773221953887}, {2961, 24.544330149848985}, {2962, 23.85023866590447}, {2963, 24.036408763069247}, {2964, 24.08876550655795}, {2965, 24.05639813443458}, {2966, 23.71814837085052}, {2967, 24.703335417148605}, {2968, 24.77916378099878}, {2969, 24.839641043240448},
	{2970, 24.853870491674087}, {2971, 25.840255119538664}, {2972, 25.818729777629176}, {2973, 25.73662194677672}, {2974, 26.312249087826}, {2975, 26.081048566805045}, {2976, 26.039636620532686}, {2977, 26.03568726819535}, {2978, 26.063007917453888}, {2979, 26.074627484746603},
	{2980, 26.040651463264155}, {2981, 26.172289495364286}, {2982, 26.62269151997738}, {2983, 26.521078122843306}, {2984, 26.48143361417722}, {2985, 26.43597116107479}, {2986, 26.479253919810066}, {2987, 26.05243489612348}, {2988, 26.065403680162337}, {2989, 26.070748034587236},
	{2990, 26.054077155633216}, {2991, 25.652831846415367}, {2992, 25.876662312969824}, {2993, 26.316574636642432}, {2994, 26.27465443874206}, {2995, 26.499843498562846}, {2996, 26.427205343025584}, {2997, 26.798259276629466}, {2998, 26.901808522372313}, {2999, 26.76079388053373},
	{3000, 26.95186823373628}, {3001, 27.034524957712406}, {3002, 26.87614970836558}, {3003, 26.088631779268834}, {3004, 26.258487166059158}, {3005, 26.263116669541553}, {3006, 26.556642147234385}, {3007, 27.1359861481772}, {3008, 27.05636721935326}, {3009, 27.782632975155},
	{3010, 28.239461231129635}, {3011, 28.171321453013107}, {3012, 27.388829894601574}, {3013, 27.765206394186475}, {3014, 27.665523688066237}, {3015, 27.652201388513607}, {3016, 27.76330159496823}, {3017, 27.652745228165806}, {3018, 29.16493980313136}, {3019, 29.760186326718667},
	{3020, 29.524598241887276}, {3021, 29.871951567195385}, {3022, 29.972022031694312}, {3023, 29.991328977556655}, {3024, 30.51114039017488}, {3025, 30.358833052283288}, {3026, 31.113437416596867}, {3027, 30.73034455732333}, {3028, 32.411088299325755}, {3029, 32.448779387658455},
	{3030, 32.40261565557047}, {3031, 33.32318930682262}, {3032, 33.53986533177098}, {3033, 34.14238204328724}, {3034, 34.324204651156585}, {3035, 34.55394232184136}, {3036, 33.80917147487097}, {3037, 33.87637554473631}, {3038, 33.52627570280564}, {3039, 32.710090552383846},
	{3040, 32.87558231122469}, {3041, 32.83723732102603}, {3042, 32.68286627184585}, {3043, 32.645629659702166}, {3044, 32.485577854400574}, {3045, 32.54464973603174}, {3046, 32.72824138287855}, {3047, 32.569049941408885}, {3048, 32.05613996926093}, {3049, 31.418578354753414},
	{3050, 31.974802932294068}, {3051, 31.517876027087098}, {3052, 31.478771719965934}, {3053, 32.33321726337759}, {3054, 32.15907422841291}, {3055, 32.39386557285096}, {3056, 32.92288104967725}, {3057, 32.58205659155766}, {3058, 33.02979168623353}, {3059, 33.104577943842884},
	{3060, 32.7508051872267}, {3061, 30.759481316657414}, {3062, 29.93908316497376}, {3063, 30.168995523464204}, {3064, 30.234201200937164}, {3065, 29.60257745821407}, {3066, 29.42426454491802}, {3067, 29.780785754603404}, {3068, 29.758857379324553}, {3069, 30.339341677481386},
	{3070, 30.17509659780736}, {3071, 30.39121521041002}, {3072, 30.39268093037097}, {3073, 30.119809979067465}, {3074, 29.755321684850596}, {3075, 30.254534421486376}, {3076, 30.27128056523592}, {3077, 30.269129730144403}, {3078, 30.268406185451322}, {3079, 30.808812815476546},
	{3080, 30.541034763482905}, {3081, 30.616071356417166}, {3082, 30.49034629358917}, {3083, 30.327451475881006}, {3084, 30.20172837588546}, {3085, 30.552615556325403}, {3086, 31.018620896589276}, {3087, 31.016826954239793}, {3088, 31.03257471371818}, {3089, 30.76388835634399},
	{3090, 30.750773848565544}, {3091, 28.90734498274122}, {3092, 28.88512555430076}, {3093, 29.235602659773928}, {3094, 29.227088109152646}, {3095, 29.265927078146902}, {3096, 29.63113527441051}, {3097, 30.325843427198762}, {3098, 30.366277557982425}, {3099, 30.81125656901041},
	{3100, 29.607530596142997}, {3101, 30.157333515983648}, {3102, 30.18646934065617}, {3103, 30.27379415294111}, {3104, 30.289365730425246}, {3105, 30.283540247033166}, {3106, 31.32710063553683}, {3107, 30.380921899830913}, {3108, 30.22467645076004}, {3109, 30.23362298145734},
	{3110, 30.61875215657774}, {3111, 30.98837784635033}, {3112, 31.03260739138466}, {3113, 30.976968690215546}, {3114, 31.79541274581999}, {3115, 32.30837337558492}, {3116, 30.958484720733267}, {3117, 31.248323567786898}, {3118, 31.17080295379335}, {3119, 31.490285494334042},
	{3120, 31.28299461589361}, {3121, 31.12746538392657}, {3122, 30.304134609467486}, {3123, 30.482783363335685}, {3124, 30.800000711544357}, {3125, 30.923176972067218}, {3126, 30.92985171567796}, {3127, 31.237871497288655}, {3128, 30.082238264022603}, {3129, 30.6089077906634},
	{3130, 31.235939986705212}, {3131, 31.14323375771582}, {3132, 31.32918643869485}, {3133, 31.47312641489513}, {3134, 31.466063254090106}, {3135, 31.425832509717182}, {3136, 32.1719990071092}, {3137, 32.41592307689316}, {3138, 32.676500312625016}, {3139, 33.35536331207698},
	{3140, 33.65570232797892}, {3141, 33.04862310178812}, {3142, 33.03181458653315}, {3143, 32.67952645100101}, {3144, 32.58771553180158}, {3145, 32.60526161774588}, {3146, 32.59144411017273}, {3147, 33.328724603980014}, {3148, 32.82736116656727}, {3149, 32.585413549083036},
	{3150, 31.909366787173354}, {3151, 31.890172235321025}, {3152, 32.01030930891559}, {3153, 31.876026787120207}, {3154, 31.177003426608458}, {3155, 31.269152245617928}, {3156, 31.321299373154623}, {3157, 31.185431050212017}, {3158, 31.33308403249633}, {3159, 31.396718431876668},
	{3160, 30.967056835014755}, {3161, 31.937036635712108}, {3162, 31.782999539504566}, {3163, 31.463231624729538}, {3164, 31.462330205674178}, {3165, 32.38149340842041}, {3166, 31.490726766628722}, {3167, 31.180181319988332}, {3168, 31.285452919047007}, {3169, 32.61725672571165},
	{3170, 32.54476600813624}, {3171, 32.867677415690224}, {3172, 32.851230576948424}, {3173, 32.447875933693695}, {3174, 32.327497251158114}, {3175, 32.54030609356738}, {3176, 33.219908261056695}, {3177, 33.05354548450645}, {3178, 32.91346861269424}, {3179, 32.972877044342646},
	{3180, 32.93786082284114}, {3181, 33.05108392047543}, {3182, 33.89537603616726}, {3183, 33.82184220941501}, {3184, 33.83547506546621}, {3185, 33.46981809068626}, {3186, 33.48014088578789}, {3187, 33.99535008164156}, {3188, 34.134687943016004}, {3189, 34.116357932617554},
	{3190, 34.3777412140907}, {3191, 34.47433796931576}, {3192, 35.329063289425584}, {3193, 36.389648583072216}, {3194, 37.152845814499535}, {3195, 37.04698767782292}, {3196, 36.924986340055234}, {3197, 36.72395148805289}, {3198, 37.099937243992414}, {3199, 37.03586955519982},
	{3200, 36.85659515898313}, {3201, 37.68701715509432}, {3202, 36.94563230667493}, {3203, 36.9801530400879}, {3204, 37.124204726164955}, {3205, 37.21769294584}, {3206, 37.36244560706185}, {3207, 37.177958656048105}, {3208, 37.17234726327357}, {3209, 37.2334453881957},
	{3210, 37.443103290909}, {3211, 37.47601907379215}, {3212, 37.492358954797}, {3213, 37.75965833545013}, {3214, 37.44614357662946}, {3215, 37.36038063096078}, {3216, 37.05950813066276}, {3217, 38.18103211360699}, {3218, 36.53683047392274}, {3219, 36.83403875076923},
	{3220, 36.799322175892655}, {3221, 35.76343601069714}, {3222, 35.732925176029}, {3223, 36.030449190392034}, {3224, 35.53535958118256}, {3225, 35.46682168640866}, {3226, 35.73775862190484}, {3227, 35.61261356902764}, {3228, 35.60401961780849}, {3229, 35.7950184685732},
	{3230, 35.680731912648454}, {3231, 35.91734464456234}, {3232, 36.215345080856956}, {3233, 36.169986316646735}, {3234, 36.19636620447901}, {3235, 35.68416087517605}, {3236, 34.782382760280335}, {3237, 34.682205263960896}, {3238, 34.6915019903415}, {3239, 34.01850844249432},
	{3240, 34.49164616505544}, {3241, 34.81821831651344}, {3242, 34.17367204635451}, {3243, 33.50257123928646}, {3244, 33.74605123682653}, {3245, 33.207146127232235}, {3246, 33.350131113450125}, {3247, 33.31108845186046}, {3248, 33.25208316113067}, {3249, 32.96860920898072},
	{3250, 32.81656955503311}, {3251, 32.596084703753874}, {3252, 32.72681616233501}, {3253, 32.989201391855794}, {3254, 32.720933976649086}, {3255, 32.76607998687764}, {3256, 32.971731400496566}, {3257, 32.978292043059476}, {3258, 32.96571499076951}, {3259, 33.54075000081999},
	{3260, 33.428210870837745}, {3261, 33.37480509177156}, {3262, 32.04401143262248}, {3263, 31.758176393318287}, {3264, 31.640748236625246}, {3265, 31.64024961699623}, {3266, 32.12120327486007}, {3267, 32.09409145385511}, {3268, 31.82108292829529}, {3269, 31.767305808090345},
	{3270, 31.61485887968538}, {3271, 31.25747957686745}, {3272, 30.343098748976058}, {3273, 30.310065993327697}, {3274, 30.08147466217843}, {3275, 29.06160851755138}, {3276, 29.649133669716544}, {3277, 29.479576201649866}, {3278, 29.53734181807828}, {3279, 29.875185928183274},
	{3280, 30.026430749893212}, {3281, 29.070477635815827}, {3282, 30.080721132734187}, {3283, 30.213354081612774}, {3284, 30.584419177806883}, {3285, 30.554197032740483}, {3286, 30.743451866698816}, {3287, 32.72273350370443}, {3288, 32.55596605650281}, {3289, 32.58240930965781},
	{3290, 32.42498977194752}, {3291, 32.61029965109377}, {3292, 32.9308941823172}, {3293, 32.89483722129089}, {3294, 32.85881557046856}, {3295, 32.726785325793635}, {3296, 33.04118883100211}, {3297, 33.83571180198559}, {3298, 33.647394009337454}, {3299, 33.520540287573574},
	{3300, 33.162168528911174}, {3301, 33.508306024446206}, {3302, 33.525507479986295}, {3303, 33.52207711917462}, {3304, 33.627821807306546}, {3305, 33.198515456466744}, {3306, 33.42607172054768}, {3307, 33.07791501061832}, {3308, 33.107977635263275}, {3309, 32.842151272849485},
	{3310, 33.05292527827272}, {3311, 32.957185834270064}, {3312, 33.06230697948977}, {3313, 33.61764522661923}, {3314, 34.3994082345058}, {3315, 34.29897488531151}, {3316, 34.21313709031122}, {3317, 34.15640542042003}, {3318, 34.189075319669456}, {3319, 34.065995348334695},
	{3320, 33.99963167652209}, {3321, 33.824584145650626}, {3322, 32.62903776472264}, {3323, 32.07197931490158}, {3324, 31.212041654609635}, {3325, 31.35529289602581}, {3326, 31.795752220664465}, {3327, 32.055153913003146}, {3328, 32.120788126976784}, {3329, 32.11630360272935},
	{3330, 32.137853597557225}, {3331, 32.09903615115943}, {3332, 32.30648496829282}, {3333, 32.07508894046564}, {3334, 32.234779372557384}, {3335, 31.75162714209973}, {3336, 31.175617555355522}, {3337, 31.132722428185286}, {3338, 30.740013555537057}, {3339, 30.80440681916967},
	{3340, 30.389128544023528}, {3341, 30.923705876216804}, {3342, 30.570681686489785}, {3343, 30.56960911154055}, {3344, 30.572573228321385}, {3345, 30.56283258873671}, {3346, 30.75768607862666}, {3347, 30.70512333660316}, {3348, 30.73660038831468}, {3349, 31.14637617533282},
	{3350, 31.20431061055002}, {3351, 31.20123522063627}, {3352, 30.97866560996787}, {3353, 31.09897337898735}, {3354, 31.592251360854707}, {3355, 31.658003377873115}, {3356, 31.749358291626148}, {3357, 31.615018574293643}, {3358, 32.13348019004665}, {3359, 32.26754114906748},
	{3360, 32.114108645990356}, {3361, 32.09349668953626}, {3362, 32.12743992074132}, {3363, 33.26855777434632}, {3364, 33.20672720628778}, {3365, 33.222054502547586}, {3366, 33.276565557113116}, {3367, 33.24616375772876}, {3368, 33.22546957275849}, {3369, 33.197145715564346},
	{3370, 32.89226183861777}, {3371, 32.63753378800023}, {3372, 32.85392625336492}, {3373, 32.654738825317295}, {3374, 33.52629206488907}, {3375, 33.551906915417874}, {3376, 33.013300850717286}, {3377, 32.45224067089088}, {3378, 33.536730399855294}, {3379, 33.382025520697695},
	{3380, 33.65246947890217}, {3381, 33.729081781626235}, {3382, 33.68914809456685}, {3383, 34.27142675843858}, {3384, 34.3384613970915}, {3385, 33.041230980966134}, {3386, 33.01273553419829}, {3387, 33.81018910800749}, {3388, 34.24585759532097}, {3389, 34.61769546449783},
	{3390, 34.83617615053483}, {3391, 35.197775455649}, {3392, 35.41194481617064}, {3393, 36.97802352361716}, {3394, 36.955361245072574}, {3395, 36.46776848088892}, {3396, 36.439365640673294}, {3397, 37.01957434647059}, {3398, 36.90031551517573}, {3399, 36.34320496911004},
	{3400, 36.27540466884174}, {3401, 35.499445889025864}, {3402, 35.438767477098544}, {3403, 35.23819008394313}, {3404, 35.19377350745659}, {3405, 35.244867145440864}, {3406, 34.786303985903714}, {3407, 34.68233052858934}, {3408, 34.68606294217492}, {3409, 35.15865659415544},
	{3410, 36.152459222278075}, {3411, 36.09225370958755}, {3412, 36.43348782533814}, {3413, 37.17740333669563}, {3414, 37.09959143159908}, {3415, 37.19283547903976}, {3416, 37.067139992874246}, {3417, 37.12896533687519}, {3418, 37.374869441323746}, {3419, 37.001095013732005},
	{3420, 35.8685171365076}, {3421, 35.7790596667844}, {3422, 35.767099214183794}, {3423, 35.66846294670802}, {3424, 36.04001746550384}, {3425, 36.0480945234249}, {3426, 36.02197200446126}, {3427, 35.60312899342081}, {3428, 35.61743213922281}, {3429, 35.481336812650724},
	{3430, 35.6265808419118}, {3431, 35.58736423372758}, {3432, 34.924601234309385}, {3433, 34.90979132407057}, {3434, 35.12660838689912}, {3435, 35.27414359176062}, {3436, 34.4572696783567}, {3437, 34.855188368960206}, {3438, 34.7694402963776}, {3439, 34.65799602194358},
	{3440, 34.63813926025997}, {3441, 34.877437006370286}, {3442, 34.15314684377819}, {3443, 34.255400076640996}, {3444, 34.396642283465276}, {3445, 33.719365607039315}, {3446, 33.641859553881055}, {3447, 33.24778570063584}, {3448, 33.03425968268789}, {3449, 31.735215667970092},
	{3450, 32.52074978898301}, {3451, 32.51001723815836}, {3452, 31.988903384703473}, {3453, 32.00635868003232}, {3454, 33.15034114204495}, {3455, 33.150708817243185}, {3456, 33.160443645038676}, {3457, 33.25145744811404}, {3458, 31.855456989765536}, {3459, 31.540691769358283},
	{3460, 31.22731634782854}, {3461, 30.109943743087637}, {3462, 30.081678413940462}, {3463, 30.071462139339655}, {3464, 31.811852478724177}, {3465, 31.7817438259946}, {3466, 31.65842780226553}, {3467, 31.645232457369303}, {3468, 31.577808697440936}, {3469, 31.965622730682476},
	{3470, 31.55851189895187}, {3471, 31.55400579073177}, {3472, 31.615309544387085}, {3473, 30.577964817545922}, {3474, 31.380957115505957}, {3475, 31.65967766234796}, {3476, 31.650632080520086}, {3477, 31.583511885018947}, {3478, 31.46866237334157}, {3479, 31.51539173204228},
	{3480, 31.683674297218584}, {3481, 31.843475655353362}, {3482, 31.833474481849517}, {3483, 31.83374497628001}, {3484, 31.297115220943716}, {3485, 31.84548063776127}, {3486, 30.76165139386353}, {3487, 30.779380693616407}, {3488, 30.560174724155342}, {3489, 31.442644349165654},
	{3490, 31.23456150289414}, {3491, 31.47065724426264}, {3492, 31.04388200251078}, {3493, 31.887381742205424}, {3494, 31.022715733669997}, {3495, 31.132724334176533}, {3496, 31.254131102633508}, {3497, 29.47070713463634}, {3498, 30.102350147175464}, {3499, 30.80347150519261},
	{3500, 31.10662961863165}, {3501, 31.069676016670755}, {3502, 31.26759264402205}, {3503, 31.469315701418683}, {3504, 31.42829010862853}, {3505, 31.20304707788888}, {3506, 30.880459790358785}, {3507, 31.732791810278144}, {3508, 31.666863184217398}, {3509, 31.0372666719452},
	{3510, 30.95557997606788}, {3511, 31.980223292918765}, {3512, 32.012017886826364}, {3513, 31.69007433474044}, {3514, 31.768581447723278}, {3515, 32.15852386773846}, {3516, 31.853809576176754}, {3517, 31.849132994909127}, {3518, 32.43271679812625}, {3519, 31.639885035846955},
	{3520, 31.634677292557605}, {3521, 31.65931351662495}, {3522, 31.64099204228493}, {3523, 31.10736248404926}, {3524, 30.95348491889584}, {3525, 30.39386488435902}, {3526, 30.082639749439995}, {3527, 31.189586327936507}, {3528, 31.43839740369831}, {3529, 31.313018471682966},
	{3530, 31.24190268841608}, {3531, 31.373635460402006}, {3532, 31.26635675448505}, {3533, 30.98293712220932}, {3534, 31.431319445797822}, {3535, 30.662258590716984}, {3536, 31.555087070316418}, {3537, 32.98014017195333}, {3538, 32.718573086874514}, {3539, 32.69374365847009},
	{3540, 32.334428458462085}, {3541, 32.79981705652948}, {3542, 32.54809889650045}, {3543, 32.25529291766223}, {3544, 31.785544957781138}, {3545, 31.689101326443183}, {3546, 31.617220851427742}, {3547, 31.549033274787455}, {3548, 32.92223632877409}, {3549, 32.8330770506699},
	{3550, 33.014591854223255}, {3551, 33.36379119283432}, {3552, 33.055540509396565}, {3553, 32.46582242202945}, {3554, 32.09927951615547}, {3555, 32.68733881264074}, {3556, 33.86320988116308}, {3557, 33.94494214738513}, {3558, 33.529412010032885}, {3559, 33.4888869543669},
	{3560, 33.38035950901418}, {3561, 33.31012171482195}, {3562, 33.48535073196302}, {3563, 33.597392261160415}, {3564, 33.4512300687611}, {3565, 32.81838924040587}, {3566, 33.41685969176084}, {3567, 33.44158744976233}, {3568, 31.864631180692385}, {3569, 31.69972472198296},
	{3570, 31.62978284463028}, {3571, 33.02109212331147}, {3572, 33.012962884618574}, {3573, 32.541542372624065}, {3574, 31.491346373021337}, {3575, 31.615350692550003}, {3576, 31.804732803514614}, {3577, 31.785970967334098}, {3578, 31.302173527640477}, {3579, 31.066768598626613},
	{3580, 30.83902872742016}, {3581, 30.647189213101132}, {3582, 30.679283971247305}, {3583, 30.635220918876687}, {3584, 30.474194541456203}, {3585, 30.323171221808224}, {3586, 30.231880521112476}, {3587, 30.14165312650818}, {3588, 30.587932180323367}, {3589, 30.515797815362596},
	{3590, 30.697580128792886}, {3591, 30.5092767324158}, {3592, 30.22933286653618}, {3593, 30.399883720364244}, {3594, 30.563655322165122}, {3595, 30.916284482811637}, {3596, 31.266903691899042}, {3597, 31.277953104128557}, {3598, 31.248343781043335}, {3599, 31.665546713305297},
	{3600, 31.780736348640186}, {3601, 32.560705734243456}, {3602, 32.58949125031766}, {3603, 32.648379121925466}, {3604, 32.648994209302636}, {3605, 32.89262541394924}, {3606, 32.386706534468246}, {3607, 33.10476073358268}, {3608, 32.127562371704016}, {3609, 32.08021758550007},
	{3610, 32.01828734139976}, {3611, 32.149616630644026}, {3612, 32.24939276030207}, {3613, 31.908269478103314}, {3614, 31.75980113913783}, {3615, 31.599177196466123}, {3616, 30.82883453465096}, {3617, 30.805848182195113}, {3618, 30.67015361507686}, {3619, 30.82551357191438},
	{3620, 31.231900275482825}, {3621, 31.39570326592559}, {3622, 31.220478731815824}, {3623, 31.191057259483284}, {3624, 31.71256738228641}, {3625, 31.767353330007293}, {3626, 31.7421965553774}, {3627, 32.169320034067475}, {3628, 32.83045534082564}, {3629, 33.09082984672529},
	{3630, 33.091418882239445}, {3631, 33.534698294315376}, {3632, 34.98860015194777}, {3633, 34.887785100600965}, {3634, 34.52612439270598}, {3635, 35.222998429400846}, {3636, 35.32696073852328}, {3637, 33.91614263793164}, {3638, 33.955178987781}, {3639, 32.98821123005988},
	{3640, 31.54612425654933}, {3641, 30.47179194130409}, {3642, 29.121801087250198}, {3643, 28.98075756334753}, {3644, 29.21120341558452}, {3645, 28.94324522035289}, {3646, 30.61040164869518}, {3647, 30.938644800763065}, {3648, 31.88964085600857}, {3649, 31.104255236657654},
	{3650, 30.80739952109552}, {3651, 30.87061979495017}, {3652, 30.50628535976767}, {3653, 30.526826937324103}, {3654, 30.39733248162421}, {3655, 30.396253710063263}, {3656, 30.500732657862326}, {3657, 30.464941464184626}, {3658, 30.397674823493038}, {3659, 31.559828803294607},
	{3660, 30.4775995110338}, {3661, 30.605373430398316}, {3662, 30.959781079195544}, {3663, 30.686376335617936}, {3664, 30.45394463567413}, {3665, 30.836569443595376}, {3666, 30.41004287663308}, {3667, 30.76197883114409}, {3668, 30.17037689073509}, {3669, 30.057913986094512},
	{3670, 30.087583283388085}, {3671, 30.21878224005264}, {3672, 30.246448076959325}, {3673, 30.58839113549538}, {3674, 31.47426930437642}, {3675, 31.010529526010682}, {3676, 31.303422051514435}, {3677, 31.003100220279816}, {3678, 30.98326209088546}, {3679, 30.69183779794675},
	{3680, 31.223367625034683}, {3681, 30.789280075755688}, {3682, 30.19829216553304}, {3683, 30.363595369442493}, {3684, 30.27935553254929}, {3685, 30.1261971935347}, {3686, 30.79863985302651}, {3687, 31.047595403218057}, {3688, 30.90228673518786}, {3689, 30.543388017289054},
	{3690, 30.704356144092372}, {3691, 30.63973229439528}, {3692, 30.68310619503808}, {3693, 30.603549759307885}, {3694, 31.374934823463768}, {3695, 31.389460746452443}, {3696, 31.904273713484496}, {3697, 31.885063882176844}, {3698, 31.820524013817312}, {3699, 31.82770668437377},
	{3700, 31.62129391692174}, {3701, 33.01039885910495}, {3702, 32.810936220934124}, {3703, 33.11606920366353}, {3704, 33.45236130557991}, {3705, 34.35768750096602}, {3706, 33.480461372240505}, {3707, 33.73411429026118}, {3708, 33.89279065017372}, {3709, 34.23881544215997},
	{3710, 34.935789977307365}, {3711, 34.77481188799792}, {3712, 34.73666168190101}, {3713, 34.049290860266446}, {3714, 34.3821020789841}, {3715, 34.6030641653466}, {3716, 34.69594103398987}, {3717, 34.17980982257179}, {3718, 34.16518765028321}, {3719, 34.23763587885022},
	{3720, 34.601596281681694}, {3721, 35.4175582873499}, {3722, 35.59749071347688}, {3723, 34.32925786634385}, {3724, 34.51637645217182}, {3725, 34.525950151725944}, {3726, 35.998069795400646}, {3727, 35.963551274884786}, {3728, 36.036689984025955}, {3729, 37.24781768842208},
	{3730, 37.277514336598095}, {3731, 37.30863902603817}, {3732, 36.79217135191674}, {3733, 36.79064349318625}, {3734, 36.001098652284306}, {3735, 35.86481428501773}, {3736, 35.94802206870304}, {3737, 37.14027447150489}, {3738, 36.258549896818224}, {3739, 36.802348037612525},
	{3740, 36.89335332794575}, {3741, 37.908095460582}, {3742, 37.71387537919735}, {3743, 37.25060233029356}, {3744, 36.911971103005506}, {3745, 36.621626787271495}, {3746, 36.78598563390066}, {3747, 36.78867687247616}, {3748, 36.846211552881314}, {3749, 36.68451178474116},
	{3750, 36.30880218835804}, {3751, 36.74490372547481}, {3752, 36.93776738041527}, {3753, 36.92794573529495}, {3754, 36.88702244570728}, {3755, 37.032752352208334}, {3756, 37.09031587985092}, {3757, 37.25861213788812}, {3758, 37.0208483030904}, {3759, 37.44627314073198},
	{3760, 36.60326002825027}, {3761, 36.5349242191796}, {3762, 36.18844767465498}, {3763, 36.58284312296601}, {3764, 36.501734860814345}, {3765, 36.047516333562704}, {3766, 35.32968089985233}, {3767, 36.28983500653037}, {3768, 35.9811194049413}, {3769, 36.10451903716811},
	{3770, 36.34687133526118}, {3771, 36.31609256803086}, {3772, 37.63818828180108}, {3773, 38.43083167710727}, {3774, 38.457277972233115}, {3775, 38.50074370521922}, {3776, 38.57905462745658}, {3777, 37.94556968927861}, {3778, 38.250174481197824}, {3779, 38.87016646551586},
	{3780, 38.96356411591443}, {3781, 38.81436757446562}, {3782, 38.70813805142539}, {3783, 38.36257955910033}, {3784, 38.334587300767666}, {3785, 38.573334533834945}, {3786, 38.706937363024785}, {3787, 38.456878484269325}, {3788, 38.59652287562196}, {3789, 38.87303482456266},
	{3790, 38.26707578973226}, {3791, 38.08710058110894}, {3792, 38.107611873182606}, {3793, 37.87348574106414}, {3794, 38.467343581667315}, {3795, 38.52284971229728}, {3796, 38.80030552742671}, {3797, 39.31444077052365}, {3798, 39.36714339199697}, {3799, 39.265510040584786},
	{3800, 39.35757249633458}, {3801, 39.23029087940918}, {3802, 40.236476990129525}, {3803, 40.40447274896678}, {3804, 39.90050059379676}, {3805, 39.82968538918735}, {3806, 39.568796564237815}, {3807, 39.66844747677395}, {3808, 39.48947001553621}, {3809, 39.07804466925928},
	{3810, 39.08468133372294}, {3811, 39.409077167178886}, {3812, 39.59388813521032}, {3813, 39.61292554954707}, {3814, 39.53006069194008}, {3815, 39.43424867493228}, {3816, 39.364325046233276}, {3817, 39.24878540639196}, {3818, 38.91030638030182}, {3819, 39.19021407549976},
	{3820, 39.52465873164222}, {3821, 39.30579054542478}, {3822, 39.066334049300906}, {3823, 38.445919893706396}, {3824, 38.82331512394734}, {3825, 38.722751358387455}, {3826, 39.18918989725993}, {3827, 39.3325423377068}, {3828, 40.07164954275041}, {3829, 40.07074505067318},
	{3830, 40.27305857026511}, {3831, 40.29841893573262}, {3832, 40.35632841195591}, {3833, 41.25954776973257}, {3834, 41.08661644599172}, {3835, 40.930860440282444}, {3836, 40.67035270986339}, {3837, 40.59686023107034}, {3838, 40.966306832072135}, {3839, 41.73206011126974},
	{3840, 41.83313880921912}, {3841, 42.710027568498774}, {3842, 43.09298354963694}, {3843, 43.97481631223127}, {3844, 43.06984802315324}, {3845, 42.88682049659426}, {3846, 42.70391340792306}, {3847, 42.67733443704977}, {3848, 42.312517547282376}, {3849, 42.68248973003122},
	{3850, 41.89851060373508}, {3851, 42.499365091434946}, {3852, 42.04285692039637}, {3853, 42.36335659371158}, {3854, 43.00859290667485}, {3855, 42.64595368210728}, {3856, 42.84344419146314}, {3857, 42.58554402244061}, {3858, 42.94977322974173}, {3859, 42.970561962196946},
	{3860, 43.09387131088587}, {3861, 43.5526747563676}, {3862, 43.59839466763858}, {3863, 43.491401190645476}, {3864, 43.890847555316626}, {3865, 43.90554980755929}, {3866, 43.29419748320046}, {3867, 43.19271817040813}, {3868, 43.15798450802592}, {3869, 44.936354699949135},
	{3870, 44.925896564304466}, {3871, 45.141313850266805}, {3872, 45.15805553382705}, {3873, 45.175146274315395}, {3874, 44.602873917897206}, {3875, 43.98425210064129}, {3876, 44.21112444021221}, {3877, 44.31207946892926}, {3878, 44.32915256192521}, {3879, 44.54003640246446},
	{3880, 44.43388783676019}, {3881, 44.377913951958845}, {3882, 44.08660155118512}, {3883, 44.084088844428344}, {3884, 44.678908282742874}, {3885, 44.69090507621899}, {3886, 44.66399823516045}, {3887, 44.70003406608551}, {3888, 44.64217161352199}, {3889, 44.598427607594914},
	{3890, 44.64183638547881}, {3891, 45.313385126126406}, {3892, 45.213056881203656}, {3893, 45.83751311620533}, {3894, 45.97798477844367}, {3895, 46.69554397624657}, {3896, 46.780476914271844}, {3897, 46.42161452367823}, {3898, 46.485265361946965}, {3899, 46.463419227463945},
	{3900, 46.40619518750473}, {3901, 46.06654509998825}, {3902, 46.57689530438109}, {3903, 46.23083598006043}, {3904, 46.574270685203786}, {3905, 46.78507045779222}, {3906, 46.762325322870765}, {3907, 47.013171115464665}, {3908, 47.35684909712627}, {3909, 47.46573772776851},
	{3910, 47.79168684198062}, {3911, 46.864811059928705}, {3912, 46.19102604217612}, {3913, 45.57512279475959}, {3914, 45.27697004686091}, {3915, 44.43233105401431}, {3916, 44.48913258511433}, {3917, 44.05739070330766}, {3918, 43.43326838667846}, {3919, 43.18101584512046},
	{3920, 43.12661207742961}, {3921, 43.20235581216143}, {3922, 43.21124585054493}, {3923, 43.54158862241011}, {3924, 43.50571782863192}, {3925, 43.711364180631804}, {3926, 43.18168675879529}, {3927, 42.89854097019134}, {3928, 42.910583730646124}, {3929, 43.18510405314944},
	{3930, 42.639952988135626}, {3931, 42.797465701366804}, {3932, 43.44286812172023}, {3933, 43.19594242280566}, {3934, 43.423279844975504}, {3935, 43.637554324106404}, {3936, 43.56664792791941}, {3937, 44.47718122890482}, {3938, 42.71893554253818}, {3939, 42.68619011219234},
	{3940, 42.764744246822005}, {3941, 42.368141211578596}, {3942, 42.72177242428145}, {3943, 42.58290514752061}, {3944, 42.500109121456575}, {3945, 43.06917028887632}, {3946, 43.1390878438651}, {3947, 43.67566420376484}, {3948, 43.32879166406192}, {3949, 43.12282803410909},
	{3950, 43.53504871953674}, {3951, 43.11341790856445}, {3952, 43.09460900193214}, {3953, 42.975278393392486}, {3954, 43.02716626297875}, {3955, 43.28841760595471}, {3956, 43.15013781306844}, {3957, 43.05005871018039}, {3958, 42.643291525484216}, {3959, 41.40330273303392},
	{3960, 41.190483201302776}, {3961, 41.18851255115125}, {3962, 41.139227053508684}, {3963, 41.262957426835335}, {3964, 41.56188105204588}, {3965, 41.29178612732812}, {3966, 42.1903083759515}, {3967, 43.24502540234582}, {3968, 43.53636550586511}, {3969, 43.2653460646287},
	{3970, 43.08283306703269}, {3971, 42.4092975371573}, {3972, 42.339747488590305}, {3973, 42.17938430330037}, {3974, 42.9302231459865}, {3975, 44.14104375702491}, {3976, 44.32654181837024}, {3977, 44.85103730540091}, {3978, 43.686022699020185}, {3979, 43.52045377054748},
	{3980, 44.066949791075196}, {3981, 43.54943797407643}, {3982, 43.55681098163001}, {3983, 43.62378293786004}, {3984, 43.27719869525927}, {3985, 43.520080202226026}, {3986, 43.48833320696304}, {3987, 43.528692784115066}, {3988, 43.39572733345793}, {3989, 43.66669909833283},
	{3990, 43.627624602729895}, {3991, 44.99085408453511}, {3992, 44.957885207190635}, {3993, 44.75608239056898}, {3994, 44.79205318911418}, {3995, 45.071567286436604}, {3996, 45.0773216187218}, {3997, 45.20628655580068}, {3998, 45.042340799331626}, {3999, 44.40459780963831},
	{4000, 44.84911779417697}, {4001, 44.84679216126694}, {4002, 44.9926860827092}, {4003, 45.332476785661704}, {4004, 45.32599258516697}, {4005, 44.97196102902279}, {4006, 44.975532895597816}, {4007, 45.03190754404627}, {4008, 43.66039558703255}, {4009, 43.82989258131152},
	{4010, 44.06126134232322}, {4011, 44.30529606181042}, {4012, 44.44658393531378}, {4013, 43.738910733073006}, {4014, 44.212806733919}, {4015, 44.10630077043948}, {4016, 43.99563053457421}, {4017, 44.095566651377375}, {4018, 43.83450825940757}, {4019, 43.84846576986777},
	{4020, 42.71505037386405}, {4021, 43.00488908696087}, {4022, 42.4995621932694}, {4023, 42.28588980382473}, {4024, 42.304954106759766}, {4025, 41.580902668274064}, {4026, 42.195928955837026}, {4027, 42.32891452704911}, {4028, 42.394421598632725}, {4029, 42.88514428175226},
	{4030, 42.88411017501612}, {4031, 42.44465234171097}, {4032, 42.423161360690465}, {4033, 42.06024809501421}, {4034, 41.46983767233033}, {4035, 41.450540092235606}, {4036, 41.551824782132655}, {4037, 41.497581890358525}, {4038, 41.74337678928221}, {4039, 42.01458088760071},
	{4040, 42.000161946828975}, {4041, 42.09809076103792}, {4042, 40.40121722063858}, {4043, 40.405347534544276}, {4044, 41.45596015966376}, {4045, 41.34524024668175}, {4046, 41.48790124860581}, {4047, 40.85226478482957}, {4048, 41.72644422704275}, {4049, 42.28054826801833},
	{4050, 42.470889350803844}, {4051, 42.58707283732388}, {4052, 43.376033472640444}, {4053, 43.273463592859194}, {4054, 42.91653543267234}, {4055, 43.68837327519839}, {4056, 44.35550220099082}, {4057, 44.303862119305684}, {4058, 44.268994539070036}, {4059, 44.12291558250871},
	{4060, 44.15997387053544}, {4061, 43.847891173179995}, {4062, 43.88605800805093}, {4063, 43.76622485923872}, {4064, 44.08049094209474}, {4065, 43.52840705131174}, {4066, 43.47588617544269}, {4067, 43.42547149366908}, {4068, 43.620164305725254}, {4069, 43.62469613986601},
	{4070, 43.35722721012197}, {4071, 43.11523304678633}, {4072, 43.21270244719499}, {4073, 42.799008504053795}, {4074, 42.579441010470354}, {4075, 43.616467334850654}, {4076, 44.21857842681485}, {4077, 44.096520800225065}, {4078, 44.076122818906754}, {4079, 43.882145702606714},
	{4080, 44.025173271395175}, {4081, 44.08675228361723}, {4082, 44.08280580012843}, {4083, 44.089090764695634}, {4084, 44.63027712418217}, {4085, 44.64257806553344}, {4086, 44.63488930186029}, {4087, 43.49185769105879}, {4088, 43.81922760361489}, {4089, 44.55770909655596},
	{4090, 44.495768552475916}, {4091, 44.70529568081817}, {4092, 44.608267360939585}, {4093, 44.32192140208638}, {4094, 44.32913149339295}, {4095, 43.92083958045917}, {4096, 43.93629699159078}, {4097, 44.42006096186749}, {4098, 44.436560493979954}, {4099, 45.03381928301654},
	{4100, 44.89092252034728}, {4101, 45.228836061954944}, {4102, 44.96315616449893}, {4103, 45.317252160358144}, {4104, 45.3699223441705}, {4105, 44.99809335119828}, {4106, 45.31350010825937}, {4107, 45.28642508634763}, {4108, 45.23753191697613}, {4109, 45.55004475954644},
	{4110, 46.058774601853955}, {4111, 45.83557796236126}, {4112, 45.67893880941216}, {4113, 45.58586429125116}, {4114, 45.483336441906616}, {4115, 44.95324979965775}, {4116, 44.766511487040916}, {4117, 44.863928712529}, {4118, 45.521105859507294}, {4119, 45.597789271022776},
	{4120, 45.548218639658785}, {4121, 45.5671964393491}, {4122, 45.66840481231619}, {4123, 45.421280141591325}, {4124, 45.42131956848279}, {4125, 46.48565429648017}, {4126, 46.691978861656345}, {4127, 46.7203310903226}, {4128, 47.83269632839022}, {4129, 47.818072148512215},
	{4130, 47.904859885869236}, {4131, 47.7041273974865}, {4132, 47.69720727111671}, {4133, 48.00314297086582}, {4134, 46.56039022043427}, {4135, 44.90413846099235}, {4136, 45.52514774325245}, {4137, 46.058621957431804}, {4138, 46.12588682589276}, {4139, 46.58227592497253},
	{4140, 46.17055554294809}, {4141, 46.80784968189301}, {4142, 46.49508518393976}, {4143, 46.500309270278464}, {4144, 46.414835172420304}, {4145, 46.304075582190514}, {4146, 46.22819939150845}, {4147, 45.85490163160914}, {4148, 46.16449836318747}, {4149, 46.36607159615689},
	{4150, 45.33765696135226}, {4151, 45.51784949111958}, {4152, 45.27464232646123}, {4153, 45.64354971534378}, {4154, 45.57676214832657}, {4155, 45.56569880057714}, {4156, 45.645824829272414}, {4157, 45.6060530616635}, {4158, 45.78376908108006}, {4159, 45.92037288384215},
	{4160, 45.93018712100647}, {4161, 45.04435615370153}, {4162, 43.97591673735583}, {4163, 43.60804290415924}, {4164, 43.25559660341626}, {4165, 43.30560502979643}, {4166, 43.32162929680021}, {4167, 43.220797929589125}, {4168, 43.88958904031423}, {4169, 43.92613927037596},
	{4170, 43.28570468545945}, {4171, 43.33758546950846}, {4172, 43.38200781871171}, {4173, 43.37439151387566}, {4174, 43.62114145159183}, {4175, 42.583155075251156}, {4176, 41.79257202974383}, {4177, 41.5301578370286}, {4178, 40.72846655122725}, {4179, 40.9074303438794},
	{4180, 41.486828841681415}, {4181, 41.43693955839994}, {4182, 41.25469470037508}, {4183, 41.3152306690082}, {4184, 42.05756123320117}, {4185, 41.976765116312805}, {4186, 42.55329890940964}, {4187, 42.32763877115726}, {4188, 42.331621409998704}, {4189, 41.678572270110294},
	{4190, 41.78167622000538}, {4191, 41.57841592927911}, {4192, 41.41582587790593}, {4193, 40.829011801535664}, {4194, 42.57985084363515}, {4195, 42.4375122885433}, {4196, 42.32575825185156}, {4197, 42.800600639022605}, {4198, 42.07267000939594}, {4199, 41.991890779837725},
	{4200, 42.01125834670128}, {4201, 42.01783872316503}, {4202, 41.99633327331731}, {4203, 42.2264225459579}, {4204, 42.41931446868698}, {4205, 42.5104434476498}, {4206, 42.51820041440961}, {4207, 43.10274662201198}, {4208, 43.03752438898408}, {4209, 43.19323932573483},
	{4210, 43.15253357742187}, {4211, 42.158082291323616}, {4212, 42.18530485919557}, {4213, 42.179672734709584}, {4214, 42.08370843694731}, {4215, 42.062223021469975}, {4216, 41.67838942952538}, {4217, 41.49506764318014}, {4218, 41.59881716888323}, {4219, 41.926024236261355},
	{4220, 42.11947567033156}, {4221, 42.26187787539394}, {4222, 42.65015253639434}, {4223, 42.441042770154844}, {4224, 43.08690587956467}, {4225, 44.39310986424937}, {4226, 44.94461257206579}, {4227, 44.78804776055559}, {4228, 45.53797859707034}, {4229, 45.55187883708798},
	{4230, 45.88537683206737}, {4231, 45.825185517872704}, {4232, 46.07574947104996}, {4233, 46.060884716412254}, {4234, 45.76160043499644}, {4235, 45.76931072837809}, {4236, 45.51959493255436}, {4237, 45.554677642229564}, {4238, 45.52426093953901}, {4239, 46.109945660686115},
	{4240, 45.99257414377729}, {4241, 46.07894808606258}, {4242, 44.286086348874676}, {4243, 44.4865400708932}, {4244, 44.234913797823154}, {4245, 44.16033974830902}, {4246, 43.44966049381201}, {4247, 43.08447818539749}, {4248, 43.205930480034986}, {4249, 43.27174171858989},
	{4250, 43.37829207780095}, {4251, 43.10867398251995}, {4252, 43.143056746791466}, {4253, 43.184584390833216}, {4254, 43.2384965784782}, {4255, 43.64269672822312}, {4256, 43.95024182576365}, {4257, 44.34389839798999}, {4258, 44.779096753781424}, {4259, 44.81584343357247},
	{4260, 44.862897971461486}, {4261, 44.809095330679426}, {4262, 44.82258689695792}, {4263, 44.94257959545199}, {4264, 44.70649326700459}, {4265, 44.83403801956116}, {4266, 44.69375741776056}, {4267, 44.246909347585806}, {4268, 44.31131992100262}, {4269, 44.30870396354328},
	{4270, 45.277184693727}, {4271, 45.325741450057016}, {4272, 45.35787945327525}, {4273, 46.26696427252453}, {4274, 46.3349833461467}, {4275, 46.262367003647526}, {4276, 45.88415082220467}, {4277, 45.69088772324733}, {4278, 46.30744653697344}, {4279, 46.109976226034966},
	{4280, 46.00659771921764}, {4281, 45.98327288475588}, {4282, 45.93683158647156}, {4283, 45.827017445641175}, {4284, 44.898780786668084}, {4285, 44.857946447901604}, {4286, 44.78129029650326}, {4287, 44.460979780768575}, {4288, 43.781370713844545}, {4289, 43.80346385692286},
	{4290, 43.70136533034899}, {4291, 43.59605587452415}, {4292, 46.60711089281704}, {4293, 43.20999116221206}, {4294, 43.61705810567689}, {4295, 43.10115465773163}, {4296, 43.384267987646375}, {4297, 43.335817467294284}, {4298, 43.450535768186434}, {4299, 43.27624559738883},
	{4300, 43.74264705432361}, {4301, 43.80047106789878}, {4302, 43.1793620620206}, {4303, 44.06844891439754}, {4304, 44.122958015118876}, {4305, 44.16868478059633}, {4306, 43.763355009011846}, {4307, 44.24245012746741}, {4308, 43.6667108237416}, {4309, 43.44755931800053},
	{4310, 43.8388540119679}, {4311, 43.84684532813053}, {4312, 43.891606967283025}, {4313, 43.61609318450177}, {4314, 43.50391313644561}, {4315, 43.4370124294098}, {4316, 43.320512498718685}, {4317, 43.43317762888966}, {4318, 43.441565229865844}, {4319, 43.89166237920707},
	{4320, 43.79297096639801}, {4321, 42.86616397750371}, {4322, 42.492817070603124}, {4323, 42.463597734904255}, {4324, 42.099203979340935}, {4325, 43.148352379283736}, {4326, 43.14393983822119}, {4327, 43.802920465762334}, {4328, 43.787438894126545}, {4329, 44.8390211407645},
	{4330, 43.9210831019679}, {4331, 44.160162794499165}, {4332, 44.603706152703076}, {4333, 44.6029921449433}, {4334, 45.71896157142412}, {4335, 45.7186083077643}, {4336, 46.132237714004425}, {4337, 45.29810811659616}, {4338, 45.44893704926406}, {4339, 44.56756839730384},
	{4340, 44.84857422415435}, {4341, 44.59101148982434}, {4342, 45.832174813792975}, {4343, 46.24568332480992}, {4344, 46.27972490525816}, {4345, 46.220037760327614}, {4346, 46.26785697686892}, {4347, 45.91029124256099}, {4348, 46.01333033455775}, {4349, 45.55640134102827},
	{4350, 45.07332328943664}, {4351, 44.05034495051119}, {4352, 44.37631641742659}, {4353, 44.47510379397457}, {4354, 44.481536987385375}, {4355, 45.09815452419815}, {4356, 44.23545269297595}, {4357, 44.35190888940349}, {4358, 44.44376512206195}, {4359, 44.35377582256026},
	{4360, 44.182956840667266}, {4361, 44.4297999192324}, {4362, 44.13473879958124}, {4363, 44.055995402850435}, {4364, 44.005471335161786}, {4365, 43.25758809794344}, {4366, 43.817908095986404}, {4367, 43.822056761477334}, {4368, 44.14477410502386}, {4369, 43.797486505074176},
	{4370, 43.79800963408963}, {4371, 42.8796997482786}, {4372, 42.88556424491737}, {4373, 42.77727527309622}, {4374, 42.35778308150795}, {4375, 42.16975466552083}, {4376, 41.93028553518078}, {4377, 42.09563715627173}, {4378, 41.17204610689614}, {4379, 41.78572427771177},
	{4380, 41.92150205271964}, {4381, 42.09741338103042}, {4382, 43.69386481163199}, {4383, 42.96742035210106}, {4384, 42.343580110976134}, {4385, 42.22399465949221}, {4386, 42.6091386627358}, {4387, 42.568896188906415}, {4388, 42.64410302487118}, {4389, 41.95886131685545},
	{4390, 40.80681239206415}, {4391, 39.38331357790885}, {4392, 39.78427361503698}, {4393, 39.93810078981509}, {4394, 40.13352169285055}, {4395, 40.21778170710591}, {4396, 40.16970625785058}, {4397, 40.49257098503543}, {4398, 39.526963187820655}, {4399, 39.39632170400282},
	{4400, 38.65146414419247}, {4401, 38.69622195198017}, {4402, 38.82824084957831}, {4403, 38.35894467631948}, {4404, 38.374288310893164}, {4405, 38.30201987865161}, {4406, 39.040498102853704}, {4407, 38.739032917012814}, {4408, 38.21513757304971}, {4409, 37.79412671670286},
	{4410, 37.572863184633725}, {4411, 36.71659398164643}, {4412, 36.9686014580944}, {4413, 36.61396796753844}, {4414, 36.21992527315708}, {4415, 36.544907354858005}, {4416, 36.94702029184928}, {4417, 37.040712123103496}, {4418, 37.86983316239789}, {4419, 37.9133259993023},
	{4420, 37.740462632345725}, {4421, 37.80334582875091}, {4422, 38.06669175124991}, {4423, 38.82569943174218}, {4424, 38.79645166307203}, {4425, 38.138183023387136}, {4426, 37.343389010610906}, {4427, 37.06893203484559}, {4428, 36.974042644355606}, {4429, 37.10878943344164},
	{4430, 36.92199614208741}, {4431, 36.31927104688222}, {4432, 36.318646750338225}, {4433, 35.93959392178788}, {4434, 35.957928276775064}, {4435, 36.57803220920125}, {4436, 36.48729877130802}, {4437, 36.08934258703699}, {4438, 35.92075815637091}, {4439, 35.97790853205448},
	{4440, 37.10428719217352}, {4441, 37.34763949569804}, {4442, 37.54555366814172}, {4443, 38.21664941647024}, {4444, 38.15910673215726}, {4445, 38.18389302943226}, {4446, 38.15032771707228}, {4447, 38.257644304614324}, {4448, 37.89935320642902}, {4449, 37.92806972052069},
	{4450, 38.44876254366418}, {4451, 38.39207298891007}, {4452, 37.688682446222174}, {4453, 37.5187537924215}, {4454, 37.51914139540737}, {4455, 37.09540108270616}, {4456, 37.73546306496036}, {4457, 37.81369411954859}, {4458, 36.83626164610845}, {4459, 36.93994071270752},
	{4460, 36.95018579100306}, {4461, 37.26709009753631}, {4462, 37.15237030254232}, {4463, 37.049394970609185}, {4464, 37.7162630971784}, {4465, 37.778299282663106}, {4466, 38.730315146387746}, {4467, 38.7451015147541}, {4468, 38.61705719495839}, {4469, 37.872865556491874},
	{4470, 37.89246439250997}, {4471, 38.16788956159939}, {4472, 37.860151832562025}, {4473, 37.73726372456453}, {4474, 37.69142767992998}, {4475, 37.63232006550031}, {4476, 37.423877674083585}, {4477, 37.4556569056629}, {4478, 37.96421499308509}, {4479, 37.81211863240172},
	{4480, 38.05702647753458}, {4481, 38.210884926434076}, {4482, 38.312564817548534}, {4483, 38.6074646961431}, {4484, 38.61409094278309}, {4485, 38.017765676373614}, {4486, 38.13255323384495}, {4487, 38.08371503820191}, {4488, 39.74784443380604}, {4489, 39.581076576624355},
	{4490, 39.560969587140264}, {4491, 39.633230280700445}, {4492, 39.4716793618942}, {4493, 39.85116292164824}, {4494, 40.13334579775557}, {4495, 40.63456793316489}, {4496, 40.71073257614338}, {4497, 40.614825837238605}, {4498, 40.52093195142476}, {4499, 40.625992282699016},
	{4500, 40.61279333802842}, {4501, 40.60312836705065}, {4502, 40.45124308705166}, {4503, 39.813179582460556}, {4504, 39.40056608371914}, {4505, 39.400036014144824}, {4506, 40.068292685250626}, {4507, 39.85851159258621}, {4508, 40.22426761068521}, {4509, 40.20179430857556},
	{4510, 40.195867059687664}, {4511, 40.17841644766825}, {4512, 40.33883934166413}, {4513, 40.43097043722167}, {4514, 39.97935686013634}, {4515, 40.35201602305827}, {4516, 40.362381301668016}, {4517, 41.646176394626345}, {4518, 41.090525592460445}, {4519, 40.79730768415044},
	{4520, 40.72921199361499}, {4521, 40.41889455210564}, {4522, 40.379424134550845}, {4523, 40.39436450202139}, {4524, 40.009568103338225}, {4525, 40.60519761105382}, {4526, 40.20213007918731}, {4527, 40.39015160569152}, {4528, 39.9454660982101}, {4529, 39.075001110176856},
	{4530, 39.13454982085495}, {4531, 39.648058502641085}, {4532, 39.648144119118776}, {4533, 39.324207361611386}, {4534, 39.53997526505957}, {4535, 39.97557044175399}, {4536, 40.26787350849}, {4537, 40.17369778686508}, {4538, 40.44006641312129}, {4539, 40.57083491561394},
	{4540, 40.66689326871952}, {4541, 40.65187955527909}, {4542, 39.934274637704824}, {4543, 40.300330136488476}, {4544, 39.967275063438045}, {4545, 40.042315039135865}, {4546, 40.142830573608606}, {4547, 40.061258001400915}, {4548, 40.404909259369646}, {4549, 40.450392865002364},
	{4550, 40.87269030449907}, {4551, 41.296599615123064}, {4552, 41.304588768416615}, {4553, 41.90167025496052}, {4554, 41.923025365981076}, {4555, 42.16170196977729}, {4556, 42.10361415553816}, {4557, 42.10129865988418}, {4558, 42.31197566235926}, {4559, 42.826247977993646},
	{4560, 42.74728359084352}, {4561, 42.667331833071664}, {4562, 42.928631961847074}, {4563, 43.00083178487252}, {4564, 43.37357490404957}, {4565, 43.2237675498371}, {4566, 43.86137004897719}, {4567, 43.98416288339857}, {4568, 44.0470084423368}, {4569, 44.11391700866567},
	{4570, 43.33351237600878}, {4571, 43.34757034996372}, {4572, 44.14608921239006}, {4573, 43.315144980691606}, {4574, 43.1647218607577}, {4575, 42.10202383999383}, {4576, 42.045575631273714}, {4577, 41.92172379039672}, {4578, 41.61112748037281}, {4579, 41.46655883593124},
	{4580, 42.135593115850845}, {4581, 42.28588201326873}, {4582, 42.15472962179464}, {4583, 41.752838975392386}, {4584, 41.91347248013341}, {4585, 41.92681361497359}, {4586, 41.9507666881852}, {4587, 41.90301229148557}, {4588, 41.95079936213436}, {4589, 42.01550498847925},
	{4590, 42.13012135355233}, {4591, 42.119576747364945}, {4592, 42.11677669401778}, {4593, 41.43172999572018}, {4594, 41.49388864519924}, {4595, 41.37380290015346}, {4596, 41.370035845679794}, {4597, 41.81317893158739}, {4598, 41.718756954520984}, {4599, 41.7298553763554},
	{4600, 41.53894095306525}, {4601, 41.75447883581544}, {4602, 41.885739012000045}, {4603, 42.06290639339678}, {4604, 42.01765532193647}, {4605, 42.09963693863422}, {4606, 42.121746882846026}, {4607, 42.40289053451183}, {4608, 42.43904810148321}, {4609, 42.073085450783054},
	{4610, 42.003884006662666}, {4611, 42.02391206710711}, {4612, 42.43143955801055}, {4613, 42.418444114505455}, {4614, 42.50130186535948}, {4615, 42.50861804985267}, {4616, 42.8667351445971}, {4617, 43.2708291680743}, {4618, 43.258875230182355}, {4619, 43.41983125615069},
	{4620, 43.02540169744918}, {4621, 43.03671781336059}, {4622, 43.51115813355301}, {4623, 43.620694664026104}, {4624, 44.28128377598449}, {4625, 45.28965233946238}, {4626, 45.984997240186246}, {4627, 45.98395822876192}, {4628, 46.06556368008116}, {4629, 45.196081738035325},
	{4630, 44.651596037353286}, {4631, 45.8360412664365}, {4632, 45.030975374089174}, {4633, 45.34523081375098}, {4634, 45.516897796124226}, {4635, 45.41290103045353}, {4636, 45.783086761335824}, {4637, 45.729375501632695}, {4638, 46.30543062423142}, {4639, 46.97672701088541},
	{4640, 46.47744540724059}, {4641, 46.43460283813155}, {4642, 46.176535515295534}, {4643, 46.1267773587671}, {4644, 46.07078753090914}, {4645, 45.90463206174146}, {4646, 45.55249821676164}, {4647, 46.10452178892155}, {4648, 46.657238306997954}, {4649, 46.676446405868745},
	{4650, 46.61931105547808}, {4651, 46.75145539959066}, {4652, 47.15614626698322}, {4653, 47.87910231233235}, {4654, 47.90315790426083}, {4655, 48.13748706690984}, {4656, 48.14012518669324}, {4657, 48.12478834534791}, {4658, 47.721710829839914}, {4659, 47.75882142791673},
	{4660, 48.62175299672685}, {4661, 49.44973560609625}, {4662, 49.45655590836775}, {4663, 49.467384079074314}, {4664, 49.36632082510971}, {4665, 49.361539089859946}, {4666, 48.923792508100405}, {4667, 48.82936960309324}, {4668, 48.696827533051106}, {4669, 49.021992536039356},
	{4670, 48.88792946529902}, {4671, 49.049698787091685}, {4672, 49.08423254107231}, {4673, 48.92829127058939}, {4674, 48.38289408354073}, {4675, 48.92579198716452}, {4676, 48.49132529951036}, {4677, 48.54115658361094}, {4678, 48.22070675260601}, {4679, 47.92838519785814},
	{4680, 47.732252711009075}, {4681, 45.99113534110142}, {4682, 44.72899549055614}, {4683, 44.55687451719093}, {4684, 44.55628471776198}, {4685, 44.44930616361875}, {4686, 44.69514501843518}, {4687, 44.08997798757562}, {4688, 44.326776424034165}, {4689, 44.5246373562509},
	{4690, 44.77024206609575}, {4691, 44.41279660589304}, {4692, 44.29090624408688}, {4693, 43.49452874948875}, {4694, 43.31906915186023}, {4695, 42.936317507114055}, {4696, 42.887727362033345}, {4697, 42.05490971051252}, {4698, 42.14072479814179}, {4699, 40.804558836186786},
	{4700, 41.48316460835661}, {4701, 41.52072176780903}, {4702, 41.5348100852975}, {4703, 41.75692669456157}, {4704, 41.49643711525131}, {4705, 42.35954965911466}, {4706, 42.254443486387316}, {4707, 42.346428230827634}, {4708, 42.26152211995296}, {4709, 42.978169988498536},
	{4710, 42.523208465380144}, {4711, 42.92136840228886}, {4712, 42.491877240874906}, {4713, 42.43808793916936}, {4714, 42.31386731961688}, {4715, 42.40503671098323}, {4716, 41.51956996493458}, {4717, 41.51666400077679}, {4718, 41.47426644424032}, {4719, 41.642970570173034},
	{4720, 41.62187072416654}, {4721, 41.15180912858265}, {4722, 41.894760156551904}, {4723, 42.092594714290364}, {4724, 42.27635546119988}, {4725, 42.69832068724076}, {4726, 42.980504524777594}, {4727, 45.87658310035213}, {4728, 43.6183451512828}, {4729, 43.92197152986545},
	{4730, 43.97403155795249}, {4731, 43.83776224600831}, {4732, 44.01998787494774}, {4733, 43.74137827823208}, {4734, 43.51842058845427}, {4735, 43.28245959362667}, {4736, 42.931398042043796}, {4737, 42.81785284737095}, {4738, 43.3507423739577}, {4739, 42.53626377548142},
	{4740, 43.32318432190919}, {4741, 44.1194336467924}, {4742, 44.256900789761175}, {4743, 44.471678262389915}, {4744, 44.52826323886761}, {4745, 44.28324388592612}, {4746, 44.23885158768107}, {4747, 44.118008732018836}, {4748, 44.126076154771745}, {4749, 43.920419005974225},
	{4750, 43.47296751071649}, {4751, 43.54310189974708}, {4752, 43.53066942512155}, {4753, 44.49097326057114}, {4754, 44.60107183314088}, {4755, 42.77090560264186}, {4756, 42.99334677650617}, {4757, 42.929199954491246}, {4758, 42.4663653797701}, {4759, 42.63510417353381},
	{4760, 41.15252150405892}, {4761, 41.65062666173321}, {4762, 41.63569595747878}, {4763, 41.80167602812174}, {4764, 41.54305663974481}, {4765, 41.09851635788159}, {4766, 40.44563966701578}, {4767, 40.533880450251715}, {4768, 40.8690019227734}, {4769, 40.88937124246862},
	{4770, 41.183809565163905}, {4771, 41.23702889676266}, {4772, 41.98448907911279}, {4773, 41.95032094100293}, {4774, 41.831147917269575}, {4775, 41.61384516565436}, {4776, 41.337855349523466}, {4777, 41.31691388756026}, {4778, 41.00824360651651}, {4779, 40.66303052923502},
	{4780, 40.75233960523218}, {4781, 40.74691723991323}, {4782, 41.224220277952135}, {4783, 41.24176898114373}, {4784, 41.19227291002064}, {4785, 41.455618057185966}, {4786, 41.793314227583664}, {4787, 41.169085632598424}, {4788, 41.147687532911064}, {4789, 41.308688926534245},
	{4790, 41.159786924004884}, {4791, 41.8142881123724}, {4792, 41.552546791536315}, {4793, 41.63707209178867}, {4794, 41.36580909924643}, {4795, 40.810470695252555}, {4796, 40.90861666010221}, {4797, 40.9449761604474}, {4798, 41.15181950532048}, {4799, 41.13789218005914},
	{4800, 41.08509141277718}, {4801, 41.05365891335565}, {4802, 40.980911652896054}, {4803, 41.734203454889105}, {4804, 41.31916007992194}, {4805, 41.4215682147432}, {4806, 41.51414417468774}, {4807, 42.37111482324612}, {4808, 42.70943804743709}, {4809, 42.666757607996296},
	{4810, 42.12147053040958}, {4811, 42.464100810348334}, {4812, 42.62139441696377}, {4813, 41.94637435030276}, {4814, 41.99684563449916}, {4815, 42.54816794861336}, {4816, 42.28223265087694}, {4817, 42.24550930900591}, {4818, 42.282491306075286}, {4819, 42.58423495563741},
	{4820, 41.359861111288104}, {4821, 42.10481353702761}, {4822, 42.24941093960088}, {4823, 41.19941990664588}, {4824, 41.21364184446058}, {4825, 41.72506184259513}, {4826, 42.53601771160175}, {4827, 42.67420054464686}, {4828, 42.76426057329836}, {4829, 42.78798548069922},
	{4830, 42.76148923124109}, {4831, 43.55500018064631}, {4832, 43.52818564137662}, {4833, 43.71030227628026}, {4834, 43.69559859751488}, {4835, 42.75390903216747}, {4836, 42.95452875778498}, {4837, 43.365066775687346}, {4838, 43.36814790382736}, {4839, 43.89333739845817},
	{4840, 43.989916759215}, {4841, 43.56253598246386}, {4842, 43.377743454747105}, {4843, 42.924400615882426}, {4844, 43.12304670119044}, {4845, 42.58288520924721}, {4846, 42.6192440085378}, {4847, 42.65060540788467}, {4848, 42.41222623035344}, {4849, 41.646360968682984},
	{4850, 41.424134917273825}, {4851, 41.10868413269653}, {4852, 41.172396017699}, {4853, 41.36004588804885}, {4854, 40.800077988280925}, {4855, 40.86912290176179}, {4856, 39.88125368753376}, {4857, 40.413562336579986}, {4858, 40.30739366800392}, {4859, 40.4448665834484},
	{4860, 40.67992036846289}, {4861, 39.19323041879348}, {4862, 38.934776988261994}, {4863, 38.6635282389286}, {4864, 38.018950718551935}, {4865, 38.04674518139207}, {4866, 38.01853292656019}, {4867, 37.71021607139222}, {4868, 38.422846767406455}, {4869, 38.450019969893354},
	{4870, 38.3997470792123}, {4871, 38.34361998177123}, {4872, 39.091980399463395}, {4873, 39.5198852558182}, {4874, 39.5472385581927}, {4875, 39.52236007766908}, {4876, 39.37969949452826}, {4877, 40.222868236832014}, {4878, 39.66661286220836}, {4879, 40.283042854444616},
	{4880, 40.229716416585205}, {4881, 40.445190873458}, {4882, 41.20372788803875}, {4883, 41.40919784184403}, {4884, 41.40205136110032}, {4885, 41.489596657482274}, {4886, 41.63320805924114}, {4887, 41.74501472339082}, {4888, 41.59463339227347}, {4889, 41.89165418164628},
	{4890, 42.429906756721266}, {4891, 42.51566334270849}, {4892, 42.43112651097444}, {4893, 42.65573412390896}, {4894, 42.5649774287204}, {4895, 42.20578627338075}, {4896, 42.19905186404266}, {4897, 42.063060621486514}, {4898, 40.8631606909062}, {4899, 41.4015851042295},
	{4900, 40.88944459737443}, {4901, 41.365721619037295}, {4902, 40.08190763242786}, {4903, 40.11091422145917}, {4904, 40.97087104137605}, {4905, 41.15805729486192}, {4906, 41.27896864220977}, {4907, 41.170130110377485}, {4908, 41.019095916064586}, {4909, 41.19823454109512},
	{4910, 40.71222352487721}, {4911, 40.604096585580145}, {4912, 40.22428726447587}, {4913, 38.86084836942058}, {4914, 38.70041746310922}, {4915, 38.8194506164692}, {4916, 38.64467182897344}, {4917, 38.639870243656844}, {4918, 38.929014450694986}, {4919, 38.80087908949201},
	{4920, 38.474735694735124}, {4921, 38.66300047873025}, {4922, 38.684455038039566}, {4923, 38.29265621342109}, {4924, 38.49017410077791}, {4925, 38.88748571310341}, {4926, 39.34561928924596}, {4927, 39.41078759839496}, {4928, 39.753432401888055}, {4929, 39.66725496587569},
	{4930, 39.64503039721447}, {4931, 39.74434633216348}, {4932, 39.24422485817575}, {4933, 39.357176347703124}, {4934, 39.083868743073175}, {4935, 38.77958154299146}, {4936, 38.784739437051876}, {4937, 38.84416930772779}, {4938, 38.531983904133995}, {4939, 38.13839982421345},
	{4940, 38.19834116299139}, {4941, 38.384878790359856}, {4942, 37.41788048991505}, {4943, 38.32825078053794}, {4944, 37.27571543485687}, {4945, 37.381643210593964}, {4946, 37.139400383368596}, {4947, 37.686425234248986}, {4948, 37.603432975092}, {4949, 37.64359097418195},
	{4950, 37.23329232367846}, {4951, 36.994849462220934}, {4952, 36.826705097979186}, {4953, 36.10850429296769}, {4954, 36.10515278531009}, {4955, 36.27585866868438}, {4956, 35.877106950223286}, {4957, 35.06902417472288}, {4958, 35.68954496717155}, {4959, 34.429975016070486},
	{4960, 33.9039081124664}, {4961, 34.50994734260132}, {4962, 34.24726508634311}, {4963, 34.27196566995411}, {4964, 34.53854603237626}, {4965, 33.18029169046981}, {4966, 33.74849740086445}, {4967, 33.7660814446232}, {4968, 33.690731394344716}, {4969, 33.75687045286519},
	{4970, 33.94382441333488}, {4971, 33.56341790269826}, {4972, 33.64387610469928}, {4973, 33.603199106999526}, {4974, 33.55490176741914}, {4975, 33.76379562158691}, {4976, 33.76315401597445}, {4977, 32.8267558087521}, {4978, 32.45241276131267}, {4979, 32.55733463964615},
	{4980, 33.319801723754786}, {4981, 33.59341126615778}, {4982, 33.73081923269426}, {4983, 34.37346764688176}, {4984, 35.07176548766099}, {4985, 35.37591959109057}, {4986, 35.471233571041964}, {4987, 35.13016122517179}, {4988, 34.65099719562258}, {4989, 34.37111074112498},
	{4990, 34.51523331821902}, {4991, 34.357189444832144}, {4992, 34.36407537164143}, {4993, 34.34124435265085}, {4994, 34.71701325993874}, {4995, 34.535111124444725}, {4996, 34.12819607955428}, {4997, 33.476805201968794}, {4998, 33.21364571883214}, {4999, 34.07622604782128},
}

func BenchmarkLTTB(b *testing.B) {
	for i := 0; i < b.N; i++ {
		LTTB(data, 1000)
	}
}
