// SPDX-License-Identifier: Apache-2.0 OR MIT OR Unlicense

// Code auto-generated by piet-gpu-derive

struct AnnoFillRef {
    uint offset;
};

struct AnnoFillImageRef {
    uint offset;
};

struct AnnoStrokeRef {
    uint offset;
};

struct AnnoClipRef {
    uint offset;
};

struct AnnotatedRef {
    uint offset;
};

struct AnnoFill {
    vec4 bbox;
    uint rgba_color;
};

#define AnnoFill_size 20

AnnoFillRef AnnoFill_index(AnnoFillRef ref, uint index) {
    return AnnoFillRef(ref.offset + index * AnnoFill_size);
}

struct AnnoFillImage {
    vec4 bbox;
    uint index;
    ivec2 offset;
};

#define AnnoFillImage_size 24

AnnoFillImageRef AnnoFillImage_index(AnnoFillImageRef ref, uint index) {
    return AnnoFillImageRef(ref.offset + index * AnnoFillImage_size);
}

struct AnnoStroke {
    vec4 bbox;
    uint rgba_color;
    float linewidth;
};

#define AnnoStroke_size 24

AnnoStrokeRef AnnoStroke_index(AnnoStrokeRef ref, uint index) {
    return AnnoStrokeRef(ref.offset + index * AnnoStroke_size);
}

struct AnnoClip {
    vec4 bbox;
};

#define AnnoClip_size 16

AnnoClipRef AnnoClip_index(AnnoClipRef ref, uint index) {
    return AnnoClipRef(ref.offset + index * AnnoClip_size);
}

#define Annotated_Nop 0
#define Annotated_Stroke 1
#define Annotated_Fill 2
#define Annotated_FillImage 3
#define Annotated_BeginClip 4
#define Annotated_EndClip 5
#define Annotated_size 28

AnnotatedRef Annotated_index(AnnotatedRef ref, uint index) {
    return AnnotatedRef(ref.offset + index * Annotated_size);
}

AnnoFill AnnoFill_read(Alloc a, AnnoFillRef ref) {
    uint ix = ref.offset >> 2;
    uint raw0 = read_mem(a, ix + 0);
    uint raw1 = read_mem(a, ix + 1);
    uint raw2 = read_mem(a, ix + 2);
    uint raw3 = read_mem(a, ix + 3);
    uint raw4 = read_mem(a, ix + 4);
    AnnoFill s;
    s.bbox = vec4(uintBitsToFloat(raw0), uintBitsToFloat(raw1), uintBitsToFloat(raw2), uintBitsToFloat(raw3));
    s.rgba_color = raw4;
    return s;
}

void AnnoFill_write(Alloc a, AnnoFillRef ref, AnnoFill s) {
    uint ix = ref.offset >> 2;
    write_mem(a, ix + 0, floatBitsToUint(s.bbox.x));
    write_mem(a, ix + 1, floatBitsToUint(s.bbox.y));
    write_mem(a, ix + 2, floatBitsToUint(s.bbox.z));
    write_mem(a, ix + 3, floatBitsToUint(s.bbox.w));
    write_mem(a, ix + 4, s.rgba_color);
}

AnnoFillImage AnnoFillImage_read(Alloc a, AnnoFillImageRef ref) {
    uint ix = ref.offset >> 2;
    uint raw0 = read_mem(a, ix + 0);
    uint raw1 = read_mem(a, ix + 1);
    uint raw2 = read_mem(a, ix + 2);
    uint raw3 = read_mem(a, ix + 3);
    uint raw4 = read_mem(a, ix + 4);
    uint raw5 = read_mem(a, ix + 5);
    AnnoFillImage s;
    s.bbox = vec4(uintBitsToFloat(raw0), uintBitsToFloat(raw1), uintBitsToFloat(raw2), uintBitsToFloat(raw3));
    s.index = raw4;
    s.offset = ivec2(int(raw5 << 16) >> 16, int(raw5) >> 16);
    return s;
}

void AnnoFillImage_write(Alloc a, AnnoFillImageRef ref, AnnoFillImage s) {
    uint ix = ref.offset >> 2;
    write_mem(a, ix + 0, floatBitsToUint(s.bbox.x));
    write_mem(a, ix + 1, floatBitsToUint(s.bbox.y));
    write_mem(a, ix + 2, floatBitsToUint(s.bbox.z));
    write_mem(a, ix + 3, floatBitsToUint(s.bbox.w));
    write_mem(a, ix + 4, s.index);
    write_mem(a, ix + 5, (uint(s.offset.x) & 0xffff) | (uint(s.offset.y) << 16));
}

AnnoStroke AnnoStroke_read(Alloc a, AnnoStrokeRef ref) {
    uint ix = ref.offset >> 2;
    uint raw0 = read_mem(a, ix + 0);
    uint raw1 = read_mem(a, ix + 1);
    uint raw2 = read_mem(a, ix + 2);
    uint raw3 = read_mem(a, ix + 3);
    uint raw4 = read_mem(a, ix + 4);
    uint raw5 = read_mem(a, ix + 5);
    AnnoStroke s;
    s.bbox = vec4(uintBitsToFloat(raw0), uintBitsToFloat(raw1), uintBitsToFloat(raw2), uintBitsToFloat(raw3));
    s.rgba_color = raw4;
    s.linewidth = uintBitsToFloat(raw5);
    return s;
}

void AnnoStroke_write(Alloc a, AnnoStrokeRef ref, AnnoStroke s) {
    uint ix = ref.offset >> 2;
    write_mem(a, ix + 0, floatBitsToUint(s.bbox.x));
    write_mem(a, ix + 1, floatBitsToUint(s.bbox.y));
    write_mem(a, ix + 2, floatBitsToUint(s.bbox.z));
    write_mem(a, ix + 3, floatBitsToUint(s.bbox.w));
    write_mem(a, ix + 4, s.rgba_color);
    write_mem(a, ix + 5, floatBitsToUint(s.linewidth));
}

AnnoClip AnnoClip_read(Alloc a, AnnoClipRef ref) {
    uint ix = ref.offset >> 2;
    uint raw0 = read_mem(a, ix + 0);
    uint raw1 = read_mem(a, ix + 1);
    uint raw2 = read_mem(a, ix + 2);
    uint raw3 = read_mem(a, ix + 3);
    AnnoClip s;
    s.bbox = vec4(uintBitsToFloat(raw0), uintBitsToFloat(raw1), uintBitsToFloat(raw2), uintBitsToFloat(raw3));
    return s;
}

void AnnoClip_write(Alloc a, AnnoClipRef ref, AnnoClip s) {
    uint ix = ref.offset >> 2;
    write_mem(a, ix + 0, floatBitsToUint(s.bbox.x));
    write_mem(a, ix + 1, floatBitsToUint(s.bbox.y));
    write_mem(a, ix + 2, floatBitsToUint(s.bbox.z));
    write_mem(a, ix + 3, floatBitsToUint(s.bbox.w));
}

uint Annotated_tag(Alloc a, AnnotatedRef ref) {
    return read_mem(a, ref.offset >> 2);
}

AnnoStroke Annotated_Stroke_read(Alloc a, AnnotatedRef ref) {
    return AnnoStroke_read(a, AnnoStrokeRef(ref.offset + 4));
}

AnnoFill Annotated_Fill_read(Alloc a, AnnotatedRef ref) {
    return AnnoFill_read(a, AnnoFillRef(ref.offset + 4));
}

AnnoFillImage Annotated_FillImage_read(Alloc a, AnnotatedRef ref) {
    return AnnoFillImage_read(a, AnnoFillImageRef(ref.offset + 4));
}

AnnoClip Annotated_BeginClip_read(Alloc a, AnnotatedRef ref) {
    return AnnoClip_read(a, AnnoClipRef(ref.offset + 4));
}

AnnoClip Annotated_EndClip_read(Alloc a, AnnotatedRef ref) {
    return AnnoClip_read(a, AnnoClipRef(ref.offset + 4));
}

void Annotated_Nop_write(Alloc a, AnnotatedRef ref) {
    write_mem(a, ref.offset >> 2, Annotated_Nop);
}

void Annotated_Stroke_write(Alloc a, AnnotatedRef ref, AnnoStroke s) {
    write_mem(a, ref.offset >> 2, Annotated_Stroke);
    AnnoStroke_write(a, AnnoStrokeRef(ref.offset + 4), s);
}

void Annotated_Fill_write(Alloc a, AnnotatedRef ref, AnnoFill s) {
    write_mem(a, ref.offset >> 2, Annotated_Fill);
    AnnoFill_write(a, AnnoFillRef(ref.offset + 4), s);
}

void Annotated_FillImage_write(Alloc a, AnnotatedRef ref, AnnoFillImage s) {
    write_mem(a, ref.offset >> 2, Annotated_FillImage);
    AnnoFillImage_write(a, AnnoFillImageRef(ref.offset + 4), s);
}

void Annotated_BeginClip_write(Alloc a, AnnotatedRef ref, AnnoClip s) {
    write_mem(a, ref.offset >> 2, Annotated_BeginClip);
    AnnoClip_write(a, AnnoClipRef(ref.offset + 4), s);
}

void Annotated_EndClip_write(Alloc a, AnnotatedRef ref, AnnoClip s) {
    write_mem(a, ref.offset >> 2, Annotated_EndClip);
    AnnoClip_write(a, AnnoClipRef(ref.offset + 4), s);
}

