// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/aiplatform/v1beta1/schema/trainingjob/definition/automl_tables.proto

package definition

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A TrainingJob that trains and uploads an AutoML Tables Model.
type AutoMlTables struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The input parameters of this TrainingJob.
	Inputs *AutoMlTablesInputs `protobuf:"bytes,1,opt,name=inputs,proto3" json:"inputs,omitempty"`
	// The metadata information.
	Metadata *AutoMlTablesMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *AutoMlTables) Reset() {
	*x = AutoMlTables{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlTables) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlTables) ProtoMessage() {}

func (x *AutoMlTables) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlTables.ProtoReflect.Descriptor instead.
func (*AutoMlTables) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDescGZIP(), []int{0}
}

func (x *AutoMlTables) GetInputs() *AutoMlTablesInputs {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *AutoMlTables) GetMetadata() *AutoMlTablesMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

type AutoMlTablesInputs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Additional optimization objective configuration. Required for
	// `maximize-precision-at-recall` and `maximize-recall-at-precision`,
	// otherwise unused.
	//
	// Types that are assignable to AdditionalOptimizationObjectiveConfig:
	//	*AutoMlTablesInputs_OptimizationObjectiveRecallValue
	//	*AutoMlTablesInputs_OptimizationObjectivePrecisionValue
	AdditionalOptimizationObjectiveConfig isAutoMlTablesInputs_AdditionalOptimizationObjectiveConfig `protobuf_oneof:"additional_optimization_objective_config"`
	// The type of prediction the Model is to produce.
	//   "classification" - Predict one out of multiple target values is
	//                      picked for each row.
	//   "regression" - Predict a value based on its relation to other values.
	//                  This type is available only to columns that contain
	//                  semantically numeric values, i.e. integers or floating
	//                  point number, even if stored as e.g. strings.
	PredictionType string `protobuf:"bytes,1,opt,name=prediction_type,json=predictionType,proto3" json:"prediction_type,omitempty"`
	// The column name of the target column that the model is to predict.
	TargetColumn string `protobuf:"bytes,2,opt,name=target_column,json=targetColumn,proto3" json:"target_column,omitempty"`
	// Each transformation will apply transform function to given input column.
	// And the result will be used for training.
	// When creating transformation for BigQuery Struct column, the column should
	// be flattened using "." as the delimiter.
	Transformations []*AutoMlTablesInputs_Transformation `protobuf:"bytes,3,rep,name=transformations,proto3" json:"transformations,omitempty"`
	// Objective function the model is optimizing towards. The training process
	// creates a model that maximizes/minimizes the value of the objective
	// function over the validation set.
	//
	// The supported optimization objectives depend on the prediction type.
	// If the field is not set, a default objective function is used.
	//
	// classification (binary):
	//   "maximize-au-roc" (default) - Maximize the area under the receiver
	//                                 operating characteristic (ROC) curve.
	//   "minimize-log-loss" - Minimize log loss.
	//   "maximize-au-prc" - Maximize the area under the precision-recall curve.
	//   "maximize-precision-at-recall" - Maximize precision for a specified
	//                                   recall value.
	//   "maximize-recall-at-precision" - Maximize recall for a specified
	//                                    precision value.
	//
	// classification (multi-class):
	//   "minimize-log-loss" (default) - Minimize log loss.
	//
	// regression:
	//   "minimize-rmse" (default) - Minimize root-mean-squared error (RMSE).
	//   "minimize-mae" - Minimize mean-absolute error (MAE).
	//   "minimize-rmsle" - Minimize root-mean-squared log error (RMSLE).
	OptimizationObjective string `protobuf:"bytes,4,opt,name=optimization_objective,json=optimizationObjective,proto3" json:"optimization_objective,omitempty"`
	// Required. The train budget of creating this model, expressed in milli node
	// hours i.e. 1,000 value in this field means 1 node hour.
	//
	// The training cost of the model will not exceed this budget. The final cost
	// will be attempted to be close to the budget, though may end up being (even)
	// noticeably smaller - at the backend's discretion. This especially may
	// happen when further model training ceases to provide any improvements.
	//
	// If the budget is set to a value known to be insufficient to train a
	// model for the given dataset, the training won't be attempted and
	// will error.
	//
	// The train budget must be between 1,000 and 72,000 milli node hours,
	// inclusive.
	TrainBudgetMilliNodeHours int64 `protobuf:"varint,7,opt,name=train_budget_milli_node_hours,json=trainBudgetMilliNodeHours,proto3" json:"train_budget_milli_node_hours,omitempty"`
	// Use the entire training budget. This disables the early stopping feature.
	// By default, the early stopping feature is enabled, which means that AutoML
	// Tables might stop training before the entire training budget has been used.
	DisableEarlyStopping bool `protobuf:"varint,8,opt,name=disable_early_stopping,json=disableEarlyStopping,proto3" json:"disable_early_stopping,omitempty"`
	// Column name that should be used as the weight column.
	// Higher values in this column give more importance to the row
	// during model training. The column must have numeric values between 0 and
	// 10000 inclusively; 0 means the row is ignored for training. If weight
	// column field is not set, then all rows are assumed to have equal weight
	// of 1.
	WeightColumnName string `protobuf:"bytes,9,opt,name=weight_column_name,json=weightColumnName,proto3" json:"weight_column_name,omitempty"`
	// Configuration for exporting test set predictions to a BigQuery table. If
	// this configuration is absent, then the export is not performed.
	ExportEvaluatedDataItemsConfig *ExportEvaluatedDataItemsConfig `protobuf:"bytes,10,opt,name=export_evaluated_data_items_config,json=exportEvaluatedDataItemsConfig,proto3" json:"export_evaluated_data_items_config,omitempty"`
}

func (x *AutoMlTablesInputs) Reset() {
	*x = AutoMlTablesInputs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlTablesInputs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlTablesInputs) ProtoMessage() {}

func (x *AutoMlTablesInputs) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlTablesInputs.ProtoReflect.Descriptor instead.
func (*AutoMlTablesInputs) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDescGZIP(), []int{1}
}

func (m *AutoMlTablesInputs) GetAdditionalOptimizationObjectiveConfig() isAutoMlTablesInputs_AdditionalOptimizationObjectiveConfig {
	if m != nil {
		return m.AdditionalOptimizationObjectiveConfig
	}
	return nil
}

func (x *AutoMlTablesInputs) GetOptimizationObjectiveRecallValue() float32 {
	if x, ok := x.GetAdditionalOptimizationObjectiveConfig().(*AutoMlTablesInputs_OptimizationObjectiveRecallValue); ok {
		return x.OptimizationObjectiveRecallValue
	}
	return 0
}

func (x *AutoMlTablesInputs) GetOptimizationObjectivePrecisionValue() float32 {
	if x, ok := x.GetAdditionalOptimizationObjectiveConfig().(*AutoMlTablesInputs_OptimizationObjectivePrecisionValue); ok {
		return x.OptimizationObjectivePrecisionValue
	}
	return 0
}

func (x *AutoMlTablesInputs) GetPredictionType() string {
	if x != nil {
		return x.PredictionType
	}
	return ""
}

func (x *AutoMlTablesInputs) GetTargetColumn() string {
	if x != nil {
		return x.TargetColumn
	}
	return ""
}

func (x *AutoMlTablesInputs) GetTransformations() []*AutoMlTablesInputs_Transformation {
	if x != nil {
		return x.Transformations
	}
	return nil
}

func (x *AutoMlTablesInputs) GetOptimizationObjective() string {
	if x != nil {
		return x.OptimizationObjective
	}
	return ""
}

func (x *AutoMlTablesInputs) GetTrainBudgetMilliNodeHours() int64 {
	if x != nil {
		return x.TrainBudgetMilliNodeHours
	}
	return 0
}

func (x *AutoMlTablesInputs) GetDisableEarlyStopping() bool {
	if x != nil {
		return x.DisableEarlyStopping
	}
	return false
}

func (x *AutoMlTablesInputs) GetWeightColumnName() string {
	if x != nil {
		return x.WeightColumnName
	}
	return ""
}

func (x *AutoMlTablesInputs) GetExportEvaluatedDataItemsConfig() *ExportEvaluatedDataItemsConfig {
	if x != nil {
		return x.ExportEvaluatedDataItemsConfig
	}
	return nil
}

type isAutoMlTablesInputs_AdditionalOptimizationObjectiveConfig interface {
	isAutoMlTablesInputs_AdditionalOptimizationObjectiveConfig()
}

type AutoMlTablesInputs_OptimizationObjectiveRecallValue struct {
	// Required when optimization_objective is "maximize-precision-at-recall".
	// Must be between 0 and 1, inclusive.
	OptimizationObjectiveRecallValue float32 `protobuf:"fixed32,5,opt,name=optimization_objective_recall_value,json=optimizationObjectiveRecallValue,proto3,oneof"`
}

type AutoMlTablesInputs_OptimizationObjectivePrecisionValue struct {
	// Required when optimization_objective is "maximize-recall-at-precision".
	// Must be between 0 and 1, inclusive.
	OptimizationObjectivePrecisionValue float32 `protobuf:"fixed32,6,opt,name=optimization_objective_precision_value,json=optimizationObjectivePrecisionValue,proto3,oneof"`
}

func (*AutoMlTablesInputs_OptimizationObjectiveRecallValue) isAutoMlTablesInputs_AdditionalOptimizationObjectiveConfig() {
}

func (*AutoMlTablesInputs_OptimizationObjectivePrecisionValue) isAutoMlTablesInputs_AdditionalOptimizationObjectiveConfig() {
}

// Model metadata specific to AutoML Tables.
type AutoMlTablesMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The actual training cost of the model, expressed in milli
	// node hours, i.e. 1,000 value in this field means 1 node hour. Guaranteed
	// to not exceed the train budget.
	TrainCostMilliNodeHours int64 `protobuf:"varint,1,opt,name=train_cost_milli_node_hours,json=trainCostMilliNodeHours,proto3" json:"train_cost_milli_node_hours,omitempty"`
}

func (x *AutoMlTablesMetadata) Reset() {
	*x = AutoMlTablesMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlTablesMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlTablesMetadata) ProtoMessage() {}

func (x *AutoMlTablesMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlTablesMetadata.ProtoReflect.Descriptor instead.
func (*AutoMlTablesMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDescGZIP(), []int{2}
}

func (x *AutoMlTablesMetadata) GetTrainCostMilliNodeHours() int64 {
	if x != nil {
		return x.TrainCostMilliNodeHours
	}
	return 0
}

type AutoMlTablesInputs_Transformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The transformation that the training pipeline will apply to the input
	// columns.
	//
	// Types that are assignable to TransformationDetail:
	//	*AutoMlTablesInputs_Transformation_Auto
	//	*AutoMlTablesInputs_Transformation_Numeric
	//	*AutoMlTablesInputs_Transformation_Categorical
	//	*AutoMlTablesInputs_Transformation_Timestamp
	//	*AutoMlTablesInputs_Transformation_Text
	//	*AutoMlTablesInputs_Transformation_RepeatedNumeric
	//	*AutoMlTablesInputs_Transformation_RepeatedCategorical
	//	*AutoMlTablesInputs_Transformation_RepeatedText
	TransformationDetail isAutoMlTablesInputs_Transformation_TransformationDetail `protobuf_oneof:"transformation_detail"`
}

func (x *AutoMlTablesInputs_Transformation) Reset() {
	*x = AutoMlTablesInputs_Transformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlTablesInputs_Transformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlTablesInputs_Transformation) ProtoMessage() {}

func (x *AutoMlTablesInputs_Transformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlTablesInputs_Transformation.ProtoReflect.Descriptor instead.
func (*AutoMlTablesInputs_Transformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDescGZIP(), []int{1, 0}
}

func (m *AutoMlTablesInputs_Transformation) GetTransformationDetail() isAutoMlTablesInputs_Transformation_TransformationDetail {
	if m != nil {
		return m.TransformationDetail
	}
	return nil
}

func (x *AutoMlTablesInputs_Transformation) GetAuto() *AutoMlTablesInputs_Transformation_AutoTransformation {
	if x, ok := x.GetTransformationDetail().(*AutoMlTablesInputs_Transformation_Auto); ok {
		return x.Auto
	}
	return nil
}

func (x *AutoMlTablesInputs_Transformation) GetNumeric() *AutoMlTablesInputs_Transformation_NumericTransformation {
	if x, ok := x.GetTransformationDetail().(*AutoMlTablesInputs_Transformation_Numeric); ok {
		return x.Numeric
	}
	return nil
}

func (x *AutoMlTablesInputs_Transformation) GetCategorical() *AutoMlTablesInputs_Transformation_CategoricalTransformation {
	if x, ok := x.GetTransformationDetail().(*AutoMlTablesInputs_Transformation_Categorical); ok {
		return x.Categorical
	}
	return nil
}

func (x *AutoMlTablesInputs_Transformation) GetTimestamp() *AutoMlTablesInputs_Transformation_TimestampTransformation {
	if x, ok := x.GetTransformationDetail().(*AutoMlTablesInputs_Transformation_Timestamp); ok {
		return x.Timestamp
	}
	return nil
}

func (x *AutoMlTablesInputs_Transformation) GetText() *AutoMlTablesInputs_Transformation_TextTransformation {
	if x, ok := x.GetTransformationDetail().(*AutoMlTablesInputs_Transformation_Text); ok {
		return x.Text
	}
	return nil
}

func (x *AutoMlTablesInputs_Transformation) GetRepeatedNumeric() *AutoMlTablesInputs_Transformation_NumericArrayTransformation {
	if x, ok := x.GetTransformationDetail().(*AutoMlTablesInputs_Transformation_RepeatedNumeric); ok {
		return x.RepeatedNumeric
	}
	return nil
}

func (x *AutoMlTablesInputs_Transformation) GetRepeatedCategorical() *AutoMlTablesInputs_Transformation_CategoricalArrayTransformation {
	if x, ok := x.GetTransformationDetail().(*AutoMlTablesInputs_Transformation_RepeatedCategorical); ok {
		return x.RepeatedCategorical
	}
	return nil
}

func (x *AutoMlTablesInputs_Transformation) GetRepeatedText() *AutoMlTablesInputs_Transformation_TextArrayTransformation {
	if x, ok := x.GetTransformationDetail().(*AutoMlTablesInputs_Transformation_RepeatedText); ok {
		return x.RepeatedText
	}
	return nil
}

type isAutoMlTablesInputs_Transformation_TransformationDetail interface {
	isAutoMlTablesInputs_Transformation_TransformationDetail()
}

type AutoMlTablesInputs_Transformation_Auto struct {
	Auto *AutoMlTablesInputs_Transformation_AutoTransformation `protobuf:"bytes,1,opt,name=auto,proto3,oneof"`
}

type AutoMlTablesInputs_Transformation_Numeric struct {
	Numeric *AutoMlTablesInputs_Transformation_NumericTransformation `protobuf:"bytes,2,opt,name=numeric,proto3,oneof"`
}

type AutoMlTablesInputs_Transformation_Categorical struct {
	Categorical *AutoMlTablesInputs_Transformation_CategoricalTransformation `protobuf:"bytes,3,opt,name=categorical,proto3,oneof"`
}

type AutoMlTablesInputs_Transformation_Timestamp struct {
	Timestamp *AutoMlTablesInputs_Transformation_TimestampTransformation `protobuf:"bytes,4,opt,name=timestamp,proto3,oneof"`
}

type AutoMlTablesInputs_Transformation_Text struct {
	Text *AutoMlTablesInputs_Transformation_TextTransformation `protobuf:"bytes,5,opt,name=text,proto3,oneof"`
}

type AutoMlTablesInputs_Transformation_RepeatedNumeric struct {
	RepeatedNumeric *AutoMlTablesInputs_Transformation_NumericArrayTransformation `protobuf:"bytes,6,opt,name=repeated_numeric,json=repeatedNumeric,proto3,oneof"`
}

type AutoMlTablesInputs_Transformation_RepeatedCategorical struct {
	RepeatedCategorical *AutoMlTablesInputs_Transformation_CategoricalArrayTransformation `protobuf:"bytes,7,opt,name=repeated_categorical,json=repeatedCategorical,proto3,oneof"`
}

type AutoMlTablesInputs_Transformation_RepeatedText struct {
	RepeatedText *AutoMlTablesInputs_Transformation_TextArrayTransformation `protobuf:"bytes,8,opt,name=repeated_text,json=repeatedText,proto3,oneof"`
}

func (*AutoMlTablesInputs_Transformation_Auto) isAutoMlTablesInputs_Transformation_TransformationDetail() {
}

func (*AutoMlTablesInputs_Transformation_Numeric) isAutoMlTablesInputs_Transformation_TransformationDetail() {
}

func (*AutoMlTablesInputs_Transformation_Categorical) isAutoMlTablesInputs_Transformation_TransformationDetail() {
}

func (*AutoMlTablesInputs_Transformation_Timestamp) isAutoMlTablesInputs_Transformation_TransformationDetail() {
}

func (*AutoMlTablesInputs_Transformation_Text) isAutoMlTablesInputs_Transformation_TransformationDetail() {
}

func (*AutoMlTablesInputs_Transformation_RepeatedNumeric) isAutoMlTablesInputs_Transformation_TransformationDetail() {
}

func (*AutoMlTablesInputs_Transformation_RepeatedCategorical) isAutoMlTablesInputs_Transformation_TransformationDetail() {
}

func (*AutoMlTablesInputs_Transformation_RepeatedText) isAutoMlTablesInputs_Transformation_TransformationDetail() {
}

// Training pipeline will infer the proper transformation based on the
// statistic of dataset.
type AutoMlTablesInputs_Transformation_AutoTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
}

func (x *AutoMlTablesInputs_Transformation_AutoTransformation) Reset() {
	*x = AutoMlTablesInputs_Transformation_AutoTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlTablesInputs_Transformation_AutoTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlTablesInputs_Transformation_AutoTransformation) ProtoMessage() {}

func (x *AutoMlTablesInputs_Transformation_AutoTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlTablesInputs_Transformation_AutoTransformation.ProtoReflect.Descriptor instead.
func (*AutoMlTablesInputs_Transformation_AutoTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *AutoMlTablesInputs_Transformation_AutoTransformation) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

// Training pipeline will perform following transformation functions.
// *  The value converted to float32.
// *  The z_score of the value.
// *  log(value+1) when the value is greater than or equal to 0. Otherwise,
//    this transformation is not applied and the value is considered a
//    missing value.
// *  z_score of log(value+1) when the value is greater than or equal to 0.
//    Otherwise, this transformation is not applied and the value is
//    considered a missing value.
// *  A boolean value that indicates whether the value is valid.
type AutoMlTablesInputs_Transformation_NumericTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
	// If invalid values is allowed, the training pipeline will create a
	// boolean feature that indicated whether the value is valid.
	// Otherwise, the training pipeline will discard the input row from
	// trainining data.
	InvalidValuesAllowed bool `protobuf:"varint,2,opt,name=invalid_values_allowed,json=invalidValuesAllowed,proto3" json:"invalid_values_allowed,omitempty"`
}

func (x *AutoMlTablesInputs_Transformation_NumericTransformation) Reset() {
	*x = AutoMlTablesInputs_Transformation_NumericTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlTablesInputs_Transformation_NumericTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlTablesInputs_Transformation_NumericTransformation) ProtoMessage() {}

func (x *AutoMlTablesInputs_Transformation_NumericTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlTablesInputs_Transformation_NumericTransformation.ProtoReflect.Descriptor instead.
func (*AutoMlTablesInputs_Transformation_NumericTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDescGZIP(), []int{1, 0, 1}
}

func (x *AutoMlTablesInputs_Transformation_NumericTransformation) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

func (x *AutoMlTablesInputs_Transformation_NumericTransformation) GetInvalidValuesAllowed() bool {
	if x != nil {
		return x.InvalidValuesAllowed
	}
	return false
}

// Training pipeline will perform following transformation functions.
// *  The categorical string as is--no change to case, punctuation,
// spelling,
//    tense, and so on.
// *  Convert the category name to a dictionary lookup index and generate an
//    embedding for each index.
// *  Categories that appear less than 5 times in the training dataset are
//    treated as the "unknown" category. The "unknown" category gets its own
//    special lookup index and resulting embedding.
type AutoMlTablesInputs_Transformation_CategoricalTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
}

func (x *AutoMlTablesInputs_Transformation_CategoricalTransformation) Reset() {
	*x = AutoMlTablesInputs_Transformation_CategoricalTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlTablesInputs_Transformation_CategoricalTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlTablesInputs_Transformation_CategoricalTransformation) ProtoMessage() {}

func (x *AutoMlTablesInputs_Transformation_CategoricalTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlTablesInputs_Transformation_CategoricalTransformation.ProtoReflect.Descriptor instead.
func (*AutoMlTablesInputs_Transformation_CategoricalTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDescGZIP(), []int{1, 0, 2}
}

func (x *AutoMlTablesInputs_Transformation_CategoricalTransformation) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

// Training pipeline will perform following transformation functions.
// *  Apply the transformation functions for Numerical columns.
// *  Determine the year, month, day,and weekday. Treat each value from the
// *  timestamp as a Categorical column.
// *  Invalid numerical values (for example, values that fall outside of a
//    typical timestamp range, or are extreme values) receive no special
//    treatment and are not removed.
type AutoMlTablesInputs_Transformation_TimestampTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
	// The format in which that time field is expressed. The time_format must
	// either be one of:
	// * `unix-seconds`
	// * `unix-milliseconds`
	// * `unix-microseconds`
	// * `unix-nanoseconds`
	// (for respectively number of seconds, milliseconds, microseconds and
	// nanoseconds since start of the Unix epoch);
	// or be written in `strftime` syntax. If time_format is not set, then the
	// default format is RFC 3339 `date-time` format, where
	// `time-offset` = `"Z"` (e.g. 1985-04-12T23:20:50.52Z)
	TimeFormat string `protobuf:"bytes,2,opt,name=time_format,json=timeFormat,proto3" json:"time_format,omitempty"`
	// If invalid values is allowed, the training pipeline will create a
	// boolean feature that indicated whether the value is valid.
	// Otherwise, the training pipeline will discard the input row from
	// trainining data.
	InvalidValuesAllowed bool `protobuf:"varint,3,opt,name=invalid_values_allowed,json=invalidValuesAllowed,proto3" json:"invalid_values_allowed,omitempty"`
}

func (x *AutoMlTablesInputs_Transformation_TimestampTransformation) Reset() {
	*x = AutoMlTablesInputs_Transformation_TimestampTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlTablesInputs_Transformation_TimestampTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlTablesInputs_Transformation_TimestampTransformation) ProtoMessage() {}

func (x *AutoMlTablesInputs_Transformation_TimestampTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlTablesInputs_Transformation_TimestampTransformation.ProtoReflect.Descriptor instead.
func (*AutoMlTablesInputs_Transformation_TimestampTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDescGZIP(), []int{1, 0, 3}
}

func (x *AutoMlTablesInputs_Transformation_TimestampTransformation) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

func (x *AutoMlTablesInputs_Transformation_TimestampTransformation) GetTimeFormat() string {
	if x != nil {
		return x.TimeFormat
	}
	return ""
}

func (x *AutoMlTablesInputs_Transformation_TimestampTransformation) GetInvalidValuesAllowed() bool {
	if x != nil {
		return x.InvalidValuesAllowed
	}
	return false
}

// Training pipeline will perform following transformation functions.
// *  The text as is--no change to case, punctuation, spelling, tense, and
// so
//    on.
// *  Tokenize text to words. Convert each words to a dictionary lookup
// index
//    and generate an embedding for each index. Combine the embedding of all
//    elements into a single embedding using the mean.
// *  Tokenization is based on unicode script boundaries.
// *  Missing values get their own lookup index and resulting embedding.
// *  Stop-words receive no special treatment and are not removed.
type AutoMlTablesInputs_Transformation_TextTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
}

func (x *AutoMlTablesInputs_Transformation_TextTransformation) Reset() {
	*x = AutoMlTablesInputs_Transformation_TextTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlTablesInputs_Transformation_TextTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlTablesInputs_Transformation_TextTransformation) ProtoMessage() {}

func (x *AutoMlTablesInputs_Transformation_TextTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlTablesInputs_Transformation_TextTransformation.ProtoReflect.Descriptor instead.
func (*AutoMlTablesInputs_Transformation_TextTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDescGZIP(), []int{1, 0, 4}
}

func (x *AutoMlTablesInputs_Transformation_TextTransformation) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

// Treats the column as numerical array and performs following
// transformation functions.
// *  All transformations for Numerical types applied to the average of the
//    all elements.
// *  The average of empty arrays is treated as zero.
type AutoMlTablesInputs_Transformation_NumericArrayTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
	// If invalid values is allowed, the training pipeline will create a
	// boolean feature that indicated whether the value is valid.
	// Otherwise, the training pipeline will discard the input row from
	// trainining data.
	InvalidValuesAllowed bool `protobuf:"varint,2,opt,name=invalid_values_allowed,json=invalidValuesAllowed,proto3" json:"invalid_values_allowed,omitempty"`
}

func (x *AutoMlTablesInputs_Transformation_NumericArrayTransformation) Reset() {
	*x = AutoMlTablesInputs_Transformation_NumericArrayTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlTablesInputs_Transformation_NumericArrayTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlTablesInputs_Transformation_NumericArrayTransformation) ProtoMessage() {}

func (x *AutoMlTablesInputs_Transformation_NumericArrayTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlTablesInputs_Transformation_NumericArrayTransformation.ProtoReflect.Descriptor instead.
func (*AutoMlTablesInputs_Transformation_NumericArrayTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDescGZIP(), []int{1, 0, 5}
}

func (x *AutoMlTablesInputs_Transformation_NumericArrayTransformation) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

func (x *AutoMlTablesInputs_Transformation_NumericArrayTransformation) GetInvalidValuesAllowed() bool {
	if x != nil {
		return x.InvalidValuesAllowed
	}
	return false
}

// Treats the column as categorical array and performs following
// transformation functions.
// *  For each element in the array, convert the category name to a
// dictionary
//    lookup index and generate an embedding for each index.
//    Combine the embedding of all elements into a single embedding using
//    the mean.
// *  Empty arrays treated as an embedding of zeroes.
type AutoMlTablesInputs_Transformation_CategoricalArrayTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
}

func (x *AutoMlTablesInputs_Transformation_CategoricalArrayTransformation) Reset() {
	*x = AutoMlTablesInputs_Transformation_CategoricalArrayTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlTablesInputs_Transformation_CategoricalArrayTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlTablesInputs_Transformation_CategoricalArrayTransformation) ProtoMessage() {}

func (x *AutoMlTablesInputs_Transformation_CategoricalArrayTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlTablesInputs_Transformation_CategoricalArrayTransformation.ProtoReflect.Descriptor instead.
func (*AutoMlTablesInputs_Transformation_CategoricalArrayTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDescGZIP(), []int{1, 0, 6}
}

func (x *AutoMlTablesInputs_Transformation_CategoricalArrayTransformation) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

// Treats the column as text array and performs following transformation
// functions.
// *  Concatenate all text values in the array into a single text value
// using
//    a space (" ") as a delimiter, and then treat the result as a single
//    text value. Apply the transformations for Text columns.
// *  Empty arrays treated as an empty text.
type AutoMlTablesInputs_Transformation_TextArrayTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
}

func (x *AutoMlTablesInputs_Transformation_TextArrayTransformation) Reset() {
	*x = AutoMlTablesInputs_Transformation_TextArrayTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlTablesInputs_Transformation_TextArrayTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlTablesInputs_Transformation_TextArrayTransformation) ProtoMessage() {}

func (x *AutoMlTablesInputs_Transformation_TextArrayTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlTablesInputs_Transformation_TextArrayTransformation.ProtoReflect.Descriptor instead.
func (*AutoMlTablesInputs_Transformation_TextArrayTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDescGZIP(), []int{1, 0, 7}
}

func (x *AutoMlTablesInputs_Transformation_TextArrayTransformation) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

var File_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDesc = []byte{
	0x0a, 0x51, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x6a, 0x6f, 0x62, 0x2f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x1a, 0x66, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x2f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74,
	0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xea, 0x01, 0x0a, 0x0c, 0x41, 0x75, 0x74,
	0x6f, 0x4d, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x69, 0x0a, 0x06, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64,
	0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x52, 0x06, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x73, 0x12, 0x6f, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69,
	0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x89, 0x16, 0x0a, 0x12, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x4f, 0x0a, 0x23,
	0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x20, 0x6f, 0x70, 0x74,
	0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x52, 0x65, 0x63, 0x61, 0x6c, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x55, 0x0a,
	0x26, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52,
	0x23, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x12, 0x8a, 0x01, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x60, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f,
	0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74,
	0x6f, 0x4d, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x35, 0x0a, 0x16, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x15, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x40, 0x0a, 0x1d, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x5f,
	0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x5f, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x19, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x4d, 0x69, 0x6c, 0x6c, 0x69, 0x4e,
	0x6f, 0x64, 0x65, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x64, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x5f, 0x73, 0x74, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x45, 0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x2c,
	0x0a, 0x12, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x77, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0xa9, 0x01, 0x0a,
	0x22, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64,
	0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65,
	0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1e, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65,
	0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xba, 0x0f, 0x0a, 0x0e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x89, 0x01, 0x0a, 0x04,
	0x61, 0x75, 0x74, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e,
	0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d,
	0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74,
	0x6f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x04, 0x61, 0x75, 0x74, 0x6f, 0x12, 0x92, 0x01, 0x0a, 0x07, 0x6e, 0x75, 0x6d, 0x65,
	0x72, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x76, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64,
	0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4e, 0x75, 0x6d, 0x65,
	0x72, 0x69, 0x63, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x07, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x12, 0x9e, 0x01, 0x0a,
	0x0b, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x7a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x0b, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x12, 0x98, 0x01,
	0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x09, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x89, 0x01, 0x0a, 0x04, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x04,
	0x74, 0x65, 0x78, 0x74, 0x12, 0xa8, 0x01, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x7b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x41, 0x72, 0x72, 0x61, 0x79, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0f,
	0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x65, 0x64, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x12,
	0xb4, 0x01, 0x0a, 0x14, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x7f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41,
	0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x41, 0x72, 0x72, 0x61,
	0x79, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x13, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x65, 0x64, 0x43, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x12, 0x9f, 0x01, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x65, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x78,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41,
	0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x54, 0x65, 0x78, 0x74, 0x41, 0x72, 0x72, 0x61, 0x79, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x65,
	0x61, 0x74, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x1a, 0x35, 0x0a, 0x12, 0x41, 0x75, 0x74, 0x6f,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f,
	0x0a, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x1a,
	0x6e, 0x0a, 0x15, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x69, 0x6e, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x5f, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x69, 0x6e, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x1a,
	0x3c, 0x0a, 0x19, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b,
	0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x91, 0x01,
	0x0a, 0x17, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x69,
	0x6d, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x74, 0x69, 0x6d, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x34, 0x0a, 0x16, 0x69,
	0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x5f, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x69, 0x6e, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65,
	0x64, 0x1a, 0x35, 0x0a, 0x12, 0x54, 0x65, 0x78, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x73, 0x0a, 0x1a, 0x4e, 0x75, 0x6d, 0x65,
	0x72, 0x69, 0x63, 0x41, 0x72, 0x72, 0x61, 0x79, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x69, 0x6e, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x1a, 0x41, 0x0a,
	0x1e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x41, 0x72, 0x72, 0x61,
	0x79, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65,
	0x1a, 0x3a, 0x0a, 0x17, 0x54, 0x65, 0x78, 0x74, 0x41, 0x72, 0x72, 0x61, 0x79, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x63,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x42, 0x17, 0x0a, 0x15,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x42, 0x2a, 0x0a, 0x28, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x22, 0x54, 0x0a, 0x14, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3c, 0x0a, 0x1b, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x5f, 0x6e, 0x6f,
	0x64, 0x65, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x17,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x73, 0x74, 0x4d, 0x69, 0x6c, 0x6c, 0x69, 0x4e, 0x6f,
	0x64, 0x65, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x42, 0xc1, 0x01, 0x0a, 0x41, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a,
	0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x11, 0x41,
	0x75, 0x74, 0x6f, 0x4d, 0x4c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x67, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x3b, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_goTypes = []interface{}{
	(*AutoMlTables)(nil),                                                     // 0: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTables
	(*AutoMlTablesInputs)(nil),                                               // 1: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs
	(*AutoMlTablesMetadata)(nil),                                             // 2: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesMetadata
	(*AutoMlTablesInputs_Transformation)(nil),                                // 3: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation
	(*AutoMlTablesInputs_Transformation_AutoTransformation)(nil),             // 4: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.AutoTransformation
	(*AutoMlTablesInputs_Transformation_NumericTransformation)(nil),          // 5: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.NumericTransformation
	(*AutoMlTablesInputs_Transformation_CategoricalTransformation)(nil),      // 6: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.CategoricalTransformation
	(*AutoMlTablesInputs_Transformation_TimestampTransformation)(nil),        // 7: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.TimestampTransformation
	(*AutoMlTablesInputs_Transformation_TextTransformation)(nil),             // 8: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.TextTransformation
	(*AutoMlTablesInputs_Transformation_NumericArrayTransformation)(nil),     // 9: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.NumericArrayTransformation
	(*AutoMlTablesInputs_Transformation_CategoricalArrayTransformation)(nil), // 10: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.CategoricalArrayTransformation
	(*AutoMlTablesInputs_Transformation_TextArrayTransformation)(nil),        // 11: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.TextArrayTransformation
	(*ExportEvaluatedDataItemsConfig)(nil),                                   // 12: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.ExportEvaluatedDataItemsConfig
}
var file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_depIdxs = []int32{
	1,  // 0: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTables.inputs:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs
	2,  // 1: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTables.metadata:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesMetadata
	3,  // 2: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.transformations:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation
	12, // 3: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.export_evaluated_data_items_config:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.ExportEvaluatedDataItemsConfig
	4,  // 4: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.auto:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.AutoTransformation
	5,  // 5: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.numeric:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.NumericTransformation
	6,  // 6: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.categorical:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.CategoricalTransformation
	7,  // 7: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.timestamp:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.TimestampTransformation
	8,  // 8: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.text:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.TextTransformation
	9,  // 9: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.repeated_numeric:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.NumericArrayTransformation
	10, // 10: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.repeated_categorical:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.CategoricalArrayTransformation
	11, // 11: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.repeated_text:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlTablesInputs.Transformation.TextArrayTransformation
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() {
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_init()
}
func file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_export_evaluated_data_items_config_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlTables); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlTablesInputs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlTablesMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlTablesInputs_Transformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlTablesInputs_Transformation_AutoTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlTablesInputs_Transformation_NumericTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlTablesInputs_Transformation_CategoricalTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlTablesInputs_Transformation_TimestampTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlTablesInputs_Transformation_TextTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlTablesInputs_Transformation_NumericArrayTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlTablesInputs_Transformation_CategoricalArrayTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlTablesInputs_Transformation_TextArrayTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*AutoMlTablesInputs_OptimizationObjectiveRecallValue)(nil),
		(*AutoMlTablesInputs_OptimizationObjectivePrecisionValue)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*AutoMlTablesInputs_Transformation_Auto)(nil),
		(*AutoMlTablesInputs_Transformation_Numeric)(nil),
		(*AutoMlTablesInputs_Transformation_Categorical)(nil),
		(*AutoMlTablesInputs_Transformation_Timestamp)(nil),
		(*AutoMlTablesInputs_Transformation_Text)(nil),
		(*AutoMlTablesInputs_Transformation_RepeatedNumeric)(nil),
		(*AutoMlTablesInputs_Transformation_RepeatedCategorical)(nil),
		(*AutoMlTablesInputs_Transformation_RepeatedText)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto = out.File
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_tables_proto_depIdxs = nil
}
