// Copyright 2022 The CCGO Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package ccgo // import "modernc.org/ccgo/v4/lib"

var testExecKnownFails = map[string]struct{}{
	// ==== EXEC FAIL - compiles and builds but fails when executed.

	`assets/CompCert-3.6/test/c/mandelbrot.c`:                                                           {}, // EXEC FAIL
	`assets/benchmarksgame-team.pages.debian.net/fasta-3.c`:                                             {}, // EXEC FAIL: assets/benchmarksgame-team.pages.debian.net/fasta-3.c: >ONE Homo sapiens alu
	`assets/benchmarksgame-team.pages.debian.net/fasta-8.c`:                                             {}, // EXEC FAIL: assets/benchmarksgame-team.pages.debian.net/fasta-8.c: >ONE Homo sapiens alu
	`assets/benchmarksgame-team.pages.debian.net/mandelbrot-9.c`:                                        {}, // EXEC FAIL
	`assets/benchmarksgame-team.pages.debian.net/reverse-complement-2.c`:                                {}, // EXEC FAIL: assets/benchmarksgame-team.pages.debian.net/reverse-complement-2.c: unexpected fault address 0x234ef8fffff
	`assets/benchmarksgame-team.pages.debian.net/reverse-complement-5.c`:                                {}, // EXEC FAIL: assets/benchmarksgame-team.pages.debian.net/reverse-complement-5.c: panic: runtime error: index out of range [-8]
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/align-3.c`:                                    {}, // EXEC FAIL: assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/align-3.c: libc_windows.go:1794:Xabort: TODOTODO
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/builtin-types-compatible-p.c`:                 {}, // EXEC FAIL: assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/builtin-types-compatible-p.c: libc_windows.go:1794:Xabort: TODOTODO
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr36093.c`:                                    {}, // EXEC FAIL: assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr36093.c: panic: 544
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr36321.c`:                                    {}, // EXEC FAIL: assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr36321.c: libc_windows.go:1794:Xabort: TODOTODO
	`assets/github.com/AbsInt/CompCert/test/c/mandelbrot.c`:                                             {}, // EXEC FAIL
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/align-3.c`:                    {}, // EXEC FAIL: assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/align-3.c: libc_windows.go:1794:Xabort: TODOTODO
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/builtin-types-compatible-p.c`: {}, // EXEC FAIL: assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/builtin-types-compatible-p.c: libc_windows.go:1794:Xabort: TODOTODO
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr36321.c`:                    {}, // EXEC FAIL: assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr36321.c: libc_windows.go:1794:Xabort: TODOTODO
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/return-addr.c`:                {}, // EXEC FAIL
	`assets/github.com/vnmakarov/mir/c-benchmarks/mandelbrot.c`:                                         {}, // EXEC FAIL
	`assets/github.com/vnmakarov/mir/c-tests/lacc/bitfield-pack-next.c`:                                 {}, // EXEC FAIL
	`assets/github.com/vnmakarov/mir/c-tests/lacc/bitfield-trailing-zero.c`:                             {}, // EXEC FAIL
	`assets/github.com/vnmakarov/mir/c-tests/lacc/bitfield-types-init.c`:                                {}, // EXEC FAIL
	`assets/github.com/vnmakarov/mir/c-tests/lacc/declaration-default-int.c`:                            {}, // EXEC FAIL: assets/github.com/vnmakarov/mir/c-tests/lacc/declaration-default-int.c: : FAIL: exit status 51
	`assets/github.com/vnmakarov/mir/c-tests/lacc/function-implicit-declare.c`:                          {}, // EXEC FAIL: assets/github.com/vnmakarov/mir/c-tests/lacc/function-implicit-declare.c: : FAIL: exit status 42
	`assets/github.com/vnmakarov/mir/c-tests/lacc/vararg-complex-2.c`:                                   {}, // EXEC FAIL: assets/github.com/vnmakarov/mir/c-tests/lacc/vararg-complex-2.c: 0,0,0,0
	`assets/tcc-0.9.27/tests/tests2/73_arm64.c`:                                                         {}, // EXEC FAIL: assets/tcc-0.9.27/tests/tests2/73_arm64.c: Arguments:
	`assets/tcc-0.9.27/tests/tests2/95_bitfields.c`:                                                     {}, // EXEC FAIL: assets/tcc-0.9.27/tests/tests2/95_bitfields.c: ---- TEST 1 ----
	`assets/tcc-0.9.27/tests/tests2/95_bitfields_ms.c`:                                                  {}, // EXEC FAIL: assets/tcc-0.9.27/tests/tests2/95_bitfields_ms.c: ---- TEST 1 - MS-BITFIELDS ----

	// ==== BUILD FAIL - compiles but does not build.

	`assets/benchmarksgame-team.pages.debian.net/reverse-complement-4.c`: {}, // BUILD FAIL: "exit status 1"
	`assets/ccgo/bug/sqlite.c`: {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010122-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040709-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040709-2.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040709-3.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20060905-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20080502-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20090113-2.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20090113-3.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20180921-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/builtin-bitops-1.c`:                  {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/20030331-1.c`:                   {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/compare-fp-1.c`:                 {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr35456.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr37780.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr42570.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr53160.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr64006.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr66556.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr67037.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71631.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr79286.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr89195.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/strlen-6.c`:                          {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010122-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040709-2.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040709-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040709-3.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20060905-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20080502-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20090113-2.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20090113-3.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20180921-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/builtin-bitops-1.c`:  {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/20030331-1.c`:   {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/compare-fp-1.c`: {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr35456.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr37780.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr42570.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr53160.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr64006.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr66556.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr67037.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71631.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr79286.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr89195.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr93249.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr93494.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/strlen-6.c`:          {}, // BUILD FAIL: "exit status 1"

	// ==== COMPILE FAIL - does not compile.

	`assets/benchmarksgame-team.pages.debian.net/mandelbrot-8.c`:                            {}, // COMPILE FAIL: "\"mandelbrot-8.c:16:30: unsupported vector type: Vec (expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1730:unaryExpression: type.go:407:isValidType: type.go:440:isValidType..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20000326-2.c`:                     {}, // COMPILE FAIL: "\"20000326-2.c:7:3: label declarations not supported (compile.go:478:compile: decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:402:functionDefinition0: stmt.go:340:compoundState..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20000518-1.c`:                     {}, // COMPILE FAIL: "\"20000518-1.c:7:2: label declarations not supported (compile.go:478:compile: decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:402:functionDefinition0: stmt.go:340:compoundState..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010202-1.c`:                     {}, // COMPILE FAIL: "\"20010202-1.c:3:5: incomplete type: array of array of char (decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:382:functionDefinition0: type.go:459:isValidType1: type.go:383:isVa..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20021108-1.c`:                     {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (expr.go:1220:additiveExpression: expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1739:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030903-1.c`:                     {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:531:expr0: expr.go:3887:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030910-1.c`:                     {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:531:expr0: expr.go:3892:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040317-1.c`:                     {}, // COMPILE FAIL: "\"20040317-1.c:1:5: incomplete type: array of array of char (decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:382:functionDefinition0: type.go:459:isValidType1: type.go:383:isVa..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040614-1.c`:                     {}, // COMPILE FAIL: "\"TODO <nil> (asm_arm64.s:1223:goexit: compile.go:478:compile: decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:388:functionDefinition0: decl.go:106:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20050113-1.c`:                     {}, // COMPILE FAIL: "\"20050113-1.c:11:20: unsupported vector type: V2SF (expr.go:561:expr0: expr.go:4276:primaryExpression: expr.go:4748:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVa..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20070603-1.c`:                     {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:1203:additiveExpression: expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20070603-2.c`:                     {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:1203:additiveExpression: expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20070919-1.c`:                     {}, // COMPILE FAIL: "\"TODO exprUintptr (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: expr.go:101:expr: expr.go:559:expr0: expr.go:2195:postfixExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20110131-1.c`:                     {}, // COMPILE FAIL: "\"-: TODO (expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20121107-1.c`:                     {}, // COMPILE FAIL: "\"-: TODO (expr.go:561:expr0: expr.go:4293:primaryExpression: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/981001-4.c`:                       {}, // COMPILE FAIL: "\"-: TODO (expr.go:561:expr0: expr.go:4293:primaryExpression: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/981006-1.c`:                       {}, // COMPILE FAIL: "\"981006-1.c:14:3: label declarations not supported (compile.go:478:compile: decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:402:functionDefinition0: stmt.go:340:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/981223-1.c`:                       {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:1308:equalityExpression: expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/991213-1.c`:                       {}, // COMPILE FAIL: "\"TODO UnaryExpressionImag (expr.go:70:topExpr: expr.go:101:expr: expr.go:561:expr0: expr.go:4293:primaryExpression: expr.go:567:expr0: expr.go:1763:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-1.c`:                      {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (expr.go:70:topExpr: expr.go:115:expr: expr.go:169:convert: expr.go:355:convertType: type.go:30:helper: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-2.c`:                      {}, // COMPILE FAIL: "\"TODO UnaryExpressionImag (expr.go:101:expr: expr.go:531:expr0: expr.go:3887:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1763:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-3.c`:                      {}, // COMPILE FAIL: "\"TODO UnaryExpressionImag (expr.go:1203:additiveExpression: expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1763:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-4.c`:                      {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:531:expr0: expr.go:3887:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-5.c`:                      {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (expr.go:101:expr: expr.go:561:expr0: expr.go:4274:primaryExpression: expr.go:4727:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/icfmatch.c`:                       {}, // COMPILE FAIL: "\"icfmatch.c:4:14: unsupported vector type: v4qi (expr.go:115:expr: expr.go:169:convert: expr.go:353:convertType: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/labels-3.c`:                       {}, // COMPILE FAIL: "\"TODO <nil> (asm_arm64.s:1223:goexit: compile.go:478:compile: decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:388:functionDefinition0: decl.go:106:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr18903.c`:                        {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (stmt.go:376:blockItem: stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1739:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr21356.c`:                        {}, // COMPILE FAIL: "\"TODO <nil> (asm_arm64.s:1223:goexit: compile.go:478:compile: decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:388:functionDefinition0: decl.go:106:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr22422.c`:                        {}, // COMPILE FAIL: "\"TODO pr22422.c:27:3: from pointer to int, exprUintptr to pointer to int exprVoid, src '&d->c [d->n]', buf '((((aad))+4)+(((ppuintptr(((*tsD)(iqunsafe.ppPointer((aad))).fdn))))*4))' (stmt.go:376:block..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr25224.c`:                        {}, // COMPILE FAIL: "\"TODO <nil> (asm_arm64.s:1223:goexit: compile.go:478:compile: decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:388:functionDefinition0: decl.go:106:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr27341-1.c`:                      {}, // COMPILE FAIL: "\"TODO UnaryExpressionImag (expr.go:101:expr: expr.go:531:expr0: expr.go:3887:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1763:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr33617.c`:                        {}, // COMPILE FAIL: "\".: unsupported vector type: V8SF (asm_arm64.s:1223:goexit: asm_arm64.s:1223:goexit: compile.go:531:compile: decl.go:910:signature: type.go:383:isValidParamType: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr34856.c`:                        {}, // COMPILE FAIL: "\"pr34856.c:11:16: unsupported vector type: VU32 (expr.go:115:expr: expr.go:169:convert: expr.go:353:convertType: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr35431.c`:                        {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (expr.go:101:expr: expr.go:561:expr0: expr.go:4274:primaryExpression: expr.go:4727:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr38771.c`:                        {}, // COMPILE FAIL: "\"-: TODO (expr.go:561:expr0: expr.go:4293:primaryExpression: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr41987.c`:                        {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex char _Complex char (expr.go:101:expr: expr.go:561:expr0: expr.go:4274:primaryExpression: expr.go:4727:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42196-1.c`:                      {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:298:externalDeclaration: decl.go:977:declaration: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:312:typ0: type.go:159:typ0:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42196-2.c`:                      {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:298:externalDeclaration: decl.go:977:declaration: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:323:typ0: type.go:159:typ0:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42196-3.c`:                      {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:298:externalDeclaration: decl.go:977:declaration: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:323:typ0: type.go:159:typ0:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42559.c`:                        {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (init.go:30:initializerOuter: init.go:82:initializer: expr.go:70:topExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1739:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42716.c`:                        {}, // COMPILE FAIL: "\"-: TODO (expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42717.c`:                        {}, // COMPILE FAIL: "\"-: TODO (expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr44119.c`:                        {}, // COMPILE FAIL: "\"-: TODO (expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr46107.c`:                        {}, // COMPILE FAIL: "\"TODO <nil> (asm_arm64.s:1223:goexit: compile.go:478:compile: decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:388:functionDefinition0: decl.go:106:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr51495.c`:                        {}, // COMPILE FAIL: "\"TODO <nil> (asm_arm64.s:1223:goexit: compile.go:478:compile: decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:388:functionDefinition0: decl.go:106:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr53410-2.c`:                      {}, // COMPILE FAIL: "\"pr53410-2.c:9:3: unsupported vector type: V (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr53748.c`:                        {}, // COMPILE FAIL: "\"pr53748.c:8:3: unsupported vector type: V (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr54713-1.c`:                      {}, // COMPILE FAIL: "\"pr54713-1.c:15:3: unsupported vector type: V (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr54713-2.c`:                      {}, // COMPILE FAIL: "\"pr54713-1.c:15:3: unsupported vector type: V (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr54713-3.c`:                      {}, // COMPILE FAIL: "\"pr54713-1.c:15:3: unsupported vector type: V (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr56571.c`:                        {}, // COMPILE FAIL: "\"-: TODO (expr.go:561:expr0: expr.go:4293:primaryExpression: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr60502.c`:                        {}, // COMPILE FAIL: "\"pr60502.c:9:16: unsupported vector type: v16i8 (expr.go:115:expr: expr.go:169:convert: expr.go:353:convertType: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70199.c`:                        {}, // COMPILE FAIL: "\"TODO <nil> (asm_arm64.s:1223:goexit: compile.go:478:compile: decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:388:functionDefinition0: decl.go:106:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70355.c`:                        {}, // COMPILE FAIL: "\"unsigned __int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70633.c`:                        {}, // COMPILE FAIL: "\"pr70633.c:10:5: unsupported vector type: V (decl.go:458:functionDefinition0: stmt.go:261:compoundStatement: decl.go:231:declareLocals: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70916.c`:                        {}, // COMPILE FAIL: "\"-: TODO (expr.go:3892:assignmentExpression: expr.go:101:expr: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr71109.c`:                        {}, // COMPILE FAIL: "\"pr71109.c:15:7: too few arguments to function 'foo', type 'function(int, struct S, struct T)' in 'foo (bar, a)' (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:559:expr0: expr.go..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-1.c`:                      {}, // COMPILE FAIL: "\"pr77754-1.c:5:13: incomplete type: array of array of int (asm_arm64.s:1223:goexit: asm_arm64.s:1223:goexit: compile.go:531:compile: decl.go:910:signature: type.go:383:isValidParamType: type.go:471:is..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-2.c`:                      {}, // COMPILE FAIL: "\"pr77754-2.c:5:6: incomplete type: array of array of int (type.go:658:defineType0: type.go:658:defineType0: type.go:646:defineType0: type.go:459:isValidType1: type.go:383:isValidParamType: type.go:471..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-3.c`:                      {}, // COMPILE FAIL: "\"pr77754-3.c:5:14: incomplete type: array of array of int (type.go:642:defineType: type.go:658:defineType0: type.go:646:defineType0: type.go:459:isValidType1: type.go:383:isValidParamType: type.go:471..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-4.c`:                      {}, // COMPILE FAIL: "\"pr77754-4.c:5:14: incomplete type: array of array of int (type.go:642:defineType: type.go:658:defineType0: type.go:646:defineType0: type.go:459:isValidType1: type.go:383:isValidParamType: type.go:471..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-5.c`:                      {}, // COMPILE FAIL: "\"pr77754-5.c:6:6: incomplete type: array of array of int (decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:382:functionDefinition0: type.go:459:isValidType1: type.go:383:isVali..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr84305.c`:                        {}, // COMPILE FAIL: "\"pr84305.c:3:34: TODO (expr.go:1921:postfixExpressionIndex: expr.go:101:expr: expr.go:559:expr0: expr.go:2004:postfixExpression: expr.go:1837:postfixExpressionIndex: expr.go:1787:mul:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr85704.c`:                        {}, // COMPILE FAIL: "\"TODO *cc.StructType (expr.go:3892:assignmentExpression: expr.go:101:expr: expr.go:559:expr0: expr.go:2305:postfixExpression: init.go:105:initializer: init.go:275:initializerStruct:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr84960.c`:                        {}, // COMPILE FAIL: "\"TODO <nil> (asm_arm64.s:1223:goexit: compile.go:478:compile: decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:388:functionDefinition0: decl.go:106:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr85945.c`:                        {}, // COMPILE FAIL: "\"pr85945.c:4:1: unsupported vector type: V (decl.go:977:declaration: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:323:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr86122.c`:                        {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (expr.go:101:expr: expr.go:561:expr0: expr.go:4274:primaryExpression: expr.go:4727:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr86123.c`:                        {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex unsigned _Complex unsigned (expr.go:101:expr: expr.go:561:expr0: expr.go:4274:primaryExpression: expr.go:4727:primaryExpressionIntConst: type.go:30:helper: type.go:15..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr89655.c`:                        {}, // COMPILE FAIL: "\"-: TODO (expr.go:561:expr0: expr.go:4293:primaryExpression: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr90139.c`:                        {}, // COMPILE FAIL: "\"pr90139.c:10:11: unsupported vector type: V (decl.go:458:functionDefinition0: stmt.go:261:compoundStatement: decl.go:231:declareLocals: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-1.c`:                         {}, // COMPILE FAIL: "\"simd-1.c:5:16: unsupported vector type: v2si (expr.go:561:expr0: expr.go:4274:primaryExpression: expr.go:4710:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-2.c`:                         {}, // COMPILE FAIL: "\"simd-2.c:14:9: unsupported vector type: floatvect2 (expr.go:559:expr0: expr.go:2122:postfixExpression: expr.go:2962:postfixExpressionSelect: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-3.c`:                         {}, // COMPILE FAIL: "\"simd-3.c:19:9: unsupported vector type: floatvect2 (expr.go:559:expr0: expr.go:2122:postfixExpression: expr.go:2962:postfixExpressionSelect: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-4.c`:                         {}, // COMPILE FAIL: "\"simd-4.c:11:26: unsupported vector type: floatvect2 (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-6.c`:                         {}, // COMPILE FAIL: "\"simd-6.c:5:11: unsupported vector type: vec (init.go:99:initializer: init.go:174:initializerArray: type.go:42:typ: type.go:337:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/sra-1.c`:                          {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:1337:relationExpression: expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/struct-non-lval-2.c`:              {}, // COMPILE FAIL: "\"TODO assertion failed (expr.go:101:expr: expr.go:559:expr0: expr.go:2122:postfixExpression: expr.go:3060:postfixExpressionSelect: expr.go:115:expr: expr.go:131:convert:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/struct-non-lval-3.c`:              {}, // COMPILE FAIL: "\"TODO exprUintptr (expr.go:3060:postfixExpressionSelect: expr.go:101:expr: expr.go:561:expr0: expr.go:4293:primaryExpression: expr.go:531:expr0: expr.go:3897:assignmentExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-1.c`:                       {}, // COMPILE FAIL: "\"vector-1.c:3:1: unsupported vector type: float (decl.go:975:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-2.c`:                       {}, // COMPILE FAIL: "\"vector-2.c:3:1: unsupported vector type: float (decl.go:975:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-4.c`:                       {}, // COMPILE FAIL: "\"vector-4.c:7:47: unsupported vector type: signed char (decl.go:298:externalDeclaration: decl.go:985:declaration: decl.go:1180:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-align-1.c`:                 {}, // COMPILE FAIL: "\"TODO vector (compile.go:478:compile: decl.go:298:externalDeclaration: decl.go:985:declaration: decl.go:1180:initDeclarator: type.go:42:typ: type.go:89:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20020411-1.c`:                     {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:531:expr0: expr.go:3887:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030330-1.c`:                     {}, // COMPILE FAIL: "20030330-1.o.go:1167:4: undefined: \"link_error\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:201:Main: ccgo.go:666:main: link.go:302:link: link.go:870:link:) (all_test.go:465:1: all..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040302-1.c`:                     {}, // COMPILE FAIL: "\"TODO <nil> (asm_arm64.s:1223:goexit: compile.go:478:compile: decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:388:functionDefinition0: decl.go:106:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041201-1.c`:                     {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex char _Complex char (decl.go:298:externalDeclaration: decl.go:985:declaration: decl.go:1150:initDeclarator: type.go:18:typedef: type.go:263:typ0: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041214-1.c`:                     {}, // COMPILE FAIL: "\"TODO <nil> (asm_arm64.s:1223:goexit: compile.go:478:compile: decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:388:functionDefinition0: decl.go:106:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050121-1.c`:                     {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:531:expr0: expr.go:3887:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050316-1.c`:                     {}, // COMPILE FAIL: "\"20050316-1.c:15:29: unsupported vector type: V2SI (expr.go:561:expr0: expr.go:4274:primaryExpression: expr.go:4727:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidTy..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050316-2.c`:                     {}, // COMPILE FAIL: "\"20050316-2.c:38:14: unsupported vector type: V2SF (expr.go:561:expr0: expr.go:4276:primaryExpression: expr.go:4748:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVa..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050316-3.c`:                     {}, // COMPILE FAIL: "\"20050316-3.c:29:3: unsupported vector type: V2USI (expr.go:559:expr0: expr.go:2122:postfixExpression: expr.go:2962:postfixExpressionSelect: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050604-1.c`:                     {}, // COMPILE FAIL: "\"20050604-1.c:16:3: unsupported vector type: v4hi (decl.go:985:declaration: decl.go:1180:initDeclarator: type.go:42:typ: type.go:323:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050607-1.c`:                     {}, // COMPILE FAIL: "\"20050607-1.c:12:32: unsupported vector type: V2SI (expr.go:561:expr0: expr.go:4274:primaryExpression: expr.go:4710:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVali..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20060420-1.c`:                     {}, // COMPILE FAIL: "\"20060420-1.c:8:19: unsupported vector type: v4flt (expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1730:unaryExpression: type.go:407:isValidType: type.go:440:isValidType1..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20071210-1.c`:                     {}, // COMPILE FAIL: "\"TODO <nil> (asm_arm64.s:1223:goexit: compile.go:478:compile: decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:388:functionDefinition0: decl.go:106:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/comp-goto-1.c`:                    {}, // COMPILE FAIL: "\"TODO <nil> (asm_arm64.s:1223:goexit: compile.go:478:compile: decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:388:functionDefinition0: decl.go:106:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/complex-6.c`:                      {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:435:functionDefinition0: decl.go:928:signature: type.go:48:typ2: type.go:15..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/complex-7.c`:                      {}, // COMPILE FAIL: "\"TODO 2.2iL *cc.ComplexLongDoubleValue from=_Complex long t=long double mode=exprDefault (expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:561:expr0: expr.go:4276:prim..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/fprintf-2.c`:                      {}, // COMPILE FAIL: "fprintf-2.o.go:1856:15: undefined: \"tmpnam\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:201:Main: ccgo.go:666:main: link.go:302:link: link.go:870:link:)"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/pr72824-2.c`:                 {}, // COMPILE FAIL: "\"pr72824-2.c:17:17: unsupported vector type: V (expr.go:561:expr0: expr.go:4276:primaryExpression: expr.go:4758:primaryExpressionFloatConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidType..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr23135.c`:                        {}, // COMPILE FAIL: "\"pr23135.c:19:14: unsupported vector type: vecint (expr.go:561:expr0: expr.go:4274:primaryExpression: expr.go:4710:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValid..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr23324.c`:                        {}, // COMPILE FAIL: "\"TODO (decl.go:1242:initDeclaratorInit: type.go:642:defineType: type.go:656:defineType0: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:315:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr34154.c`:                        {}, // COMPILE FAIL: "\"TODO SelectionStatementSwitch (decl.go:402:functionDefinition0: stmt.go:340:compoundStatement: stmt.go:376:blockItem: stmt.go:42:statement: stmt.go:464:selectionStatement: stmt.go:681:selectionStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr38151.c`:                        {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:298:externalDeclaration: decl.go:975:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263:typ0: type.go:159:typ..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr49218.c`:                        {}, // COMPILE FAIL: "\"__int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr53645-2.c`:                      {}, // COMPILE FAIL: "\"pr53645-2.c:41:1: unsupported vector type: UV (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr53645.c`:                        {}, // COMPILE FAIL: "\"pr53645.c:41:1: unsupported vector type: UV (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr54471.c`:                        {}, // COMPILE FAIL: "\"unsigned __int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr56837.c`:                        {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:298:externalDeclaration: decl.go:985:declaration: decl.go:1180:initDeclarator: type.go:42:typ: type.go:337:typ0: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr60960.c`:                        {}, // COMPILE FAIL: "\"pr60960.c:26:14: unsupported vector type: v4qi (expr.go:561:expr0: expr.go:4274:primaryExpression: expr.go:4716:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidTy..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr61375.c`:                        {}, // COMPILE FAIL: "\"unsigned __int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr63302.c`:                        {}, // COMPILE FAIL: "\"__int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr65170.c`:                        {}, // COMPILE FAIL: "\"unsigned __int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr65427.c`:                        {}, // COMPILE FAIL: "\"pr65427.c:4:3: unsupported vector type: V (decl.go:298:externalDeclaration: decl.go:985:declaration: decl.go:1180:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr68249.c`:                        {}, // COMPILE FAIL: "\"-: TODO (expr.go:3892:assignmentExpression: expr.go:101:expr: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr68381.c`:                        {}, // COMPILE FAIL: "\"TODO unsigned short * unsigned short -> int (stmt.go:42:statement: stmt.go:411:selectionStatement: expr.go:101:expr: expr.go:559:expr0: expr.go:2062:postfixExpression: expr.go:2344:mulOverflow:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr70460.c`:                        {}, // COMPILE FAIL: "\"TODO <nil> (asm_arm64.s:1223:goexit: compile.go:478:compile: decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:388:functionDefinition0: decl.go:106:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr70903.c`:                        {}, // COMPILE FAIL: "\"TODO (expr.go:3588:postfixExpressionCall: expr.go:70:topExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2305:postfixExpression: init.go:51:initializer:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71554.c`:                        {}, // COMPILE FAIL: "\"TODO unsigned * int -> int (stmt.go:42:statement: stmt.go:411:selectionStatement: expr.go:101:expr: expr.go:559:expr0: expr.go:2062:postfixExpression: expr.go:2344:mulOverflow:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71626-1.c`:                      {}, // COMPILE FAIL: "\"TODO PostfixExpressionIndex (expr.go:1311:equalityExpression: expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2011:postfixExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71626-2.c`:                      {}, // COMPILE FAIL: "\"TODO PostfixExpressionIndex (expr.go:1311:equalityExpression: expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2011:postfixExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr77767.c`:                        {}, // COMPILE FAIL: "\"pr77767.c:4:1: incomplete type: array of int (decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:382:functionDefinition0: type.go:459:isValidType1: type.go:383:isValidParamType:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr84169.c`:                        {}, // COMPILE FAIL: "\"unsigned __int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr84748.c`:                        {}, // COMPILE FAIL: "\"unsigned __int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85169.c`:                        {}, // COMPILE FAIL: "\"pr85169.c:8:9: unsupported vector type: V (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85582-2.c`:                      {}, // COMPILE FAIL: "\"__int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85582-3.c`:                      {}, // COMPILE FAIL: "\"__int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr88739.c`:                        {}, // COMPILE FAIL: "\"TODO exprUintptr (expr.go:2122:postfixExpression: expr.go:2926:postfixExpressionSelect: expr.go:101:expr: expr.go:559:expr0: expr.go:2122:postfixExpression: expr.go:3041:postfixExpressionSelect:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr89434.c`:                        {}, // COMPILE FAIL: "\"TODO int * long -> unsigned (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2062:postfixExpression: expr.go:2344:mulOverflow:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/printf-2.c`:                       {}, // COMPILE FAIL: "printf-2.o.go:1879:15: undefined: \"tmpnam\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:201:Main: ccgo.go:666:main: link.go:302:link: link.go:870:link:)"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/scal-to-vec2.c`:                   {}, // COMPILE FAIL: "scal-to-vec2.o.go:1188:17: undefined: \"main\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:201:Main: ccgo.go:666:main: link.go:302:link: link.go:870:link:) (all_test.go:465:1: all_te..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/scal-to-vec1.c`:                   {}, // COMPILE FAIL: "scal-to-vec1.o.go:1158:17: undefined: \"main\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:201:Main: ccgo.go:666:main: link.go:302:link: link.go:870:link:) (all_test.go:465:1: all_te..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/scal-to-vec3.c`:                   {}, // COMPILE FAIL: "scal-to-vec3.o.go:1152:17: undefined: \"main\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:201:Main: ccgo.go:666:main: link.go:302:link: link.go:870:link:) (all_test.go:465:1: all_te..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-6.c`:                         {}, // COMPILE FAIL: "\"simd-6.c:13:14: unsupported vector type: v8qi (expr.go:561:expr0: expr.go:4274:primaryExpression: expr.go:4716:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidTyp..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/string-opt-18.c`:                  {}, // COMPILE FAIL: "string-opt-18.o.go:1175:5: undefined: \"mempcpy\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:201:Main: ccgo.go:666:main: link.go:302:link: link.go:870:link:) (all_test.go:465:1: all..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/user-printf.c`:                    {}, // COMPILE FAIL: "user-printf.o.go:1871:15: undefined: \"tmpnam\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:201:Main: ccgo.go:666:main: link.go:302:link: link.go:870:link:)"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/zero-struct-2.c`:                  {}, // COMPILE FAIL: "\"zero-struct-2.c:15:48: TODO \\\"Xone_raw_spinlock(cgtls)\\\" from=raw_spinlock_t struct 0 exprDefault -> to=spinlock_t struct 0 exprDefault (zero-struct-2.c:15:48:) (expr.go:559:expr0: expr.go:2305:postf..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20020411-1.c`:     {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:531:expr0: expr.go:3887:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030330-1.c`:     {}, // COMPILE FAIL: "20030330-1.o.go:1167:4: undefined: \"link_error\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:201:Main: ccgo.go:666:main: link.go:302:link: link.go:870:link:) (all_test.go:465:1: all..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040302-1.c`:     {}, // COMPILE FAIL: "\"TODO <nil> (asm_arm64.s:1223:goexit: compile.go:478:compile: decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:388:functionDefinition0: decl.go:106:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041201-1.c`:     {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex char _Complex char (decl.go:298:externalDeclaration: decl.go:985:declaration: decl.go:1150:initDeclarator: type.go:18:typedef: type.go:263:typ0: type.go:159:typ0:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041214-1.c`:     {}, // COMPILE FAIL: "\"TODO <nil> (asm_arm64.s:1223:goexit: compile.go:478:compile: decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:388:functionDefinition0: decl.go:106:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050121-1.c`:     {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:531:expr0: expr.go:3887:assignmentExpression: expr.go:101:expr: expr.go:567:expr0: expr.go:1765:unaryExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050316-1.c`:     {}, // COMPILE FAIL: "\"20050316-1.c:15:29: unsupported vector type: V2SI (expr.go:561:expr0: expr.go:4274:primaryExpression: expr.go:4727:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidTy..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050316-2.c`:     {}, // COMPILE FAIL: "\"20050316-2.c:38:14: unsupported vector type: V2SF (expr.go:561:expr0: expr.go:4276:primaryExpression: expr.go:4748:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVa..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050316-3.c`:     {}, // COMPILE FAIL: "\"20050316-3.c:29:3: unsupported vector type: V2USI (expr.go:559:expr0: expr.go:2122:postfixExpression: expr.go:2962:postfixExpressionSelect: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050604-1.c`:     {}, // COMPILE FAIL: "\"20050604-1.c:16:3: unsupported vector type: v4hi (decl.go:985:declaration: decl.go:1180:initDeclarator: type.go:42:typ: type.go:323:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050607-1.c`:     {}, // COMPILE FAIL: "\"20050607-1.c:12:32: unsupported vector type: V2SI (expr.go:561:expr0: expr.go:4274:primaryExpression: expr.go:4710:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVali..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20060420-1.c`:     {}, // COMPILE FAIL: "\"20060420-1.c:8:19: unsupported vector type: v4flt (expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:567:expr0: expr.go:1730:unaryExpression: type.go:407:isValidType: type.go:440:isValidType1..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20071210-1.c`:     {}, // COMPILE FAIL: "\"TODO <nil> (asm_arm64.s:1223:goexit: compile.go:478:compile: decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:388:functionDefinition0: decl.go:106:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/comp-goto-1.c`:    {}, // COMPILE FAIL: "\"TODO <nil> (asm_arm64.s:1223:goexit: compile.go:478:compile: decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:388:functionDefinition0: decl.go:106:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/complex-6.c`:      {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:435:functionDefinition0: decl.go:928:signature: type.go:48:typ2: type.go:15..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/complex-7.c`:      {}, // COMPILE FAIL: "\"TODO 2.2iL *cc.ComplexLongDoubleValue from=_Complex long t=long double mode=exprDefault (expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:561:expr0: expr.go:4276:prim..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/fprintf-2.c`:      {}, // COMPILE FAIL: "fprintf-2.o.go:1856:15: undefined: \"tmpnam\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:201:Main: ccgo.go:666:main: link.go:302:link: link.go:870:link:)"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/pr72824-2.c`: {}, // COMPILE FAIL: "\"pr72824-2.c:17:17: unsupported vector type: V (expr.go:561:expr0: expr.go:4276:primaryExpression: expr.go:4758:primaryExpressionFloatConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidType..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr23324.c`:        {}, // COMPILE FAIL: "\"TODO (decl.go:1242:initDeclaratorInit: type.go:642:defineType: type.go:656:defineType0: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:315:typ0:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr23135.c`:        {}, // COMPILE FAIL: "\"pr23135.c:19:14: unsupported vector type: vecint (expr.go:561:expr0: expr.go:4274:primaryExpression: expr.go:4710:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValid..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr34154.c`:        {}, // COMPILE FAIL: "\"TODO SelectionStatementSwitch (decl.go:402:functionDefinition0: stmt.go:340:compoundStatement: stmt.go:376:blockItem: stmt.go:42:statement: stmt.go:464:selectionStatement: stmt.go:681:selectionStatem..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr38151.c`:        {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:298:externalDeclaration: decl.go:975:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263:typ0: type.go:159:typ..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr49218.c`:        {}, // COMPILE FAIL: "\"__int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr53645-2.c`:      {}, // COMPILE FAIL: "\"pr53645-2.c:41:1: unsupported vector type: UV (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr53645.c`:        {}, // COMPILE FAIL: "\"pr53645.c:41:1: unsupported vector type: UV (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr54471.c`:        {}, // COMPILE FAIL: "\"unsigned __int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr56837.c`:        {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:298:externalDeclaration: decl.go:985:declaration: decl.go:1180:initDeclarator: type.go:42:typ: type.go:337:typ0: type.go:159:typ0:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr60960.c`:        {}, // COMPILE FAIL: "\"pr60960.c:26:14: unsupported vector type: v4qi (expr.go:561:expr0: expr.go:4274:primaryExpression: expr.go:4716:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidTy..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr61375.c`:        {}, // COMPILE FAIL: "\"unsigned __int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr63302.c`:        {}, // COMPILE FAIL: "\"__int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr65170.c`:        {}, // COMPILE FAIL: "\"unsigned __int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr65427.c`:        {}, // COMPILE FAIL: "\"pr65427.c:4:3: unsupported vector type: V (decl.go:298:externalDeclaration: decl.go:985:declaration: decl.go:1180:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr68249.c`:        {}, // COMPILE FAIL: "\"-: TODO (expr.go:3892:assignmentExpression: expr.go:101:expr: expr.go:543:expr0: expr.go:955:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr68381.c`:        {}, // COMPILE FAIL: "\"TODO unsigned short * unsigned short -> int (stmt.go:42:statement: stmt.go:411:selectionStatement: expr.go:101:expr: expr.go:559:expr0: expr.go:2062:postfixExpression: expr.go:2344:mulOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr70460.c`:        {}, // COMPILE FAIL: "\"TODO <nil> (asm_arm64.s:1223:goexit: compile.go:478:compile: decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:388:functionDefinition0: decl.go:106:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr70903.c`:        {}, // COMPILE FAIL: "\"TODO (expr.go:3588:postfixExpressionCall: expr.go:70:topExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2305:postfixExpression: init.go:51:initializer:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71554.c`:        {}, // COMPILE FAIL: "\"TODO unsigned * int -> int (stmt.go:42:statement: stmt.go:411:selectionStatement: expr.go:101:expr: expr.go:559:expr0: expr.go:2062:postfixExpression: expr.go:2344:mulOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71626-1.c`:      {}, // COMPILE FAIL: "\"TODO PostfixExpressionIndex (expr.go:1311:equalityExpression: expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2011:postfixExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71626-2.c`:      {}, // COMPILE FAIL: "\"TODO PostfixExpressionIndex (expr.go:1311:equalityExpression: expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2011:postfixExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr77767.c`:        {}, // COMPILE FAIL: "\"pr77767.c:4:1: incomplete type: array of int (decl.go:296:externalDeclaration: decl.go:362:functionDefinition: decl.go:382:functionDefinition0: type.go:459:isValidType1: type.go:383:isValidParamType:..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr84169.c`:        {}, // COMPILE FAIL: "\"unsigned __int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr84748.c`:        {}, // COMPILE FAIL: "\"unsigned __int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr85169.c`:        {}, // COMPILE FAIL: "\"pr85169.c:8:9: unsupported vector type: V (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr85582-2.c`:      {}, // COMPILE FAIL: "\"__int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr85582-3.c`:      {}, // COMPILE FAIL: "\"__int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr88739.c`:        {}, // COMPILE FAIL: "\"TODO exprUintptr (expr.go:2122:postfixExpression: expr.go:2926:postfixExpressionSelect: expr.go:101:expr: expr.go:559:expr0: expr.go:2122:postfixExpression: expr.go:3041:postfixExpressionSelect:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr89434.c`:        {}, // COMPILE FAIL: "\"TODO int * long -> unsigned (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2062:postfixExpression: expr.go:2344:mulOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr90311.c`:        {}, // COMPILE FAIL: "\"TODO unsigned char + int -> unsigned (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2064:postfixExpression: expr.go:2479:addOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr91450-1.c`:      {}, // COMPILE FAIL: "\"TODO int * int -> unsigned long long (expr.go:1686:unaryExpression: expr.go:1240:checkVolatileExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:2062:postfixExpression: expr.go:2344:mulOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr91450-2.c`:      {}, // COMPILE FAIL: "\"TODO int * int -> unsigned long long (stmt.go:42:statement: stmt.go:411:selectionStatement: expr.go:101:expr: expr.go:559:expr0: expr.go:2062:postfixExpression: expr.go:2344:mulOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr91635.c`:        {}, // COMPILE FAIL: "\"TODO int + int -> unsigned short (expr.go:531:expr0: expr.go:4007:assignmentExpression: expr.go:101:expr: expr.go:559:expr0: expr.go:2064:postfixExpression: expr.go:2479:addOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr92618.c`:        {}, // COMPILE FAIL: "\"pr92618.c:33:3: unsupported vector type: __m128i (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr92904.c`:        {}, // COMPILE FAIL: "\"__int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr93213.c`:        {}, // COMPILE FAIL: "\"unsigned __int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94412.c`:        {}, // COMPILE FAIL: "\"pr94412.c:8:3: unsupported vector type: V (expr.go:101:expr: expr.go:567:expr0: expr.go:1653:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94524-1.c`:      {}, // COMPILE FAIL: "\"pr94524-1.c:15:20: unsupported vector type: V (expr.go:561:expr0: expr.go:4274:primaryExpression: expr.go:4727:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidType1:..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94524-2.c`:      {}, // COMPILE FAIL: "\"pr94524-2.c:15:20: unsupported vector type: V (expr.go:115:expr: expr.go:169:convert: expr.go:353:convertType: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr98474.c`:        {}, // COMPILE FAIL: "\"unsigned __int128 not supported on windows/arm64 (check.go:2473:check:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/printf-2.c`:       {}, // COMPILE FAIL: "printf-2.o.go:1879:15: undefined: \"tmpnam\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:201:Main: ccgo.go:666:main: link.go:302:link: link.go:870:link:)"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/scal-to-vec1.c`:   {}, // COMPILE FAIL: "scal-to-vec1.o.go:1158:17: undefined: \"main\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:201:Main: ccgo.go:666:main: link.go:302:link: link.go:870:link:) (all_test.go:465:1: all_te..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/scal-to-vec2.c`:   {}, // COMPILE FAIL: "scal-to-vec2.o.go:1188:17: undefined: \"main\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:201:Main: ccgo.go:666:main: link.go:302:link: link.go:870:link:) (all_test.go:465:1: all_te..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/scal-to-vec3.c`:   {}, // COMPILE FAIL: "scal-to-vec3.o.go:1152:17: undefined: \"main\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:201:Main: ccgo.go:666:main: link.go:302:link: link.go:870:link:) (all_test.go:465:1: all_te..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/simd-6.c`:         {}, // COMPILE FAIL: "\"simd-6.c:13:14: unsupported vector type: v8qi (expr.go:561:expr0: expr.go:4274:primaryExpression: expr.go:4716:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidTyp..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/string-opt-18.c`:  {}, // COMPILE FAIL: "string-opt-18.o.go:1175:5: undefined: \"mempcpy\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:201:Main: ccgo.go:666:main: link.go:302:link: link.go:870:link:) (all_test.go:465:1: all..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/user-printf.c`:    {}, // COMPILE FAIL: "user-printf.o.go:1871:15: undefined: \"tmpnam\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:201:Main: ccgo.go:666:main: link.go:302:link: link.go:870:link:)"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/zero-struct-2.c`:  {}, // COMPILE FAIL: "\"zero-struct-2.c:15:48: TODO \\\"Xone_raw_spinlock(cgtls)\\\" from=raw_spinlock_t struct 0 exprDefault -> to=spinlock_t struct 0 exprDefault (gcc.c-torture\\\\execute\\\\zero-struct-2.c:15:48:) (expr.go:559:e..."
	`assets/github.com/vnmakarov/mir/c-benchmarks/except.c`:                                 {}, // COMPILE FAIL: "except.o.go:1904:3: undefined: \"__mingw_longjmp\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:201:Main: ccgo.go:666:main: link.go:302:link: link.go:870:link:)"
	`assets/github.com/vnmakarov/mir/c-tests/lacc/function-incomplete.c`:                    {}, // COMPILE FAIL: "\"mir\\\\c-tests\\\\lacc\\\\function-incomplete.c:6:9: too few arguments to function 'foo', type 'function(pointer to char) returning int' in 'foo()' (expr.go:1235:binopArgs: expr.go:1240:checkVolatileExpr: ..."
	`assets/github.com/vnmakarov/mir/c-tests/lacc/identifier.c`:                             {}, // COMPILE FAIL: "invalid object file: multiple defintions of c (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:201:Main: ccgo.go:666:main: link.go:260:link: link.go:540:getFileSymbols:)"
	`assets/github.com/vnmakarov/mir/c-tests/lacc/initialize-call.c`:                        {}, // COMPILE FAIL: "\"initialize-call.c:25:9: TODO \\\"sigetobj(cgtls, (ppint32(2)), (ppint32(8)), (ppint32(1)))\\\" from=struct obj {s array of 3 short} struct 6 exprDefault -> to=struct {t struct obj} struct 6 exprDefault (..."
	`assets/github.com/vnmakarov/mir/c-tests/lacc/initialize-string.c`:                      {}, // COMPILE FAIL: "\"initialize-string.c:14:14: TODO \\\"\\\\\\\"wat\\\\\\\\x00\\\\\\\"\\\" from=pointer to char pointer 8 exprDefault -> to=array of 7 char array 7 exprDefault (mir\\\\c-tests\\\\lacc\\\\initialize-string.c:14:14:) (decl.go:1..."
	`assets/github.com/vnmakarov/mir/c-tests/lacc/string-addr.c`:                            {}, // COMPILE FAIL: "\"string-addr.c:4:16: TODO array of 6 char pointer to array of 6 char pointer to array of 6 char \\\"Hello\\\\x00\\\" (expr.go:567:expr0: expr.go:1605:unaryExpression: expr.go:101:expr: expr.go:561:expr0: ex..."
	`assets/github.com/vnmakarov/mir/c-tests/lacc/stringify.c`:                              {}, // COMPILE FAIL: "\"TODO `'\\\\xA'` -> invalid syntax (expr.go:4005:assignmentExpression: expr.go:70:topExpr: expr.go:101:expr: expr.go:561:expr0: expr.go:4278:primaryExpression: expr.go:4556:primaryExpressionCharConst:)\""
	`assets/github.com/vnmakarov/mir/c-tests/new/setjmp.c`:                                  {}, // COMPILE FAIL: "setjmp.o.go:1506:2: undefined: \"__mingw_longjmp\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:201:Main: ccgo.go:666:main: link.go:302:link: link.go:870:link:)"
	`assets/tcc-0.9.27/tests/tests2/76_dollars_in_identifiers.c`:                            {}, // COMPILE FAIL: "\"76_dollars_in_identifiers.c: gofmt: exit status 2 (.:0:: asm_arm64.s:1223:goexit: asm_arm64.s:1223:goexit: asm_arm64.s:1223:goexit: compile.go:550:compile: compile.go:550:compile:)\""
	`assets/tcc-0.9.27/tests/tests2/85_asm-outside-function.c`:                              {}, // COMPILE FAIL: "85_asm-outside-function.o.go:1157:2: undefined: \"vide\" external (all_test.go:465:1: all_test.go:561:testExec1: ccgo.go:201:Main: ccgo.go:666:main: link.go:302:link: link.go:870:link:) (all_test.go:465..."
	`assets/tcc-0.9.27/tests/tests2/87_dead_code.c`:                                         {}, // COMPILE FAIL: "\"87_dead_code.c: gofmt: exit status 2 (.:0:: asm_arm64.s:1223:goexit: asm_arm64.s:1223:goexit: asm_arm64.s:1223:goexit: compile.go:550:compile: compile.go:550:compile:)\""
}
