// This file is part of MinIO Operator
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// Code generated by client-gen. DO NOT EDIT.

package v2

import (
	"context"
	"time"

	v2 "github.com/minio/operator/pkg/apis/minio.min.io/v2"
	scheme "github.com/minio/operator/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// TenantsGetter has a method to return a TenantInterface.
// A group's client should implement this interface.
type TenantsGetter interface {
	Tenants(namespace string) TenantInterface
}

// TenantInterface has methods to work with Tenant resources.
type TenantInterface interface {
	Create(ctx context.Context, tenant *v2.Tenant, opts v1.CreateOptions) (*v2.Tenant, error)
	Update(ctx context.Context, tenant *v2.Tenant, opts v1.UpdateOptions) (*v2.Tenant, error)
	UpdateStatus(ctx context.Context, tenant *v2.Tenant, opts v1.UpdateOptions) (*v2.Tenant, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v2.Tenant, error)
	List(ctx context.Context, opts v1.ListOptions) (*v2.TenantList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2.Tenant, err error)
	TenantExpansion
}

// tenants implements TenantInterface
type tenants struct {
	client rest.Interface
	ns     string
}

// newTenants returns a Tenants
func newTenants(c *MinioV2Client, namespace string) *tenants {
	return &tenants{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the tenant, and returns the corresponding tenant object, and an error if there is any.
func (c *tenants) Get(ctx context.Context, name string, options v1.GetOptions) (result *v2.Tenant, err error) {
	result = &v2.Tenant{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("tenants").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Tenants that match those selectors.
func (c *tenants) List(ctx context.Context, opts v1.ListOptions) (result *v2.TenantList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v2.TenantList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("tenants").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested tenants.
func (c *tenants) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("tenants").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a tenant and creates it.  Returns the server's representation of the tenant, and an error, if there is any.
func (c *tenants) Create(ctx context.Context, tenant *v2.Tenant, opts v1.CreateOptions) (result *v2.Tenant, err error) {
	result = &v2.Tenant{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("tenants").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tenant).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a tenant and updates it. Returns the server's representation of the tenant, and an error, if there is any.
func (c *tenants) Update(ctx context.Context, tenant *v2.Tenant, opts v1.UpdateOptions) (result *v2.Tenant, err error) {
	result = &v2.Tenant{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("tenants").
		Name(tenant.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tenant).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *tenants) UpdateStatus(ctx context.Context, tenant *v2.Tenant, opts v1.UpdateOptions) (result *v2.Tenant, err error) {
	result = &v2.Tenant{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("tenants").
		Name(tenant.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tenant).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the tenant and deletes it. Returns an error if one occurs.
func (c *tenants) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("tenants").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *tenants) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("tenants").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched tenant.
func (c *tenants) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2.Tenant, err error) {
	result = &v2.Tenant{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("tenants").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
