package main

import (
	"context"
	"fmt"
	"net/url"
	"os"
	"strings"

	"io/ioutil"

	"github.com/mozillazg/go-cos"
)

func upload(c *cos.Client, name string) {
	f := strings.NewReader("test")
	f = strings.NewReader("test xxx")
	opt := &cos.ObjectPutOptions{
		ObjectPutHeaderOptions: &cos.ObjectPutHeaderOptions{
			ContentType: "text/html",
		},
		ACLHeaderOptions: &cos.ACLHeaderOptions{
			XCosACL: "public-read",
		},
	}
	c.Object.Put(context.Background(), name, f, opt)
	return
}

func main() {
	u, _ := url.Parse(os.Getenv("COS_BUCKET_URL"))
	b := &cos.BaseURL{BucketURL: u}
	c := cos.NewClient(b, nil)

	name := "test/anonymous_get.go"
	upload(c, name)

	resp, err := c.Object.Get(context.Background(), name, nil)
	if err != nil {
		panic(err)
		return
	}
	bs, _ := ioutil.ReadAll(resp.Body)
	defer resp.Body.Close()
	fmt.Printf("%s\n", string(bs))
}
