package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindDBResourcePoolWithUser invokes the adb.BindDBResourcePoolWithUser API synchronously
func (client *Client) BindDBResourcePoolWithUser(request *BindDBResourcePoolWithUserRequest) (response *BindDBResourcePoolWithUserResponse, err error) {
	response = CreateBindDBResourcePoolWithUserResponse()
	err = client.DoAction(request, response)
	return
}

// BindDBResourcePoolWithUserWithChan invokes the adb.BindDBResourcePoolWithUser API asynchronously
func (client *Client) BindDBResourcePoolWithUserWithChan(request *BindDBResourcePoolWithUserRequest) (<-chan *BindDBResourcePoolWithUserResponse, <-chan error) {
	responseChan := make(chan *BindDBResourcePoolWithUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindDBResourcePoolWithUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindDBResourcePoolWithUserWithCallback invokes the adb.BindDBResourcePoolWithUser API asynchronously
func (client *Client) BindDBResourcePoolWithUserWithCallback(request *BindDBResourcePoolWithUserRequest, callback func(response *BindDBResourcePoolWithUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindDBResourcePoolWithUserResponse
		var err error
		defer close(result)
		response, err = client.BindDBResourcePoolWithUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindDBResourcePoolWithUserRequest is the request struct for api BindDBResourcePoolWithUser
type BindDBResourcePoolWithUserRequest struct {
	*requests.RpcRequest
	PoolName             string           `position:"Query" name:"PoolName"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PoolUser             string           `position:"Query" name:"PoolUser"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// BindDBResourcePoolWithUserResponse is the response struct for api BindDBResourcePoolWithUser
type BindDBResourcePoolWithUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBindDBResourcePoolWithUserRequest creates a request to invoke BindDBResourcePoolWithUser API
func CreateBindDBResourcePoolWithUserRequest() (request *BindDBResourcePoolWithUserRequest) {
	request = &BindDBResourcePoolWithUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "BindDBResourcePoolWithUser", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBindDBResourcePoolWithUserResponse creates a response to parse from BindDBResourcePoolWithUser response
func CreateBindDBResourcePoolWithUserResponse() (response *BindDBResourcePoolWithUserResponse) {
	response = &BindDBResourcePoolWithUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
