package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeResultList invokes the aegis.DescribeResultList API synchronously
// api document: https://help.aliyun.com/api/aegis/describeresultlist.html
func (client *Client) DescribeResultList(request *DescribeResultListRequest) (response *DescribeResultListResponse, err error) {
	response = CreateDescribeResultListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeResultListWithChan invokes the aegis.DescribeResultList API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeresultlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeResultListWithChan(request *DescribeResultListRequest) (<-chan *DescribeResultListResponse, <-chan error) {
	responseChan := make(chan *DescribeResultListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeResultList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeResultListWithCallback invokes the aegis.DescribeResultList API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeresultlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeResultListWithCallback(request *DescribeResultListRequest, callback func(response *DescribeResultListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeResultListResponse
		var err error
		defer close(result)
		response, err = client.DescribeResultList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeResultListRequest is the request struct for api DescribeResultList
type DescribeResultListRequest struct {
	*requests.RpcRequest
	SourceIp    string           `position:"Query" name:"SourceIp"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	EndTime     requests.Integer `position:"Query" name:"EndTime"`
	RuleName    string           `position:"Query" name:"RuleName"`
	Remark      string           `position:"Query" name:"Remark"`
	UuidList    string           `position:"Query" name:"UuidList"`
	Dealed      string           `position:"Query" name:"Dealed"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	StartTime   requests.Integer `position:"Query" name:"StartTime"`
}

// DescribeResultListResponse is the response struct for api DescribeResultList
type DescribeResultListResponse struct {
	*responses.BaseResponse
	RequestId  string           `json:"RequestId" xml:"RequestId"`
	PageInfo   PageInfo         `json:"PageInfo" xml:"PageInfo"`
	ResultList []ResultListItem `json:"ResultList" xml:"ResultList"`
}

// CreateDescribeResultListRequest creates a request to invoke DescribeResultList API
func CreateDescribeResultListRequest() (request *DescribeResultListRequest) {
	request = &DescribeResultListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeResultList", "vipaegis", "openAPI")
	return
}

// CreateDescribeResultListResponse creates a response to parse from DescribeResultList response
func CreateDescribeResultListResponse() (response *DescribeResultListResponse) {
	response = &DescribeResultListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
