package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWhiteListStrategyStatistics invokes the aegis.DescribeWhiteListStrategyStatistics API synchronously
// api document: https://help.aliyun.com/api/aegis/describewhiteliststrategystatistics.html
func (client *Client) DescribeWhiteListStrategyStatistics(request *DescribeWhiteListStrategyStatisticsRequest) (response *DescribeWhiteListStrategyStatisticsResponse, err error) {
	response = CreateDescribeWhiteListStrategyStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWhiteListStrategyStatisticsWithChan invokes the aegis.DescribeWhiteListStrategyStatistics API asynchronously
// api document: https://help.aliyun.com/api/aegis/describewhiteliststrategystatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWhiteListStrategyStatisticsWithChan(request *DescribeWhiteListStrategyStatisticsRequest) (<-chan *DescribeWhiteListStrategyStatisticsResponse, <-chan error) {
	responseChan := make(chan *DescribeWhiteListStrategyStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWhiteListStrategyStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWhiteListStrategyStatisticsWithCallback invokes the aegis.DescribeWhiteListStrategyStatistics API asynchronously
// api document: https://help.aliyun.com/api/aegis/describewhiteliststrategystatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWhiteListStrategyStatisticsWithCallback(request *DescribeWhiteListStrategyStatisticsRequest, callback func(response *DescribeWhiteListStrategyStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWhiteListStrategyStatisticsResponse
		var err error
		defer close(result)
		response, err = client.DescribeWhiteListStrategyStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWhiteListStrategyStatisticsRequest is the request struct for api DescribeWhiteListStrategyStatistics
type DescribeWhiteListStrategyStatisticsRequest struct {
	*requests.RpcRequest
	SourceIp    string           `position:"Query" name:"SourceIp"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	StrategyIds string           `position:"Query" name:"StrategyIds"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Lang        string           `position:"Query" name:"Lang"`
}

// DescribeWhiteListStrategyStatisticsResponse is the response struct for api DescribeWhiteListStrategyStatistics
type DescribeWhiteListStrategyStatisticsResponse struct {
	*responses.BaseResponse
	RequestId   string     `json:"RequestId" xml:"RequestId"`
	Count       int        `json:"Count" xml:"Count"`
	PageSize    int        `json:"PageSize" xml:"PageSize"`
	TotalCount  int        `json:"TotalCount" xml:"TotalCount"`
	CurrentPage int        `json:"CurrentPage" xml:"CurrentPage"`
	Strategies  []Strategy `json:"Strategies" xml:"Strategies"`
}

// CreateDescribeWhiteListStrategyStatisticsRequest creates a request to invoke DescribeWhiteListStrategyStatistics API
func CreateDescribeWhiteListStrategyStatisticsRequest() (request *DescribeWhiteListStrategyStatisticsRequest) {
	request = &DescribeWhiteListStrategyStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeWhiteListStrategyStatistics", "vipaegis", "openAPI")
	return
}

// CreateDescribeWhiteListStrategyStatisticsResponse creates a response to parse from DescribeWhiteListStrategyStatistics response
func CreateDescribeWhiteListStrategyStatisticsResponse() (response *DescribeWhiteListStrategyStatisticsResponse) {
	response = &DescribeWhiteListStrategyStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
