package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFlowRulesOfResource invokes the ahas_openapi.ListFlowRulesOfResource API synchronously
func (client *Client) ListFlowRulesOfResource(request *ListFlowRulesOfResourceRequest) (response *ListFlowRulesOfResourceResponse, err error) {
	response = CreateListFlowRulesOfResourceResponse()
	err = client.DoAction(request, response)
	return
}

// ListFlowRulesOfResourceWithChan invokes the ahas_openapi.ListFlowRulesOfResource API asynchronously
func (client *Client) ListFlowRulesOfResourceWithChan(request *ListFlowRulesOfResourceRequest) (<-chan *ListFlowRulesOfResourceResponse, <-chan error) {
	responseChan := make(chan *ListFlowRulesOfResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFlowRulesOfResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFlowRulesOfResourceWithCallback invokes the ahas_openapi.ListFlowRulesOfResource API asynchronously
func (client *Client) ListFlowRulesOfResourceWithCallback(request *ListFlowRulesOfResourceRequest, callback func(response *ListFlowRulesOfResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFlowRulesOfResourceResponse
		var err error
		defer close(result)
		response, err = client.ListFlowRulesOfResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFlowRulesOfResourceRequest is the request struct for api ListFlowRulesOfResource
type ListFlowRulesOfResourceRequest struct {
	*requests.RpcRequest
	Resource     string           `position:"Query" name:"Resource"`
	AhasRegionId string           `position:"Query" name:"AhasRegionId"`
	AppName      string           `position:"Query" name:"AppName"`
	Namespace    string           `position:"Query" name:"Namespace"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	PageIndex    requests.Integer `position:"Query" name:"PageIndex"`
}

// ListFlowRulesOfResourceResponse is the response struct for api ListFlowRulesOfResource
type ListFlowRulesOfResourceResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListFlowRulesOfResourceRequest creates a request to invoke ListFlowRulesOfResource API
func CreateListFlowRulesOfResourceRequest() (request *ListFlowRulesOfResourceRequest) {
	request = &ListFlowRulesOfResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "ListFlowRulesOfResource", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListFlowRulesOfResourceResponse creates a response to parse from ListFlowRulesOfResource response
func CreateListFlowRulesOfResourceResponse() (response *ListFlowRulesOfResourceResponse) {
	response = &ListFlowRulesOfResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
