package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAScripts invokes the alb.ListAScripts API synchronously
func (client *Client) ListAScripts(request *ListAScriptsRequest) (response *ListAScriptsResponse, err error) {
	response = CreateListAScriptsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAScriptsWithChan invokes the alb.ListAScripts API asynchronously
func (client *Client) ListAScriptsWithChan(request *ListAScriptsRequest) (<-chan *ListAScriptsResponse, <-chan error) {
	responseChan := make(chan *ListAScriptsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAScripts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAScriptsWithCallback invokes the alb.ListAScripts API asynchronously
func (client *Client) ListAScriptsWithCallback(request *ListAScriptsRequest, callback func(response *ListAScriptsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAScriptsResponse
		var err error
		defer close(result)
		response, err = client.ListAScripts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAScriptsRequest is the request struct for api ListAScripts
type ListAScriptsRequest struct {
	*requests.RpcRequest
	NextToken    string           `position:"Query" name:"NextToken"`
	AScriptNames *[]string        `position:"Query" name:"AScriptNames"  type:"Repeated"`
	ListenerIds  *[]string        `position:"Query" name:"ListenerIds"  type:"Repeated"`
	AScriptIds   *[]string        `position:"Query" name:"AScriptIds"  type:"Repeated"`
	MaxResults   requests.Integer `position:"Query" name:"MaxResults"`
}

// ListAScriptsResponse is the response struct for api ListAScripts
type ListAScriptsResponse struct {
	*responses.BaseResponse
	TotalCount int       `json:"TotalCount" xml:"TotalCount"`
	RequestId  string    `json:"RequestId" xml:"RequestId"`
	NextToken  string    `json:"NextToken" xml:"NextToken"`
	MaxResults int       `json:"MaxResults" xml:"MaxResults"`
	AScripts   []AScript `json:"AScripts" xml:"AScripts"`
}

// CreateListAScriptsRequest creates a request to invoke ListAScripts API
func CreateListAScriptsRequest() (request *ListAScriptsRequest) {
	request = &ListAScriptsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "ListAScripts", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListAScriptsResponse creates a response to parse from ListAScripts response
func CreateListAScriptsResponse() (response *ListAScriptsResponse) {
	response = &ListAScriptsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
