package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindInstanceDomains invokes the alidns.BindInstanceDomains API synchronously
func (client *Client) BindInstanceDomains(request *BindInstanceDomainsRequest) (response *BindInstanceDomainsResponse, err error) {
	response = CreateBindInstanceDomainsResponse()
	err = client.DoAction(request, response)
	return
}

// BindInstanceDomainsWithChan invokes the alidns.BindInstanceDomains API asynchronously
func (client *Client) BindInstanceDomainsWithChan(request *BindInstanceDomainsRequest) (<-chan *BindInstanceDomainsResponse, <-chan error) {
	responseChan := make(chan *BindInstanceDomainsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindInstanceDomains(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindInstanceDomainsWithCallback invokes the alidns.BindInstanceDomains API asynchronously
func (client *Client) BindInstanceDomainsWithCallback(request *BindInstanceDomainsRequest, callback func(response *BindInstanceDomainsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindInstanceDomainsResponse
		var err error
		defer close(result)
		response, err = client.BindInstanceDomains(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindInstanceDomainsRequest is the request struct for api BindInstanceDomains
type BindInstanceDomainsRequest struct {
	*requests.RpcRequest
	DomainNames  string `position:"Query" name:"DomainNames"`
	InstanceId   string `position:"Query" name:"InstanceId"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// BindInstanceDomainsResponse is the response struct for api BindInstanceDomains
type BindInstanceDomainsResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	FailedCount  int    `json:"FailedCount" xml:"FailedCount"`
	SuccessCount int    `json:"SuccessCount" xml:"SuccessCount"`
}

// CreateBindInstanceDomainsRequest creates a request to invoke BindInstanceDomains API
func CreateBindInstanceDomainsRequest() (request *BindInstanceDomainsRequest) {
	request = &BindInstanceDomainsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "BindInstanceDomains", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBindInstanceDomainsResponse creates a response to parse from BindInstanceDomains response
func CreateBindInstanceDomainsResponse() (response *BindInstanceDomainsResponse) {
	response = &BindInstanceDomainsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
