package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserUploadSign invokes the alinlp.GetUserUploadSign API synchronously
func (client *Client) GetUserUploadSign(request *GetUserUploadSignRequest) (response *GetUserUploadSignResponse, err error) {
	response = CreateGetUserUploadSignResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserUploadSignWithChan invokes the alinlp.GetUserUploadSign API asynchronously
func (client *Client) GetUserUploadSignWithChan(request *GetUserUploadSignRequest) (<-chan *GetUserUploadSignResponse, <-chan error) {
	responseChan := make(chan *GetUserUploadSignResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserUploadSign(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserUploadSignWithCallback invokes the alinlp.GetUserUploadSign API asynchronously
func (client *Client) GetUserUploadSignWithCallback(request *GetUserUploadSignRequest, callback func(response *GetUserUploadSignResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserUploadSignResponse
		var err error
		defer close(result)
		response, err = client.GetUserUploadSign(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserUploadSignRequest is the request struct for api GetUserUploadSign
type GetUserUploadSignRequest struct {
	*requests.RpcRequest
	ServiceCode string `position:"Body" name:"ServiceCode"`
}

// GetUserUploadSignResponse is the response struct for api GetUserUploadSign
type GetUserUploadSignResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetUserUploadSignRequest creates a request to invoke GetUserUploadSign API
func CreateGetUserUploadSignRequest() (request *GetUserUploadSignRequest) {
	request = &GetUserUploadSignRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetUserUploadSign", "alinlp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetUserUploadSignResponse creates a response to parse from GetUserUploadSign response
func CreateGetUserUploadSignResponse() (response *GetUserUploadSignResponse) {
	response = &GetUserUploadSignResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
