package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetWsCustomizedChEcomComment invokes the alinlp.GetWsCustomizedChEcomComment API synchronously
func (client *Client) GetWsCustomizedChEcomComment(request *GetWsCustomizedChEcomCommentRequest) (response *GetWsCustomizedChEcomCommentResponse, err error) {
	response = CreateGetWsCustomizedChEcomCommentResponse()
	err = client.DoAction(request, response)
	return
}

// GetWsCustomizedChEcomCommentWithChan invokes the alinlp.GetWsCustomizedChEcomComment API asynchronously
func (client *Client) GetWsCustomizedChEcomCommentWithChan(request *GetWsCustomizedChEcomCommentRequest) (<-chan *GetWsCustomizedChEcomCommentResponse, <-chan error) {
	responseChan := make(chan *GetWsCustomizedChEcomCommentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetWsCustomizedChEcomComment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetWsCustomizedChEcomCommentWithCallback invokes the alinlp.GetWsCustomizedChEcomComment API asynchronously
func (client *Client) GetWsCustomizedChEcomCommentWithCallback(request *GetWsCustomizedChEcomCommentRequest, callback func(response *GetWsCustomizedChEcomCommentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetWsCustomizedChEcomCommentResponse
		var err error
		defer close(result)
		response, err = client.GetWsCustomizedChEcomComment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetWsCustomizedChEcomCommentRequest is the request struct for api GetWsCustomizedChEcomComment
type GetWsCustomizedChEcomCommentRequest struct {
	*requests.RpcRequest
	ServiceCode string `position:"Body" name:"ServiceCode"`
	TokenizerId string `position:"Body" name:"TokenizerId"`
	Text        string `position:"Body" name:"Text"`
	OutType     string `position:"Body" name:"OutType"`
}

// GetWsCustomizedChEcomCommentResponse is the response struct for api GetWsCustomizedChEcomComment
type GetWsCustomizedChEcomCommentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetWsCustomizedChEcomCommentRequest creates a request to invoke GetWsCustomizedChEcomComment API
func CreateGetWsCustomizedChEcomCommentRequest() (request *GetWsCustomizedChEcomCommentRequest) {
	request = &GetWsCustomizedChEcomCommentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetWsCustomizedChEcomComment", "alinlp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetWsCustomizedChEcomCommentResponse creates a response to parse from GetWsCustomizedChEcomComment response
func CreateGetWsCustomizedChEcomCommentResponse() (response *GetWsCustomizedChEcomCommentResponse) {
	response = &GetWsCustomizedChEcomCommentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
