package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetWsCustomizedChO2O invokes the alinlp.GetWsCustomizedChO2O API synchronously
func (client *Client) GetWsCustomizedChO2O(request *GetWsCustomizedChO2ORequest) (response *GetWsCustomizedChO2OResponse, err error) {
	response = CreateGetWsCustomizedChO2OResponse()
	err = client.DoAction(request, response)
	return
}

// GetWsCustomizedChO2OWithChan invokes the alinlp.GetWsCustomizedChO2O API asynchronously
func (client *Client) GetWsCustomizedChO2OWithChan(request *GetWsCustomizedChO2ORequest) (<-chan *GetWsCustomizedChO2OResponse, <-chan error) {
	responseChan := make(chan *GetWsCustomizedChO2OResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetWsCustomizedChO2O(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetWsCustomizedChO2OWithCallback invokes the alinlp.GetWsCustomizedChO2O API asynchronously
func (client *Client) GetWsCustomizedChO2OWithCallback(request *GetWsCustomizedChO2ORequest, callback func(response *GetWsCustomizedChO2OResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetWsCustomizedChO2OResponse
		var err error
		defer close(result)
		response, err = client.GetWsCustomizedChO2O(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetWsCustomizedChO2ORequest is the request struct for api GetWsCustomizedChO2O
type GetWsCustomizedChO2ORequest struct {
	*requests.RpcRequest
	ServiceCode string `position:"Body" name:"ServiceCode"`
	TokenizerId string `position:"Body" name:"TokenizerId"`
	Text        string `position:"Body" name:"Text"`
	OutType     string `position:"Body" name:"OutType"`
}

// GetWsCustomizedChO2OResponse is the response struct for api GetWsCustomizedChO2O
type GetWsCustomizedChO2OResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetWsCustomizedChO2ORequest creates a request to invoke GetWsCustomizedChO2O API
func CreateGetWsCustomizedChO2ORequest() (request *GetWsCustomizedChO2ORequest) {
	request = &GetWsCustomizedChO2ORequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetWsCustomizedChO2O", "alinlp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetWsCustomizedChO2OResponse creates a response to parse from GetWsCustomizedChO2O response
func CreateGetWsCustomizedChO2OResponse() (response *GetWsCustomizedChO2OResponse) {
	response = &GetWsCustomizedChO2OResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
