package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetClusterAllUrl invokes the arms.GetClusterAllUrl API synchronously
func (client *Client) GetClusterAllUrl(request *GetClusterAllUrlRequest) (response *GetClusterAllUrlResponse, err error) {
	response = CreateGetClusterAllUrlResponse()
	err = client.DoAction(request, response)
	return
}

// GetClusterAllUrlWithChan invokes the arms.GetClusterAllUrl API asynchronously
func (client *Client) GetClusterAllUrlWithChan(request *GetClusterAllUrlRequest) (<-chan *GetClusterAllUrlResponse, <-chan error) {
	responseChan := make(chan *GetClusterAllUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetClusterAllUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetClusterAllUrlWithCallback invokes the arms.GetClusterAllUrl API asynchronously
func (client *Client) GetClusterAllUrlWithCallback(request *GetClusterAllUrlRequest, callback func(response *GetClusterAllUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetClusterAllUrlResponse
		var err error
		defer close(result)
		response, err = client.GetClusterAllUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetClusterAllUrlRequest is the request struct for api GetClusterAllUrl
type GetClusterAllUrlRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// GetClusterAllUrlResponse is the response struct for api GetClusterAllUrl
type GetClusterAllUrlResponse struct {
	*responses.BaseResponse
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateGetClusterAllUrlRequest creates a request to invoke GetClusterAllUrl API
func CreateGetClusterAllUrlRequest() (request *GetClusterAllUrlRequest) {
	request = &GetClusterAllUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "GetClusterAllUrl", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetClusterAllUrlResponse creates a response to parse from GetClusterAllUrl response
func CreateGetClusterAllUrlResponse() (response *GetClusterAllUrlResponse) {
	response = &GetClusterAllUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
