package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCmsInstances invokes the arms.ListCmsInstances API synchronously
func (client *Client) ListCmsInstances(request *ListCmsInstancesRequest) (response *ListCmsInstancesResponse, err error) {
	response = CreateListCmsInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// ListCmsInstancesWithChan invokes the arms.ListCmsInstances API asynchronously
func (client *Client) ListCmsInstancesWithChan(request *ListCmsInstancesRequest) (<-chan *ListCmsInstancesResponse, <-chan error) {
	responseChan := make(chan *ListCmsInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCmsInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCmsInstancesWithCallback invokes the arms.ListCmsInstances API asynchronously
func (client *Client) ListCmsInstancesWithCallback(request *ListCmsInstancesRequest, callback func(response *ListCmsInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCmsInstancesResponse
		var err error
		defer close(result)
		response, err = client.ListCmsInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCmsInstancesRequest is the request struct for api ListCmsInstances
type ListCmsInstancesRequest struct {
	*requests.RpcRequest
	TypeFilter string `position:"Query" name:"TypeFilter"`
	ClusterId  string `position:"Query" name:"ClusterId"`
}

// ListCmsInstancesResponse is the response struct for api ListCmsInstances
type ListCmsInstancesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListCmsInstancesRequest creates a request to invoke ListCmsInstances API
func CreateListCmsInstancesRequest() (request *ListCmsInstancesRequest) {
	request = &ListCmsInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "ListCmsInstances", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListCmsInstancesResponse creates a response to parse from ListCmsInstances response
func CreateListCmsInstancesResponse() (response *ListCmsInstancesResponse) {
	response = &ListCmsInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
