package beian

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ManageAccessorDomain invokes the beian.ManageAccessorDomain API synchronously
func (client *Client) ManageAccessorDomain(request *ManageAccessorDomainRequest) (response *ManageAccessorDomainResponse, err error) {
	response = CreateManageAccessorDomainResponse()
	err = client.DoAction(request, response)
	return
}

// ManageAccessorDomainWithChan invokes the beian.ManageAccessorDomain API asynchronously
func (client *Client) ManageAccessorDomainWithChan(request *ManageAccessorDomainRequest) (<-chan *ManageAccessorDomainResponse, <-chan error) {
	responseChan := make(chan *ManageAccessorDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ManageAccessorDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ManageAccessorDomainWithCallback invokes the beian.ManageAccessorDomain API asynchronously
func (client *Client) ManageAccessorDomainWithCallback(request *ManageAccessorDomainRequest, callback func(response *ManageAccessorDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ManageAccessorDomainResponse
		var err error
		defer close(result)
		response, err = client.ManageAccessorDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ManageAccessorDomainRequest is the request struct for api ManageAccessorDomain
type ManageAccessorDomainRequest struct {
	*requests.RpcRequest
	Caller    string `position:"Query" name:"Caller"`
	Domain    string `position:"Query" name:"Domain"`
	Operation string `position:"Query" name:"Operation"`
}

// ManageAccessorDomainResponse is the response struct for api ManageAccessorDomain
type ManageAccessorDomainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateManageAccessorDomainRequest creates a request to invoke ManageAccessorDomain API
func CreateManageAccessorDomainRequest() (request *ManageAccessorDomainRequest) {
	request = &ManageAccessorDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Beian", "2016-08-10", "ManageAccessorDomain", "", "")
	request.Method = requests.POST
	return
}

// CreateManageAccessorDomainResponse creates a response to parse from ManageAccessorDomain response
func CreateManageAccessorDomainResponse() (response *ManageAccessorDomainResponse) {
	response = &ManageAccessorDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
