package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// WithdrawPublishedRouteEntries invokes the cbn.WithdrawPublishedRouteEntries API synchronously
func (client *Client) WithdrawPublishedRouteEntries(request *WithdrawPublishedRouteEntriesRequest) (response *WithdrawPublishedRouteEntriesResponse, err error) {
	response = CreateWithdrawPublishedRouteEntriesResponse()
	err = client.DoAction(request, response)
	return
}

// WithdrawPublishedRouteEntriesWithChan invokes the cbn.WithdrawPublishedRouteEntries API asynchronously
func (client *Client) WithdrawPublishedRouteEntriesWithChan(request *WithdrawPublishedRouteEntriesRequest) (<-chan *WithdrawPublishedRouteEntriesResponse, <-chan error) {
	responseChan := make(chan *WithdrawPublishedRouteEntriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.WithdrawPublishedRouteEntries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// WithdrawPublishedRouteEntriesWithCallback invokes the cbn.WithdrawPublishedRouteEntries API asynchronously
func (client *Client) WithdrawPublishedRouteEntriesWithCallback(request *WithdrawPublishedRouteEntriesRequest, callback func(response *WithdrawPublishedRouteEntriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *WithdrawPublishedRouteEntriesResponse
		var err error
		defer close(result)
		response, err = client.WithdrawPublishedRouteEntries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// WithdrawPublishedRouteEntriesRequest is the request struct for api WithdrawPublishedRouteEntries
type WithdrawPublishedRouteEntriesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId           requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CenId                     string           `position:"Query" name:"CenId"`
	ChildInstanceRegionId     string           `position:"Query" name:"ChildInstanceRegionId"`
	ResourceOwnerAccount      string           `position:"Query" name:"ResourceOwnerAccount"`
	DestinationCidrBlock      string           `position:"Query" name:"DestinationCidrBlock"`
	ChildInstanceType         string           `position:"Query" name:"ChildInstanceType"`
	Version                   string           `position:"Query" name:"Version"`
	ChildInstanceId           string           `position:"Query" name:"ChildInstanceId"`
	ChildInstanceRouteTableId string           `position:"Query" name:"ChildInstanceRouteTableId"`
}

// WithdrawPublishedRouteEntriesResponse is the response struct for api WithdrawPublishedRouteEntries
type WithdrawPublishedRouteEntriesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateWithdrawPublishedRouteEntriesRequest creates a request to invoke WithdrawPublishedRouteEntries API
func CreateWithdrawPublishedRouteEntriesRequest() (request *WithdrawPublishedRouteEntriesRequest) {
	request = &WithdrawPublishedRouteEntriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "WithdrawPublishedRouteEntries", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateWithdrawPublishedRouteEntriesResponse creates a response to parse from WithdrawPublishedRouteEntries response
func CreateWithdrawPublishedRouteEntriesResponse() (response *WithdrawPublishedRouteEntriesResponse) {
	response = &WithdrawPublishedRouteEntriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
