package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLegacyAppraiseLogs invokes the ccc.ListLegacyAppraiseLogs API synchronously
func (client *Client) ListLegacyAppraiseLogs(request *ListLegacyAppraiseLogsRequest) (response *ListLegacyAppraiseLogsResponse, err error) {
	response = CreateListLegacyAppraiseLogsResponse()
	err = client.DoAction(request, response)
	return
}

// ListLegacyAppraiseLogsWithChan invokes the ccc.ListLegacyAppraiseLogs API asynchronously
func (client *Client) ListLegacyAppraiseLogsWithChan(request *ListLegacyAppraiseLogsRequest) (<-chan *ListLegacyAppraiseLogsResponse, <-chan error) {
	responseChan := make(chan *ListLegacyAppraiseLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLegacyAppraiseLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLegacyAppraiseLogsWithCallback invokes the ccc.ListLegacyAppraiseLogs API asynchronously
func (client *Client) ListLegacyAppraiseLogsWithCallback(request *ListLegacyAppraiseLogsRequest, callback func(response *ListLegacyAppraiseLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLegacyAppraiseLogsResponse
		var err error
		defer close(result)
		response, err = client.ListLegacyAppraiseLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLegacyAppraiseLogsRequest is the request struct for api ListLegacyAppraiseLogs
type ListLegacyAppraiseLogsRequest struct {
	*requests.RpcRequest
	EndTime    requests.Integer `position:"Query" name:"EndTime"`
	StartTime  requests.Integer `position:"Query" name:"StartTime"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// ListLegacyAppraiseLogsResponse is the response struct for api ListLegacyAppraiseLogs
type ListLegacyAppraiseLogsResponse struct {
	*responses.BaseResponse
	HttpStatusCode int                          `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string                       `json:"Code" xml:"Code"`
	Message        string                       `json:"Message" xml:"Message"`
	RequestId      string                       `json:"RequestId" xml:"RequestId"`
	Success        bool                         `json:"Success" xml:"Success"`
	Data           DataInListLegacyAppraiseLogs `json:"Data" xml:"Data"`
}

// CreateListLegacyAppraiseLogsRequest creates a request to invoke ListLegacyAppraiseLogs API
func CreateListLegacyAppraiseLogsRequest() (request *ListLegacyAppraiseLogsRequest) {
	request = &ListLegacyAppraiseLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ListLegacyAppraiseLogs", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListLegacyAppraiseLogsResponse creates a response to parse from ListLegacyAppraiseLogs response
func CreateListLegacyAppraiseLogsResponse() (response *ListLegacyAppraiseLogsResponse) {
	response = &ListLegacyAppraiseLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
