package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckMonitorAlert invokes the clickhouse.CheckMonitorAlert API synchronously
func (client *Client) CheckMonitorAlert(request *CheckMonitorAlertRequest) (response *CheckMonitorAlertResponse, err error) {
	response = CreateCheckMonitorAlertResponse()
	err = client.DoAction(request, response)
	return
}

// CheckMonitorAlertWithChan invokes the clickhouse.CheckMonitorAlert API asynchronously
func (client *Client) CheckMonitorAlertWithChan(request *CheckMonitorAlertRequest) (<-chan *CheckMonitorAlertResponse, <-chan error) {
	responseChan := make(chan *CheckMonitorAlertResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckMonitorAlert(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckMonitorAlertWithCallback invokes the clickhouse.CheckMonitorAlert API asynchronously
func (client *Client) CheckMonitorAlertWithCallback(request *CheckMonitorAlertRequest, callback func(response *CheckMonitorAlertResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckMonitorAlertResponse
		var err error
		defer close(result)
		response, err = client.CheckMonitorAlert(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckMonitorAlertRequest is the request struct for api CheckMonitorAlert
type CheckMonitorAlertRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// CheckMonitorAlertResponse is the response struct for api CheckMonitorAlert
type CheckMonitorAlertResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	State     string `json:"State" xml:"State"`
	Parameter string `json:"Parameter" xml:"Parameter"`
}

// CreateCheckMonitorAlertRequest creates a request to invoke CheckMonitorAlert API
func CreateCheckMonitorAlertRequest() (request *CheckMonitorAlertRequest) {
	request = &CheckMonitorAlertRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "CheckMonitorAlert", "service", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckMonitorAlertResponse creates a response to parse from CheckMonitorAlert response
func CreateCheckMonitorAlertResponse() (response *CheckMonitorAlertResponse) {
	response = &CheckMonitorAlertResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
