package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUsersByProd invokes the cloud_siem.ListUsersByProd API synchronously
func (client *Client) ListUsersByProd(request *ListUsersByProdRequest) (response *ListUsersByProdResponse, err error) {
	response = CreateListUsersByProdResponse()
	err = client.DoAction(request, response)
	return
}

// ListUsersByProdWithChan invokes the cloud_siem.ListUsersByProd API asynchronously
func (client *Client) ListUsersByProdWithChan(request *ListUsersByProdRequest) (<-chan *ListUsersByProdResponse, <-chan error) {
	responseChan := make(chan *ListUsersByProdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUsersByProd(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUsersByProdWithCallback invokes the cloud_siem.ListUsersByProd API asynchronously
func (client *Client) ListUsersByProdWithCallback(request *ListUsersByProdRequest, callback func(response *ListUsersByProdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUsersByProdResponse
		var err error
		defer close(result)
		response, err = client.ListUsersByProd(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUsersByProdRequest is the request struct for api ListUsersByProd
type ListUsersByProdRequest struct {
	*requests.RpcRequest
	SourceProdCode string `position:"Body" name:"SourceProdCode"`
}

// ListUsersByProdResponse is the response struct for api ListUsersByProd
type ListUsersByProdResponse struct {
	*responses.BaseResponse
	RequestId string                      `json:"RequestId" xml:"RequestId"`
	Data      []DataItemInListUsersByProd `json:"Data" xml:"Data"`
}

// CreateListUsersByProdRequest creates a request to invoke ListUsersByProd API
func CreateListUsersByProdRequest() (request *ListUsersByProdRequest) {
	request = &ListUsersByProdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "ListUsersByProd", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListUsersByProdResponse creates a response to parse from ListUsersByProd response
func CreateListUsersByProdResponse() (response *ListUsersByProdResponse) {
	response = &ListUsersByProdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
