package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetApisAuthorities invokes the cloudapi.SetApisAuthorities API synchronously
func (client *Client) SetApisAuthorities(request *SetApisAuthoritiesRequest) (response *SetApisAuthoritiesResponse, err error) {
	response = CreateSetApisAuthoritiesResponse()
	err = client.DoAction(request, response)
	return
}

// SetApisAuthoritiesWithChan invokes the cloudapi.SetApisAuthorities API asynchronously
func (client *Client) SetApisAuthoritiesWithChan(request *SetApisAuthoritiesRequest) (<-chan *SetApisAuthoritiesResponse, <-chan error) {
	responseChan := make(chan *SetApisAuthoritiesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetApisAuthorities(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetApisAuthoritiesWithCallback invokes the cloudapi.SetApisAuthorities API asynchronously
func (client *Client) SetApisAuthoritiesWithCallback(request *SetApisAuthoritiesRequest, callback func(response *SetApisAuthoritiesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetApisAuthoritiesResponse
		var err error
		defer close(result)
		response, err = client.SetApisAuthorities(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetApisAuthoritiesRequest is the request struct for api SetApisAuthorities
type SetApisAuthoritiesRequest struct {
	*requests.RpcRequest
	AuthVaildTime string           `position:"Query" name:"AuthVaildTime"`
	StageName     string           `position:"Query" name:"StageName"`
	GroupId       string           `position:"Query" name:"GroupId"`
	Description   string           `position:"Query" name:"Description"`
	AuthValidTime string           `position:"Query" name:"AuthValidTime"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	AppId         requests.Integer `position:"Query" name:"AppId"`
	ApiIds        string           `position:"Query" name:"ApiIds"`
}

// SetApisAuthoritiesResponse is the response struct for api SetApisAuthorities
type SetApisAuthoritiesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetApisAuthoritiesRequest creates a request to invoke SetApisAuthorities API
func CreateSetApisAuthoritiesRequest() (request *SetApisAuthoritiesRequest) {
	request = &SetApisAuthoritiesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "SetApisAuthorities", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetApisAuthoritiesResponse creates a response to parse from SetApisAuthorities response
func CreateSetApisAuthoritiesResponse() (response *SetApisAuthoritiesResponse) {
	response = &SetApisAuthoritiesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
