package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveWhiteListSetting invokes the cloudauth.RemoveWhiteListSetting API synchronously
func (client *Client) RemoveWhiteListSetting(request *RemoveWhiteListSettingRequest) (response *RemoveWhiteListSettingResponse, err error) {
	response = CreateRemoveWhiteListSettingResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveWhiteListSettingWithChan invokes the cloudauth.RemoveWhiteListSetting API asynchronously
func (client *Client) RemoveWhiteListSettingWithChan(request *RemoveWhiteListSettingRequest) (<-chan *RemoveWhiteListSettingResponse, <-chan error) {
	responseChan := make(chan *RemoveWhiteListSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveWhiteListSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveWhiteListSettingWithCallback invokes the cloudauth.RemoveWhiteListSetting API asynchronously
func (client *Client) RemoveWhiteListSettingWithCallback(request *RemoveWhiteListSettingRequest, callback func(response *RemoveWhiteListSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveWhiteListSettingResponse
		var err error
		defer close(result)
		response, err = client.RemoveWhiteListSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveWhiteListSettingRequest is the request struct for api RemoveWhiteListSetting
type RemoveWhiteListSettingRequest struct {
	*requests.RpcRequest
	ServiceCode string    `position:"Query" name:"ServiceCode"`
	Ids         *[]string `position:"Query" name:"Ids"  type:"Json"`
}

// RemoveWhiteListSettingResponse is the response struct for api RemoveWhiteListSetting
type RemoveWhiteListSettingResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Code         string `json:"Code" xml:"Code"`
	Message      string `json:"Message" xml:"Message"`
	Success      bool   `json:"Success" xml:"Success"`
	ResultObject bool   `json:"ResultObject" xml:"ResultObject"`
}

// CreateRemoveWhiteListSettingRequest creates a request to invoke RemoveWhiteListSetting API
func CreateRemoveWhiteListSettingRequest() (request *RemoveWhiteListSettingRequest) {
	request = &RemoveWhiteListSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "RemoveWhiteListSetting", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveWhiteListSettingResponse creates a response to parse from RemoveWhiteListSetting response
func CreateRemoveWhiteListSettingResponse() (response *RemoveWhiteListSettingResponse) {
	response = &RemoveWhiteListSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
