package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSmsCallbackLink invokes the cloudcallcenter.GetSmsCallbackLink API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getsmscallbacklink.html
func (client *Client) GetSmsCallbackLink(request *GetSmsCallbackLinkRequest) (response *GetSmsCallbackLinkResponse, err error) {
	response = CreateGetSmsCallbackLinkResponse()
	err = client.DoAction(request, response)
	return
}

// GetSmsCallbackLinkWithChan invokes the cloudcallcenter.GetSmsCallbackLink API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getsmscallbacklink.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetSmsCallbackLinkWithChan(request *GetSmsCallbackLinkRequest) (<-chan *GetSmsCallbackLinkResponse, <-chan error) {
	responseChan := make(chan *GetSmsCallbackLinkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSmsCallbackLink(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSmsCallbackLinkWithCallback invokes the cloudcallcenter.GetSmsCallbackLink API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getsmscallbacklink.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetSmsCallbackLinkWithCallback(request *GetSmsCallbackLinkRequest, callback func(response *GetSmsCallbackLinkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSmsCallbackLinkResponse
		var err error
		defer close(result)
		response, err = client.GetSmsCallbackLink(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSmsCallbackLinkRequest is the request struct for api GetSmsCallbackLink
type GetSmsCallbackLinkRequest struct {
	*requests.RpcRequest
}

// GetSmsCallbackLinkResponse is the response struct for api GetSmsCallbackLink
type GetSmsCallbackLinkResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Link           string `json:"Link" xml:"Link"`
}

// CreateGetSmsCallbackLinkRequest creates a request to invoke GetSmsCallbackLink API
func CreateGetSmsCallbackLinkRequest() (request *GetSmsCallbackLinkRequest) {
	request = &GetSmsCallbackLinkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetSmsCallbackLink", "", "")
	request.Method = requests.POST
	return
}

// CreateGetSmsCallbackLinkResponse creates a response to parse from GetSmsCallbackLink response
func CreateGetSmsCallbackLinkResponse() (response *GetSmsCallbackLinkResponse) {
	response = &GetSmsCallbackLinkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
