package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyCategory invokes the cloudcallcenter.ModifyCategory API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifycategory.html
func (client *Client) ModifyCategory(request *ModifyCategoryRequest) (response *ModifyCategoryResponse, err error) {
	response = CreateModifyCategoryResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyCategoryWithChan invokes the cloudcallcenter.ModifyCategory API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifycategory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyCategoryWithChan(request *ModifyCategoryRequest) (<-chan *ModifyCategoryResponse, <-chan error) {
	responseChan := make(chan *ModifyCategoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyCategory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyCategoryWithCallback invokes the cloudcallcenter.ModifyCategory API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifycategory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyCategoryWithCallback(request *ModifyCategoryRequest, callback func(response *ModifyCategoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyCategoryResponse
		var err error
		defer close(result)
		response, err = client.ModifyCategory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyCategoryRequest is the request struct for api ModifyCategory
type ModifyCategoryRequest struct {
	*requests.RpcRequest
	ModifyOption string `position:"Query" name:"ModifyOption"`
	InstanceId   string `position:"Query" name:"InstanceId"`
	Options      string `position:"Query" name:"Options"`
	ScenarioId   string `position:"Query" name:"ScenarioId"`
	CategoryId   string `position:"Query" name:"CategoryId"`
}

// ModifyCategoryResponse is the response struct for api ModifyCategory
type ModifyCategoryResponse struct {
	*responses.BaseResponse
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Success        bool     `json:"Success" xml:"Success"`
	Code           string   `json:"Code" xml:"Code"`
	Message        string   `json:"Message" xml:"Message"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Category       Category `json:"Category" xml:"Category"`
}

// CreateModifyCategoryRequest creates a request to invoke ModifyCategory API
func CreateModifyCategoryRequest() (request *ModifyCategoryRequest) {
	request = &ModifyCategoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ModifyCategory", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyCategoryResponse creates a response to parse from ModifyCategory response
func CreateModifyCategoryResponse() (response *ModifyCategoryResponse) {
	response = &ModifyCategoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
