package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryRedialIndicator invokes the cloudcallcenter.QueryRedialIndicator API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/queryredialindicator.html
func (client *Client) QueryRedialIndicator(request *QueryRedialIndicatorRequest) (response *QueryRedialIndicatorResponse, err error) {
	response = CreateQueryRedialIndicatorResponse()
	err = client.DoAction(request, response)
	return
}

// QueryRedialIndicatorWithChan invokes the cloudcallcenter.QueryRedialIndicator API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/queryredialindicator.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryRedialIndicatorWithChan(request *QueryRedialIndicatorRequest) (<-chan *QueryRedialIndicatorResponse, <-chan error) {
	responseChan := make(chan *QueryRedialIndicatorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryRedialIndicator(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryRedialIndicatorWithCallback invokes the cloudcallcenter.QueryRedialIndicator API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/queryredialindicator.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryRedialIndicatorWithCallback(request *QueryRedialIndicatorRequest, callback func(response *QueryRedialIndicatorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryRedialIndicatorResponse
		var err error
		defer close(result)
		response, err = client.QueryRedialIndicator(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryRedialIndicatorRequest is the request struct for api QueryRedialIndicator
type QueryRedialIndicatorRequest struct {
	*requests.RpcRequest
	ContactId    string `position:"Query" name:"ContactId"`
	MockResponse string `position:"Query" name:"MockResponse"`
}

// QueryRedialIndicatorResponse is the response struct for api QueryRedialIndicator
type QueryRedialIndicatorResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Redial         bool   `json:"Redial" xml:"Redial"`
}

// CreateQueryRedialIndicatorRequest creates a request to invoke QueryRedialIndicator API
func CreateQueryRedialIndicatorRequest() (request *QueryRedialIndicatorRequest) {
	request = &QueryRedialIndicatorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "QueryRedialIndicator", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryRedialIndicatorResponse creates a response to parse from QueryRedialIndicator response
func CreateQueryRedialIndicatorResponse() (response *QueryRedialIndicatorResponse) {
	response = &QueryRedialIndicatorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
