package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckServiceLinkedRoleForDeleting invokes the cloudesl.CheckServiceLinkedRoleForDeleting API synchronously
func (client *Client) CheckServiceLinkedRoleForDeleting(request *CheckServiceLinkedRoleForDeletingRequest) (response *CheckServiceLinkedRoleForDeletingResponse, err error) {
	response = CreateCheckServiceLinkedRoleForDeletingResponse()
	err = client.DoAction(request, response)
	return
}

// CheckServiceLinkedRoleForDeletingWithChan invokes the cloudesl.CheckServiceLinkedRoleForDeleting API asynchronously
func (client *Client) CheckServiceLinkedRoleForDeletingWithChan(request *CheckServiceLinkedRoleForDeletingRequest) (<-chan *CheckServiceLinkedRoleForDeletingResponse, <-chan error) {
	responseChan := make(chan *CheckServiceLinkedRoleForDeletingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckServiceLinkedRoleForDeleting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckServiceLinkedRoleForDeletingWithCallback invokes the cloudesl.CheckServiceLinkedRoleForDeleting API asynchronously
func (client *Client) CheckServiceLinkedRoleForDeletingWithCallback(request *CheckServiceLinkedRoleForDeletingRequest, callback func(response *CheckServiceLinkedRoleForDeletingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckServiceLinkedRoleForDeletingResponse
		var err error
		defer close(result)
		response, err = client.CheckServiceLinkedRoleForDeleting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckServiceLinkedRoleForDeletingRequest is the request struct for api CheckServiceLinkedRoleForDeleting
type CheckServiceLinkedRoleForDeletingRequest struct {
	*requests.RpcRequest
	ExtraParams    string           `position:"Body" name:"ExtraParams"`
	DeletionTaskId string           `position:"Query" name:"DeletionTaskId"`
	ServiceName    string           `position:"Query" name:"ServiceName"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	SPIRegionId    string           `position:"Query" name:"SPIRegionId"`
	RoleArn        string           `position:"Query" name:"RoleArn"`
}

// CheckServiceLinkedRoleForDeletingResponse is the response struct for api CheckServiceLinkedRoleForDeleting
type CheckServiceLinkedRoleForDeletingResponse struct {
	*responses.BaseResponse
	Deletable      bool        `json:"Deletable" xml:"Deletable"`
	RequestId      string      `json:"RequestId" xml:"RequestId"`
	Success        bool        `json:"Success" xml:"Success"`
	Message        string      `json:"Message" xml:"Message"`
	ErrorCode      string      `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string      `json:"ErrorMessage" xml:"ErrorMessage"`
	Code           string      `json:"Code" xml:"Code"`
	DynamicCode    string      `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string      `json:"DynamicMessage" xml:"DynamicMessage"`
	RoleUsages     []RoleUsage `json:"RoleUsages" xml:"RoleUsages"`
}

// CreateCheckServiceLinkedRoleForDeletingRequest creates a request to invoke CheckServiceLinkedRoleForDeleting API
func CreateCheckServiceLinkedRoleForDeletingRequest() (request *CheckServiceLinkedRoleForDeletingRequest) {
	request = &CheckServiceLinkedRoleForDeletingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "CheckServiceLinkedRoleForDeleting", "", "")
	request.Method = requests.POST
	return
}

// CreateCheckServiceLinkedRoleForDeletingResponse creates a response to parse from CheckServiceLinkedRoleForDeleting response
func CreateCheckServiceLinkedRoleForDeletingResponse() (response *CheckServiceLinkedRoleForDeletingResponse) {
	response = &CheckServiceLinkedRoleForDeletingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
