package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCompanyTemplateVersions invokes the cloudesl.DescribeCompanyTemplateVersions API synchronously
func (client *Client) DescribeCompanyTemplateVersions(request *DescribeCompanyTemplateVersionsRequest) (response *DescribeCompanyTemplateVersionsResponse, err error) {
	response = CreateDescribeCompanyTemplateVersionsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCompanyTemplateVersionsWithChan invokes the cloudesl.DescribeCompanyTemplateVersions API asynchronously
func (client *Client) DescribeCompanyTemplateVersionsWithChan(request *DescribeCompanyTemplateVersionsRequest) (<-chan *DescribeCompanyTemplateVersionsResponse, <-chan error) {
	responseChan := make(chan *DescribeCompanyTemplateVersionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCompanyTemplateVersions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCompanyTemplateVersionsWithCallback invokes the cloudesl.DescribeCompanyTemplateVersions API asynchronously
func (client *Client) DescribeCompanyTemplateVersionsWithCallback(request *DescribeCompanyTemplateVersionsRequest, callback func(response *DescribeCompanyTemplateVersionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCompanyTemplateVersionsResponse
		var err error
		defer close(result)
		response, err = client.DescribeCompanyTemplateVersions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCompanyTemplateVersionsRequest is the request struct for api DescribeCompanyTemplateVersions
type DescribeCompanyTemplateVersionsRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Body" name:"PageNumber"`
	PageSize   requests.Integer `position:"Body" name:"PageSize"`
}

// DescribeCompanyTemplateVersionsResponse is the response struct for api DescribeCompanyTemplateVersions
type DescribeCompanyTemplateVersionsResponse struct {
	*responses.BaseResponse
	TotalCount     int              `json:"TotalCount" xml:"TotalCount"`
	RequestId      string           `json:"RequestId" xml:"RequestId"`
	ErrorMessage   string           `json:"ErrorMessage" xml:"ErrorMessage"`
	Success        bool             `json:"Success" xml:"Success"`
	ErrorCode      string           `json:"ErrorCode" xml:"ErrorCode"`
	Code           string           `json:"Code" xml:"Code"`
	Message        string           `json:"Message" xml:"Message"`
	DynamicMessage string           `json:"DynamicMessage" xml:"DynamicMessage"`
	DynamicCode    string           `json:"DynamicCode" xml:"DynamicCode"`
	PageSize       int              `json:"PageSize" xml:"PageSize"`
	PageNumber     int              `json:"PageNumber" xml:"PageNumber"`
	Versions       []SelectItemInfo `json:"Versions" xml:"Versions"`
}

// CreateDescribeCompanyTemplateVersionsRequest creates a request to invoke DescribeCompanyTemplateVersions API
func CreateDescribeCompanyTemplateVersionsRequest() (request *DescribeCompanyTemplateVersionsRequest) {
	request = &DescribeCompanyTemplateVersionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "DescribeCompanyTemplateVersions", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeCompanyTemplateVersionsResponse creates a response to parse from DescribeCompanyTemplateVersions response
func CreateDescribeCompanyTemplateVersionsResponse() (response *DescribeCompanyTemplateVersionsResponse) {
	response = &DescribeCompanyTemplateVersionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
