package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceMembers invokes the cloudfw.DescribeInstanceMembers API synchronously
func (client *Client) DescribeInstanceMembers(request *DescribeInstanceMembersRequest) (response *DescribeInstanceMembersResponse, err error) {
	response = CreateDescribeInstanceMembersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceMembersWithChan invokes the cloudfw.DescribeInstanceMembers API asynchronously
func (client *Client) DescribeInstanceMembersWithChan(request *DescribeInstanceMembersRequest) (<-chan *DescribeInstanceMembersResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceMembersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceMembers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceMembersWithCallback invokes the cloudfw.DescribeInstanceMembers API asynchronously
func (client *Client) DescribeInstanceMembersWithCallback(request *DescribeInstanceMembersRequest, callback func(response *DescribeInstanceMembersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceMembersResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceMembers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceMembersRequest is the request struct for api DescribeInstanceMembers
type DescribeInstanceMembersRequest struct {
	*requests.RpcRequest
	MemberDisplayName string `position:"Query" name:"MemberDisplayName"`
	SourceIp          string `position:"Query" name:"SourceIp"`
	PageSize          string `position:"Query" name:"PageSize"`
	Lang              string `position:"Query" name:"Lang"`
	CurrentPage       string `position:"Query" name:"CurrentPage"`
	MemberUid         string `position:"Query" name:"MemberUid"`
	MemberDesc        string `position:"Query" name:"MemberDesc"`
}

// DescribeInstanceMembersResponse is the response struct for api DescribeInstanceMembers
type DescribeInstanceMembersResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	PageInfo  PageInfo `json:"PageInfo" xml:"PageInfo"`
	Members   []Data   `json:"Members" xml:"Members"`
}

// CreateDescribeInstanceMembersRequest creates a request to invoke DescribeInstanceMembers API
func CreateDescribeInstanceMembersRequest() (request *DescribeInstanceMembersRequest) {
	request = &DescribeInstanceMembersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribeInstanceMembers", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceMembersResponse creates a response to parse from DescribeInstanceMembers response
func CreateDescribeInstanceMembersResponse() (response *DescribeInstanceMembersResponse) {
	response = &DescribeInstanceMembersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
