package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BusinessShowList invokes the cloudwf.BusinessShowList API synchronously
// api document: https://help.aliyun.com/api/cloudwf/businessshowlist.html
func (client *Client) BusinessShowList(request *BusinessShowListRequest) (response *BusinessShowListResponse, err error) {
	response = CreateBusinessShowListResponse()
	err = client.DoAction(request, response)
	return
}

// BusinessShowListWithChan invokes the cloudwf.BusinessShowList API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/businessshowlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BusinessShowListWithChan(request *BusinessShowListRequest) (<-chan *BusinessShowListResponse, <-chan error) {
	responseChan := make(chan *BusinessShowListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BusinessShowList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BusinessShowListWithCallback invokes the cloudwf.BusinessShowList API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/businessshowlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BusinessShowListWithCallback(request *BusinessShowListRequest, callback func(response *BusinessShowListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BusinessShowListResponse
		var err error
		defer close(result)
		response, err = client.BusinessShowList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BusinessShowListRequest is the request struct for api BusinessShowList
type BusinessShowListRequest struct {
	*requests.RpcRequest
	Page requests.Integer `position:"Query" name:"Page"`
	Per  requests.Integer `position:"Query" name:"Per"`
}

// BusinessShowListResponse is the response struct for api BusinessShowList
type BusinessShowListResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateBusinessShowListRequest creates a request to invoke BusinessShowList API
func CreateBusinessShowListRequest() (request *BusinessShowListRequest) {
	request = &BusinessShowListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "BusinessShowList", "cloudwf", "openAPI")
	return
}

// CreateBusinessShowListResponse creates a response to parse from BusinessShowList response
func CreateBusinessShowListResponse() (response *BusinessShowListResponse) {
	response = &BusinessShowListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
