package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPageProperties invokes the cloudwf.GetPageProperties API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getpageproperties.html
func (client *Client) GetPageProperties(request *GetPagePropertiesRequest) (response *GetPagePropertiesResponse, err error) {
	response = CreateGetPagePropertiesResponse()
	err = client.DoAction(request, response)
	return
}

// GetPagePropertiesWithChan invokes the cloudwf.GetPageProperties API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getpageproperties.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPagePropertiesWithChan(request *GetPagePropertiesRequest) (<-chan *GetPagePropertiesResponse, <-chan error) {
	responseChan := make(chan *GetPagePropertiesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPageProperties(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPagePropertiesWithCallback invokes the cloudwf.GetPageProperties API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getpageproperties.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPagePropertiesWithCallback(request *GetPagePropertiesRequest, callback func(response *GetPagePropertiesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPagePropertiesResponse
		var err error
		defer close(result)
		response, err = client.GetPageProperties(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPagePropertiesRequest is the request struct for api GetPageProperties
type GetPagePropertiesRequest struct {
	*requests.RpcRequest
}

// GetPagePropertiesResponse is the response struct for api GetPageProperties
type GetPagePropertiesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetPagePropertiesRequest creates a request to invoke GetPageProperties API
func CreateGetPagePropertiesRequest() (request *GetPagePropertiesRequest) {
	request = &GetPagePropertiesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetPageProperties", "cloudwf", "openAPI")
	return
}

// CreateGetPagePropertiesResponse creates a response to parse from GetPageProperties response
func CreateGetPagePropertiesResponse() (response *GetPagePropertiesResponse) {
	response = &GetPagePropertiesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
