package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApAsset invokes the cloudwf.ListApAsset API synchronously
// api document: https://help.aliyun.com/api/cloudwf/listapasset.html
func (client *Client) ListApAsset(request *ListApAssetRequest) (response *ListApAssetResponse, err error) {
	response = CreateListApAssetResponse()
	err = client.DoAction(request, response)
	return
}

// ListApAssetWithChan invokes the cloudwf.ListApAsset API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listapasset.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListApAssetWithChan(request *ListApAssetRequest) (<-chan *ListApAssetResponse, <-chan error) {
	responseChan := make(chan *ListApAssetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApAsset(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListApAssetWithCallback invokes the cloudwf.ListApAsset API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listapasset.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListApAssetWithCallback(request *ListApAssetRequest, callback func(response *ListApAssetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListApAssetResponse
		var err error
		defer close(result)
		response, err = client.ListApAsset(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListApAssetRequest is the request struct for api ListApAsset
type ListApAssetRequest struct {
	*requests.RpcRequest
	OrderCol       string           `position:"Query" name:"OrderCol"`
	SearchName     string           `position:"Query" name:"SearchName"`
	SearchSerialNo string           `position:"Query" name:"SearchSerialNo"`
	Length         requests.Integer `position:"Query" name:"Length"`
	PageIndex      requests.Integer `position:"Query" name:"PageIndex"`
	SearchMac      string           `position:"Query" name:"SearchMac"`
	OrderDir       string           `position:"Query" name:"OrderDir"`
	SearchModel    string           `position:"Query" name:"SearchModel"`
}

// ListApAssetResponse is the response struct for api ListApAsset
type ListApAssetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateListApAssetRequest creates a request to invoke ListApAsset API
func CreateListApAssetRequest() (request *ListApAssetRequest) {
	request = &ListApAssetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ListApAsset", "cloudwf", "openAPI")
	return
}

// CreateListApAssetResponse creates a response to parse from ListApAsset response
func CreateListApAssetResponse() (response *ListApAssetResponse) {
	response = &ListApAssetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
