package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveStaStatus invokes the cloudwf.SaveStaStatus API synchronously
// api document: https://help.aliyun.com/api/cloudwf/savestastatus.html
func (client *Client) SaveStaStatus(request *SaveStaStatusRequest) (response *SaveStaStatusResponse, err error) {
	response = CreateSaveStaStatusResponse()
	err = client.DoAction(request, response)
	return
}

// SaveStaStatusWithChan invokes the cloudwf.SaveStaStatus API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/savestastatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveStaStatusWithChan(request *SaveStaStatusRequest) (<-chan *SaveStaStatusResponse, <-chan error) {
	responseChan := make(chan *SaveStaStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveStaStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveStaStatusWithCallback invokes the cloudwf.SaveStaStatus API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/savestastatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveStaStatusWithCallback(request *SaveStaStatusRequest, callback func(response *SaveStaStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveStaStatusResponse
		var err error
		defer close(result)
		response, err = client.SaveStaStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveStaStatusRequest is the request struct for api SaveStaStatus
type SaveStaStatusRequest struct {
	*requests.RpcRequest
	Description string           `position:"Query" name:"Description"`
	Id          requests.Integer `position:"Query" name:"Id"`
}

// SaveStaStatusResponse is the response struct for api SaveStaStatus
type SaveStaStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateSaveStaStatusRequest creates a request to invoke SaveStaStatus API
func CreateSaveStaStatusRequest() (request *SaveStaStatusRequest) {
	request = &SaveStaStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "SaveStaStatus", "cloudwf", "openAPI")
	return
}

// CreateSaveStaStatusResponse creates a response to parse from SaveStaStatus response
func CreateSaveStaStatusResponse() (response *SaveStaStatusResponse) {
	response = &SaveStaStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
