package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UserDataUpdate invokes the cloudwf.UserDataUpdate API synchronously
// api document: https://help.aliyun.com/api/cloudwf/userdataupdate.html
func (client *Client) UserDataUpdate(request *UserDataUpdateRequest) (response *UserDataUpdateResponse, err error) {
	response = CreateUserDataUpdateResponse()
	err = client.DoAction(request, response)
	return
}

// UserDataUpdateWithChan invokes the cloudwf.UserDataUpdate API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/userdataupdate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UserDataUpdateWithChan(request *UserDataUpdateRequest) (<-chan *UserDataUpdateResponse, <-chan error) {
	responseChan := make(chan *UserDataUpdateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UserDataUpdate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UserDataUpdateWithCallback invokes the cloudwf.UserDataUpdate API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/userdataupdate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UserDataUpdateWithCallback(request *UserDataUpdateRequest, callback func(response *UserDataUpdateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UserDataUpdateResponse
		var err error
		defer close(result)
		response, err = client.UserDataUpdate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UserDataUpdateRequest is the request struct for api UserDataUpdate
type UserDataUpdateRequest struct {
	*requests.RpcRequest
	Iid        requests.Integer `position:"Query" name:"Iid"`
	UploadFile string           `position:"Query" name:"UploadFile"`
	Name       string           `position:"Query" name:"Name"`
	Bid        requests.Integer `position:"Query" name:"Bid"`
	Type       string           `position:"Query" name:"Type"`
}

// UserDataUpdateResponse is the response struct for api UserDataUpdate
type UserDataUpdateResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateUserDataUpdateRequest creates a request to invoke UserDataUpdate API
func CreateUserDataUpdateRequest() (request *UserDataUpdateRequest) {
	request = &UserDataUpdateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "UserDataUpdate", "cloudwf", "openAPI")
	return
}

// CreateUserDataUpdateResponse creates a response to parse from UserDataUpdate response
func CreateUserDataUpdateResponse() (response *UserDataUpdateResponse) {
	response = &UserDataUpdateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
