package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateBranch invokes the codeup.CreateBranch API synchronously
func (client *Client) CreateBranch(request *CreateBranchRequest) (response *CreateBranchResponse, err error) {
	response = CreateCreateBranchResponse()
	err = client.DoAction(request, response)
	return
}

// CreateBranchWithChan invokes the codeup.CreateBranch API asynchronously
func (client *Client) CreateBranchWithChan(request *CreateBranchRequest) (<-chan *CreateBranchResponse, <-chan error) {
	responseChan := make(chan *CreateBranchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateBranch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateBranchWithCallback invokes the codeup.CreateBranch API asynchronously
func (client *Client) CreateBranchWithCallback(request *CreateBranchRequest, callback func(response *CreateBranchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateBranchResponse
		var err error
		defer close(result)
		response, err = client.CreateBranch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateBranchRequest is the request struct for api CreateBranch
type CreateBranchRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	SubUserId      string           `position:"Query" name:"SubUserId"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
}

// CreateBranchResponse is the response struct for api CreateBranch
type CreateBranchResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateCreateBranchRequest creates a request to invoke CreateBranch API
func CreateCreateBranchRequest() (request *CreateBranchRequest) {
	request = &CreateBranchRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "CreateBranch", "/api/v3/projects/[ProjectId]/repository/branches", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateBranchResponse creates a response to parse from CreateBranch response
func CreateCreateBranchResponse() (response *CreateBranchResponse) {
	response = &CreateBranchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
