package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAggregator invokes the config.CreateAggregator API synchronously
func (client *Client) CreateAggregator(request *CreateAggregatorRequest) (response *CreateAggregatorResponse, err error) {
	response = CreateCreateAggregatorResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAggregatorWithChan invokes the config.CreateAggregator API asynchronously
func (client *Client) CreateAggregatorWithChan(request *CreateAggregatorRequest) (<-chan *CreateAggregatorResponse, <-chan error) {
	responseChan := make(chan *CreateAggregatorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAggregator(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAggregatorWithCallback invokes the config.CreateAggregator API asynchronously
func (client *Client) CreateAggregatorWithCallback(request *CreateAggregatorRequest, callback func(response *CreateAggregatorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAggregatorResponse
		var err error
		defer close(result)
		response, err = client.CreateAggregator(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAggregatorRequest is the request struct for api CreateAggregator
type CreateAggregatorRequest struct {
	*requests.RpcRequest
	AggregatorType     string                                `position:"Body" name:"AggregatorType"`
	ClientToken        string                                `position:"Body" name:"ClientToken"`
	AggregatorName     string                                `position:"Body" name:"AggregatorName"`
	Description        string                                `position:"Body" name:"Description"`
	AggregatorAccounts *[]CreateAggregatorAggregatorAccounts `position:"Body" name:"AggregatorAccounts"  type:"Json"`
}

// CreateAggregatorAggregatorAccounts is a repeated param struct in CreateAggregatorRequest
type CreateAggregatorAggregatorAccounts struct {
	AccountId   string `name:"AccountId"`
	AccountName string `name:"AccountName"`
	AccountType string `name:"AccountType"`
}

// CreateAggregatorResponse is the response struct for api CreateAggregator
type CreateAggregatorResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	AggregatorId string `json:"AggregatorId" xml:"AggregatorId"`
}

// CreateCreateAggregatorRequest creates a request to invoke CreateAggregator API
func CreateCreateAggregatorRequest() (request *CreateAggregatorRequest) {
	request = &CreateAggregatorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "CreateAggregator", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateAggregatorResponse creates a response to parse from CreateAggregator response
func CreateCreateAggregatorResponse() (response *CreateAggregatorResponse) {
	response = &CreateAggregatorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
