package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAggregators invokes the config.ListAggregators API synchronously
func (client *Client) ListAggregators(request *ListAggregatorsRequest) (response *ListAggregatorsResponse, err error) {
	response = CreateListAggregatorsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAggregatorsWithChan invokes the config.ListAggregators API asynchronously
func (client *Client) ListAggregatorsWithChan(request *ListAggregatorsRequest) (<-chan *ListAggregatorsResponse, <-chan error) {
	responseChan := make(chan *ListAggregatorsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAggregators(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAggregatorsWithCallback invokes the config.ListAggregators API asynchronously
func (client *Client) ListAggregatorsWithCallback(request *ListAggregatorsRequest, callback func(response *ListAggregatorsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAggregatorsResponse
		var err error
		defer close(result)
		response, err = client.ListAggregators(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAggregatorsRequest is the request struct for api ListAggregators
type ListAggregatorsRequest struct {
	*requests.RpcRequest
	NextToken  string           `position:"Query" name:"NextToken"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
}

// ListAggregatorsResponse is the response struct for api ListAggregators
type ListAggregatorsResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	AggregatorsResult AggregatorsResult `json:"AggregatorsResult" xml:"AggregatorsResult"`
}

// CreateListAggregatorsRequest creates a request to invoke ListAggregators API
func CreateListAggregatorsRequest() (request *ListAggregatorsRequest) {
	request = &ListAggregatorsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "ListAggregators", "", "")
	request.Method = requests.POST
	return
}

// CreateListAggregatorsResponse creates a response to parse from ListAggregators response
func CreateListAggregatorsResponse() (response *ListAggregatorsResponse) {
	response = &ListAggregatorsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
