package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteInstanceEndpointAclPolicy invokes the cr.DeleteInstanceEndpointAclPolicy API synchronously
// api document: https://help.aliyun.com/api/cr/deleteinstanceendpointaclpolicy.html
func (client *Client) DeleteInstanceEndpointAclPolicy(request *DeleteInstanceEndpointAclPolicyRequest) (response *DeleteInstanceEndpointAclPolicyResponse, err error) {
	response = CreateDeleteInstanceEndpointAclPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteInstanceEndpointAclPolicyWithChan invokes the cr.DeleteInstanceEndpointAclPolicy API asynchronously
// api document: https://help.aliyun.com/api/cr/deleteinstanceendpointaclpolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteInstanceEndpointAclPolicyWithChan(request *DeleteInstanceEndpointAclPolicyRequest) (<-chan *DeleteInstanceEndpointAclPolicyResponse, <-chan error) {
	responseChan := make(chan *DeleteInstanceEndpointAclPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteInstanceEndpointAclPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteInstanceEndpointAclPolicyWithCallback invokes the cr.DeleteInstanceEndpointAclPolicy API asynchronously
// api document: https://help.aliyun.com/api/cr/deleteinstanceendpointaclpolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteInstanceEndpointAclPolicyWithCallback(request *DeleteInstanceEndpointAclPolicyRequest, callback func(response *DeleteInstanceEndpointAclPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteInstanceEndpointAclPolicyResponse
		var err error
		defer close(result)
		response, err = client.DeleteInstanceEndpointAclPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteInstanceEndpointAclPolicyRequest is the request struct for api DeleteInstanceEndpointAclPolicy
type DeleteInstanceEndpointAclPolicyRequest struct {
	*requests.RpcRequest
	Entry        string `position:"Query" name:"Entry"`
	InstanceId   string `position:"Query" name:"InstanceId"`
	EndpointType string `position:"Query" name:"EndpointType"`
	ModuleName   string `position:"Query" name:"ModuleName"`
}

// DeleteInstanceEndpointAclPolicyResponse is the response struct for api DeleteInstanceEndpointAclPolicy
type DeleteInstanceEndpointAclPolicyResponse struct {
	*responses.BaseResponse
	DeleteInstanceEndpointAclPolicyIsSuccess bool   `json:"IsSuccess" xml:"IsSuccess"`
	Code                                     string `json:"Code" xml:"Code"`
	RequestId                                string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteInstanceEndpointAclPolicyRequest creates a request to invoke DeleteInstanceEndpointAclPolicy API
func CreateDeleteInstanceEndpointAclPolicyRequest() (request *DeleteInstanceEndpointAclPolicyRequest) {
	request = &DeleteInstanceEndpointAclPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "DeleteInstanceEndpointAclPolicy", "acr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteInstanceEndpointAclPolicyResponse creates a response to parse from DeleteInstanceEndpointAclPolicy response
func CreateDeleteInstanceEndpointAclPolicyResponse() (response *DeleteInstanceEndpointAclPolicyResponse) {
	response = &DeleteInstanceEndpointAclPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
