package cusanalytic_sc_online

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLocations invokes the cusanalytic_sc_online.GetLocations API synchronously
// api document: https://help.aliyun.com/api/cusanalytic_sc_online/getlocations.html
func (client *Client) GetLocations(request *GetLocationsRequest) (response *GetLocationsResponse, err error) {
	response = CreateGetLocationsResponse()
	err = client.DoAction(request, response)
	return
}

// GetLocationsWithChan invokes the cusanalytic_sc_online.GetLocations API asynchronously
// api document: https://help.aliyun.com/api/cusanalytic_sc_online/getlocations.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetLocationsWithChan(request *GetLocationsRequest) (<-chan *GetLocationsResponse, <-chan error) {
	responseChan := make(chan *GetLocationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLocations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLocationsWithCallback invokes the cusanalytic_sc_online.GetLocations API asynchronously
// api document: https://help.aliyun.com/api/cusanalytic_sc_online/getlocations.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetLocationsWithCallback(request *GetLocationsRequest, callback func(response *GetLocationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLocationsResponse
		var err error
		defer close(result)
		response, err = client.GetLocations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLocationsRequest is the request struct for api GetLocations
type GetLocationsRequest struct {
	*requests.RpcRequest
	StoreId requests.Integer `position:"Body" name:"StoreId"`
}

// GetLocationsResponse is the response struct for api GetLocations
type GetLocationsResponse struct {
	*responses.BaseResponse
	StoreId       int64         `json:"StoreId" xml:"StoreId"`
	LocationItems LocationItems `json:"LocationItems" xml:"LocationItems"`
}

// CreateGetLocationsRequest creates a request to invoke GetLocations API
func CreateGetLocationsRequest() (request *GetLocationsRequest) {
	request = &GetLocationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cusanalytic_sc_online", "2019-05-24", "GetLocations", "", "")
	return
}

// CreateGetLocationsResponse creates a response to parse from GetLocations response
func CreateGetLocationsResponse() (response *GetLocationsResponse) {
	response = &GetLocationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
