package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstanceSqlOptimizeStatistic invokes the das.GetInstanceSqlOptimizeStatistic API synchronously
func (client *Client) GetInstanceSqlOptimizeStatistic(request *GetInstanceSqlOptimizeStatisticRequest) (response *GetInstanceSqlOptimizeStatisticResponse, err error) {
	response = CreateGetInstanceSqlOptimizeStatisticResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstanceSqlOptimizeStatisticWithChan invokes the das.GetInstanceSqlOptimizeStatistic API asynchronously
func (client *Client) GetInstanceSqlOptimizeStatisticWithChan(request *GetInstanceSqlOptimizeStatisticRequest) (<-chan *GetInstanceSqlOptimizeStatisticResponse, <-chan error) {
	responseChan := make(chan *GetInstanceSqlOptimizeStatisticResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstanceSqlOptimizeStatistic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstanceSqlOptimizeStatisticWithCallback invokes the das.GetInstanceSqlOptimizeStatistic API asynchronously
func (client *Client) GetInstanceSqlOptimizeStatisticWithCallback(request *GetInstanceSqlOptimizeStatisticRequest, callback func(response *GetInstanceSqlOptimizeStatisticResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstanceSqlOptimizeStatisticResponse
		var err error
		defer close(result)
		response, err = client.GetInstanceSqlOptimizeStatistic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstanceSqlOptimizeStatisticRequest is the request struct for api GetInstanceSqlOptimizeStatistic
type GetInstanceSqlOptimizeStatisticRequest struct {
	*requests.RpcRequest
	EndTime      string `position:"Query" name:"EndTime"`
	Threshold    string `position:"Query" name:"Threshold"`
	StartTime    string `position:"Query" name:"StartTime"`
	UseMerging   string `position:"Query" name:"UseMerging"`
	InstanceId   string `position:"Query" name:"InstanceId"`
	NodeId       string `position:"Query" name:"NodeId"`
	FilterEnable string `position:"Query" name:"FilterEnable"`
}

// GetInstanceSqlOptimizeStatisticResponse is the response struct for api GetInstanceSqlOptimizeStatistic
type GetInstanceSqlOptimizeStatisticResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetInstanceSqlOptimizeStatisticRequest creates a request to invoke GetInstanceSqlOptimizeStatistic API
func CreateGetInstanceSqlOptimizeStatisticRequest() (request *GetInstanceSqlOptimizeStatisticRequest) {
	request = &GetInstanceSqlOptimizeStatisticRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetInstanceSqlOptimizeStatistic", "", "")
	request.Method = requests.POST
	return
}

// CreateGetInstanceSqlOptimizeStatisticResponse creates a response to parse from GetInstanceSqlOptimizeStatistic response
func CreateGetInstanceSqlOptimizeStatisticResponse() (response *GetInstanceSqlOptimizeStatisticResponse) {
	response = &GetInstanceSqlOptimizeStatisticResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
