package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetQueryOptimizeDataTrend invokes the das.GetQueryOptimizeDataTrend API synchronously
func (client *Client) GetQueryOptimizeDataTrend(request *GetQueryOptimizeDataTrendRequest) (response *GetQueryOptimizeDataTrendResponse, err error) {
	response = CreateGetQueryOptimizeDataTrendResponse()
	err = client.DoAction(request, response)
	return
}

// GetQueryOptimizeDataTrendWithChan invokes the das.GetQueryOptimizeDataTrend API asynchronously
func (client *Client) GetQueryOptimizeDataTrendWithChan(request *GetQueryOptimizeDataTrendRequest) (<-chan *GetQueryOptimizeDataTrendResponse, <-chan error) {
	responseChan := make(chan *GetQueryOptimizeDataTrendResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetQueryOptimizeDataTrend(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetQueryOptimizeDataTrendWithCallback invokes the das.GetQueryOptimizeDataTrend API asynchronously
func (client *Client) GetQueryOptimizeDataTrendWithCallback(request *GetQueryOptimizeDataTrendRequest, callback func(response *GetQueryOptimizeDataTrendResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetQueryOptimizeDataTrendResponse
		var err error
		defer close(result)
		response, err = client.GetQueryOptimizeDataTrend(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetQueryOptimizeDataTrendRequest is the request struct for api GetQueryOptimizeDataTrend
type GetQueryOptimizeDataTrendRequest struct {
	*requests.RpcRequest
	Start          string `position:"Query" name:"Start"`
	TagNames       string `position:"Query" name:"TagNames"`
	ConsoleContext string `position:"Query" name:"ConsoleContext"`
	Engine         string `position:"Query" name:"Engine"`
	InstanceIds    string `position:"Query" name:"InstanceIds"`
	End            string `position:"Query" name:"End"`
	Region         string `position:"Query" name:"Region"`
}

// GetQueryOptimizeDataTrendResponse is the response struct for api GetQueryOptimizeDataTrend
type GetQueryOptimizeDataTrendResponse struct {
	*responses.BaseResponse
	Code      string                          `json:"Code" xml:"Code"`
	Message   string                          `json:"Message" xml:"Message"`
	RequestId string                          `json:"RequestId" xml:"RequestId"`
	Success   string                          `json:"Success" xml:"Success"`
	Data      DataInGetQueryOptimizeDataTrend `json:"Data" xml:"Data"`
}

// CreateGetQueryOptimizeDataTrendRequest creates a request to invoke GetQueryOptimizeDataTrend API
func CreateGetQueryOptimizeDataTrendRequest() (request *GetQueryOptimizeDataTrendRequest) {
	request = &GetQueryOptimizeDataTrendRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetQueryOptimizeDataTrend", "", "")
	request.Method = requests.GET
	return
}

// CreateGetQueryOptimizeDataTrendResponse creates a response to parse from GetQueryOptimizeDataTrend response
func CreateGetQueryOptimizeDataTrendResponse() (response *GetQueryOptimizeDataTrendResponse) {
	response = &GetQueryOptimizeDataTrendResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
